/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.json.JSONException;
import org.json.JSONObject;

public class ButtonRenderer
extends RendererBase {
    private static final String TYPE_ICON = "icon";
    private static final String TYPE_IMAGE = "image";
    private static final String TYPE_RESET = "reset";
    private static final String TYPE_SUBMIT = "submit";
    private static final String[] stringAttributes = new String[]{"accessKey", "alt", "align", "dir", "lang", "onBlur", "onClick", "onDblClick", "onFocus", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseOut", "onMouseOver", "onMouseUp", "onMouseMove", "style"};
    private static final String[] intAttributes = new String[]{"tabIndex"};

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!(component instanceof Button)) {
            throw new IllegalArgumentException("ButtonRenderer can only decode Button components.");
        }
        Button button = (Button)component;
        if (button.isReset()) {
            return;
        }
        String clientId = button.getClientId(context);
        Map map = context.getExternalContext().getRequestParameterMap();
        if (map.containsKey(clientId) || map.containsKey(clientId + ".x") && map.containsKey(clientId + ".y")) {
            button.queueEvent((FacesEvent)new ActionEvent((UIComponent)button));
        }
    }

    protected JSONObject getProperties(FacesContext context, UIComponent component) throws JSONException, IOException {
        if (!(component instanceof Button)) {
            throw new IllegalArgumentException("ButtonRenderer can only render Button components.");
        }
        Button button = (Button)component;
        JSONObject json = new JSONObject();
        json.put("className", (Object)button.getStyleClass()).put("disabled", button.isDisabled()).put("mini", button.isMini()).put("primary", button.isPrimary()).put("title", (Object)button.getToolTip()).put("visible", button.isVisible());
        String type = this.getType(button);
        if (type.equals(TYPE_ICON)) {
            this.setIconProperties(button, json);
        } else if (type.equals(TYPE_IMAGE)) {
            this.setImageProperties(context, button, json);
        } else {
            this.setTextProperties(button, json);
        }
        JSONUtilities.addStringProperties(stringAttributes, component, json);
        JSONUtilities.addIntegerProperties(intAttributes, component, json);
        return json;
    }

    protected String getWidgetType(FacesContext context, UIComponent component) {
        if (!(component instanceof Button)) {
            throw new IllegalArgumentException("ButtonRenderer can only render Button components.");
        }
        String type = this.getType((Button)component);
        if (type.equals(TYPE_ICON) || type.equals(TYPE_IMAGE)) {
            return JavaScriptUtilities.getModuleName("widget.imageButton");
        }
        if (type.equals(TYPE_RESET)) {
            return JavaScriptUtilities.getModuleName("widget.resetButton");
        }
        return JavaScriptUtilities.getModuleName("widget.button");
    }

    private String getType(Button component) {
        if (component.getIcon() != null) {
            return TYPE_ICON;
        }
        if (component.getImageURL() != null) {
            return TYPE_IMAGE;
        }
        if (component.isReset()) {
            return TYPE_RESET;
        }
        return TYPE_SUBMIT;
    }

    private void setIconProperties(Button component, JSONObject json) throws JSONException {
        Icon icon = ThemeUtilities.getIcon(this.getTheme(), component.getIcon());
        json.put("alt", (Object)icon.getAlt()).put("src", (Object)icon.getUrl());
    }

    private void setImageProperties(FacesContext context, Button component, JSONObject json) throws JSONException {
        String url = context.getApplication().getViewHandler().getResourceURL(context, component.getImageURL());
        json.put("alt", (Object)component.getAlt()).put("src", (Object)url);
    }

    private void setTextProperties(Button component, JSONObject json) throws JSONException {
        String text = ConversionUtilities.convertValueToString((UIComponent)component, component.getText());
        if (text != null && text.trim().length() > 0 && !component.isNoTextPadding()) {
            if (text.trim().length() <= 3) {
                text = "  " + text + "  ";
            } else if (text.trim().length() == 4) {
                text = " " + text + " ";
            }
        }
        json.put("value", (Object)text).put("escape", component.isEscape());
    }
}

