/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.ListSelector;
import com.sun.webui.jsf.model.Separator;
import com.sun.webui.jsf.model.list.EndGroup;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.model.list.StartGroup;
import com.sun.webui.jsf.renderkit.widget.RendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ListRendererBase
extends RendererBase {
    protected static final String[] stringAttributes = new String[]{"onBlur", "onChange", "onClick", "onDblClick", "onFocus", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp", "onSelect", "style", "dir", "lang", "accessKey"};

    public void decode(FacesContext context, UIComponent component) {
        if (((ListManager)component).isReadOnly()) {
            return;
        }
        String id = component.getClientId(context);
        if (component instanceof ComplexComponent) {
            id = ((ComplexComponent)component).getLabeledElementId(context);
        }
        this.decode(context, component, id);
    }

    protected void decode(FacesContext context, UIComponent component, String id) {
        ListManager lmComponent = (ListManager)component;
        if (lmComponent.isReadOnly()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String[] values = null;
        Object p = params.get(id);
        values = p == null ? new String[]{} : (String[])p;
        if (values.length > 1) {
            ArrayList<String> newParams = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                if ("com_sun_webui_jsf_NONESELECTED".equals(values[i])) continue;
                newParams.add(values[i]);
            }
            values = newParams.toArray(new String[newParams.size()]);
        } else if (values.length == 1 && "com_sun_webui_jsf_NONESELECTED".equals(values[0])) {
            return;
        }
        if (values.length > 0 || !lmComponent.isDisabled()) {
            lmComponent.setSubmittedValue(values);
        }
    }

    protected JSONObject getProperties(FacesContext context, ListSelector component) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        UIComponent label = component.getLabelComponent();
        boolean labelOnTop = component.isLabelOnTop();
        if (label != null && !labelOnTop && component.getRows() > 1) {
            Theme theme = this.getTheme();
            String listAlign = theme.getStyleClass("LIST_ALIGN");
            Map attributes = label.getAttributes();
            Object styleClass = attributes.get("styleClass");
            if (styleClass == null) {
                attributes.put("styleClass", listAlign);
            } else if (styleClass.toString().indexOf(listAlign) == -1) {
                attributes.put("styleClass", styleClass + " " + listAlign);
            }
        }
        json.put("label", (Object)WidgetUtilities.renderComponent(context, label));
        json.put("className", (Object)component.getStyleClass());
        json.put("labelOnTop", labelOnTop);
        this.recordRenderedValue((UIComponent)component);
        this.getListProperties(json, component, context);
        return json;
    }

    private void getListProperties(JSONObject json, ListManager listManager, FacesContext context) throws JSONException {
        json.put("disabled", listManager.isDisabled());
        json.put("size", listManager.getRows());
        json.put("multiple", listManager.isMultiple());
        json.put("tabIndex", listManager.getTabIndex());
        json.put("title", (Object)listManager.getToolTip());
        this.getListOptionsProperties(json, (UIComponent)listManager, listManager.getListItems(context, true));
    }

    private void getListOptionsProperties(JSONObject json, UIComponent component, Iterator optionsIterator) throws JSONException {
        JSONArray optionsJsonArray = new JSONArray();
        JSONObject groupOptionJson = null;
        JSONArray groupOptionsJsonArray = null;
        Object option = null;
        boolean noSeparator = true;
        while (optionsIterator.hasNext()) {
            JSONObject separatorJson;
            option = optionsIterator.next();
            if (option instanceof Separator) {
                if (!this.canGetSeparatorProperties(component)) continue;
                separatorJson = new JSONObject();
                this.getSeparatorProperties(separatorJson, component);
                if (groupOptionsJsonArray != null) {
                    groupOptionsJsonArray.put((Object)separatorJson);
                    continue;
                }
                optionsJsonArray.put((Object)separatorJson);
                continue;
            }
            if (option instanceof StartGroup) {
                StartGroup group = option;
                if (!noSeparator && this.canGetSeparatorProperties(component)) {
                    JSONObject separatorJson2 = new JSONObject();
                    this.getSeparatorProperties(separatorJson2, component);
                    optionsJsonArray.put((Object)separatorJson2);
                }
                groupOptionJson = new JSONObject();
                groupOptionJson.put("group", true);
                groupOptionJson.put("label", (Object)group.getLabel());
                optionsJsonArray.put((Object)groupOptionJson);
                groupOptionsJsonArray = new JSONArray();
                noSeparator = true;
                continue;
            }
            if (option instanceof EndGroup) {
                groupOptionJson.put("options", groupOptionsJsonArray);
                groupOptionsJsonArray = null;
                if (optionsIterator.hasNext() && this.canGetSeparatorProperties(component)) {
                    separatorJson = new JSONObject();
                    this.getSeparatorProperties(separatorJson, component);
                    optionsJsonArray.put((Object)separatorJson);
                }
                noSeparator = true;
                continue;
            }
            JSONObject optionJson = new JSONObject();
            this.getListOptionProperties(optionJson, option);
            if (groupOptionsJsonArray != null) {
                groupOptionsJsonArray.put((Object)optionJson);
            } else {
                optionsJsonArray.put((Object)optionJson);
            }
            noSeparator = false;
        }
        json.put("options", (Object)optionsJsonArray);
    }

    private void getSeparatorProperties(JSONObject json, UIComponent component) throws JSONException {
        if (!this.canGetSeparatorProperties(component)) {
            return;
        }
        ListSelector selector = (ListSelector)component;
        json.put("separator", true);
        json.put("group", false);
        json.put("disabled", true);
        int numEms = selector.getSeparatorLength();
        StringBuffer labelBuffer = new StringBuffer();
        for (int em = 0; em < numEms; ++em) {
            labelBuffer.append("-");
        }
        json.put("label", (Object)labelBuffer.toString());
    }

    private boolean canGetSeparatorProperties(UIComponent component) {
        if (!(component instanceof ListSelector)) {
            return false;
        }
        ListSelector selector = (ListSelector)component;
        return selector.isSeparators();
    }

    private void getListOptionProperties(JSONObject json, ListItem listItem) throws JSONException {
        json.put("group", false);
        json.put("separator", false);
        json.put("disabled", listItem.isDisabled());
        json.put("selected", listItem.isSelected());
        json.put("value", (Object)listItem.getValue());
        json.put("isTitle", listItem.isTitle());
        json.put("label", (Object)listItem.getLabel());
        json.put("escape", listItem.isEscape());
    }

    private void recordRenderedValue(UIComponent component) {
        if (component instanceof EditableValueHolder && ((EditableValueHolder)component).getSubmittedValue() == null) {
            ConversionUtilities.setRenderedValue(component, ((EditableValueHolder)component).getValue());
        }
    }
}

