/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.theme.JSFThemeContext;
import com.sun.webui.jsf.util.JSONUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeContext;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JavaScriptUtilities {
    private static final String DEBUG_KEY = "com_sun_webui_jsf_util_debug";

    public static boolean isDebug() {
        return JavaScriptUtilities.getRequestMap().containsKey(DEBUG_KEY) || JavaScriptUtilities.getRequestParameterMap().containsKey("debug");
    }

    public static void setDebug(boolean enable) {
        JavaScriptUtilities.getRequestMap().put(DEBUG_KEY, enable ? Boolean.TRUE : null);
    }

    public static String getDomNode(FacesContext context, UIComponent component) {
        StringBuffer buff = new StringBuffer(128);
        buff.append("document.getElementById('").append(component.getClientId(context)).append("')");
        return buff.toString();
    }

    public static String getModule(String name) {
        StringBuffer buff = new StringBuffer(128);
        buff.append("dojo.require('").append(JavaScriptUtilities.getModuleName(name)).append("');");
        return buff.toString();
    }

    public static String getModuleName(String name) {
        StringBuffer buff = new StringBuffer(128);
        buff.append(JavaScriptUtilities.getTheme().getJSString("modulePrefix")).append(".").append(name);
        return buff.toString();
    }

    public static String getWidget(FacesContext context, UIComponent component) {
        StringBuffer buff = new StringBuffer(128);
        buff.append("dojo.widget.byId('").append(component.getClientId(context)).append("')");
        return buff.toString();
    }

    public static void renderBootstrap(UIComponent component, ResponseWriter writer, JSONObject json) throws IOException, JSONException {
        JavaScriptUtilities.renderJavaScript(component, writer, JavaScriptUtilities.getDojoConfig(json.getBoolean("parseOnLoad")));
        JavaScriptUtilities.renderJsonInclude(component, writer);
        JavaScriptUtilities.renderPrototypeInclude(component, writer);
        if (json.getBoolean("webuiJsfx")) {
            JavaScriptUtilities.renderJsfxInclude(component, writer);
        }
        JavaScriptUtilities.renderDojoInclude(component, writer, json.getBoolean("dijitAll"));
        JavaScriptUtilities.renderJavaScript(component, writer, JavaScriptUtilities.getModuleConfig());
        JavaScriptUtilities.renderWebuiInclude(component, writer, json.getBoolean("webuiAll"), json.getBoolean("webuiJsfx"));
        JavaScriptUtilities.renderJavaScript(component, writer, JavaScriptUtilities.getBootstrapConfig());
        JavaScriptUtilities.renderGlobalInclude(component, writer);
    }

    public static void renderJavaScript(UIComponent component, ResponseWriter writer, String js) throws IOException {
        JavaScriptUtilities.renderJavaScript(component, writer, js, false);
    }

    public static void renderJavaScript(UIComponent component, ResponseWriter writer, String js, boolean defer) throws IOException {
        if (js == null) {
            return;
        }
        JavaScriptUtilities.renderJavaScriptBegin(component, writer, defer);
        writer.write(js);
        JavaScriptUtilities.renderJavaScriptEnd(component, writer, defer);
    }

    public static void renderJavaScriptBegin(UIComponent component, ResponseWriter writer, boolean defer) throws IOException {
        if (JavaScriptUtilities.isDebug()) {
            writer.write("\n");
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (defer) {
            writer.write("dojo.addOnLoad(function() {");
        }
    }

    public static void renderJavaScriptEnd(UIComponent component, ResponseWriter writer, boolean defer) throws IOException {
        if (defer) {
            writer.write("});");
        }
        writer.endElement("script");
    }

    private static String getBootstrapConfig() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("debug", JavaScriptUtilities.isDebug()).put("theme", (Object)JavaScriptUtilities.getThemeConfig(FacesContext.getCurrentInstance()));
        StringBuffer buff = new StringBuffer(256);
        buff.append(JavaScriptUtilities.getModuleName("bootstrap.init")).append("(").append(JSONUtilities.getString(json)).append(");");
        return buff.toString();
    }

    private static String getDojoConfig(boolean parseOnLoad) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("isDebug", JavaScriptUtilities.isDebug()).put("parseOnLoad", parseOnLoad);
        StringBuffer buff = new StringBuffer(256);
        buff.append("var djConfig=").append(JSONUtilities.getString(json));
        return buff.toString();
    }

    private static String getModuleConfig() {
        StringBuffer buff = new StringBuffer(256);
        buff.append("dojo.registerModulePath(\"").append(JavaScriptUtilities.getTheme().getJSString("modulePrefix")).append("\", \"").append(JavaScriptUtilities.getTheme().getPathToJSFile(JavaScriptUtilities.isDebug() ? "modulePathUncompressed" : "modulePath")).append("\");");
        return buff.toString();
    }

    private static JSONObject getThemeConfig(FacesContext context) throws JSONException {
        String themeModule = JavaScriptUtilities.getTheme().getJSString("themeModule");
        String themeModulePath = JavaScriptUtilities.isDebug() ? JavaScriptUtilities.getTheme().getJSString("themeModulePathUncompressed") : JavaScriptUtilities.getTheme().getJSString("themeModulePath");
        String themeBundle = JavaScriptUtilities.getTheme().getJSString("themeBundle");
        String themeLocale = context.getViewRoot().getLocale().toString().replaceAll("_", "-");
        ThemeContext themeContext = JSFThemeContext.getInstance(context);
        String themePrefix = themeContext.getResourcePath("");
        int lastSlash = themePrefix.lastIndexOf("/");
        if (lastSlash > 0) {
            themePrefix = themePrefix.substring(0, lastSlash);
        }
        JSONArray customThemes = null;
        String[] customThemeResources = themeContext.getThemeResources();
        if (customThemeResources != null) {
            customThemes = new JSONArray();
            for (int i = 0; i < customThemeResources.length; ++i) {
                customThemes.put(i, (Object)customThemeResources[i]);
            }
        }
        JSONObject json = new JSONObject();
        json.put("prefix", (Object)themePrefix).put("module", (Object)themeModule).put("modulePath", (Object)themeModulePath).put("bundle", (Object)themeBundle).put("locale", (Object)themeLocale).put("custom", (Object)customThemes);
        return json;
    }

    private static Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private static Map getRequestMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
    }

    private static Map getRequestParameterMap() {
        return FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
    }

    private static void renderDojoInclude(UIComponent component, ResponseWriter writer, boolean dijitAll) throws IOException {
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, JavaScriptUtilities.isDebug() ? "dojoUncompressed" : "dojo");
        String dijit = null;
        dijit = dijitAll ? (JavaScriptUtilities.isDebug() ? "dijitAllUncompressed" : "dijitAll") : (JavaScriptUtilities.isDebug() ? "dijitUncompressed" : "dijit");
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, dijit);
    }

    private static void renderGlobalInclude(UIComponent component, ResponseWriter writer) throws IOException {
        String[] javascripts = JavaScriptUtilities.getTheme().getGlobalJSFiles();
        if (javascripts == null) {
            return;
        }
        for (int i = 0; i < javascripts.length; ++i) {
            String file = javascripts[i];
            if (file == null) continue;
            if (JavaScriptUtilities.isDebug()) {
                writer.write("\n");
            }
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeURIAttribute("src", (Object)file.toString(), null);
            writer.endElement("script");
        }
    }

    private static void renderJavaScriptInclude(UIComponent component, ResponseWriter writer, String file) throws IOException {
        if (file == null) {
            return;
        }
        String jsFile = JavaScriptUtilities.getTheme().getPathToJSFile(file);
        if (jsFile == null) {
            return;
        }
        if (JavaScriptUtilities.isDebug()) {
            writer.write("\n");
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeURIAttribute("src", (Object)jsFile, null);
        writer.endElement("script");
    }

    private static void renderJsfxInclude(UIComponent component, ResponseWriter writer) throws IOException {
        Map requestMap = JavaScriptUtilities.getRequestMap();
        if (!requestMap.containsKey("com.sun.faces.extensions.avatar.LINKED/com_sun_faces_ajax.js")) {
            JavaScriptUtilities.renderJavaScriptInclude(component, writer, JavaScriptUtilities.isDebug() ? "jsfxUncompressed" : "jsfx");
            requestMap.put("com.sun.faces.extensions.avatar.LINKED/com_sun_faces_ajax.js", Boolean.TRUE);
        }
    }

    private static void renderJsonInclude(UIComponent component, ResponseWriter writer) throws IOException {
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, JavaScriptUtilities.isDebug() ? "jsonUncompressed" : "json");
    }

    private static void renderPrototypeInclude(UIComponent component, ResponseWriter writer) throws IOException {
        Map map = JavaScriptUtilities.getRequestMap();
        if (!map.containsKey("com.sun.faces.extensions.avatar.LINKED/prototype.js")) {
            JavaScriptUtilities.renderJavaScriptInclude(component, writer, JavaScriptUtilities.isDebug() ? "prototypeUncompressed" : "prototype");
            map.put("com.sun.faces.extensions.avatar.LINKED/prototype.js", Boolean.TRUE);
        }
    }

    private static void renderWebuiInclude(UIComponent component, ResponseWriter writer, boolean webuiAll, boolean webuiJsfx) throws IOException {
        String webui = null;
        webui = webuiAll ? (webuiJsfx ? (JavaScriptUtilities.isDebug() ? "webuiJsfxAllUncompressed" : "webuiJsfxAll") : (JavaScriptUtilities.isDebug() ? "webuiAllUncompressed" : "webuiAll")) : (webuiJsfx ? (JavaScriptUtilities.isDebug() ? "webuiJsfxUncompressed" : "webuiJsfx") : (JavaScriptUtilities.isDebug() ? "webuiUncompressed" : "webui"));
        JavaScriptUtilities.renderJavaScriptInclude(component, writer, webui);
    }
}

