/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import com.sun.wbem.solarisprovider.lvm.Solaris_VMUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.PropertyProvider;
import javax.wbem.query.SelectExp;

public class Solaris_VMSoftPartition
implements InstanceProvider,
Authorizable,
PropertyProvider,
EventProvider {
    private CIMOMHandle cimomhandle = null;
    private SVM slvm = null;
    private String hostName = null;
    private String[] deviceTypes = new String[]{"Raid", "Stripe", "Mirror", "Concat", "Trans", "Disk"};

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        try {
            this.slvm = SVM.instance();
        }
        catch (RemoteException remoteException) {
            String string = remoteException.getMessage();
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                throw new CIMException(string);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.slvm = null;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void cleanup() throws CIMException {
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        Solaris_VMUtil.authorizeFilter(cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle);
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return Solaris_VMUtil.mustPoll(string);
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        Solaris_VMUtil.activateFilter(string, cIMObjectPath, bl, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            Solaris_VMUtil.deActivateFilter(string, cIMObjectPath, (ProviderCIMOMHandle)this.cimomhandle, this.slvm);
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        if (this.slvm == null) {
            return null;
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        try {
            return this.softPartToCI(device, cIMClass, bl, bl2, bl3, stringArray);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMObjectPath[0];
            }
            ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
            String string = cIMObjectPath.getObjectName();
            String string2 = cIMObjectPath.getNameSpace();
            Vector vector = this.slvm.getDevices("SoftPartition");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string, string2);
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.hostName));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMSoftPartition"));
                cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)device.getProperty("device key").toString()));
                arrayList.add(cIMObjectPath2);
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[arrayList.size()];
            arrayList.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            if (this.slvm == null) {
                return new CIMInstance[0];
            }
            ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
            String string = cIMObjectPath.getObjectName();
            String string2 = cIMObjectPath.getNameSpace();
            Vector vector = this.slvm.getDevices("SoftPartition");
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                Device device = (Device)vector.elementAt(i);
                arrayList.add(this.softPartToCI(device, cIMClass, bl, bl2, bl3, stringArray));
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[arrayList.size()];
            arrayList.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        String string;
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        String string2 = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        if (string2 == null) {
            string2 = Solaris_VMUtil.getMDName(this.slvm, false);
        }
        if ((string = (String)Solaris_VMUtil.getValue(cIMInstance, "Component")) == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Component");
        }
        Device device = null;
        for (int i = 0; i < this.deviceTypes.length && (device = Solaris_VMUtil.getDeviceByAttr(this.slvm, string, "name", this.deviceTypes[i])) == null; ++i) {
        }
        String string3 = null;
        string3 = device != null ? Solaris_VMUtil.getDiskSet(this.slvm, device) : Solaris_VMUtil.getSliceDiskSet(this.slvm, string);
        Boolean bl = (Boolean)Solaris_VMUtil.getValue(cIMInstance, "RePartition");
        UnsignedInt64 unsignedInt64 = (UnsignedInt64)Solaris_VMUtil.getValue(cIMInstance, "Size");
        if (unsignedInt64 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Size");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metainit");
        if (string3 != null) {
            arrayList.add("-s");
            arrayList.add(string3);
        }
        arrayList.add(string2);
        arrayList.add("-p");
        if (bl != null && bl.booleanValue()) {
            arrayList.add("-e");
        }
        arrayList.add(string);
        arrayList.add(unsignedInt64.toString() + "b");
        Solaris_VMUtil.run(arrayList, this.hostName);
        Solaris_VMUtil.flush(this.slvm, string3);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
        String string4 = null;
        string4 = string3 != null ? string3 + "/" + string2 : string2;
        Device device2 = Solaris_VMUtil.getDeviceByAttr(this.slvm, string4, "name", "SoftPartition");
        Long l = (Long)device2.getProperty("device key");
        cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_VMSoftPartition"));
        cIMObjectPath2.addKey("SystemName", new CIMValue((Object)this.hostName));
        cIMObjectPath2.addKey("DeviceID", new CIMValue((Object)l.toString()));
        return cIMObjectPath2;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)device.getProperty("name");
        String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/sbin/metaclear");
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        arrayList.add(string);
        Solaris_VMUtil.run(arrayList, this.hostName);
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Long l;
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        String string = (String)Solaris_VMUtil.getValue(cIMInstance, "MetaDevice");
        if (string != null) {
            Solaris_VMUtil.rename(this.slvm, device, string);
        }
        UnsignedInt64 unsignedInt64 = (UnsignedInt64)Solaris_VMUtil.getValue(cIMInstance, "Size");
        long l2 = 0L;
        if (unsignedInt64 != null) {
            l = (Long)device.getProperty("size");
            Long l3 = new Long(unsignedInt64.toString());
            if (l > l3) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Size");
            }
            l2 = l3 - l;
            if (l2 != 0L) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string2 = Solaris_VMUtil.getDiskSet(this.slvm, device);
                arrayList.add("/usr/sbin/metattach");
                if (string2 != null) {
                    arrayList.add("-s");
                    arrayList.add(string2);
                }
                if (string != null) {
                    arrayList.add(string);
                } else {
                    arrayList.add((String)device.getProperty("name"));
                }
                arrayList.add(new Long(l2).toString() + "b");
                Solaris_VMUtil.run(arrayList, this.hostName);
                Solaris_VMUtil.flush(this.slvm, string2);
            }
        }
        if ((l = (UnsignedInt16)Solaris_VMUtil.getValue(cIMInstance, "StatusInfo")) != null) {
            this.enable(device, (UnsignedInt16)l);
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray = this.enumerateInstances(cIMObjectPath, false, false, false, null, cIMClass);
        return Solaris_VMUtil.execQuery(cIMInstanceArray, string, string2);
    }

    public CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"propertyName");
        }
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = this.cimomhandle.getInstance(cIMObjectPath, false, false, false, null);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
        if (cIMInstance == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        CIMProperty cIMProperty = cIMInstance.getProperty(string2);
        if (cIMProperty == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        CIMValue cIMValue = cIMProperty.getValue();
        return cIMValue;
    }

    public void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        Solaris_VMUtil.checkRights((ProviderCIMOMHandle)this.cimomhandle, "solaris.admin.volmgr.write", cIMObjectPath);
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        if (!(string2.equalsIgnoreCase("MetaDevice") || string2.equalsIgnoreCase("Size") || string2.equalsIgnoreCase("StatusInfo"))) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string2);
        }
        Device device = Solaris_VMUtil.getDeviceByOP(this.slvm, cIMObjectPath);
        if (device == null) {
            throw new CIMException("CIM_ERR_NOT_FOUND", (Object)cIMObjectPath);
        }
        if (string2.equalsIgnoreCase("MetaDevice")) {
            String string3 = (String)cIMValue.getValue();
            Solaris_VMUtil.rename(this.slvm, device, string3);
        } else if (string2.equalsIgnoreCase("Size")) {
            String string4 = (String)device.getProperty("name");
            UnsignedInt64 unsignedInt64 = (UnsignedInt64)cIMValue.getValue();
            Long l = (Long)device.getProperty("size");
            Long l2 = new Long(unsignedInt64.toString());
            if (l > l2) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)"Size");
            }
            long l3 = l2 - l;
            if (l3 != 0L) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("/usr/sbin/metattach");
                String string5 = Solaris_VMUtil.getDiskSet(this.slvm, device);
                if (string5 != null) {
                    arrayList.add("-s");
                    arrayList.add(string5);
                }
                arrayList.add(string4);
                arrayList.add(new Long(l3).toString() + "b");
                Solaris_VMUtil.run(arrayList, this.hostName);
            }
        } else if (string2.equalsIgnoreCase("StatusInfo")) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
            this.enable(device, unsignedInt16);
        }
    }

    private void enable(Device device, UnsignedInt16 unsignedInt16) throws CIMException {
        if (unsignedInt16 == null || unsignedInt16.intValue() != 3) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)unsignedInt16);
        }
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(this.getStatusInfo(this.getSoftPartState(device)));
        if (unsignedInt16.intValue() == unsignedInt162.intValue()) {
            return;
        }
        if (this.slvm == null) {
            throw new CIMException("CIM_ERR_METHOD_NOT_AVAILABLE");
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = null;
            string = Solaris_VMUtil.getDiskSet(this.slvm, device);
            arrayList.add("/usr/sbin/metarecover");
            if (string != null) {
                arrayList.add("-s");
                arrayList.add(string);
            }
            Vector vector = null;
            vector = this.slvm.getAntecedents(device, "BasedOn");
            if (vector == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)device);
            }
            vector = this.slvm.getAntecedents((Device)vector.elementAt(0), "BasedOn");
            Device device2 = (Device)vector.elementAt(0);
            arrayList.add((String)device2.getProperty("name"));
            arrayList.add("-p");
            Solaris_VMUtil.run(arrayList, this.hostName);
            arrayList.clear();
            arrayList.add("/usr/sbin/metareplace");
            string = Solaris_VMUtil.getDiskSet(this.slvm, device);
            if (string != null) {
                arrayList.add("-s");
                arrayList.add(string);
            }
            arrayList.add("-f");
            arrayList.add("-e");
            vector = this.slvm.getDependents(device, "BasedOn");
            if (vector == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)device);
            }
            Device device3 = (Device)vector.elementAt(0);
            String string2 = (String)device3.getProperty("name");
            arrayList.add(string2);
            arrayList.add((String)device.getProperty("name"));
            Solaris_VMUtil.run(arrayList, this.hostName);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.getMessage());
        }
    }

    private CIMInstance softPartToCI(Device device, CIMClass cIMClass, boolean bl, boolean bl2, boolean bl3, String[] stringArray) throws CIMException {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        cIMInstance.setProperty("SystemName", new CIMValue((Object)this.hostName));
        cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_VMSoftPartition"));
        Long l = (Long)device.getProperty("device key");
        cIMInstance.setProperty("DeviceID", new CIMValue((Object)l.toString()));
        Date date = (Date)device.getProperty("time");
        if (date != null) {
            cIMInstance.setProperty("InstallDate", new CIMValue((Object)new CIMDateTime(date)));
        }
        Boolean bl4 = (Boolean)device.getProperty("on slice");
        cIMInstance.setProperty("IsAvailableAsComponent", new CIMValue((Object)bl4));
        String string = this.getSoftPartState(device);
        cIMInstance.setProperty("Status", new CIMValue((Object)string));
        cIMInstance.setProperty("StatusInfo", new CIMValue((Object)new UnsignedInt16(this.getStatusInfo(string))));
        String string2 = (String)device.getProperty("name");
        cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string2));
        Long l2 = (Long)device.getProperty("size");
        long l3 = l2;
        cIMInstance.setProperty("Size", new CIMValue((Object)new UnsignedInt64(String.valueOf(l3))));
        cIMInstance.setProperty("DataOrganization", new CIMValue((Object)new UnsignedInt16(2)));
        cIMInstance.setProperty("Access", new CIMValue((Object)new UnsignedInt16(3)));
        cIMInstance.setProperty("BlockSize", new CIMValue((Object)Solaris_VMUtil.BLOCKSIZE));
        Boolean bl5 = this.checkUnderlyingRedundancy(device);
        cIMInstance.setProperty("IsBasedOnUnderlyingRedundancy", new CIMValue((Object)bl5));
        cIMInstance.setProperty("SequentialAccess", new CIMValue((Object)Boolean.FALSE));
        cIMInstance.setProperty("PowerManagementSupported", new CIMValue((Object)Boolean.FALSE));
        Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>();
        vector.add(new UnsignedInt16(1));
        cIMInstance.setProperty("PowerManagementCapabilities", new CIMValue(vector));
        cIMInstance.setProperty("Availability", new CIMValue((Object)new UnsignedInt16(3)));
        cIMInstance.setProperty("LastErrorCode", new CIMValue((Object)new UnsignedInt32(0L)));
        Vector<UnsignedInt16> vector2 = new Vector<UnsignedInt16>();
        vector2.add(new UnsignedInt16(6));
        cIMInstance.setProperty("AdditionalAvailability", new CIMValue(vector2));
        cIMInstance.setProperty("MaxQuiesceTime", new CIMValue((Object)new UnsignedInt64("0")));
        cIMInstance.setProperty("Name", new CIMValue((Object)string2));
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    private int getStatusInfo(String string) {
        if (string == null) {
            return 5;
        }
        if (string.equalsIgnoreCase("Errored")) {
            return 4;
        }
        if (string.equalsIgnoreCase("Deleting")) {
            return 2;
        }
        return 3;
    }

    private String getSoftPartState(Device device) {
        Integer n = (Integer)device.getProperty("state");
        int n2 = n;
        String string = "";
        switch (n2) {
            case 0: {
                string = "Creating";
                break;
            }
            case 1: {
                string = "Growing";
                break;
            }
            case 2: {
                string = "Deleting";
                break;
            }
            case 3: {
                string = "Okay";
                break;
            }
            case 4: {
                string = "Errored";
                break;
            }
            case 5: {
                string = "Recovering";
            }
        }
        return string;
    }

    private Boolean checkUnderlyingRedundancy(Device device) throws CIMException {
        Boolean bl = Boolean.FALSE;
        Vector vector = null;
        Device device2 = null;
        try {
            vector = this.slvm.getAntecedents(device, "BasedOn");
            device2 = (Device)vector.elementAt(0);
            vector = this.slvm.getAntecedents(device2, "BasedOn");
            device2 = (Device)vector.elementAt(0);
            if (device2 == null) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)device);
            }
            String string = (String)device2.getProperty("type");
            if (string.equals("Raid") || string.equals("Mirror")) {
                bl = Boolean.TRUE;
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
        return bl;
    }
}

