/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.lvm;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVM;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;
import javax.wbem.client.LocalPasswordCredential;
import javax.wbem.client.LocalUserPrincipal;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class Solaris_VMTc {
    private static BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
    private static boolean printStack = true;
    private static String usage = "[-a className] - get associations - must have object name\n[-A device type] - get API devices\n[-c] - create concat\n[-C] - print all class names\n[-d] - create database\n[-D className] - delete class\n[-e className] - listen for events on class\n[-g className] - getInstances - allows operation on each instance\n[-H hostname] - run on host\n[-h] - create hot spare pool\n[-i className] - enumInstances\n[-m] - create mirror\n[-N namespace] - use namespace (instead of root\\cimv2)\n[-n className] - enumInstanceNames\n[-p className] - print class definition\n[-P ] - print namespaces\n[-q className] - execQuery\n[-r] - create raid5\n[-s] - create stripe\n[-S] - create diskset\n[-t] - create trans\n[-u username password] - login with user & pw";

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length == 0) {
            System.out.println(usage);
            System.exit(1);
        }
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            string = stringArray[n++];
            switch (string.charAt(1)) {
                case 'A': {
                    if (n >= stringArray.length) {
                        System.err.println("Missing device type");
                        System.err.println("Slice, Metadb, Stripe, Concat, Mirror, Raid, Trans, Hsp, HotSpare, Diskset\nDisk, Host, Filesystem");
                        System.exit(1);
                    }
                    Solaris_VMTc.testSlvm(stringArray[n++]);
                    System.exit(0);
                    break;
                }
                case 'H': {
                    if (n >= stringArray.length) {
                        System.err.println("Missing hostname");
                        System.exit(1);
                    }
                    string2 = stringArray[n++];
                    break;
                }
                case 'N': {
                    if (n >= stringArray.length) {
                        System.err.println("Missing namespace");
                        System.exit(1);
                    }
                    string5 = stringArray[n++];
                    break;
                }
                case 'P': {
                    string5 = "\\";
                    break;
                }
                case 'u': {
                    if (n >= stringArray.length - 1) {
                        System.err.println("Missing username and password");
                        System.exit(1);
                    }
                    string3 = stringArray[n++];
                    string4 = stringArray[n++];
                    break;
                }
                case '?': {
                    System.out.println(usage);
                    System.exit(1);
                }
            }
        }
        try {
            CIMNameSpace cIMNameSpace = string5 == null ? new CIMNameSpace(string2) : new CIMNameSpace(string2, string5);
            string = string3 == null ? new CIMClient(cIMNameSpace, (Principal)new LocalUserPrincipal(), (Object)new LocalPasswordCredential()) : new CIMClient(cIMNameSpace, (Principal)new UserPrincipal(string3), (Object)new PasswordCredential(string4));
            int n2 = 0;
            block39: while (n2 < stringArray.length && stringArray[n2].startsWith("-")) {
                String string6 = stringArray[n2++];
                switch (string6.charAt(1)) {
                    case 'A': {
                        continue block39;
                    }
                    case 'a': {
                        if (n2 >= stringArray.length) {
                            Solaris_VMTc.getAssociations((CIMClient)string, null);
                            continue block39;
                        }
                        Solaris_VMTc.getAssociations((CIMClient)string, stringArray[n2++]);
                        continue block39;
                    }
                    case 'c': {
                        Solaris_VMTc.newConcat((CIMClient)string);
                        continue block39;
                    }
                    case 'C': {
                        Solaris_VMTc.printClasses((CIMClient)string);
                        continue block39;
                    }
                    case 'd': {
                        Solaris_VMTc.newStateDB((CIMClient)string);
                        continue block39;
                    }
                    case 'D': {
                        if (n2 >= stringArray.length) {
                            System.err.println("Missing className");
                            System.exit(1);
                        }
                        Solaris_VMTc.deleteClass((CIMClient)string, stringArray[n2++]);
                        continue block39;
                    }
                    case 'e': {
                        if (n2 >= stringArray.length) {
                            System.err.println("Missing className");
                            System.exit(1);
                        }
                        Solaris_VMTc.events((CIMClient)string, stringArray[n2++]);
                        continue block39;
                    }
                    case 'g': {
                        if (n2 >= stringArray.length) {
                            System.err.println("Missing className");
                            System.exit(1);
                        }
                        Solaris_VMTc.getInstances((CIMClient)string, stringArray[n2++]);
                        continue block39;
                    }
                    case 'H': {
                        ++n2;
                        continue block39;
                    }
                    case 'h': {
                        Solaris_VMTc.newHsp((CIMClient)string);
                        continue block39;
                    }
                    case 'i': {
                        if (n2 >= stringArray.length) {
                            System.err.println("Missing className");
                            System.exit(1);
                        }
                        Solaris_VMTc.enumInstances((CIMClient)string, stringArray[n2++]);
                        continue block39;
                    }
                    case 'm': {
                        Solaris_VMTc.newMirror((CIMClient)string);
                        continue block39;
                    }
                    case 'N': {
                        ++n2;
                        continue block39;
                    }
                    case 'n': {
                        if (n2 >= stringArray.length) {
                            System.err.println("Missing className");
                            System.exit(1);
                        }
                        Solaris_VMTc.enumInstanceNames((CIMClient)string, stringArray[n2++]);
                        continue block39;
                    }
                    case 'p': {
                        if (n2 >= stringArray.length) {
                            System.err.println("Missing className");
                            System.exit(1);
                        }
                        Solaris_VMTc.printClass((CIMClient)string, stringArray[n2++]);
                        continue block39;
                    }
                    case 'P': {
                        Solaris_VMTc.printNameSpace((CIMClient)string);
                        continue block39;
                    }
                    case 'q': {
                        if (n2 >= stringArray.length) {
                            System.err.println("Missing className");
                            System.exit(1);
                        }
                        Solaris_VMTc.queryInstances((CIMClient)string, stringArray[n2++]);
                        continue block39;
                    }
                    case 'r': {
                        Solaris_VMTc.newRaid((CIMClient)string);
                        continue block39;
                    }
                    case 's': {
                        Solaris_VMTc.newStripe((CIMClient)string);
                        continue block39;
                    }
                    case 't': {
                        Solaris_VMTc.newTrans((CIMClient)string);
                        continue block39;
                    }
                    case 'T': {
                        Solaris_VMTc.newSoftPart((CIMClient)string);
                        continue block39;
                    }
                    case 'S': {
                        Solaris_VMTc.newDiskSet((CIMClient)string);
                        continue block39;
                    }
                    case 'u': {
                        ++n2;
                        ++n2;
                        continue block39;
                    }
                    case 'x': {
                        Solaris_VMTc.createAssociations((CIMClient)string);
                        continue block39;
                    }
                }
                System.err.println("Unknown attribute");
                System.err.println(usage);
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void enumInstanceNames(CIMClient cIMClient, String string) {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            Enumeration enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath);
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                System.out.println(cIMObjectPath2);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void getInstances(CIMClient cIMClient, String string) {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            Enumeration enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath);
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance;
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                System.out.println(cIMObjectPath2);
                String string2 = Solaris_VMTc.prompt("[d|g|m|M|p|s|S|u|U]? ");
                if (string2 == null) continue;
                if (string2.equalsIgnoreCase("d")) {
                    Solaris_VMTc.delete(cIMClient, cIMObjectPath2);
                    continue;
                }
                if (string2.equalsIgnoreCase("g")) {
                    cIMInstance = cIMClient.getInstance(cIMObjectPath2, false, false, false, null);
                    Solaris_VMTc.getProperties(cIMClient, cIMInstance, false, false);
                    continue;
                }
                if (string2.equals("m")) {
                    Solaris_VMTc.method(cIMClient, cIMObjectPath2);
                    continue;
                }
                if (string2.equals("M")) {
                    Solaris_VMTc.methodNot(cIMClient, cIMObjectPath2);
                    continue;
                }
                if (string2.equalsIgnoreCase("p")) {
                    cIMInstance = cIMClient.getInstance(cIMObjectPath2, false, false, false, null);
                    System.out.println(cIMInstance);
                    continue;
                }
                if (string2.equals("s")) {
                    cIMInstance = cIMClient.getInstance(cIMObjectPath2, false, true, false, null);
                    Solaris_VMTc.setProperties(cIMClient, cIMObjectPath2, cIMInstance);
                    continue;
                }
                if (string2.equals("S")) {
                    cIMInstance = cIMClient.getInstance(cIMObjectPath2, false, true, false, null);
                    Solaris_VMTc.setROProperties(cIMClient, cIMObjectPath2, cIMInstance);
                    continue;
                }
                if (string2.equals("u")) {
                    cIMInstance = cIMClient.getInstance(cIMObjectPath2, false, true, false, null);
                    Solaris_VMTc.update(cIMClient, cIMObjectPath2, cIMInstance);
                    continue;
                }
                if (!string2.equals("U")) continue;
                cIMInstance = cIMClient.getInstance(cIMObjectPath2, false, true, false, null);
                Solaris_VMTc.updateRO(cIMClient, cIMObjectPath2, cIMInstance);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void queryInstances(CIMClient cIMClient, String string) {
        try {
            String string2;
            String string3;
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            String string4 = Solaris_VMTc.prompt("attribute name? ");
            if (string4 == null) {
                string4 = string.equals("Solaris_VMStateDatabase") ? "DeviceID" : (string.equals("Solaris_VMExtent") ? "DeviceID" : (string.equals("Solaris_VMDiskSet") ? "CollectionID" : (string.equals("Solaris_VMConcatComponent") || string.equals("Solaris_VMMirrorSubmirrors") ? "Order" : (string.equals("Solaris_VMHotSpares") ? "HotStandby" : "MetaDevice"))));
            }
            if ((string3 = Solaris_VMTc.prompt("attribute Type? ")) == null) {
                string3 = "String";
            }
            if ((string2 = Solaris_VMTc.prompt("attribute value? ")) == null) {
                string2 = "*";
            }
            Object object = null;
            if (string3.equalsIgnoreCase("String")) {
                object = string2;
            } else if (string3.equalsIgnoreCase("U32")) {
                object = new UnsignedInt32(string2);
            } else if (string3.equalsIgnoreCase("U64")) {
                object = new UnsignedInt64(string2);
            } else if (string3.equalsIgnoreCase("Boolean")) {
                object = Boolean.valueOf(string2);
            }
            System.out.println("attrName = " + string4);
            System.out.println("attrValue = " + object);
            String string5 = null;
            string5 = string3.equalsIgnoreCase("String") ? "SELECT * from " + string + " WHERE " + string4 + "='" + object + "'" : "SELECT * from " + string + " WHERE " + string4 + "=" + object;
            System.out.println("query = " + string5);
            Enumeration enumeration = cIMClient.execQuery(cIMObjectPath, string5, "WQL");
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                System.out.println(cIMInstance);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void enumInstances(CIMClient cIMClient, String string) {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            Enumeration enumeration = cIMClient.enumerateInstances(cIMObjectPath, true, false);
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                System.out.println(cIMInstance);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void events(CIMClient cIMClient, String string) {
        try {
            cIMClient.addCIMListener(new CIMListener(){

                public void indicationOccured(CIMEvent cIMEvent) {
                    System.out.println("Got event " + cIMEvent.getIndication());
                }
            });
            CIMClass cIMClass = cIMClient.getClass(new CIMObjectPath("Solaris_JAVAXRMIDelivery"), false, true, true, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            CIMObjectPath cIMObjectPath = cIMClient.createInstance(new CIMObjectPath(), cIMInstance);
            CIMObjectPath cIMObjectPath2 = Solaris_VMTc.getFilter("SELECT * FROM CIM_InstCreation WHERE sourceInstance ISA " + string, cIMClient);
            Solaris_VMTc.bindFilterToHandler(cIMObjectPath2, cIMObjectPath, cIMClient);
            cIMObjectPath2 = Solaris_VMTc.getFilter("SELECT * FROM CIM_InstDeletion WHERE sourceInstance ISA " + string, cIMClient);
            Solaris_VMTc.bindFilterToHandler(cIMObjectPath2, cIMObjectPath, cIMClient);
            cIMObjectPath2 = Solaris_VMTc.getFilter("SELECT * FROM CIM_InstModification WHERE sourceInstance ISA " + string, cIMClient);
            Solaris_VMTc.bindFilterToHandler(cIMObjectPath2, cIMObjectPath, cIMClient);
            System.out.println("Wait for events");
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void bindFilterToHandler(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, CIMClient cIMClient) {
        try {
            CIMClass cIMClass = cIMClient.getClass(new CIMObjectPath("CIM_IndicationSubscription"), true, true, true, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("filter", new CIMValue((Object)cIMObjectPath));
            cIMInstance.setProperty("handler", new CIMValue((Object)cIMObjectPath2));
            CIMObjectPath cIMObjectPath3 = cIMClient.createInstance(new CIMObjectPath(), cIMInstance);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
    }

    private static CIMObjectPath getFilter(String string, CIMClient cIMClient) {
        try {
            CIMClass cIMClass = cIMClient.getClass(new CIMObjectPath("CIM_IndicationFilter"), true, true, true, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("Query", new CIMValue((Object)string));
            cIMInstance.setProperty("QueryLanguage", new CIMValue((Object)"WQL"));
            CIMObjectPath cIMObjectPath = cIMClient.createInstance(new CIMObjectPath(), cIMInstance);
            return cIMObjectPath;
        }
        catch (CIMException cIMException) {
            System.err.println((Object)cIMException);
            return null;
        }
    }

    private static void newStateDB(CIMClient cIMClient) {
        try {
            String string;
            String string2;
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMStateDatabase");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string3 = Solaris_VMTc.prompt("slice name? ");
            if (string3 != null) {
                cIMInstance.setProperty("Name", new CIMValue((Object)string3));
            }
            if ((string2 = Solaris_VMTc.prompt("num blocks? ")) != null) {
                cIMInstance.setProperty("NumberOfBlocks", new CIMValue((Object)new UnsignedInt32(string2)));
            }
            if ((string = Solaris_VMTc.prompt("num replicas? ")) != null) {
                cIMInstance.setProperty("NumReplicas", new CIMValue((Object)new UnsignedInt32(string)));
            }
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath2);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void newSoftPart(CIMClient cIMClient) {
        try {
            String string;
            String string2;
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMSoftPartition");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string3 = Solaris_VMTc.prompt("Soft Partition name? ");
            if (string3 != null) {
                cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string3));
            }
            if ((string2 = Solaris_VMTc.prompt("Component to use? ")) != null) {
                cIMInstance.setProperty("Component", new CIMValue((Object)string2));
            }
            if ((string = Solaris_VMTc.prompt("Size for soft partition? ")) != null) {
                cIMInstance.setProperty("Size", new CIMValue((Object)new UnsignedInt32(string)));
            }
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void newDiskSet(CIMClient cIMClient) {
        try {
            String string;
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMDiskSet");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string2 = Solaris_VMTc.prompt("set name? ");
            if (string2 != null) {
                cIMInstance.setProperty("CollectionID", new CIMValue((Object)string2));
            }
            if ((string = Solaris_VMTc.prompt("host name? ")) != null) {
                cIMInstance.setProperty("HostName", new CIMValue((Object)string));
            }
            System.out.println("ci " + cIMInstance);
            System.out.println("cop " + cIMObjectPath);
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath2);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void newStripe(CIMClient cIMClient) {
        try {
            String string;
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMStripe");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string2 = Solaris_VMTc.prompt("device name? ");
            if (string2 != null) {
                cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string2));
            }
            if ((string = Solaris_VMTc.prompt("interlace? ")) != null) {
                cIMInstance.setProperty("Interlace", new CIMValue((Object)new UnsignedInt32(string)));
            }
            Vector<String> vector = new Vector<String>();
            String string3 = Solaris_VMTc.prompt("sliceName? ");
            while (string3 != null) {
                vector.add(string3);
                string3 = Solaris_VMTc.prompt("sliceName? ");
            }
            cIMInstance.setProperty("StripeComponents", new CIMValue(vector));
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath2);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void newTrans(CIMClient cIMClient) {
        try {
            String string;
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMTrans");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string2 = Solaris_VMTc.prompt("Trans name? ");
            if (string2 != null) {
                cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string2));
            }
            if ((string = Solaris_VMTc.prompt("Master name? ")) != null) {
                cIMInstance.setProperty("masterName", new CIMValue((Object)string));
            }
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath2);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void newConcat(CIMClient cIMClient) {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMConcat");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string = Solaris_VMTc.prompt("device name? ");
            if (string != null) {
                cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string));
            }
            Vector<String> vector = new Vector<String>();
            String string2 = Solaris_VMTc.prompt("sliceName? ");
            while (string2 != null) {
                vector.add(string2);
                string2 = Solaris_VMTc.prompt("sliceName? ");
            }
            cIMInstance.setProperty("ConcatComponents", new CIMValue(vector));
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath2);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void newHsp(CIMClient cIMClient) {
        try {
            String string;
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMHotSparePool");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string2 = Solaris_VMTc.prompt("Hot Spare Pool Name? ");
            if (string2 != null) {
                cIMInstance.setProperty("Name", new CIMValue((Object)string2));
            }
            if ((string = Solaris_VMTc.prompt("Slice to include in hot spare pool? ")) != null) {
                cIMInstance.setProperty("HotSpareComponent", new CIMValue((Object)string));
            }
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath2);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void newMirror(CIMClient cIMClient) {
        try {
            String string;
            String string2;
            String string3;
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMMirror");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string4 = Solaris_VMTc.prompt("device name? ");
            if (string4 != null) {
                cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string4));
            }
            if ((string4 = Solaris_VMTc.prompt("SubMirror name? ")) != null) {
                cIMInstance.setProperty("SubMirror", new CIMValue((Object)string4));
            }
            if ((string3 = Solaris_VMTc.prompt("ReadOption? ")) != null) {
                cIMInstance.setProperty("ReadOption", new CIMValue((Object)new UnsignedInt16(string3)));
            }
            if ((string2 = Solaris_VMTc.prompt("WriteOption? ")) != null) {
                cIMInstance.setProperty("WriteOption", new CIMValue((Object)new UnsignedInt16(string2)));
            }
            if ((string = Solaris_VMTc.prompt("Pass? ")) != null) {
                cIMInstance.setProperty("Pass", new CIMValue((Object)new UnsignedInt32(string)));
            }
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath2);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void newRaid(CIMClient cIMClient) {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMRaid5");
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string = Solaris_VMTc.prompt("device name? ");
            if (string != null) {
                cIMInstance.setProperty("MetaDevice", new CIMValue((Object)string));
            }
            Vector<String> vector = new Vector<String>();
            string = Solaris_VMTc.prompt("Component name? ");
            while (string != null) {
                vector.add(string);
                string = Solaris_VMTc.prompt("Component name? ");
            }
            cIMInstance.setProperty("Raid5Components", new CIMValue(vector));
            String string2 = Solaris_VMTc.prompt("interlace? ");
            if (string2 != null) {
                cIMInstance.setProperty("Interlace", new CIMValue((Object)new UnsignedInt32(string2)));
            }
            CIMObjectPath cIMObjectPath2 = cIMClient.createInstance(cIMObjectPath, cIMInstance);
            System.out.println(cIMObjectPath2);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void method(CIMClient cIMClient, CIMObjectPath cIMObjectPath) {
        String string = cIMObjectPath.getObjectName();
        try {
            if (string.equals("Solaris_VMStripe")) {
                Solaris_VMTc.stripeMethod(cIMClient, cIMObjectPath);
            } else if (string.equals("Solaris_VMConcat")) {
                Solaris_VMTc.concatMethod(cIMClient, cIMObjectPath);
            } else if (string.equals("Solaris_VMMirror")) {
                Solaris_VMTc.mirrorMethod(cIMClient, cIMObjectPath);
            } else if (string.equals("Solaris_VMRaid5")) {
                Solaris_VMTc.raidMethod(cIMClient, cIMObjectPath);
            } else if (string.equals("Solaris_VMTrans")) {
                Solaris_VMTc.transMethod(cIMClient, cIMObjectPath);
            } else if (string.equals("Solaris_VMHotSparePool")) {
                Solaris_VMTc.hspMethod(cIMClient, cIMObjectPath);
            } else if (string.equals("Solaris_VMDiskSet")) {
                Solaris_VMTc.disksetMethod(cIMClient, cIMObjectPath);
            } else {
                System.out.println("no method code for " + string);
            }
        }
        catch (CIMException cIMException) {
            System.out.println("Exception: " + cIMException.getMessage());
            Solaris_VMTc.printExceptionMessages((Exception)((Object)cIMException), printStack);
        }
    }

    private static void methodNot(CIMClient cIMClient, CIMObjectPath cIMObjectPath) {
        String string = cIMObjectPath.getObjectName();
        try {
            Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
            vector.add(new UnsignedInt32(1L));
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "foo", vector, null));
        }
        catch (CIMException cIMException) {
            System.out.println("Exception: " + cIMException.getMessage());
            Solaris_VMTc.printExceptionMessages((Exception)((Object)cIMException), printStack);
        }
    }

    private static void stripeMethod(CIMClient cIMClient, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = Solaris_VMTc.prompt("[a|h]? ");
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("a")) {
            Vector<Object> vector = new Vector<Object>();
            String string2 = Solaris_VMTc.prompt("interlace? ");
            vector.add(new UnsignedInt32(string2));
            Vector<String> vector2 = new Vector<String>();
            String string3 = Solaris_VMTc.prompt("sliceName? ");
            while (string3 != null) {
                vector2.add(string3);
                string3 = Solaris_VMTc.prompt("sliceName? ");
            }
            vector.add(vector2);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "attach", vector, null));
        } else if (string.equalsIgnoreCase("h")) {
            Vector<String> vector = new Vector<String>();
            String string4 = Solaris_VMTc.prompt("hspName? ");
            if (string4 == null) {
                vector.add("");
            } else {
                vector.add(string4);
            }
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "useHSP", vector, null));
        }
    }

    private static void concatMethod(CIMClient cIMClient, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = Solaris_VMTc.prompt("[a|h]? ");
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("a")) {
            Vector<Object> vector = new Vector<Object>();
            String string2 = Solaris_VMTc.prompt("interlace? ");
            vector.add(new UnsignedInt32(string2));
            Vector<String> vector2 = new Vector<String>();
            String string3 = Solaris_VMTc.prompt("sliceName? ");
            while (string3 != null) {
                vector2.add(string3);
                string3 = Solaris_VMTc.prompt("sliceName? ");
            }
            vector.add(vector2);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "attach", vector, null));
        } else if (string.equalsIgnoreCase("h")) {
            Vector<String> vector = new Vector<String>();
            String string4 = Solaris_VMTc.prompt("hspName? ");
            if (string4 == null) {
                vector.add("");
            } else {
                vector.add(string4);
            }
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "useHSP", vector, null));
        }
    }

    private static void mirrorMethod(CIMClient cIMClient, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = Solaris_VMTc.prompt("[a|d|f|n|r|s]? ");
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("a")) {
            Vector<String> vector = new Vector<String>();
            String string2 = Solaris_VMTc.prompt("subMirror? ");
            vector.add(string2);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "attach", vector, null));
        } else if (string.equalsIgnoreCase("d")) {
            Vector<String> vector = new Vector<String>();
            String string3 = Solaris_VMTc.prompt("subMirror? ");
            vector.add(string3);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "detach", vector, null));
        } else if (string.equalsIgnoreCase("f")) {
            Vector<String> vector = new Vector<String>();
            String string4 = Solaris_VMTc.prompt("subMirror? ");
            vector.add(string4);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "offline", vector, null));
        } else if (string.equalsIgnoreCase("n")) {
            Vector<String> vector = new Vector<String>();
            String string5 = Solaris_VMTc.prompt("subMirror? ");
            vector.add(string5);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "online", vector, null));
        } else if (string.equalsIgnoreCase("r")) {
            Vector<String> vector = new Vector<String>();
            String string6 = Solaris_VMTc.prompt("first component? ");
            vector.add(string6);
            String string7 = Solaris_VMTc.prompt("second component? ");
            vector.add(string7);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "replace", vector, null));
        } else if (string.equalsIgnoreCase("s")) {
            Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
            UnsignedInt32 unsignedInt32 = new UnsignedInt32(Solaris_VMTc.prompt("blockSize? "));
            vector.add(unsignedInt32);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "resync", vector, null));
        }
    }

    private static void raidMethod(CIMClient cIMClient, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = Solaris_VMTc.prompt("[a|r|h|s]? ");
        if (string.equalsIgnoreCase("a")) {
            Vector<String> vector = new Vector<String>();
            String string2 = Solaris_VMTc.prompt("Slice to attach? ");
            if (string2 != null) {
                vector.add(string2);
            }
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "attach", vector, null));
        } else if (string.equalsIgnoreCase("r")) {
            Vector<String> vector = new Vector<String>();
            String string3 = Solaris_VMTc.prompt("Component to replace? ");
            String string4 = Solaris_VMTc.prompt("Component to use as replacement? ");
            if (string3 == null || string4 == null) {
                System.out.println("Must indicated two components");
                System.exit(0);
            }
            vector.add(string3);
            vector.add(string4);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "replace", vector, null));
        } else if (string.equalsIgnoreCase("h")) {
            Vector<String> vector = new Vector<String>();
            String string5 = Solaris_VMTc.prompt("hsp name? ");
            if (string5 == null) {
                vector.add("");
            } else {
                vector.add(string5);
            }
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "useHSP", vector, null));
        } else if (string.equalsIgnoreCase("s")) {
            Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
            UnsignedInt32 unsignedInt32 = new UnsignedInt32(Solaris_VMTc.prompt("block Size ?"));
            if (unsignedInt32 == null) {
                System.out.println("Must enter block size");
                System.exit(0);
            }
            vector.add(unsignedInt32);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "resync", vector, null));
        }
    }

    private static void transMethod(CIMClient cIMClient, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = Solaris_VMTc.prompt("[a|d]");
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("a")) {
            Vector<String> vector = new Vector<String>();
            String string2 = Solaris_VMTc.prompt("Log? ");
            vector.add(string2);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "attach", vector, null));
        } else if (string.equalsIgnoreCase("d")) {
            Vector vector = new Vector();
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "detach", vector, null));
        }
    }

    private static void hspMethod(CIMClient cIMClient, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = Solaris_VMTc.prompt("[a|d|r]? ");
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("a")) {
            Vector<String> vector = new Vector<String>();
            String string2 = Solaris_VMTc.prompt("Slice name? ");
            vector.add(string2);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "addHotSpare", vector, null));
        } else if (string.equalsIgnoreCase("d")) {
            Vector<String> vector = new Vector<String>();
            String string3 = Solaris_VMTc.prompt("Slice to remove? ");
            vector.add(string3);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "deleteHotSpare", vector, null));
        } else if (string.equalsIgnoreCase("r")) {
            Vector<String> vector = new Vector<String>();
            String string4 = Solaris_VMTc.prompt("Slice to replace? ");
            String string5 = Solaris_VMTc.prompt("Replacement slice? ");
            vector.add(string4);
            vector.add(string5);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "replace", vector, null));
        }
    }

    private static void disksetMethod(CIMClient cIMClient, CIMObjectPath cIMObjectPath) throws CIMException {
        String string = Solaris_VMTc.prompt("[h|H|d|D|r|s|i]? ");
        if (string == null) {
            return;
        }
        if (string.equals("h")) {
            Vector<String> vector = new Vector<String>();
            String string2 = Solaris_VMTc.prompt("Hostname? ");
            vector.add(string2);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "addHost", vector, null));
        } else if (string.equals("H")) {
            Vector<String> vector = new Vector<String>();
            String string3 = Solaris_VMTc.prompt("Hostname? ");
            vector.add(string3);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "deleteHost", vector, null));
        } else if (string.equals("d")) {
            Vector<String> vector = new Vector<String>();
            String string4 = Solaris_VMTc.prompt("Drive name? ");
            vector.add(string4);
            String string5 = Solaris_VMTc.prompt("Size? ");
            vector.add((String)new UnsignedInt32(string5));
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "addDrive", vector, null));
        } else if (string.equals("D")) {
            Vector<String> vector = new Vector<String>();
            String string6 = Solaris_VMTc.prompt("Drive name? ");
            vector.add(string6);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "deleteDrive", vector, null));
        } else if (string.equals("r")) {
            Vector vector = new Vector();
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "releaseOwner", vector, null));
        } else if (string.equals("s")) {
            Vector<Boolean> vector = new Vector<Boolean>();
            Boolean bl = new Boolean(Solaris_VMTc.prompt("force? "));
            vector.add(bl);
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "setOwner", vector, null));
        } else if (string.equals("i")) {
            Vector vector = new Vector();
            System.out.println(cIMClient.invokeMethod(cIMObjectPath, "distribute", vector, null));
        }
    }

    private static void printClass(CIMClient cIMClient, String string) {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, true, true, null);
            System.out.println(cIMClass);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void printNameSpace(CIMClient cIMClient) {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("");
            Enumeration enumeration = cIMClient.enumNameSpace(cIMObjectPath, true);
            while (enumeration.hasMoreElements()) {
                System.out.println(enumeration.nextElement());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void printClasses(CIMClient cIMClient) {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("");
            Enumeration enumeration = cIMClient.enumerateClassNames(cIMObjectPath, true);
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                System.out.println(cIMObjectPath2.getObjectName());
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void displayPropertValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty == null) {
            System.out.println("no " + string + " property");
        } else {
            CIMValue cIMValue = cIMProperty.getValue();
            if (cIMValue == null) {
                System.out.println(string + " value is null");
            } else {
                Object object = cIMValue.getValue();
                System.out.println(string + ": " + object);
            }
        }
    }

    private static Object getPropertyValue(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty == null) {
            return null;
        }
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue == null) {
            return null;
        }
        return cIMValue.getValue();
    }

    private static void deleteClass(CIMClient cIMClient, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
        try {
            cIMClient.deleteClass(cIMObjectPath);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void delete(CIMClient cIMClient, CIMObjectPath cIMObjectPath) {
        try {
            System.out.println(cIMObjectPath);
            cIMClient.deleteInstance(cIMObjectPath);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void getProperties(CIMClient cIMClient, CIMInstance cIMInstance, boolean bl, boolean bl2) {
        Vector vector = cIMInstance.getProperties();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.get(i);
            String string = cIMProperty.getName();
            try {
                System.out.println(string + ": " + cIMProperty.getValue());
                if (bl) {
                    Vector vector2 = cIMProperty.getQualifiers();
                    for (int j = 0; j < vector2.size(); ++j) {
                        CIMQualifier cIMQualifier = (CIMQualifier)vector2.get(j);
                        if (cIMQualifier == null) continue;
                        System.out.println(string + " Qualifier :" + cIMQualifier);
                    }
                }
                if (!bl2 || cIMProperty.getOriginClass() == null) continue;
                System.out.println(string + " ClassOrigin :" + cIMProperty.getOriginClass());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Exception : " + exception.getMessage());
                Solaris_VMTc.printExceptionMessages(exception, printStack);
            }
        }
    }

    private static void setProperties(CIMClient cIMClient, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
        Vector vector = cIMInstance.getProperties();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.get(i);
            if (!Solaris_VMTc.isWritable(cIMProperty)) continue;
            String string = cIMProperty.getName();
            Object object = Solaris_VMTc.getPropertyValue(cIMInstance, string);
            String string2 = Solaris_VMTc.prompt(string + " [" + object + "]: ");
            if (string2 == null) continue;
            String string3 = object.getClass().getName();
            CIMValue cIMValue = null;
            if (string3.equals("java.lang.String")) {
                cIMValue = new CIMValue((Object)string2);
            } else if (string3.equals("java.lang.Boolean")) {
                cIMValue = new CIMValue((Object)new Boolean(string2));
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt16")) {
                cIMValue = new CIMValue((Object)new UnsignedInt16(string2));
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt32")) {
                cIMValue = new CIMValue((Object)new UnsignedInt32(string2));
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt64")) {
                cIMValue = new CIMValue((Object)new UnsignedInt64(string2));
            }
            try {
                cIMClient.setProperty(cIMObjectPath, string, cIMValue);
                continue;
            }
            catch (CIMException cIMException) {
                System.out.println("Exception : " + cIMException.getMessage());
                Solaris_VMTc.printExceptionMessages((Exception)((Object)cIMException), printStack);
            }
        }
    }

    private static void setROProperties(CIMClient cIMClient, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
        Vector vector = cIMInstance.getProperties();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.get(i);
            if (Solaris_VMTc.isWritable(cIMProperty)) continue;
            String string = cIMProperty.getName();
            Object object = Solaris_VMTc.getPropertyValue(cIMInstance, string);
            String string2 = Solaris_VMTc.prompt("(RO) " + string + " [" + object + "]: ");
            if (string2 == null) continue;
            String string3 = object.getClass().getName();
            CIMValue cIMValue = null;
            if (string3.equals("java.lang.String")) {
                cIMValue = new CIMValue((Object)string2);
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt16")) {
                cIMValue = new CIMValue((Object)new UnsignedInt16(string2));
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt32")) {
                cIMValue = new CIMValue((Object)new UnsignedInt32(string2));
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt64")) {
                cIMValue = new CIMValue((Object)new UnsignedInt64(string2));
            }
            try {
                cIMClient.setProperty(cIMObjectPath, string, cIMValue);
            }
            catch (CIMException cIMException) {
                System.out.println("Exception : " + cIMException.getMessage());
                Solaris_VMTc.printExceptionMessages((Exception)((Object)cIMException), printStack);
            }
            break;
        }
    }

    private static void update(CIMClient cIMClient, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
        Vector vector = cIMInstance.getProperties();
        if (vector == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.get(i);
            if (!Solaris_VMTc.isWritable(cIMProperty)) continue;
            bl = true;
            String string = cIMProperty.getName();
            Object object = Solaris_VMTc.getPropertyValue(cIMInstance, string);
            String string2 = Solaris_VMTc.prompt(string + " [" + object + "]: ");
            if (string2 == null) continue;
            String string3 = object.getClass().getName();
            CIMValue cIMValue = null;
            if (string3.equals("java.lang.String")) {
                cIMValue = new CIMValue((Object)string2);
            } else if (string3.equals("javax.wbem.cim.UnsignedInt16")) {
                cIMValue = new CIMValue((Object)new UnsignedInt16(string2));
            } else if (string3.equals("javax.wbem.cim.UnsignedInt32")) {
                cIMValue = new CIMValue((Object)new UnsignedInt32(string2));
            } else if (string3.equals("javax.wbem.cim.UnsignedInt64")) {
                cIMValue = new CIMValue((Object)new UnsignedInt64(string2));
            } else if (string3.equals("java.lang.Boolean")) {
                cIMValue = new CIMValue((Object)Boolean.valueOf(string2));
            }
            cIMInstance.setProperty(string, cIMValue);
            bl2 = true;
        }
        if (!bl) {
            System.out.println("no writable properties");
        } else if (bl2) {
            try {
                cIMClient.setInstance(cIMObjectPath, cIMInstance);
            }
            catch (CIMException cIMException) {
                System.out.println("Exception: " + cIMException.getMessage());
                Solaris_VMTc.printExceptionMessages((Exception)((Object)cIMException), printStack);
            }
        }
    }

    private static void updateRO(CIMClient cIMClient, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) {
        Vector vector = cIMInstance.getProperties();
        if (vector == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.get(i);
            if (Solaris_VMTc.isWritable(cIMProperty)) continue;
            bl = true;
            String string = cIMProperty.getName();
            Object object = Solaris_VMTc.getPropertyValue(cIMInstance, string);
            String string2 = Solaris_VMTc.prompt(string + " [" + object + "]: ");
            if (string2 == null) continue;
            String string3 = object.getClass().getName();
            CIMValue cIMValue = null;
            if (string3.equals("java.lang.String")) {
                cIMValue = new CIMValue((Object)string2);
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt16")) {
                cIMValue = new CIMValue((Object)new UnsignedInt16(string2));
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt32")) {
                cIMValue = new CIMValue((Object)new UnsignedInt32(string2));
            } else if (string3.equals("com.sun.wbem.cim.UnsignedInt64")) {
                cIMValue = new CIMValue((Object)new UnsignedInt64(string2));
            } else if (string3.equals("java.lang.Boolean")) {
                cIMValue = new CIMValue((Object)new Boolean(Boolean.getBoolean(string2)));
                System.out.println("val " + cIMValue);
            }
            cIMInstance.setProperty(string, cIMValue);
            bl2 = true;
        }
        if (!bl) {
            System.out.println("no RO properties");
        } else if (bl2) {
            try {
                cIMClient.setInstance(cIMObjectPath, cIMInstance);
            }
            catch (CIMException cIMException) {
                System.out.println("Exception : " + cIMException.getMessage());
                Solaris_VMTc.printExceptionMessages((Exception)((Object)cIMException), printStack);
            }
        }
    }

    private static String prompt(String string) {
        System.err.print(string);
        System.err.flush();
        try {
            String string2 = input.readLine();
            if (string2 != null && string2.length() == 0) {
                return null;
            }
            return string2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static boolean isWritable(CIMProperty cIMProperty) {
        Vector vector = cIMProperty.getQualifiers();
        if (vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Boolean bl;
            CIMQualifier cIMQualifier = (CIMQualifier)vector.get(i);
            if (!cIMQualifier.getName().equalsIgnoreCase("write")) continue;
            CIMValue cIMValue = cIMQualifier.getValue();
            if (cIMValue == null || (bl = (Boolean)cIMValue.getValue()) == null || !bl.booleanValue()) break;
            return true;
        }
        return false;
    }

    private static String getOPValue(CIMObjectPath cIMObjectPath, String string) {
        String string2 = null;
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
            if (!cIMProperty.getName().equalsIgnoreCase(string)) continue;
            string2 = (String)cIMProperty.getValue().getValue();
            break;
        }
        return string2;
    }

    private static void getAssociations(CIMClient cIMClient, String string) {
        if (string == null) {
            string = Solaris_VMTc.prompt("Source class:? ");
        }
        if (string == null) {
            System.out.println(usage);
            System.exit(1);
        }
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            Enumeration enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath);
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            Vector<String> vector = new Vector<String>();
            String string7 = null;
            String[] stringArray = null;
            boolean bl = false;
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2;
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                System.out.println(cIMObjectPath3);
                String string8 = Solaris_VMTc.prompt("[a|A|r|R]: ? ");
                if (string8 == null) continue;
                String string9 = Solaris_VMTc.prompt("Association:? ");
                if (string8.equals("a")) {
                    string2 = Solaris_VMTc.prompt("Result class:? ");
                    string3 = Solaris_VMTc.prompt("Role:? ");
                    string4 = Solaris_VMTc.prompt("Result role:? ");
                } else if (string8.equals("A")) {
                    string2 = Solaris_VMTc.prompt("Result class:? ");
                    string3 = Solaris_VMTc.prompt("Role:? ");
                    string4 = Solaris_VMTc.prompt("Result role:? ");
                    string5 = Solaris_VMTc.prompt("Include Qualifiers[y|n] ?");
                    string6 = Solaris_VMTc.prompt("IncludeClassOrigin[y|n] ?");
                    do {
                        if ((string7 = Solaris_VMTc.prompt("Property List Item: ?")) == null) continue;
                        vector.addElement(string7);
                    } while (string7 != null);
                    if (vector.size() > 0) {
                        stringArray = new String[vector.size()];
                        for (int i = 0; i < vector.size(); ++i) {
                            stringArray[i] = (String)vector.elementAt(i);
                        }
                    }
                } else if (string8.equals("r")) {
                    string3 = Solaris_VMTc.prompt("Role:? ");
                } else if (string8.equals("R")) {
                    string3 = Solaris_VMTc.prompt("Role:? ");
                    string5 = Solaris_VMTc.prompt("Include Qualifiers[y|n] ?");
                    string6 = Solaris_VMTc.prompt("IncludeClassOrigin[y|n] ?");
                    vector = new Vector();
                    string7 = null;
                    do {
                        if ((string7 = Solaris_VMTc.prompt("Property List Item: ?")) == null) continue;
                        vector.addElement(string7);
                    } while (string7 != null);
                    if (vector.size() > 0) {
                        stringArray = new String[vector.size()];
                        for (int i = 0; i < vector.size(); ++i) {
                            stringArray[i] = (String)vector.elementAt(i);
                        }
                    }
                }
                if (string5 != null && string5.equalsIgnoreCase("y")) {
                    bl = true;
                }
                if (string6 != null && string6.equalsIgnoreCase("y")) {
                    bl2 = true;
                }
                if (string8.equals("a")) {
                    Enumeration enumeration2 = cIMClient.associatorNames(cIMObjectPath3, string9, string2, string3, string4);
                    System.out.println("e1: " + enumeration2);
                    while (enumeration2.hasMoreElements()) {
                        cIMObjectPath2 = (CIMObjectPath)enumeration2.nextElement();
                        System.out.println(cIMObjectPath2);
                    }
                    continue;
                }
                if (string8.equals("A")) {
                    Enumeration enumeration3 = cIMClient.associators(cIMObjectPath3, string9, string2, string3, string4, bl, bl2, stringArray);
                    while (enumeration3.hasMoreElements()) {
                        cIMObjectPath2 = (CIMInstance)enumeration3.nextElement();
                        Solaris_VMTc.getProperties(cIMClient, (CIMInstance)cIMObjectPath2, bl, bl2);
                    }
                    continue;
                }
                if (string8.equals("r")) {
                    Enumeration enumeration4 = cIMClient.referenceNames(cIMObjectPath3, string9, string3);
                    while (enumeration4.hasMoreElements()) {
                        cIMObjectPath2 = (CIMObjectPath)enumeration4.nextElement();
                        System.out.println(cIMObjectPath2);
                    }
                    continue;
                }
                if (!string8.equals("R")) continue;
                System.out.println("Getting references");
                Enumeration enumeration5 = cIMClient.references(cIMObjectPath3, string9, string3, bl, bl2, stringArray);
                while (enumeration5.hasMoreElements()) {
                    cIMObjectPath2 = (CIMInstance)enumeration5.nextElement();
                    Solaris_VMTc.getProperties(cIMClient, (CIMInstance)cIMObjectPath2, bl, bl2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            Solaris_VMTc.printExceptionMessages(exception, printStack);
        }
    }

    private static void createAssociations(CIMClient cIMClient) {
        block24: {
            String string = Solaris_VMTc.prompt("Association you want to create? ");
            if (string == null) {
                System.out.println(usage);
                System.exit(1);
            }
            try {
                if (string.endsWith("Component") || string.endsWith("Submirrors")) {
                    CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
                    CIMClass cIMClass = cIMClient.getClass(cIMObjectPath, false, false, false, null);
                    CIMInstance cIMInstance = cIMClass.newInstance();
                    String string2 = Solaris_VMTc.prompt("Base class for group component? ");
                    if (string2 == null) {
                        System.out.println(usage);
                        System.exit(1);
                    }
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string2);
                    Enumeration enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath2);
                    block2: while (enumeration.hasMoreElements()) {
                        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                        System.out.println(cIMObjectPath3);
                        String string3 = Solaris_VMTc.prompt("Use as Group Component? ");
                        if (string3 == null) continue;
                        String string4 = Solaris_VMTc.prompt("Base class for part component? ");
                        if (string4 == null) {
                            System.out.println(usage);
                            System.exit(1);
                        }
                        CIMObjectPath cIMObjectPath4 = new CIMObjectPath(string4);
                        Enumeration enumeration2 = cIMClient.enumerateInstanceNames(cIMObjectPath4);
                        while (enumeration2.hasMoreElements()) {
                            CIMObjectPath cIMObjectPath5 = (CIMObjectPath)enumeration2.nextElement();
                            System.out.println(cIMObjectPath5);
                            String string5 = Solaris_VMTc.prompt("Use as part component? ");
                            if (string5 == null) continue;
                            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath3));
                            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath5));
                            cIMClient.createInstance(cIMObjectPath, cIMInstance);
                            String string6 = Solaris_VMTc.prompt("Continue with this assoc? ");
                            if (string6 != null) continue;
                            continue block2;
                        }
                    }
                    break block24;
                }
                if (string.endsWith("Set")) {
                    CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMDiskSet");
                    Enumeration enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath);
                    while (enumeration.hasMoreElements()) {
                        CIMInstance cIMInstance;
                        CIMClass cIMClass;
                        CIMObjectPath cIMObjectPath6;
                        String string7;
                        CIMObjectPath cIMObjectPath7;
                        Enumeration enumeration3;
                        CIMObjectPath cIMObjectPath8;
                        CIMObjectPath cIMObjectPath9 = (CIMObjectPath)enumeration.nextElement();
                        System.out.println(cIMObjectPath9);
                        String string8 = Solaris_VMTc.prompt("Use as disk set? ");
                        if (string8 == null) continue;
                        String string9 = Solaris_VMTc.prompt("Drive or Host: [d|h]? ");
                        if (string9.equalsIgnoreCase("d")) {
                            cIMObjectPath8 = new CIMObjectPath("Solaris_DiskDrive");
                            enumeration3 = cIMClient.enumerateInstanceNames(cIMObjectPath8);
                            while (enumeration3.hasMoreElements()) {
                                cIMObjectPath7 = (CIMObjectPath)enumeration3.nextElement();
                                System.out.println(cIMObjectPath7);
                                string7 = Solaris_VMTc.prompt("Use as drive component? ");
                                if (string7 == null) continue;
                                cIMObjectPath6 = new CIMObjectPath(string);
                                cIMClass = cIMClient.getClass(cIMObjectPath6, false, false, false, null);
                                cIMInstance = cIMClass.newInstance();
                                cIMInstance.setProperty("Collection", new CIMValue((Object)cIMObjectPath9));
                                cIMInstance.setProperty("Member", new CIMValue((Object)cIMObjectPath7));
                                System.out.println("ci: " + cIMInstance);
                                cIMClient.createInstance(cIMObjectPath6, cIMInstance);
                            }
                            continue;
                        }
                        if (!string9.equalsIgnoreCase("h")) continue;
                        cIMObjectPath8 = new CIMObjectPath("Solaris_ComputerSystem");
                        enumeration3 = cIMClient.enumerateInstanceNames(cIMObjectPath8);
                        while (enumeration3.hasMoreElements()) {
                            cIMObjectPath7 = (CIMObjectPath)enumeration3.nextElement();
                            System.out.println(cIMObjectPath7);
                            string7 = Solaris_VMTc.prompt("Use as host? ");
                            if (string7 == null) continue;
                            cIMObjectPath6 = new CIMObjectPath(string);
                            cIMClass = cIMClient.getClass(cIMObjectPath6, false, false, false, null);
                            cIMInstance = cIMClass.newInstance();
                            cIMInstance.setProperty("Collection", new CIMValue((Object)cIMObjectPath9));
                            cIMInstance.setProperty("Member", new CIMValue((Object)cIMObjectPath7));
                            System.out.println("ci: " + cIMInstance);
                            cIMClient.createInstance(cIMObjectPath6, cIMInstance);
                        }
                    }
                    break block24;
                }
                if (string.endsWith("Log")) {
                    CIMObjectPath cIMObjectPath = new CIMObjectPath("Solaris_VMTrans");
                    Enumeration enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath);
                    String string10 = null;
                    block7: while (enumeration.hasMoreElements()) {
                        CIMObjectPath cIMObjectPath10 = (CIMObjectPath)enumeration.nextElement();
                        System.out.println(cIMObjectPath10);
                        String string11 = Solaris_VMTc.prompt("Use as trans device? ");
                        if (string11 == null) continue;
                        String string12 = Solaris_VMTc.prompt("Class to use as log device? ");
                        string10 = string12 == null ? "Solaris_VMRaid5" : string12;
                        CIMObjectPath cIMObjectPath11 = new CIMObjectPath(string12);
                        Enumeration enumeration4 = cIMClient.enumerateInstanceNames(cIMObjectPath11);
                        while (enumeration4.hasMoreElements()) {
                            CIMObjectPath cIMObjectPath12 = (CIMObjectPath)enumeration4.nextElement();
                            System.out.println(cIMObjectPath12);
                            String string13 = Solaris_VMTc.prompt("Use as log? ");
                            if (string13 == null) continue;
                            CIMObjectPath cIMObjectPath13 = new CIMObjectPath(string);
                            CIMClass cIMClass = cIMClient.getClass(cIMObjectPath13, false, false, false, null);
                            CIMInstance cIMInstance = cIMClass.newInstance();
                            cIMInstance.setProperty("Dependent", new CIMValue((Object)cIMObjectPath10));
                            cIMInstance.setProperty("Antecedent", new CIMValue((Object)cIMObjectPath12));
                            cIMClient.createInstance(cIMObjectPath13, cIMInstance);
                            continue block7;
                        }
                    }
                } else if (string.endsWith("Spares")) {
                    String string14;
                    String string15;
                    CIMObjectPath cIMObjectPath;
                    Enumeration enumeration = null;
                    CIMObjectPath cIMObjectPath14 = null;
                    String string16 = null;
                    CIMObjectPath cIMObjectPath15 = new CIMObjectPath("Solaris_VMExtent");
                    enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath15);
                    while (enumeration.hasMoreElements()) {
                        cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                        System.out.println(cIMObjectPath);
                        string15 = Solaris_VMTc.prompt("Use as spare? ");
                        if (string15 == null) continue;
                        cIMObjectPath14 = cIMObjectPath;
                        break;
                    }
                    cIMObjectPath = new CIMObjectPath("Solaris_VMHotSparePool");
                    enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath);
                    while (enumeration.hasMoreElements()) {
                        string15 = (CIMObjectPath)enumeration.nextElement();
                        System.out.println((Object)string15);
                        string14 = Solaris_VMTc.prompt("Use as hot spare pool? ");
                        if (string14 == null) continue;
                        string16 = string15;
                        break;
                    }
                    string15 = new CIMObjectPath("Solaris_VMHotSpares");
                    string14 = cIMClient.getClass((CIMObjectPath)string15, false, false, false, null);
                    CIMInstance cIMInstance = string14.newInstance();
                    cIMInstance.setProperty("Group", new CIMValue((Object)string16));
                    cIMInstance.setProperty("Spare", new CIMValue((Object)cIMObjectPath14));
                    CIMObjectPath cIMObjectPath16 = cIMClient.createInstance((CIMObjectPath)string15, cIMInstance);
                    System.out.println(cIMObjectPath16);
                } else if (string.endsWith("Master")) {
                    String string17;
                    Enumeration enumeration = null;
                    String string18 = Solaris_VMTc.prompt("Class to use as master device? ");
                    if (string18 == null) {
                        string18 = "Solaris_VMExtent";
                    }
                    CIMObjectPath cIMObjectPath = new CIMObjectPath(string18);
                    CIMObjectPath cIMObjectPath17 = null;
                    enumeration = cIMClient.enumerateInstanceNames(cIMObjectPath);
                    while (enumeration.hasMoreElements()) {
                        cIMObjectPath17 = (CIMObjectPath)enumeration.nextElement();
                        System.out.println(cIMObjectPath17);
                        string17 = Solaris_VMTc.prompt("Use as trans master? ");
                        if (string17 == null) continue;
                    }
                    string17 = Solaris_VMTc.prompt("Name for trans device? ");
                    CIMObjectPath cIMObjectPath18 = new CIMObjectPath("Solaris_VMTransMaster");
                    CIMClass cIMClass = cIMClient.getClass(cIMObjectPath18, false, false, false, null);
                    CIMInstance cIMInstance = cIMClass.newInstance();
                    CIMObjectPath cIMObjectPath19 = new CIMObjectPath("Solaris_VMTrans");
                    cIMObjectPath19.addKey("MetaDevice", new CIMValue((Object)string17));
                    cIMInstance.setProperty("Dependent", new CIMValue((Object)cIMObjectPath19));
                    cIMInstance.setProperty("Antecedent", new CIMValue((Object)cIMObjectPath17));
                    CIMObjectPath cIMObjectPath20 = cIMClient.createInstance(cIMObjectPath18, cIMInstance);
                    System.out.println(cIMObjectPath20);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception : " + exception.getMessage());
                Solaris_VMTc.printExceptionMessages(exception, printStack);
            }
        }
    }

    private static void printExceptionMessages(Exception exception, boolean bl) {
        Object[] objectArray = ((CIMException)((Object)exception)).getParams();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                System.out.println(objectArray[i]);
            }
        }
        if (bl) {
            exception.printStackTrace();
        }
        System.exit(1);
    }

    private static void testSlvm(String string) {
        Vector<String> vector = new Vector<String>();
        vector.add("Slice");
        vector.add("Metadb");
        vector.add("Stripe");
        vector.add("Concat");
        vector.add("Mirror");
        vector.add("Raid");
        vector.add("Trans");
        vector.add("Hsp");
        vector.add("HotSpare");
        vector.add("Diskset");
        vector.add("Disk");
        vector.add("Host");
        vector.add("Filesystem");
        if (!vector.contains(string)) {
            System.out.println("Invalid device name");
            System.exit(1);
        }
        String[] stringArray = new String[]{"BasedOn", "ResidesOn", "ExtentInStateDatabase", "DriveInDiskGroup", "ExtentInDiskGroup", "HostInDiskGroup", "ExtentRedundancyComponent", "ExtendRedundancyComponent", "TransLogOn"};
        try {
            SVM sVM = SVM.instance();
            Vector vector2 = sVM.getDevices(string);
            if (vector2 == null) {
                System.out.println("Error, got null vector back");
                System.exit(1);
            }
            System.out.println("Devices:");
            for (int i = 0; i < vector2.size(); ++i) {
                int n;
                Device device = (Device)vector2.get(i);
                System.out.println(device);
                System.out.println();
                for (n = 0; n < stringArray.length; ++n) {
                    Solaris_VMTc.printDependents(sVM, device, stringArray[n]);
                }
                System.out.println();
                for (n = 0; n < stringArray.length; ++n) {
                    Solaris_VMTc.printAntecedents(sVM, device, stringArray[n]);
                }
                System.out.println();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static void printDependents(SVM sVM, Device device, String string) throws RemoteException {
        Vector vector = sVM.getDependents(device, string);
        if (vector != null) {
            if (vector.size() > 0) {
                System.out.println("  DEP - " + string);
            }
            for (int i = 0; i < vector.size(); ++i) {
                Device device2 = (Device)vector.get(i);
                System.out.println("    " + device2);
            }
        }
    }

    private static void printAntecedents(SVM sVM, Device device, String string) throws RemoteException {
        Vector vector = sVM.getAntecedents(device, string);
        if (vector != null) {
            if (vector.size() > 0) {
                System.out.println("  ANT - " + string);
            }
            for (int i = 0; i < vector.size(); ++i) {
                Device device2 = (Device)vector.get(i);
                System.out.println("    " + device2);
            }
        }
    }
}

