/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.util.prodname;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.AttributedString;
import javax.imageio.ImageIO;

public class GenerateProductImage {
    private static final String TM_SEQ = "(tm)";
    private static final String CR_SEQ = "(cr)";
    private static final String tms = String.valueOf('\u2122');
    private Font boldFont;
    private Font demiFont;
    private Font rglrFont;
    private static final String BOLD = "bold";
    private static final String DEMI = "demi";
    private static final String RGLR = "rglr";
    private Font fontPrimary;
    private Font fontPrimaryFirstLine;
    private Font fontPrimarySecondLine;
    private Font fontSecondaryFirstLine;
    private Font fontSecondarySecondLine;
    private Font fontVersionFirstLine;
    private Font fontVersionSecondLine;
    private Font fontSecondary;
    private Font fontVersion;
    private Font fontLogin;
    private Font fontLoginFirstLine;
    private Font fontLoginSecondLine;
    private Font fontJavaTM;
    private String fontLocation = null;
    private String fontVersionLocation = null;
    private static final String FONT_SUPPORT_1 = "com/sun/webui/util/prodname/resources/ProductNameSupport.bin";
    private static final String FONT_SUPPORT_2 = "com/sun/webui/util/prodname/resources/ProductNameSupport2.bin";
    private static final String FONT_SUPPORT_3 = "com/sun/webui/util/prodname/resources/ProductNameSupport3.bin";
    private String primaryFontType = "bold";
    private float primaryFontSize = 21.0f;
    private String secondaryFontType = "bold";
    private float secondaryFontSize = 21.0f;
    private String versionFontType = "demi";
    private float versionFontSize = 21.0f;
    private String loginFontType = "demi";
    private float loginFontSize = 21.0f;
    private String javaTMFontType = "bold";
    private float javaTMFontSize = 21.0f;
    private float primaryFirstLineSize = 21.0f;
    private float primarySecondLineSize = 18.0f;
    private String primarySecondLineType = "bold";
    private float secondaryFirstLineSize = 21.0f;
    private float secondarySecondLineSize = 18.0f;
    private String secondarySecondLineType = "bold";
    private float versionFirstLineSize = 21.0f;
    private float versionSecondLineSize = 18.0f;
    private String versionSecondLineType = "bold";
    private float loginFirstLineSize = 21.0f;
    private float loginSecondLineSize = 18.0f;
    private String loginSecondLineType = "bold";
    private int primaryLeading = 0;
    private int secondaryLeading = 0;
    private int versionLeading = 2;
    private int loginLeading = 2;
    private Color primaryForegroundColor = new Color(255, 255, 255);
    private Color secondaryForegroundColor = new Color(255, 255, 255);
    private Color versionForegroundColor = new Color(62, 100, 126);
    private Color loginForegroundColor = new Color(62, 100, 126);
    private Color primaryBackgroundColor;
    private Color secondaryBackgroundColor = this.primaryBackgroundColor = new Color(80, 98, 112, 0);
    private Color versionBackgroundColor = new Color(255, 255, 255);
    private Color loginBackgroundColor = new Color(255, 255, 255);
    private Color stupidJavaGrayColor = new Color(112, 114, 119);
    private int primaryWidth = 245;
    private int primaryHeight = 23;
    private int primarySplit = 550;
    private int secondaryWidth = 245;
    private int secondaryHeight = 23;
    private int secondarySplit = 550;
    private int versionWidth = 245;
    private int versionHeight = 42;
    private int versionSplit = 0;
    private int loginWidth = 245;
    private int loginHeight = 42;
    private int loginSplit = 0;
    private boolean bInit = false;
    private BufferedImage referenceBI = new BufferedImage(1, 1, 2);
    private Graphics2D reference2D = this.referenceBI.createGraphics();
    private boolean bDebug = false;

    public GenerateProductImage() {
    }

    public GenerateProductImage(boolean bl) {
        this.bDebug = bl;
    }

    public void initialize() {
        if (!this.bInit) {
            this.InitializeFonts();
            this.Initialize2D();
            this.bInit = true;
        }
    }

    public static void main(String[] stringArray) {
        GenerateProductImage generateProductImage = new GenerateProductImage();
        generateProductImage.GenerateImages(stringArray[0], stringArray[1]);
    }

    public void GenerateImages(String string, String string2) {
        this.initialize();
        String string3 = string + "//";
        this.GeneratePrimaryImageDebug(string3 + "primary.png", string2);
        this.GenerateSecondaryImageDebug(string3 + "secondary.png", string2);
        this.GenerateVersionImageDebug(string3 + "version.png", string2);
        this.GenerateLoginImageDebug(string3 + "login.png", string2);
    }

    public BufferedImage GenerateImage(String string, String string2, Font font, Font font2, Color color, Color color2, int n, int n2, int n3, int n4) {
        this.initialize();
        this.Initialize2D();
        BufferedImage bufferedImage = null;
        String string3 = string;
        if (string2 != null && n4 > 0) {
            string3 = string + " - " + string2;
        }
        AttributedString attributedString = new AttributedString(string3);
        this.SetAttributedStrings(attributedString, font, color, color2);
        this.SetColorForSpecialStrings(string3, attributedString, font);
        this.SetFontAndColors(font, color, color2);
        FontRenderContext fontRenderContext = this.reference2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n5 = (int)rectangle2D.getWidth();
        if (string2 == null || n5 <= n4) {
            bufferedImage = new BufferedImage(n5, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHints(this.reference2D.getRenderingHints());
            float f = (float)rectangle2D.getHeight() - textLayout.getDescent();
            if (this.bDebug) {
                System.out.println("One part name image...");
                System.out.println("xpos: 0");
                System.out.println("ypos: " + f);
                System.out.println("ht: " + rectangle2D.getHeight() + "  dc: " + textLayout.getDescent());
            }
            textLayout.draw(graphics2D, 0.0f, f);
            return bufferedImage;
        }
        if (n4 > 0) {
            string3 = string + " - ";
            attributedString = new AttributedString(string3);
            this.SetAttributedStrings(attributedString, font, color, color2);
            this.SetColorForSpecialStrings(string3, attributedString, font);
            this.SetFontAndColors(font, color, color2);
            fontRenderContext = this.reference2D.getFontRenderContext();
            textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
        }
        int n6 = (int)rectangle2D.getWidth();
        AttributedString attributedString2 = null;
        TextLayout textLayout2 = null;
        Rectangle2D rectangle2D2 = null;
        attributedString2 = new AttributedString(string2);
        this.SetAttributedStrings(attributedString2, font2, color, color2);
        this.SetFontAndColors(font2, color, color2);
        FontRenderContext fontRenderContext2 = this.reference2D.getFontRenderContext();
        textLayout2 = new TextLayout(attributedString2.getIterator(), fontRenderContext);
        rectangle2D2 = textLayout2.getBounds();
        int n7 = (int)rectangle2D2.getWidth();
        n5 = n4 > 0 ? n6 + n7 : (n6 > n7 ? n6 : n7);
        bufferedImage = new BufferedImage(n5, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(this.reference2D.getRenderingHints());
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, n5, n2);
        graphics2D.setColor(color);
        float f = (float)rectangle2D.getHeight() - textLayout.getDescent() - (float)n3;
        if (this.bDebug) {
            System.out.println("Two part name image...");
            System.out.println("Part 1 x: 0");
            System.out.println("Part 1 y: " + f);
            System.out.println("ht: " + rectangle2D.getHeight() + "  dc: " + textLayout.getDescent() + "  ld: " + textLayout.getLeading());
        }
        textLayout.draw(graphics2D, 0.0f, f);
        if (n4 > 0) {
            if (this.bDebug) {
                System.out.println("Part 2 x: " + n6);
                System.out.println("Part 2 y: " + f);
                System.out.println("ht: " + rectangle2D2.getHeight() + "  dc: " + textLayout2.getDescent() + "  ld: " + textLayout2.getLeading());
            }
            textLayout2.draw(graphics2D, n6, f);
        } else {
            f = (float)n2 - textLayout2.getDescent() - 1.0f;
            if (this.bDebug) {
                System.out.println("Part 2 x: " + n6);
                System.out.println("Part 2 y: " + f);
                System.out.println("ht: " + rectangle2D2.getHeight() + "  dc: " + textLayout2.getDescent() + "  ld: " + textLayout2.getLeading());
            }
            textLayout2.draw(graphics2D, 0.0f, f);
        }
        return bufferedImage;
    }

    public BufferedImage GeneratePrimaryImage(String string) {
        String[] stringArray;
        BufferedImage bufferedImage = null;
        this.initialize();
        if (this.bDebug) {
            System.out.println("Generating primary product name...");
        }
        bufferedImage = (stringArray = this.splitName(this.fixName(string))).length > 1 ? this.GenerateImage(stringArray[0], stringArray[1], this.fontPrimaryFirstLine, this.fontPrimarySecondLine, this.primaryForegroundColor, this.primaryBackgroundColor, this.primaryWidth, this.primaryHeight, this.primaryLeading, this.primarySplit) : this.GenerateImage(stringArray[0], null, this.fontPrimary, null, this.primaryForegroundColor, this.primaryBackgroundColor, this.primaryWidth, this.primaryHeight, this.primaryLeading, 0);
        return bufferedImage;
    }

    public void GeneratePrimaryImageDebug(String string, String string2) {
        this.initialize();
        this.SaveImage(string, this.GeneratePrimaryImage(string2));
    }

    public BufferedImage GenerateSecondaryImage(String string) {
        String[] stringArray;
        BufferedImage bufferedImage = null;
        this.initialize();
        if (this.bDebug) {
            System.out.println("Generating secondary product name...");
        }
        bufferedImage = (stringArray = this.splitName(this.fixName(string))).length > 1 ? this.GenerateImage(stringArray[0], stringArray[1], this.fontSecondaryFirstLine, this.fontSecondarySecondLine, this.secondaryForegroundColor, this.secondaryBackgroundColor, this.secondaryWidth, this.secondaryHeight, this.secondaryLeading, this.secondarySplit) : this.GenerateImage(stringArray[0], null, this.fontSecondary, null, this.secondaryForegroundColor, this.secondaryBackgroundColor, this.secondaryWidth, this.secondaryHeight, this.secondaryLeading, 0);
        return bufferedImage;
    }

    public void GenerateSecondaryImageDebug(String string, String string2) {
        this.initialize();
        this.SaveImage(string, this.GenerateSecondaryImage(string2));
    }

    public BufferedImage GenerateVersionImage(String string) {
        String[] stringArray;
        BufferedImage bufferedImage = null;
        this.initialize();
        if (this.bDebug) {
            System.out.println("Generating version product name...");
        }
        bufferedImage = (stringArray = this.splitName(this.fixName(string))).length > 1 ? this.GenerateImage(stringArray[0], stringArray[1], this.fontVersionFirstLine, this.fontVersionSecondLine, this.versionForegroundColor, this.versionBackgroundColor, this.versionWidth, this.versionHeight, this.versionLeading, 0) : this.GenerateImage(stringArray[0], null, this.fontVersion, null, this.versionForegroundColor, this.versionBackgroundColor, this.versionWidth, this.versionHeight, this.versionLeading, 0);
        return bufferedImage;
    }

    public void GenerateVersionImageDebug(String string, String string2) {
        this.SaveImage(string, this.GenerateVersionImage(string2));
    }

    public BufferedImage GenerateLoginImage(String string) {
        String[] stringArray;
        BufferedImage bufferedImage = null;
        this.initialize();
        if (this.bDebug) {
            System.out.println("Generating login product name...");
        }
        bufferedImage = (stringArray = this.splitName(this.fixName(string))).length > 1 ? this.GenerateImage(stringArray[0], stringArray[1], this.fontLoginFirstLine, this.fontLoginSecondLine, this.loginForegroundColor, this.loginBackgroundColor, this.loginWidth, this.loginHeight, this.loginLeading, 0) : this.GenerateImage(stringArray[0], null, this.fontLogin, null, this.loginForegroundColor, this.loginBackgroundColor, this.loginWidth, this.loginHeight, this.loginLeading, 0);
        return bufferedImage;
    }

    public void GenerateLoginImageDebug(String string, String string2) {
        this.SaveImage(string, this.GenerateLoginImage(string2));
    }

    private void SaveImage(String string, BufferedImage bufferedImage) {
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (Exception exception) {
            System.out.println("Error writing image");
        }
    }

    private void InitializeFonts() {
        try {
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            InputStream inputStream3 = null;
            if (this.fontLocation == null) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                inputStream = classLoader.getResourceAsStream(FONT_SUPPORT_1);
                inputStream2 = classLoader.getResourceAsStream(FONT_SUPPORT_2);
                inputStream3 = classLoader.getResourceAsStream(FONT_SUPPORT_3);
            } else {
                File file = new File(this.fontLocation);
                inputStream = new FileInputStream(file);
                File file2 = new File(this.fontVersionLocation);
                inputStream2 = new FileInputStream(file2);
                File file3 = new File(this.fontVersionLocation);
                inputStream3 = new FileInputStream(file3);
            }
            if (inputStream == null) {
                System.out.println("Font resource is null");
            }
            if (inputStream2 == null) {
                System.out.println("Font2 resource is null");
            }
            if (inputStream3 == null) {
                System.out.println("Font3 resource is null");
            }
            this.boldFont = Font.createFont(0, inputStream);
            this.demiFont = Font.createFont(0, inputStream2);
            this.rglrFont = Font.createFont(0, inputStream3);
            this.fontPrimary = this.setFont(this.primaryFontType, this.primaryFontSize);
            this.fontPrimaryFirstLine = this.setFont(this.primaryFontType, this.primaryFirstLineSize);
            this.fontPrimarySecondLine = this.setFont(this.primarySecondLineType, this.primarySecondLineSize);
            this.fontSecondary = this.setFont(this.secondaryFontType, this.secondaryFontSize);
            this.fontSecondaryFirstLine = this.setFont(this.secondaryFontType, this.secondaryFirstLineSize);
            this.fontSecondarySecondLine = this.setFont(this.secondarySecondLineType, this.secondarySecondLineSize);
            this.fontVersion = this.setFont(this.versionFontType, this.versionFontSize);
            this.fontVersionFirstLine = this.setFont(this.versionFontType, this.versionFirstLineSize);
            this.fontVersionSecondLine = this.setFont(this.versionSecondLineType, this.versionSecondLineSize);
            this.fontLogin = this.setFont(this.loginFontType, this.loginFontSize);
            this.fontLoginFirstLine = this.setFont(this.loginFontType, this.loginFirstLineSize);
            this.fontLoginSecondLine = this.setFont(this.loginSecondLineType, this.loginSecondLineSize);
            this.fontJavaTM = this.setFont(this.javaTMFontType, this.javaTMFontSize);
            inputStream.close();
            inputStream2.close();
            inputStream3.close();
        }
        catch (Exception exception) {
            System.out.println("Problem initializing Fonts");
            exception.printStackTrace();
        }
    }

    private void Initialize2D() {
        this.reference2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.reference2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.reference2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    private Font setFont(String string, float f) {
        Font font = null;
        font = string.equals(BOLD) ? this.boldFont.deriveFont(f) : (string.equals(DEMI) ? this.demiFont.deriveFont(f) : (string.equals(RGLR) ? this.rglrFont.deriveFont(f) : this.boldFont.deriveFont(f)));
        return font;
    }

    private void SetFontAndColors(Font font, Color color, Color color2) {
        this.reference2D.setFont(font);
        this.reference2D.setColor(color);
        this.reference2D.setBackground(color2);
    }

    private void SetAttributedStrings(AttributedString attributedString, Font font, Color color, Color color2) {
        attributedString.addAttribute(TextAttribute.FOREGROUND, color);
        attributedString.addAttribute(TextAttribute.BACKGROUND, color2);
        attributedString.addAttribute(TextAttribute.FONT, font);
    }

    private void SetColorForSpecialStrings(String string, AttributedString attributedString, Font font) {
        if ((font == this.fontVersion || font == this.fontLogin || font == this.fontVersionFirstLine || font == this.fontLoginFirstLine) && string.startsWith("Java" + tms)) {
            attributedString.addAttribute(TextAttribute.FOREGROUND, this.stupidJavaGrayColor, 0, 5);
            attributedString.addAttribute(TextAttribute.FONT, this.fontJavaTM, 0, 5);
        }
    }

    private String fixName(String string) {
        String string2 = string;
        int n = string.indexOf(TM_SEQ);
        if (n >= 0) {
            string2 = string.substring(0, n) + tms;
            int n2 = n + TM_SEQ.length();
            if (n2 < string.length()) {
                string2 = string2 + string.substring(n2);
            }
        }
        return string2;
    }

    private String[] splitName(String string) {
        String[] stringArray = new String[]{string, null};
        int n = string.indexOf(CR_SEQ);
        if (n >= 0) {
            stringArray[0] = string.substring(0, n);
            int n2 = n + CR_SEQ.length();
            if (n2 < string.length()) {
                stringArray[1] = string.substring(n2);
            }
        }
        return stringArray;
    }

    public void setPrimaryFontSize(float f) {
        this.primaryFontSize = f;
    }

    public void setPrimaryFontType(String string) {
        this.primaryFontType = string;
    }

    public void setPrimaryHeight(int n) {
        this.primaryHeight = n;
    }

    public void setPrimaryWidth(int n) {
        this.primaryWidth = n;
    }

    public void setPrimaryBackgroundColor(Color color) {
        this.primaryBackgroundColor = color;
    }

    public void setPrimaryForegroundColor(Color color) {
        this.primaryForegroundColor = color;
    }

    public void setPrimarySecondLineSize(float f) {
        this.primarySecondLineSize = f;
    }

    public void setPrimarySecondLineType(String string) {
        this.primarySecondLineType = string;
    }

    public void setPrimarySplitSize(int n) {
        this.primarySplit = n;
    }

    public void setSecondaryFontSize(float f) {
        this.secondaryFontSize = f;
    }

    public void setSecondaryFontType(String string) {
        this.secondaryFontType = string;
    }

    public void setSecondaryHeight(int n) {
        this.secondaryHeight = n;
    }

    public void setSecondaryWidth(int n) {
        this.secondaryWidth = n;
    }

    public void setSecondaryBackgroundColor(Color color) {
        this.secondaryBackgroundColor = color;
    }

    public void setSecondaryForegroundColor(Color color) {
        this.secondaryForegroundColor = color;
    }

    public void setSecondarySecondLineSize(float f) {
        this.secondarySecondLineSize = f;
    }

    public void setSecondarySecondLineType(String string) {
        this.secondarySecondLineType = string;
    }

    public void setSecondarySplitSize(int n) {
        this.secondarySplit = n;
    }

    public void setVersionFontSize(float f) {
        this.versionFontSize = f;
    }

    public void setVersionFontType(String string) {
        this.versionFontType = string;
    }

    public void setVersionHeight(int n) {
        this.versionHeight = n;
    }

    public void setVersionWidth(int n) {
        this.versionWidth = n;
    }

    public void setVersionBackgroundColor(Color color) {
        this.versionBackgroundColor = color;
    }

    public void setVersionForegroundColor(Color color) {
        this.versionForegroundColor = color;
    }

    public void setVersionSecondLineSize(float f) {
        this.versionSecondLineSize = f;
    }

    public void setVersionSecondLineType(String string) {
        this.versionSecondLineType = string;
    }

    public void setLoginFontSize(float f) {
        this.loginFontSize = f;
    }

    public void setLoginFontType(String string) {
        this.loginFontType = string;
    }

    public void setLoginHeight(int n) {
        this.loginHeight = n;
    }

    public void setLoginWidth(int n) {
        this.loginWidth = n;
    }

    public void setLoginBackgroundColor(Color color) {
        this.loginBackgroundColor = color;
    }

    public void setLoginForegroundColor(Color color) {
        this.loginForegroundColor = color;
    }

    public void setLoginSecondLineSize(float f) {
        this.loginSecondLineSize = f;
    }

    public void setLoginSecondLineType(String string) {
        this.loginSecondLineType = string;
    }

    public String getFontLocation() {
        return this.fontLocation;
    }

    public void setFontLocation(String string) {
        this.fontLocation = string;
    }
}

