/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.common;

import com.sun.web.common.ConsoleUtil;
import com.sun.web.ui.component.VersionPage;
import com.sun.web.ui.util.LogUtil;
import java.util.Locale;
import javax.faces.context.FacesContext;

public class ConsoleVersionBean {
    private static final String DEFAULT_BASENAME = "com.sun.web.common.resources.Resources";
    private String[] imageInfo = ConsoleUtil.getProductNameImage("version");
    private String bundleJar = null;
    private String baseName = "com.sun.web.common.resources.Resources";
    private String versionString = null;
    private String copyrightString = null;
    private String productImageURL = null;
    private String productImageDescription = null;
    private int productImageHeight = 35;
    private int productImageWidth = 285;
    private String versionInformationFile = null;
    private String style = null;
    private String styleClass = null;
    private String windowTitleKey = "version.windowTitle";
    private String windowTitle = null;
    private VersionPage version = null;

    public ConsoleVersionBean() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Locale locale = facesContext.getViewRoot().getLocale();
        try {
            this.baseName = ConsoleUtil.getBaseName();
        }
        catch (Exception exception) {
            this.baseName = DEFAULT_BASENAME;
        }
        this.versionString = ConsoleUtil.getAppVersion();
        this.copyrightString = ConsoleUtil.getMessage(this.baseName, "copyright.key");
        if (this.copyrightString.equals("copyright.key")) {
            this.copyrightString = ConsoleUtil.getMessage(DEFAULT_BASENAME, "copyright.key");
        }
        this.productImageDescription = ConsoleUtil.getDisplayAppName();
        this.windowTitle = ConsoleUtil.getMessage(this.baseName, this.windowTitleKey);
        if (this.windowTitle.equals(this.windowTitleKey)) {
            this.windowTitle = ConsoleUtil.getMessage(DEFAULT_BASENAME, this.windowTitleKey);
        }
        this.windowTitle = this.windowTitle + " " + this.productImageDescription;
        this.productImageHeight = 35;
        this.productImageWidth = 285;
        if (this.imageInfo != null) {
            this.productImageURL = this.imageInfo[0];
            try {
                this.productImageHeight = Integer.parseInt(this.imageInfo[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.productImageWidth = Integer.parseInt(this.imageInfo[2]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.productImageURL = ConsoleUtil.getVersionProductImageURL();
        }
        try {
            this.productImageHeight = this.imageInfo != null ? Integer.parseInt(this.imageInfo[1]) : ConsoleUtil.getVersionProductImageHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.productImageWidth = this.imageInfo != null ? Integer.parseInt(this.imageInfo[2]) : ConsoleUtil.getVersionProductImageWidth();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createVersionBean();
    }

    public VersionPage getVersion() {
        return this.version;
    }

    public void setVersion(VersionPage versionPage) {
        this.version = versionPage;
    }

    public String getBundle() {
        return this.baseName;
    }

    public void setBundle(String string) {
        this.baseName = string;
    }

    public String getBundleJar() {
        return this.bundleJar;
    }

    public void setBundleJar(String string) {
        this.bundleJar = string;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setWindowTitle(String string) {
        if (string != null) {
            this.windowTitle = ConsoleUtil.getMessage(this.baseName, string);
        }
    }

    public String getCopyright() {
        return this.copyrightString;
    }

    public void setCopyright(String string) {
        this.copyrightString = ConsoleUtil.getMessage(this.baseName, string);
        if (this.copyrightString.equals(string)) {
            this.copyrightString = ConsoleUtil.getMessage(DEFAULT_BASENAME, "copyright.key");
        }
        this.version.setCopyrightString(this.copyrightString);
    }

    public String getProductImageURL() {
        return this.productImageURL;
    }

    public void setProductImageURL(String string) {
        this.productImageURL = ConsoleUtil.getMessage(this.baseName, string);
        this.version.setProductImageURL(this.productImageURL);
    }

    public String getProductImageDescription() {
        return this.productImageDescription;
    }

    public void setProductImageDescription(String string) {
        this.productImageDescription = ConsoleUtil.getMessage(this.baseName, string);
        this.version.setProductImageDescription(this.productImageDescription);
    }

    public int getProductImageHeight() {
        return this.productImageHeight;
    }

    public void setProductImageHeight(int n) {
        this.productImageHeight = n;
        this.version.setProductImageHeight(this.productImageHeight);
    }

    public int getProductImageWidth() {
        return this.productImageWidth;
    }

    public void setProductImageWidth(int n) {
        this.productImageWidth = n;
        this.version.setProductImageWidth(this.productImageWidth);
    }

    public String getVersionInformationFile() {
        return this.versionInformationFile;
    }

    public void setVersionInformationFile(String string) {
        this.versionInformationFile = string;
        this.version.setVersionInformationFile(this.versionInformationFile);
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setVersionString(String string) {
        this.versionString = string;
        this.version.setVersionString(this.versionString);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        this.style = string;
        this.version.setStyle(string);
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String string) {
        this.styleClass = string;
        this.version.setStyleClass(string);
    }

    private void createVersionBean() {
        try {
            LogUtil.info((String)"createVersionBeans");
            this.version = new VersionPage();
            this.version.setCopyrightString(this.getCopyright());
            this.version.setProductImageDescription(this.getProductImageDescription());
            this.version.setProductImageHeight(this.getProductImageHeight());
            this.version.setProductImageURL(this.getProductImageURL());
            this.version.setProductImageWidth(this.getProductImageWidth());
            this.version.setStyle(this.getStyle());
            this.version.setStyleClass(this.getStyleClass());
            this.version.setVersionInformationFile(this.getVersionInformationFile());
            this.version.setVersionString(this.getVersionString());
            LogUtil.info((String)"done createVersionBeans");
        }
        catch (Exception exception) {
            LogUtil.info((String)("Exception in createVersionBeans" + exception.getMessage()));
            this.version = null;
        }
    }
}

