/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMMethod;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.MOFFormatter;
import com.sun.wbem.cim.XmlInstance;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class CIMClass
extends CIMElement {
    static final long serialVersionUID = 200L;
    private String superClass = new String("");
    private boolean isAssociationClass = false;
    private boolean isKeyedClass = false;
    private Vector qualifiers = new Vector();
    private Vector properties = new Vector();
    private Vector allproperties = new Vector();
    private Vector methods = new Vector();
    private Vector allmethods = new Vector();

    public CIMClass() {
        this("");
    }

    public CIMClass(String name) {
        super(name);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String sClass) {
        this.superClass = new String(sClass);
    }

    public boolean isKeyed() {
        return this.isKeyedClass;
    }

    public void setIsKeyed(boolean isKeyedValue) {
        this.isKeyedClass = isKeyedValue;
    }

    public Vector getKeys() {
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (!pe.isKey()) continue;
            v.addElement(pe);
        }
        return v;
    }

    public CIMQualifier getQualifier(String name) {
        if (name == null) {
            return null;
        }
        int tempIndex = this.qualifiers.indexOf(new CIMQualifier(name));
        CIMQualifier qe = tempIndex >= 0 ? (CIMQualifier)this.qualifiers.elementAt(tempIndex) : null;
        return qe;
    }

    public CIMProperty getProperty(String name) {
        if (this.allproperties == null || name == null) {
            return null;
        }
        int i = name.indexOf(46);
        if (i >= 0) {
            return this.getProperty(name.substring(i + 1, name.length()), name.substring(0, i));
        }
        int tempIndex = this.allproperties.indexOf(new CIMProperty(name));
        if (tempIndex < 0) {
            return null;
        }
        CIMProperty pe = (CIMProperty)this.allproperties.elementAt(tempIndex);
        if (pe.getOverridingProperty() != null) {
            return this.getProperty(pe.getOverridingProperty());
        }
        return pe;
    }

    public CIMProperty getProperty(String name, String originClass) {
        if (this.allproperties == null || name == null) {
            return null;
        }
        if (originClass == null || originClass.length() == 0) {
            return this.getProperty(name);
        }
        int size = this.allproperties.size();
        for (int i = 0; i < size; ++i) {
            CIMProperty pe = (CIMProperty)this.allproperties.elementAt(i);
            if (!pe.getName().equalsIgnoreCase(name) || !pe.getOriginClass().equalsIgnoreCase(originClass)) continue;
            if (pe.getOverridingProperty() != null) {
                return this.getProperty(pe.getOverridingProperty());
            }
            return pe;
        }
        return null;
    }

    public CIMMethod getMethod(String name) {
        if (this.allmethods == null || name == null) {
            return null;
        }
        int i = name.indexOf(46);
        if (i >= 0) {
            return this.getMethod(name.substring(i + 1, name.length()), name.substring(0, i));
        }
        int tempIndex = this.allmethods.indexOf(new CIMMethod(name));
        if (tempIndex < 0) {
            return null;
        }
        CIMMethod me = (CIMMethod)this.allmethods.elementAt(tempIndex);
        if (me.getOverridingMethod() != null) {
            return this.getMethod(me.getOverridingMethod());
        }
        return me;
    }

    public CIMMethod getMethod(String name, String originClass) {
        if (this.allmethods == null || name == null) {
            return null;
        }
        if (originClass == null || originClass.length() == 0) {
            return this.getMethod(name);
        }
        int size = this.allmethods.size();
        for (int i = 0; i < size; ++i) {
            CIMMethod me = (CIMMethod)this.allmethods.elementAt(i);
            if (!me.getName().equalsIgnoreCase(name) || !me.getOriginClass().equalsIgnoreCase(originClass)) continue;
            if (me.getOverridingMethod() != null) {
                return this.getMethod(me.getOverridingMethod());
            }
            return me;
        }
        return null;
    }

    public boolean isAssociation() {
        return this.isAssociationClass;
    }

    public void setIsAssociation(boolean isAssociation) {
        this.isAssociationClass = isAssociation;
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public Vector getAllProperties() {
        return this.allproperties;
    }

    public Vector getProperties() {
        return this.properties;
    }

    public Vector getAllMethods() {
        return this.allmethods;
    }

    public Vector getMethods() {
        return this.methods;
    }

    public void addProperty(CIMProperty p) {
        if (p.getOverridingProperty() == null) {
            this.properties.addElement(p);
        }
        this.allproperties.addElement(p);
    }

    public int numberOfProperties() {
        return this.properties.size();
    }

    public void setProperties(Vector Table) {
        if (Table == null || Table.size() == 0) {
            this.properties = null;
            this.allproperties = null;
        }
        this.properties = new Vector();
        this.allproperties = new Vector();
        int size = Table.size();
        for (int i = 0; i < size; ++i) {
            this.addProperty((CIMProperty)Table.elementAt(i));
        }
    }

    public void addQualifier(CIMQualifier q) {
        this.qualifiers.addElement(q);
    }

    public boolean hasQualifier(CIMQualifier q) {
        Enumeration e = this.qualifiers.elements();
        while (e.hasMoreElements()) {
            if (!((CIMQualifier)e.nextElement()).equals(q)) continue;
            return true;
        }
        return false;
    }

    public int numberOfQualifiers() {
        return this.qualifiers.size();
    }

    public boolean removeQualifier(CIMQualifier q) {
        return this.qualifiers.removeElement(q);
    }

    public void setQualifiers(Vector Table) {
        this.qualifiers = Table;
    }

    public void addMethod(CIMMethod m) {
        if (m.getOverridingMethod() == null) {
            this.methods.addElement(m);
        }
        this.allmethods.addElement(m);
    }

    public void setMethods(Vector Table) {
        if (Table == null || Table.size() == 0) {
            this.methods = null;
            this.allmethods = null;
        }
        this.methods = new Vector();
        this.allmethods = new Vector();
        int size = Table.size();
        for (int i = 0; i < size; ++i) {
            this.addMethod((CIMMethod)Table.elementAt(i));
        }
    }

    public CIMInstance newInstance() {
        Enumeration e;
        Vector<Object> ov;
        CIMInstance ci = new CIMInstance();
        if (this.allproperties == null) {
            ci.setProperties(null);
        } else {
            ov = new Vector<Object>();
            e = this.allproperties.elements();
            while (e.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)e.nextElement();
                ov.addElement(pe.clone());
            }
            ci.setProperties(ov);
        }
        ci.setClassName(this.name);
        if (this.qualifiers == null) {
            ci.setQualifiers(null);
        } else {
            ov = new Vector();
            e = this.qualifiers.elements();
            while (e.hasMoreElements()) {
                CIMQualifier qe = (CIMQualifier)e.nextElement();
                ov.addElement(qe.clone());
            }
            ci.setQualifiers(ov);
        }
        return ci;
    }

    public String toXml() {
        CIMObjectPath cop = new CIMObjectPath();
        String host = "";
        return this.toXml(cop, host);
    }

    public String toXml(CIMObjectPath cop) {
        String host = "";
        return this.toXml(cop, host);
    }

    public String toXml(CIMObjectPath cop, String host) {
        XmlInstance xi = new XmlInstance();
        return xi.toXml(this, cop, host);
    }

    public CIMClass localElements() {
        Enumeration e;
        Vector<CIMElement> ov;
        CIMClass cc = new CIMClass();
        cc.superClass = this.superClass;
        cc.name = this.name;
        cc.identifier = this.identifier;
        cc.isAssociationClass = this.isAssociationClass;
        cc.isKeyedClass = this.isKeyedClass;
        if (this.properties == null) {
            cc.setProperties(null);
        } else {
            ov = new Vector<CIMElement>();
            e = this.properties.elements();
            while (e.hasMoreElements()) {
                CIMProperty pe = (CIMProperty)e.nextElement();
                if (!pe.getOriginClass().equalsIgnoreCase(this.name)) continue;
                ov.addElement(pe);
            }
            cc.setProperties(ov);
        }
        if (this.methods == null) {
            cc.setMethods(null);
        } else {
            ov = new Vector();
            e = this.methods.elements();
            while (e.hasMoreElements()) {
                CIMMethod me = (CIMMethod)e.nextElement();
                if (!me.getOriginClass().equalsIgnoreCase(this.name)) continue;
                ov.addElement(me);
            }
            cc.setMethods(ov);
        }
        cc.setQualifiers(this.qualifiers);
        return cc;
    }

    public CIMClass filterProperties(String[] propertyList, boolean includeQualifier, boolean includeClassOrigin) {
        Vector<Object> propList;
        if (propertyList == null || this.allproperties == null || this.allproperties.size() == 0) {
            if (this.allproperties != null) {
                propList = new Vector<Object>();
                Enumeration e = this.allproperties.elements();
                while (e.hasMoreElements()) {
                    CIMProperty pe = (CIMProperty)e.nextElement();
                    propList.addElement(pe.clone(includeQualifier, includeClassOrigin));
                }
            } else {
                propList = null;
            }
        } else {
            HashMap<String, String> hm = new HashMap<String, String>();
            propList = new Vector();
            for (int i = 0; i < propertyList.length; ++i) {
                String propName;
                CIMProperty cp = this.getProperty(propertyList[i]);
                if (cp == null || hm.get(propName = cp.getOriginClass() + "." + cp.getName()) != null) continue;
                hm.put(propName, propName);
                propList.addElement(cp.clone(includeQualifier, includeClassOrigin));
            }
        }
        Vector<Object> methodList = null;
        if (this.allmethods != null) {
            methodList = new Vector<Object>();
            Enumeration e = this.allmethods.elements();
            while (e.hasMoreElements()) {
                CIMMethod cm = (CIMMethod)e.nextElement();
                methodList.addElement(cm.clone(includeQualifier, includeClassOrigin));
            }
        }
        CIMClass cc = new CIMClass();
        cc.superClass = this.superClass;
        cc.name = this.name;
        cc.identifier = this.identifier;
        cc.isAssociationClass = this.isAssociationClass;
        cc.isKeyedClass = this.isKeyedClass;
        cc.setProperties(propList);
        cc.setMethods(methodList);
        if (includeQualifier) {
            cc.setQualifiers(this.qualifiers);
        }
        return cc;
    }
}

