/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.MOFFormatter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CIMDateTime
implements Serializable {
    static final long serialVersionUID = 200L;
    private Calendar cal;
    private boolean isInterval = false;

    public CIMDateTime() {
        this(new Date());
    }

    public CIMDateTime(Date d) {
        this.cal = Calendar.getInstance();
        this.cal.setTime(d);
    }

    public CIMDateTime(Calendar c) {
        this.cal = c;
    }

    public CIMDateTime(String dt) {
        this.cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        formatter.setLenient(false);
        try {
            Date date = formatter.parse(dt.substring(0, 18));
            this.cal.setTime(date);
            if (dt.charAt(21) == ':') {
                this.isInterval = true;
            } else {
                Integer offset = null;
                offset = dt.charAt(21) == '+' ? Integer.valueOf(dt.substring(22)) : Integer.valueOf(dt.substring(21));
                TimeZone tz = TimeZone.getTimeZone("GMT");
                tz.setRawOffset(offset * 60 * 1000);
                this.cal.setTimeZone(tz);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public boolean after(CIMDateTime when) {
        return this.cal.after(when.getCalendar());
    }

    public boolean before(CIMDateTime when) {
        return this.cal.before(when.getCalendar());
    }

    public boolean equals(Object obj) {
        return this.cal.equals(((CIMDateTime)obj).getCalendar());
    }

    public Calendar getCalendar() {
        return this.cal;
    }
}

