/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.XmlInstance;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;

public class CIMNameSpace
implements Serializable {
    static final long serialVersionUID = 200L;
    private String host = ".";
    private String nameSpace = "\\root\\cimv2";
    private URL hostURL = null;

    private String validateNameSpace(String s) {
        int endindex;
        if (s == null || s.length() == 0) {
            return "";
        }
        boolean startindex = false;
        s = s.replace('/', '\\');
        s = s.toLowerCase();
        StringBuffer sb = new StringBuffer("");
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c != '\\') continue;
            try {
                while (s.charAt(i + 1) == '\\') {
                    ++i;
                }
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
        }
        if ((endindex = (s = sb.toString()).length()) > 1 && s.endsWith("\\")) {
            --endindex;
        }
        return s.substring(0, endindex).toLowerCase();
    }

    public CIMNameSpace() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.host = "localhost";
        }
    }

    public CIMNameSpace(String h) {
        try {
            this.hostURL = new URL(h);
            this.host = this.hostURL.getHost();
        }
        catch (MalformedURLException e) {
            if (h.indexOf(47) >= 0 || h.indexOf(92) >= 0) {
                throw new IllegalArgumentException(h);
            }
            this.host = h;
        }
    }

    public CIMNameSpace(String host, String ns) {
        this(host);
        this.nameSpace = this.validateNameSpace(ns);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getHost() {
        return this.host;
    }

    public URL getHostURL() {
        return this.hostURL;
    }

    public void parse(String p) {
        int index = 0;
        String s = p.replace('/', '\\');
        if (s.startsWith("\\\\")) {
            index = s.indexOf("\\", 3);
            this.host = s.substring(2, index);
        }
        if (s.charAt(index) == '\\') {
            ++index;
        }
        this.nameSpace = s.substring(index, s.lastIndexOf("\\"));
    }

    public void setNameSpace(String ns) {
        this.nameSpace = this.validateNameSpace(ns);
    }

    public void setHost(String h) {
        this.host = h;
    }

    public String toString() {
        return "\\\\" + this.host + "\\" + this.nameSpace;
    }

    public String toXml() {
        XmlInstance xi = new XmlInstance();
        return xi.toXml(this);
    }
}

