/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMFlavor;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMMethod;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMParameter;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMScope;
import com.sun.wbem.cim.CIMValue;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;

public class CheckSumGen
implements Serializable {
    static final long serialVersionUID = 200L;
    private static final int QUALS = 0;
    private static final int CPROPERTIES = 1;
    private static final int IPROPERTIES = 2;
    private static final int METHODS = 3;
    private static final int VALVECTOR = 4;
    private static final int PARAMETER = 5;
    private static final int FLAVOR = 6;
    private static final int SCOPE = 7;
    private static final String NULL = "null";
    static final String INDENT = "    ";
    static final String TAB = "\t";
    static final String QUOTE = "\"";
    static final String SPACE = " ";
    static final String COLON = ":";
    static final String LINE = "\n";
    private static final String ANY = "any";
    private static final String AS = "as";
    private static final String ASSOCIATION = "association";
    private static final String CLASS = "class";
    private static final String DISABLEOVERRIDE = "disableoverride";
    private static final String DT_BOOL = "boolean";
    private static final String DT_CHAR16 = "char16";
    private static final String DT_DATETIME = "datetime";
    private static final String DT_REAL32 = "real32";
    private static final String DT_REAL64 = "real64";
    private static final String DT_SINT16 = "sint16";
    private static final String DT_SINT32 = "sint32";
    private static final String DT_SINT64 = "sint64";
    private static final String DT_SINT8 = "sint8";
    private static final String DT_STR = "string";
    private static final String DT_UINT16 = "uint16";
    private static final String DT_UINT32 = "uint32";
    private static final String DT_UINT64 = "uint64";
    private static final String DT_UINT8 = "uint8";
    private static final String ENABLEOVERRIDE = "enableoverride";
    private static final String FALSE = "false";
    private static final String CIMFLAVOR = "Flavor";
    private static final String INDICATION = "indication";
    private static final String INSTANCE = "instance";
    private static final String METHOD = "method";
    private static final String OF = "of";
    private static final String CIMPARAMETER = "parameter";
    private static final String PRAGMA = "#pragma";
    private static final String PROPERTY = "property";
    private static final String QUALIFIER = "qualifier";
    private static final String REF = "ref";
    private static final String REFERENCE = "reference";
    private static final String RESTRICTED = "restricted";
    private static final String SCHEMA = "schema";
    private static final String CIMSCOPE = "Scope";
    private static final String TOSUBCLASS = "tosubclass";
    private static final String TRANSLATABLE = "translatable";
    private static final String TRUE = "true";
    boolean cimclass = true;

    public String vectorToMOFString(Vector v, int type) {
        return this.vectorToMOFString(v, INDENT, false, false, true, type);
    }

    public String vectorToMOFString(Vector v, String i, int type) {
        return this.vectorToMOFString(v, i, false, false, true, type);
    }

    public String vectorToMOFString(Vector v, boolean b, int type) {
        return this.vectorToMOFString(v, INDENT, b, false, true, type);
    }

    public String vectorToMOFString(Vector v, boolean b, boolean d, int type) {
        return this.vectorToMOFString(v, INDENT, b, d, true, type);
    }

    public String vectorToMOFString(Vector v, boolean b, boolean d, boolean l, int type) {
        return this.vectorToMOFString(v, INDENT, b, d, l, type);
    }

    public String vectorToMOFString(Vector v, String indent, boolean bracketed, boolean delim, boolean lf, int type) {
        String delimeter = "";
        delimeter = lf ? ",\n" : ", ";
        StringBuffer str = new StringBuffer("");
        if (v != null && !v.isEmpty()) {
            if (bracketed) {
                str.append(indent);
                str.append("[");
            }
            int maxIndex = v.size() - 1;
            block10: for (int x = 0; x <= maxIndex; ++x) {
                if (x > 0) {
                    str = delim ? str.append(delimeter + indent) : str.append(LINE);
                }
                Object elem = v.elementAt(x);
                switch (type) {
                    case 0: {
                        str.append(this.toString((CIMQualifier)elem));
                        continue block10;
                    }
                    case 1: {
                        str.append(this.toString((CIMProperty)elem, true));
                        continue block10;
                    }
                    case 2: {
                        str.append(this.toString((CIMProperty)elem, false));
                        continue block10;
                    }
                    case 3: {
                        str.append(this.toString((CIMMethod)elem));
                        continue block10;
                    }
                    case 5: {
                        str.append(this.toString((CIMParameter)elem));
                        continue block10;
                    }
                    case 6: {
                        str.append(this.toString((CIMFlavor)elem));
                        continue block10;
                    }
                    case 7: {
                        str.append(this.toString((CIMScope)elem));
                        continue block10;
                    }
                    case 4: {
                        str.append(QUOTE);
                        str.append(this.values(elem));
                        str.append(QUOTE);
                    }
                }
            }
            if (bracketed) {
                str = str.append("]\n");
            }
        }
        return str.toString();
    }

    public String toString(Vector v) {
        if (v == null) {
            return NULL;
        }
        StringBuffer buf = new StringBuffer();
        Iterator e = v.iterator();
        buf.append("[");
        int maxIndex = v.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            Object o = e.next();
            if (o instanceof CIMValue) {
                buf.append(this.toString((CIMValue)o));
            } else if (o instanceof CIMProperty) {
                buf.append(this.toString((CIMProperty)o, false));
            } else {
                buf.append(o.toString());
            }
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toString(CIMClass cc) {
        if (cc == null) {
            return NULL;
        }
        String cl = "class " + cc.getName();
        if (cc.getSuperClass().length() > 0) {
            cl = cl.concat(COLON + cc.getSuperClass());
        }
        return new String(this.vectorToMOFString(cc.getQualifiers(), true, true, 0) + cl + LINE + "{" + LINE + this.vectorToMOFString(cc.getProperties(), 1) + LINE + this.vectorToMOFString(cc.getMethods(), 3) + LINE + "};");
    }

    private String values(Object o) {
        if (o == null) {
            return NULL;
        }
        if (o instanceof CIMObjectPath) {
            return this.toString((CIMObjectPath)o);
        }
        if (o instanceof CIMDateTime) {
            return this.toString((CIMDateTime)o);
        }
        if (o instanceof CIMInstance) {
            return this.toString((CIMInstance)o);
        }
        return o.toString();
    }

    public String toString(CIMValue cv) {
        String s = NULL;
        if (cv == null) {
            return NULL;
        }
        Object o = cv.getValue();
        if (o != null) {
            if (cv.isArrayValue()) {
                s = this.vectorToMOFString((Vector)o, "", false, true, false, 4);
            } else {
                String q = "";
                if (new CIMDataType(8).equals(cv.getType())) {
                    q = QUOTE;
                }
                s = q + this.values(o) + q;
            }
        }
        return s;
    }

    public String toString(CIMQualifierType cqt) {
        if (cqt == null) {
            return NULL;
        }
        String scopeStr = "";
        String flavorStr = "";
        String valueStr = "";
        if (!cqt.getScope().isEmpty()) {
            scopeStr = "Scope(" + this.vectorToMOFString(cqt.getScope(), "", false, true, false, 7) + ")";
        }
        if (!cqt.getFlavor().isEmpty()) {
            flavorStr = ", Flavor(" + this.vectorToMOFString(cqt.getFlavor(), "", false, true, false, 6) + ")";
        }
        if (!cqt.getType().isArrayType()) {
            valueStr = " = " + this.toString(cqt.getDefaultValue());
        }
        return new String("qualifier " + cqt.getName() + " : " + this.toString(cqt.getType()) + valueStr + ", " + scopeStr + flavorStr + ";");
    }

    public String toString(CIMQualifier cq) {
        if (cq == null) {
            return NULL;
        }
        if (cq.getValue() == null) {
            return new String(cq.getName());
        }
        return new String(cq.getName() + "(" + this.toString(cq.getValue()) + ")");
    }

    public String toString(CIMDateTime cdt) {
        if (cdt == null) {
            return NULL;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS000");
        Calendar cal = cdt.getCalendar();
        TimeZone tz = cal.getTimeZone();
        if (cdt.isInterval()) {
            return formatter.format(cal.getTime()) + ":000";
        }
        int offset = cal.get(15) + cal.get(16);
        double minutes = (double)offset * 0.001 / 60.0;
        return formatter.format(cal.getTime()) + (int)minutes;
    }

    public String toString(CIMDataType cdt) {
        if (cdt == null) {
            return NULL;
        }
        switch (cdt.getType()) {
            case 0: {
                return new String(DT_UINT8);
            }
            case 1: {
                return new String(DT_SINT8);
            }
            case 2: {
                return new String(DT_UINT16);
            }
            case 3: {
                return new String(DT_SINT16);
            }
            case 4: {
                return new String(DT_UINT32);
            }
            case 5: {
                return new String(DT_SINT32);
            }
            case 6: {
                return new String(DT_UINT64);
            }
            case 7: {
                return new String(DT_SINT64);
            }
            case 10: {
                return new String(DT_REAL32);
            }
            case 11: {
                return new String(DT_REAL64);
            }
            case 8: {
                return new String(DT_STR);
            }
            case 13: {
                return new String(DT_CHAR16);
            }
            case 12: {
                return new String(DT_DATETIME);
            }
            case 9: {
                return new String(DT_BOOL);
            }
            case 14: {
                return new String("uint8[]");
            }
            case 15: {
                return new String("sint8[]");
            }
            case 16: {
                return new String("uint16[]");
            }
            case 17: {
                return new String("sint16[]");
            }
            case 18: {
                return new String("uint32[]");
            }
            case 19: {
                return new String("sint32[]");
            }
            case 20: {
                return new String("uint64[]");
            }
            case 21: {
                return new String("sint64[]");
            }
            case 24: {
                return new String("real32[]");
            }
            case 25: {
                return new String("real64[]");
            }
            case 22: {
                return new String("string[]");
            }
            case 27: {
                return new String("char16[]");
            }
            case 26: {
                return new String("datetime[]");
            }
            case 23: {
                return new String("boolean[]");
            }
            case 30: {
                return new String(NULL);
            }
            case 28: {
                return new String("reference(" + cdt.getRefClassName() + ")");
            }
        }
        return "";
    }

    public String toString(CIMFlavor cf) {
        if (cf == null) {
            return NULL;
        }
        switch (cf.getFlavor()) {
            case 0: {
                return ENABLEOVERRIDE;
            }
            case 1: {
                return DISABLEOVERRIDE;
            }
            case 2: {
                return RESTRICTED;
            }
            case 3: {
                return TOSUBCLASS;
            }
            case 4: {
                return TRANSLATABLE;
            }
        }
        return "UNKNOWN";
    }

    public String toString(CIMInstance ci) {
        if (ci == null) {
            return NULL;
        }
        this.cimclass = false;
        String tmp = new String("instance of " + ci.getClassName() + SPACE + "{" + LINE + this.vectorToMOFString(ci.getProperties(), 2) + LINE + "};");
        this.cimclass = true;
        return tmp;
    }

    public String toString(CIMMethod cp) {
        if (cp == null) {
            return NULL;
        }
        return new String(INDENT + this.toString(cp.getType()) + SPACE + cp.getName() + "(" + this.vectorToMOFString(cp.getParameters(), "", false, true, false, 5) + ");");
    }

    public String toString(CIMNameSpace ns) {
        if (ns == null) {
            return NULL;
        }
        return "\\\\" + ns.getHost() + "\\" + ns.getNameSpace();
    }

    private String pqToString(Vector v) {
        if (v == null) {
            return NULL;
        }
        StringBuffer buf = new StringBuffer();
        Iterator e = v.iterator();
        buf.append("[");
        int maxIndex = v.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            Object o = e.next();
            buf.append(this.toString((CIMQualifier)o));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toString(CIMParameter cp) {
        if (cp == null) {
            return NULL;
        }
        return new String(this.pqToString(cp.getQualifiers()) + SPACE + this.toString(cp.getType()) + SPACE + cp.getName());
    }

    public String toString(CIMProperty cp, boolean cimclass) {
        if (cp == null) {
            return NULL;
        }
        if (cimclass) {
            return new String(this.vectorToMOFString(cp.getQualifiers(), TAB, true, true, true, 0) + INDENT + this.toString(cp.getType()) + SPACE + cp.getName() + ";");
        }
        return new String(INDENT + cp.getName() + " = " + this.toString(cp.getValue()) + ";");
    }

    public String toString(CIMScope cs) {
        if (cs == null) {
            return NULL;
        }
        switch (cs.getScope()) {
            case 0: {
                return SCHEMA;
            }
            case 1: {
                return CLASS;
            }
            case 2: {
                return ASSOCIATION;
            }
            case 3: {
                return INDICATION;
            }
            case 4: {
                return PROPERTY;
            }
            case 5: {
                return REFERENCE;
            }
            case 6: {
                return METHOD;
            }
            case 7: {
                return CIMPARAMETER;
            }
            case 8: {
                return ANY;
            }
        }
        return "UNKNOWN";
    }

    public String toString(CIMObjectPath op) {
        if (op == null) {
            return NULL;
        }
        Vector keys = op.getKeys();
        String nameSpace = op.getNameSpace();
        String objectName = op.getObjectName();
        if (keys == null || keys.size() == 0) {
            if (objectName != null && objectName.length() != 0) {
                return nameSpace + "\\" + objectName;
            }
            return nameSpace;
        }
        String s = "";
        int i = 0;
        Enumeration e = keys.elements();
        while (e.hasMoreElements()) {
            CIMProperty pe = (CIMProperty)e.nextElement();
            if (pe == null) continue;
            String oc = pe.getOriginClass();
            s = oc != null && oc.length() != 0 ? s + oc + "." + pe.getName() : s + pe.getName();
            s = s + "=" + this.toString(pe.getValue()) + COLON;
            ++i;
        }
        if (i > 0) {
            return nameSpace + "\\" + objectName + COLON + s.substring(0, s.lastIndexOf(COLON));
        }
        return nameSpace + "\\" + objectName;
    }
}

