/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.client.http.HeaderParser;
import com.sun.wbem.client.http.HttpExURLConnection;
import java.net.URL;
import java.util.Hashtable;

abstract class AuthenticationInfo {
    static final char SERVER_AUTHENTICATION = 's';
    static final char PROXY_AUTHENTICATION = 'p';
    private static Hashtable cache = new Hashtable();
    char type;
    String host;
    int port;
    String realm;

    AuthenticationInfo(char type, String host, int port, String realm) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.realm = realm;
    }

    static AuthenticationInfo getServerAuth(URL url) {
        String key = 's' + url.getHost() + ":" + url.getPort();
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key);
        return result;
    }

    static AuthenticationInfo getServerAuth(URL url, String realm) {
        String key = 's' + url.getHost() + ":" + url.getPort() + ":" + realm;
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key);
        return result;
    }

    static AuthenticationInfo getProxyAuth(String host, int port) {
        String key = 'p' + host + ":" + port;
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key);
        return result;
    }

    static AuthenticationInfo getProxyAuth(String host, int port, String realm) {
        String key = 'p' + host + ":" + port + ":" + realm;
        AuthenticationInfo result = (AuthenticationInfo)cache.get(key);
        return result;
    }

    void addToCache() {
        cache.put(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.put(this.cacheKey(false), this);
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true));
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false));
        }
    }

    abstract boolean supportsPreemptiveAuthorization();

    abstract String getHeaderName();

    abstract String getHeaderValue();

    boolean setHeaders(HttpExURLConnection conn, HeaderParser p) {
        conn.setAuthenticationProperty(this.getHeaderName(), this.getHeaderValue());
        return true;
    }

    String cacheKey(boolean includeRealm) {
        if (includeRealm) {
            return this.type + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + this.host + ":" + this.port;
    }
}

