/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.client.http.ChunkedInputStream;
import com.sun.wbem.client.http.GetPropertyAction;
import com.sun.wbem.client.http.HeaderParser;
import com.sun.wbem.client.http.KeepAliveCache;
import com.sun.wbem.client.http.KeepAliveStream;
import com.sun.wbem.client.http.MessageHeader;
import com.sun.wbem.client.http.MeteredStream;
import com.sun.wbem.client.http.NetworkClient;
import com.sun.wbem.client.http.PosterOutputStream;
import com.sun.wbem.client.http.ProgressData;
import com.sun.wbem.client.http.ProgressEntry;
import com.sun.wbem.client.http.REException;
import com.sun.wbem.client.http.RegexpPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;

public class HttpClient
extends NetworkClient {
    protected boolean cachedHttpClient = false;
    private boolean inCache;
    MessageHeader requests;
    PosterOutputStream poster = null;
    boolean failedOnce = false;
    private static RegexpPool nonProxyHostsPool = null;
    private static String nonProxyHostsSource = null;
    private static final int HTTP_CONTINUE = 100;
    static final int httpPortNumber = 80;
    public static String proxyHost = null;
    public static int proxyPort = 80;
    private String instProxy = null;
    private int instProxyPort = -1;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    protected String host;
    protected int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    private static boolean keepAliveProp = true;
    volatile boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;
    protected URL url;
    public boolean reuse = false;

    protected int getDefaultPort() {
        return 80;
    }

    public static synchronized void resetProperties() {
    }

    int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    private String getProxyHost() {
        String host = (String)AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
        if (host == null) {
            host = (String)AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
        }
        if (host != null && host.length() == 0) {
            host = null;
        }
        return host;
    }

    private int getProxyPort() {
        final int[] port = new int[]{0};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                port[0] = System.getProperty("http.proxyHost") != null ? Integer.getInteger("http.proxyPort", 80).intValue() : Integer.getInteger("proxyPort", 80).intValue();
                return null;
            }
        });
        return port[0];
    }

    public boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchNonProxyHosts(String host) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String rawList = (String)AccessController.doPrivileged(new GetPropertyAction("http.nonProxyHosts"));
            if (rawList == null) {
                nonProxyHostsPool = null;
            } else if (!rawList.equals(nonProxyHostsSource)) {
                RegexpPool pool = new RegexpPool();
                StringTokenizer st = new StringTokenizer(rawList, "|", false);
                try {
                    while (st.hasMoreTokens()) {
                        pool.add(st.nextToken().toLowerCase(), Boolean.TRUE);
                    }
                }
                catch (REException ex) {
                    System.err.println("Error in http.nonProxyHosts system property:  " + ex);
                }
                nonProxyHostsPool = pool;
            }
            nonProxyHostsSource = rawList;
        }
        if (nonProxyHostsPool == null) {
            return false;
        }
        return nonProxyHostsPool.match(host) != null;
    }

    protected HttpClient() {
    }

    private HttpClient(URL url) throws IOException {
        this(url, null, -1, false);
    }

    protected HttpClient(URL url, boolean proxyDisabled) throws IOException {
        this(url, null, -1, proxyDisabled);
    }

    public HttpClient(URL url, String proxy, int proxyPort) throws IOException {
        this(url, proxy, proxyPort, false);
    }

    private HttpClient(URL url, String proxy, int proxyPort, boolean proxyDisabled) throws IOException {
        this.proxyDisabled = proxyDisabled;
        if (!proxyDisabled) {
            this.instProxy = proxy;
            this.instProxyPort = proxyPort < 0 ? this.getDefaultPort() : proxyPort;
        }
        try {
            InetAddress addr = InetAddress.getByName(url.getHost());
            this.host = addr.getHostAddress();
        }
        catch (UnknownHostException ignored) {
            this.host = url.getHost();
        }
        this.url = url;
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    public static HttpClient New(URL url) throws IOException {
        return HttpClient.New(url, true);
    }

    public static HttpClient New(URL url, boolean useCache) throws IOException {
        return HttpClient.New(url, null, -1, useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient New(URL url, String proxy, int proxyPort, boolean useCache) throws IOException {
        HttpClient ret = null;
        if (useCache && (ret = (HttpClient)kac.get(url, null)) != null) {
            HttpClient httpClient = ret;
            synchronized (httpClient) {
                ret.cachedHttpClient = true;
                if (!ret.inCache) {
                    throw new AssertionError();
                }
                ret.inCache = false;
            }
        }
        if (ret == null) {
            ret = new HttpClient(url, proxy, proxyPort);
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(url.getHost(), url.getPort());
            }
            ret.url = url;
        }
        return ret;
    }

    public void finished() {
        if (this.reuse) {
            return;
        }
        --this.keepAliveConnections;
        if (this.keepAliveConnections > 0 && this.isKeepingAlive() && !this.serverOutput.checkError()) {
            this.putInKeepAliveCache();
        } else {
            this.closeServer();
        }
    }

    protected synchronized void putInKeepAliveCache() {
        if (this.inCache) {
            throw new AssertionError((Object)"Duplicate put to keep alive cache");
        }
        this.inCache = true;
        kac.put(this.url, null, this);
    }

    public void closeIdleConnection() {
        HttpClient http = (HttpClient)kac.get(this.url, null);
        if (http != null) {
            http.closeServer();
        }
    }

    public void openServer(String server, int port) throws IOException {
        this.serverSocket = this.doConnect(server, port);
        try {
            this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(encoding + " encoding not found");
        }
        this.serverSocket.setTcpNoDelay(true);
    }

    public boolean needsTunneling() {
        return false;
    }

    public boolean isCachedConnection() {
        return this.cachedHttpClient;
    }

    public void afterConnect() throws IOException, UnknownHostException {
    }

    private synchronized void privilegedOpenServer(final String proxyHost, final int proxyPort) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.openServer(proxyHost, proxyPort);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private void superOpenServer(String proxyHost, int proxyPort) throws IOException, UnknownHostException {
        super.openServer(proxyHost, proxyPort);
    }

    private synchronized void privilegedSuperOpenServer(final String proxyHost, final int proxyPort) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.superOpenServer(proxyHost, proxyPort);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private boolean isLoopback(String host) {
        if (host == null || host.length() == 0) {
            return false;
        }
        if (host.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (!Character.isDigit(host.charAt(0))) {
            return false;
        }
        boolean firstInt = true;
        int hitDots = 0;
        char[] data = host.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return false;
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                return false;
            }
            if (firstInt) {
                firstInt = false;
                if (b != 127) {
                    return false;
                }
            }
            ++hitDots;
        }
        return hitDots == 4 && !host.endsWith(".");
    }

    protected synchronized void openServer() throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkConnect(this.host, this.port);
        }
        if (this.keepingAlive) {
            return;
        }
        String urlHost = this.url.getHost().toLowerCase();
        boolean loopback = this.isLoopback(urlHost);
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            if (this.instProxy != null && !loopback) {
                this.privilegedOpenServer(this.instProxy, this.instProxyPort);
                this.usingProxy = true;
                return;
            }
            String proxyHost = this.getProxyHost();
            if (!(proxyHost == null || this.proxyDisabled || loopback || this.matchNonProxyHosts(urlHost) || this.matchNonProxyHosts(this.host))) {
                try {
                    int proxyPort = this.getProxyPort();
                    this.privilegedOpenServer(proxyHost, proxyPort);
                    this.instProxy = proxyHost;
                    this.instProxyPort = proxyPort;
                    this.usingProxy = true;
                    return;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        if (this.instProxy != null && !loopback) {
            this.privilegedSuperOpenServer(this.instProxy, this.instProxyPort);
            this.usingProxy = true;
            return;
        }
        String proxyHost = this.getProxyHost();
        if (!(proxyHost == null || this.proxyDisabled || loopback || this.matchNonProxyHosts(urlHost) || this.matchNonProxyHosts(this.host))) {
            try {
                int proxyPort = this.getProxyPort();
                this.privilegedSuperOpenServer(proxyHost, proxyPort);
                this.instProxy = proxyHost;
                this.instProxyPort = proxyPort;
                this.usingProxy = true;
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        super.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    public String getURLFile() throws IOException {
        String fileName = this.url.getFile();
        if (fileName == null || fileName.length() == 0) {
            fileName = "/";
        }
        if (this.usingProxy) {
            fileName = this.url.toExternalForm();
        }
        if (fileName.indexOf(10) == -1) {
            return fileName;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    public void writeRequests(MessageHeader head) {
        this.requests = head;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader head, PosterOutputStream pos) throws IOException {
        this.requests = head;
        this.requests.print(this.serverOutput);
        this.poster = pos;
        if (this.poster != null) {
            this.poster.writeTo(this.serverOutput);
        }
        this.serverOutput.flush();
    }

    public boolean parseHTTP(MessageHeader responses, ProgressEntry pe) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            return this.parseHTTPHeader(responses, pe);
        }
        catch (IOException e) {
            this.closeServer();
            if (!this.failedOnce && this.requests != null && !(this.serverSocket instanceof SSLSocket)) {
                this.failedOnce = true;
                this.openServer();
                this.writeRequests(this.requests, this.poster);
                return this.parseHTTP(responses, pe);
            }
            throw e;
        }
    }

    public int setTimeout(int timeout) throws SocketException {
        int old = this.serverSocket.getSoTimeout();
        this.serverSocket.setSoTimeout(timeout);
        return old;
    }

    private boolean parseHTTPHeader(MessageHeader responses, ProgressEntry pe) throws IOException {
        int nread;
        int r;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean ret = false;
        byte[] b = new byte[8];
        this.serverInput.mark(10);
        for (nread = 0; nread < 8 && (r = this.serverInput.read(b, nread, 8 - nread)) >= 0; nread += r) {
        }
        String keep = null;
        ret = b[0] == 72 && b[1] == 84 && b[2] == 84 && b[3] == 80 && b[4] == 47 && b[5] == 49 && b[6] == 46;
        this.serverInput.reset();
        if (ret) {
            responses.parseHeader(this.serverInput);
            if (this.usingProxy) {
                keep = responses.findValue("Proxy-Connection");
            }
            if (keep == null) {
                keep = responses.findValue("Connection");
            }
            if (keep != null && keep.toLowerCase().equals("keep-alive")) {
                HeaderParser p = new HeaderParser(responses.findValue("Keep-Alive"));
                if (p != null) {
                    this.keepAliveConnections = p.findInt("max", this.usingProxy ? 50 : 5);
                    this.keepAliveTimeout = p.findInt("timeout", this.usingProxy ? 60 : 5);
                }
            } else if (b[7] != 48) {
                this.keepAliveConnections = keep != null ? 1 : 5;
            }
        } else {
            if (nread != 8) {
                if (!this.failedOnce && this.requests != null && !(this.serverSocket instanceof SSLSocket)) {
                    this.failedOnce = true;
                    this.closeServer();
                    this.openServer();
                    this.writeRequests(this.requests, this.poster);
                    return this.parseHTTP(responses, pe);
                }
                throw new SocketException("Unexpected end of file from server");
            }
            responses.set("Content-type", "unknown/unknown");
        }
        int code = -1;
        try {
            String resp = responses.getValue(0);
            int ind = resp.indexOf(32);
            while (resp.charAt(ind) == ' ') {
                ++ind;
            }
            code = Integer.parseInt(resp.substring(ind, ind + 3));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (code == 100) {
            responses.reset();
            return this.parseHTTPHeader(responses, pe);
        }
        int cl = -1;
        String te = null;
        try {
            te = responses.findValue("Transfer-Encoding");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (te != null && te.equalsIgnoreCase("chunked")) {
            this.serverInput = new ChunkedInputStream(this.serverInput, this, responses);
            if (this.keepAliveConnections < 0) {
                this.keepAliveConnections = 1;
            }
            this.keepingAlive = true;
            this.failedOnce = false;
        } else {
            try {
                cl = Integer.parseInt(responses.findValue("content-length"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.keepAliveConnections > 1 && (cl >= 0 || code == 304 || code == 204)) {
                this.keepingAlive = true;
            } else if (this.keepingAlive) {
                this.keepingAlive = false;
            }
        }
        if (cl > 0) {
            pe.setType(this.url.getFile(), responses.findValue("content-type"));
            pe.update(0, cl);
            if (this.isKeepingAlive()) {
                this.serverInput = new KeepAliveStream(this.serverInput, pe, this);
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, pe);
            }
        } else {
            ProgressData.pdata.unregister(pe);
        }
        return ret;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    protected void finalize() throws Throwable {
    }

    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return this.instProxy;
    }

    public int getProxyPortUsed() {
        return this.instProxyPort;
    }

    static {
        String keepAlive = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("http.keepAlive");
            }
        });
        keepAliveProp = keepAlive != null ? Boolean.valueOf(keepAlive) : true;
    }
}

