/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.client.http.ProgressData;
import com.sun.wbem.client.http.ProgressEntry;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MeteredStream
extends FilterInputStream {
    protected boolean closed = false;
    protected int expected;
    protected int count = 0;
    protected int markedCount = 0;
    protected int markLimit = -1;
    protected ProgressEntry te;

    public MeteredStream(InputStream is, ProgressEntry te) {
        super(is);
        this.te = te;
        this.expected = te.need;
        ProgressData.pdata.update(te);
    }

    private final void justRead(int n) throws IOException {
        if (n == -1) {
            if (!this.isMarked()) {
                this.close();
            }
            return;
        }
        this.count += n;
        if (this.count > this.markLimit) {
            this.markLimit = -1;
        }
        this.te.update(this.count, this.expected);
        ProgressData.pdata.update(this.te);
        if (this.isMarked()) {
            return;
        }
        if (this.count >= this.expected) {
            this.close();
        }
    }

    private boolean isMarked() {
        if (this.markLimit < 0) {
            return false;
        }
        return this.count <= this.markLimit;
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int c = this.in.read();
        if (c != -1) {
            this.justRead(1);
        } else {
            this.justRead(c);
        }
        return c;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n = this.in.read(b, off, len);
        this.justRead(n);
        return n;
    }

    public synchronized long skip(long n) throws IOException {
        if (this.closed) {
            return 0L;
        }
        int min = n > (long)(this.expected - this.count) ? this.expected - this.count : (int)n;
        n = this.in.skip(min);
        this.justRead((int)n);
        return n;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        ProgressData.pdata.unregister(this.te);
        this.closed = true;
        this.in.close();
    }

    public synchronized int available() throws IOException {
        return this.closed ? 0 : this.in.available();
    }

    public synchronized void mark(int readLimit) {
        if (this.closed) {
            return;
        }
        super.mark(readLimit);
        this.markedCount = this.count;
        this.markLimit = readLimit;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.isMarked()) {
            throw new IOException("Resetting to an invalid mark");
        }
        this.count = this.markedCount;
        super.reset();
    }

    public boolean markSupported() {
        if (this.closed) {
            return false;
        }
        return super.markSupported();
    }

    protected void finalize() {
        this.te.what = 3;
    }
}

