/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.client.http.REException;
import com.sun.wbem.client.http.RegexpNode;
import com.sun.wbem.client.http.RegexpTarget;
import java.io.PrintStream;

public class RegexpPool {
    private RegexpNode prefixMachine = new RegexpNode();
    private RegexpNode suffixMachine = new RegexpNode();
    private static final int BIG = Integer.MAX_VALUE;
    private int lastDepth = Integer.MAX_VALUE;

    public void add(String re, Object ret) throws REException {
        this.add(re, ret, false);
    }

    public void replace(String re, Object ret) {
        try {
            this.add(re, ret, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object delete(String re) {
        RegexpNode p;
        Object o = null;
        RegexpNode best = p = this.prefixMachine;
        int len = re.length() - 1;
        boolean prefix = true;
        if (!re.startsWith("*") || !re.endsWith("*")) {
            ++len;
        }
        if (len <= 0) {
            return null;
        }
        int i = 0;
        while (p != null) {
            if (!(p.result == null || p.depth >= Integer.MAX_VALUE || p.exact && i != len)) {
                best = p;
            }
            if (i >= len) break;
            p = p.find(re.charAt(i));
            ++i;
        }
        i = len;
        for (p = this.suffixMachine; --i >= 0 && p != null; p = p.find(re.charAt(i))) {
            if (p.result == null || p.depth >= Integer.MAX_VALUE) continue;
            prefix = false;
            best = p;
        }
        if (prefix) {
            if (re.equals(best.re)) {
                o = best.result;
                best.result = null;
            }
        } else if (re.equals(best.re)) {
            o = best.result;
            best.result = null;
        }
        return o;
    }

    public Object match(String s) {
        return this.matchAfter(s, Integer.MAX_VALUE);
    }

    public Object matchNext(String s) {
        return this.matchAfter(s, this.lastDepth);
    }

    private void add(String re, Object ret, boolean replace) throws REException {
        RegexpNode p;
        int len = re.length();
        if (re.charAt(0) == '*') {
            p = this.suffixMachine;
            while (len > 1) {
                p = p.add(re.charAt(--len));
            }
        } else {
            boolean exact = false;
            if (re.charAt(len - 1) == '*') {
                --len;
            } else {
                exact = true;
            }
            p = this.prefixMachine;
            for (int i = 0; i < len; ++i) {
                p = p.add(re.charAt(i));
            }
            p.exact = exact;
        }
        if (p.result != null && !replace) {
            throw new REException(re + " is a duplicate");
        }
        p.re = re;
        p.result = ret;
    }

    private Object matchAfter(String s, int lastMatchDepth) {
        RegexpNode p;
        RegexpNode best = p = this.prefixMachine;
        int bst = 0;
        int bend = 0;
        int len = s.length();
        if (len <= 0) {
            return null;
        }
        int i = 0;
        while (p != null) {
            if (!(p.result == null || p.depth >= lastMatchDepth || p.exact && i != len)) {
                this.lastDepth = p.depth;
                best = p;
                bst = i;
                bend = len;
            }
            if (i >= len) break;
            p = p.find(s.charAt(i));
            ++i;
        }
        i = len;
        for (p = this.suffixMachine; --i >= 0 && p != null; p = p.find(s.charAt(i))) {
            if (p.result == null || p.depth >= lastMatchDepth) continue;
            this.lastDepth = p.depth;
            best = p;
            bst = 0;
            bend = i + 1;
        }
        Object o = best.result;
        if (o != null && o instanceof RegexpTarget) {
            o = ((RegexpTarget)o).found(s.substring(bst, bend));
        }
        return o;
    }

    public void reset() {
        this.lastDepth = Integer.MAX_VALUE;
    }

    public void print(PrintStream out) {
        out.print("Regexp pool:\n");
        if (this.suffixMachine.firstchild != null) {
            out.print(" Suffix machine: ");
            this.suffixMachine.firstchild.print(out);
            out.print("\n");
        }
        if (this.prefixMachine.firstchild != null) {
            out.print(" Prefix machine: ");
            this.prefixMachine.firstchild.print(out);
            out.print("\n");
        }
    }
}

