/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.query;

import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import com.sun.wbem.query.ValueExp;

public class NumericValue
extends ValueExp {
    private long longVal;
    private double doubleVal;
    private UnsignedInt64 uint64;
    private boolean uint = false;
    private boolean sint = false;
    private boolean dbl = false;

    public NumericValue(Number val) {
        if (val instanceof Long || val instanceof Integer || val instanceof Short || val instanceof Byte) {
            this.longVal = val.longValue();
            this.sint = true;
        } else if (val instanceof UnsignedInt64 || val instanceof UnsignedInt8 || val instanceof UnsignedInt16 || val instanceof UnsignedInt32) {
            this.uint64 = val instanceof UnsignedInt64 ? (UnsignedInt64)val : new UnsignedInt64(val.toString());
            this.uint = true;
        } else {
            this.doubleVal = new Double(val + "");
            this.dbl = true;
        }
    }

    public NumericValue() {
        this.longVal = 0L;
        this.sint = true;
    }

    public double doubleValue() {
        if (this.sint) {
            return this.longVal;
        }
        if (this.uint) {
            return this.uint64.doubleValue();
        }
        return this.doubleVal;
    }

    public long longValue() {
        if (this.sint) {
            return this.longVal;
        }
        if (this.uint) {
            return this.uint64.longValue();
        }
        return (long)this.doubleVal;
    }

    public UnsignedInt64 uint64Value() {
        if (this.sint) {
            return new UnsignedInt64(String.valueOf(this.longVal));
        }
        if (this.uint) {
            return this.uint64;
        }
        return new UnsignedInt64(String.valueOf((long)this.doubleVal));
    }

    public boolean isUint() {
        return this.uint;
    }

    public boolean isSint() {
        return this.sint;
    }

    public boolean isReal() {
        return this.dbl;
    }

    public String toString() {
        if (this.uint) {
            return this.uint64.toString();
        }
        if (this.sint) {
            return String.valueOf(this.longVal);
        }
        return String.valueOf(this.doubleVal);
    }
}

