/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.client.SolarisPasswordCredential;
import com.sun.wbem.client.SolarisUserPrincipal;
import com.sun.wbem.security.RmiClientSecurity;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;

public class SolarisRmiClientSecurity
extends RmiClientSecurity {
    private String roleName;
    private byte[] rolePswd;

    public SolarisRmiClientSecurity() throws NoSuchAlgorithmException {
        this.roleName = null;
        this.rolePswd = new byte[0];
    }

    public SolarisRmiClientSecurity(CIMNameSpace ns, Principal prin, Object cred) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(ns);
        this.setPrincipal(prin);
        this.setCredential(cred);
    }

    public void setPrincipal(Principal prin) throws CIMException {
        super.setPrincipal(prin);
        this.roleName = null;
        if (prin instanceof SolarisUserPrincipal) {
            this.roleName = ((SolarisUserPrincipal)prin).getRoleName();
        }
    }

    public void setCredential(Object cred) throws CIMException {
        String tPswd;
        super.setCredential(cred);
        if (cred instanceof SolarisPasswordCredential && (tPswd = ((SolarisPasswordCredential)cred).getRolePassword()) != null) {
            int len = tPswd.length();
            this.rolePswd = new byte[len];
            for (int i = 0; i < len; ++i) {
                char c = tPswd.charAt(i);
                this.rolePswd[i] = (byte)c;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.roleName = null;
        Arrays.fill(this.rolePswd, (byte)0);
        this.rolePswd = new byte[0];
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getRolePassword() {
        String tPswd = "";
        if (this.rolePswd.length > 0) {
            char[] ca = new char[this.rolePswd.length];
            for (int i = 0; i < this.rolePswd.length; ++i) {
                ca[i] = (char)(0 | this.rolePswd[i] & 0xFF);
            }
            tPswd = new String(ca);
        }
        return tPswd;
    }
}

