/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.Buffer;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.DataStore;
import java.io.IOException;
import java.util.Vector;

public class ReadThread
implements Runnable {
    Buffer shared_buffer;
    long recordId;
    int numRecords;
    int direction;
    DataStore read_storage;
    int numRead;

    public ReadThread(Buffer record_vector, long filePointer, int numRecords, int direction, DataStore storage) {
        this.shared_buffer = record_vector;
        this.recordId = filePointer;
        this.numRecords = numRecords;
        this.direction = direction;
        this.read_storage = storage;
        this.numRead = 0;
    }

    public void run() {
        Vector records = new Vector();
        while (this.shared_buffer.getMessage()) {
            try {
                records = this.read_storage.readNumRecordsAsStr(this.recordId, this.numRecords, this.direction);
            }
            catch (AdminLogException e) {
                this.shared_buffer.setException(e);
                this.shared_buffer.setMessage();
                this.shared_buffer.setDone(true);
                break;
            }
            catch (IOException e) {
                this.shared_buffer.setException(new AdminLogException("EXLOG_IO", this.read_storage.getFileName()));
                this.shared_buffer.setMessage();
                this.shared_buffer.setDone(true);
                break;
            }
            catch (Exception e) {
                this.shared_buffer.setMessage();
                this.shared_buffer.setDone(true);
                break;
            }
            if (records == null) {
                this.shared_buffer.setMessage();
                this.shared_buffer.putRecs(null);
                break;
            }
            DataRecord rec = (DataRecord)records.lastElement();
            this.recordId = rec.getOffset();
            this.shared_buffer.putRecs(records);
        }
    }
}

