/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.solarisprovider.common.PropertyUtil;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.LogService;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_LogServiceProperties
implements InstanceProvider,
Authorizable {
    public static final String LOGSVC_WRITE_RIGHT = "solaris.admin.logsvc.write";
    public static final String LOGSVC_PURGE_RIGHT = "solaris.admin.logsvc purge";
    public static final String LOGSVC_READ_RIGHT = "solaris.admin.logsvc.read";
    public static final String LOG_PROP_SET_ID = "logprops";
    public static final String NATIVE_FILE_IMPL = "datafile.nativeimplementation";
    private LogService logsvc = null;
    private String setId = "logprops";
    private String caption = "LogService Properties";
    private String desc = this.desc + "to syslog.";
    private String propName = "LogSvcProperties";
    private PropertyUtil props = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private String nativeClass = null;

    public void cleanup() throws CIMException {
    }

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.provUtil = new ProviderUtility(cimomhandle, "Logging Service");
        try {
            this.props = new PropertyUtil("propdir", "WbemServices.properties", 1);
            this.nativeClass = this.props.getProp(NATIVE_FILE_IMPL);
            if (this.nativeClass == null) {
                this.nativeClass = "";
            }
        }
        catch (Exception ex) {
            String string = this.provUtil.writeLog(2, ex);
        }
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        long recId = 0L;
        boolean hashcode = false;
        String fileName = "";
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        CIMInstance ci = cc.newInstance();
        ci.setProperty("PropSettingName", new CIMValue((Object)this.propName));
        ci.setProperty("Directory", new CIMValue((Object)this.logsvc.getLogFileDir()));
        try {
            ci.setProperty("FileSize", new CIMValue((Object)String.valueOf(this.logsvc.getLogFileSize(null))));
        }
        catch (Exception ex) {
            // empty catch block
        }
        ci.setProperty("NumFiles", new CIMValue((Object)String.valueOf(this.logsvc.getNumLogFiles())));
        ci.setProperty("SyslogSwitch", new CIMValue((Object)this.logsvc.getSyslogSwitch()));
        ci.setProperty("DataFileImpl", new CIMValue((Object)this.nativeClass));
        if (!localOnly) {
            if (this.setId == null) {
                this.setId = LOG_PROP_SET_ID;
            }
            ci.setProperty("SettingID", new CIMValue((Object)this.setId));
            ci.setProperty("Caption", new CIMValue((Object)this.caption));
            ci.setProperty("Description", new CIMValue((Object)this.desc));
        }
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> allSettings = new Vector<CIMObjectPath>();
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
        cop.addKey("PropSettingName", new CIMValue((Object)this.propName));
        allSettings.addElement(cop);
        CIMObjectPath[] copArray = new CIMObjectPath[allSettings.size()];
        allSettings.toArray(copArray);
        return copArray;
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.setInstance(op, ci);
        return null;
    }

    public synchronized void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.provUtil.checkRights(LOGSVC_WRITE_RIGHT, op);
        if (this.logsvc == null) {
            try {
                this.logsvc = LogService.getInstance();
            }
            catch (AdminLogException ex) {
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
            }
        }
        try {
            String log_file = "wbem_log";
            String log_dir = "/var/sadm/wbem/log";
            String file_size = "5";
            String file_num = "5";
            String syslog_switch = "on";
            log_dir = (String)ci.getProperty("Directory").getValue().getValue();
            file_size = (String)ci.getProperty("FileSize").getValue().getValue();
            file_num = (String)ci.getProperty("NumFiles").getValue().getValue();
            syslog_switch = (String)ci.getProperty("SyslogSwitch").getValue().getValue();
            this.logsvc.setProperties(Integer.parseInt(file_size), Integer.parseInt(file_num), syslog_switch, log_dir);
        }
        catch (AdminLogException ex) {
            ex.printStackTrace();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.getLocalizedMessage());
        }
        try {
            this.setId = (String)ci.getProperty("SettingID").getValue().getValue();
            this.caption = (String)ci.getProperty("Caption").getValue().getValue();
            this.desc = (String)ci.getProperty("Description").getValue().getValue();
            this.propName = (String)ci.getProperty("PropSettingName").getValue().getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> allprops = new Vector<CIMInstance>();
        CIMInstance ci = this.getInstance(op, false, false, false, null, cc);
        if (localOnly) {
            ci = ci.localElements();
        }
        allprops.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
        CIMInstance[] ciArray = new CIMInstance[allprops.size()];
        allprops.toArray(ciArray);
        return ciArray;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return null;
    }
}

