/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.common;

import com.sun.wbem.utility.common.LaunchProcException;
import java.io.File;

public class ProcLauncher {
    private String command = "";
    private String username = "";
    private String[] paramListArray = new String[0];
    private String[] envVarsArray = new String[0];
    private String errorString = "";
    private int status = -1;
    private int procID = -1;

    public ProcLauncher(String cmd, String username, String[] paramsArray, String[] envArgs, boolean bUseExecProfiles) throws LaunchProcException {
        this.command = cmd;
        this.username = username;
        this.paramListArray = paramsArray;
        this.envVarsArray = envArgs;
        try {
            this.launchProc(cmd, username, paramsArray, envArgs, bUseExecProfiles);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LaunchProcException("EXM_GENERIC", e);
        }
    }

    private native void nativeLaunchProc(String[] var1, String[] var2, String var3);

    public String getCommand() {
        return this.command;
    }

    public String getUserName() {
        return this.username;
    }

    public String[] getParameters() {
        return this.paramListArray;
    }

    public String[] getEnvVarsArray() {
        return this.envVarsArray;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public int getPID() {
        return this.procID;
    }

    private void launchProc(String cmd, String username, String[] paramsArray, String[] envArgs, boolean bUseExecProfiles) throws LaunchProcException {
        File cmdexecutable = new File(cmd);
        if (!cmdexecutable.exists()) {
            throw new LaunchProcException("EXM_NOEXIST", cmd);
        }
        String[] envArray = null;
        int preEnvArgs = 2;
        if (envArgs == null) {
            envArray = new String[preEnvArgs];
            envArray[0] = "USER=" + username;
            envArray[1] = "PATH=/usr/sbin:/usr/bin";
        }
        envArray = envArgs;
        if (paramsArray == null) {
            paramsArray = new String[]{cmd};
        }
        String[] cmdArray = null;
        int preArgs = 0;
        if (bUseExecProfiles) {
            cmdArray = new String[paramsArray.length + 1];
            cmdArray[0] = "/usr/bin/pfexec";
            preArgs = 1;
        } else {
            cmdArray = new String[paramsArray.length];
        }
        for (int i = 0; i < paramsArray.length; ++i) {
            cmdArray[preArgs + i] = paramsArray[i];
        }
        this.nativeLaunchProc(cmdArray, envArray, username);
    }

    static {
        System.loadLibrary("provutil");
    }
}

