/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

class FileEditor {
    String fileToEdit;
    BufferedReader readStream;
    BufferedWriter writeStream;
    boolean locked;
    int tableAttributes;
    String saveLine;

    FileEditor(String fileToEdit, int tableAttributes) {
        this.fileToEdit = fileToEdit;
        this.tableAttributes = tableAttributes;
        this.saveLine = null;
        this.locked = false;
        this.readStream = null;
        this.writeStream = null;
    }

    String getFirstLine() throws DirectoryTableException {
        try {
            if (this.readStream != null) {
                this.readStream.close();
                this.readStream = null;
            }
            this.readStream = new BufferedReader(new FileReader(this.fileToEdit), 32768);
            if ((this.tableAttributes & 0x40) == 64) {
                this.saveLine = null;
            }
            String firstLine = this.getNextLine();
            return firstLine;
        }
        catch (IOException e) {
            throw new DirectoryTableAccessException("EXM_READERROR", this.fileToEdit);
        }
    }

    String getNextLine() throws DirectoryTableException {
        String nextLine = null;
        try {
            String tmpLine;
            if ((this.tableAttributes & 0x40) == 64) {
                if (this.saveLine != null) {
                    nextLine = this.saveLine;
                    this.saveLine = null;
                } else {
                    nextLine = this.readStream.readLine();
                }
            } else if ((this.tableAttributes & 0x100) == 256) {
                tmpLine = null;
                boolean endOfLine = false;
                int braceLevel = 0;
                tmpLine = this.readStream.readLine();
                while (!endOfLine && tmpLine != null) {
                    int i;
                    if (tmpLine != null && tmpLine.trim().startsWith("#")) {
                        tmpLine = "";
                    } else if (tmpLine != null && tmpLine.trim().startsWith("//")) {
                        tmpLine = "";
                    } else if (tmpLine != null && (i = tmpLine.indexOf("/*")) != -1) {
                        String prefixLine = tmpLine.substring(0, i);
                        while (tmpLine != null) {
                            i = tmpLine.indexOf("*/");
                            if (i != -1) {
                                tmpLine = tmpLine.substring(i + 2);
                                break;
                            }
                            tmpLine = this.readStream.readLine();
                        }
                        if (tmpLine == null) {
                            throw new DirectoryTableAccessException("EXM_READERROR", this.fileToEdit);
                        }
                        if (prefixLine != null && prefixLine.trim().length() != 0) {
                            tmpLine = prefixLine + tmpLine;
                        }
                    }
                    if (!tmpLine.equals("")) {
                        nextLine = nextLine == null ? tmpLine : nextLine + " " + tmpLine;
                        for (i = 0; i < tmpLine.length(); ++i) {
                            if (tmpLine.charAt(i) == '{') {
                                ++braceLevel;
                            }
                            if (tmpLine.charAt(i) == '}') {
                                --braceLevel;
                            }
                            if (tmpLine.charAt(i) != ';' || braceLevel != 0) continue;
                            endOfLine = true;
                        }
                    }
                    if (endOfLine) continue;
                    tmpLine = this.readStream.readLine();
                }
            } else {
                nextLine = this.readStream.readLine();
            }
            if (nextLine == null) {
                return nextLine;
            }
            if ((this.tableAttributes & 0x40) == 64) {
                this.saveLine = this.readStream.readLine();
                while (this.saveLine != null && this.saveLine.length() != 0 && (this.saveLine.charAt(0) == ' ' || this.saveLine.charAt(0) == '\t')) {
                    int i;
                    for (i = 0; i < this.saveLine.length() && (this.saveLine.charAt(i) == ' ' || this.saveLine.charAt(i) == '\t'); ++i) {
                    }
                    if (i < this.saveLine.length()) {
                        nextLine = nextLine + this.saveLine.substring(i, this.saveLine.length());
                    }
                    this.saveLine = this.readStream.readLine();
                }
                return nextLine;
            }
            if ((this.tableAttributes & 0x80) == 128) {
                tmpLine = null;
                if (this.isDbFileMultilineStart(nextLine)) {
                    tmpLine = this.readStream.readLine();
                    while (tmpLine != null) {
                        nextLine = nextLine + " " + tmpLine;
                        if (!this.isDbFileMultilineEnd(tmpLine)) {
                            tmpLine = this.readStream.readLine();
                            continue;
                        }
                        tmpLine = null;
                    }
                }
                return nextLine;
            }
            if ((this.tableAttributes & 0x20) == 32) {
                tmpLine = null;
                if (nextLine.length() > 0) {
                    while (nextLine.charAt(nextLine.length() - 1) == '\\') {
                        tmpLine = this.readStream.readLine();
                        if (tmpLine != null) {
                            nextLine = nextLine.substring(0, nextLine.length() - 1) + tmpLine;
                            continue;
                        }
                        nextLine = nextLine.substring(0, nextLine.length() - 1);
                    }
                }
                return nextLine;
            }
            return nextLine;
        }
        catch (IOException e) {
            throw new DirectoryTableAccessException("EXM_READERROR", this.fileToEdit);
        }
    }

    void modifyLine(String oldline, String newline) throws DirectoryTableException {
        try {
            this.lockFile();
            String tempFile = this.makeTempName(this.fileToEdit);
            File fd = new File(tempFile);
            fd.delete();
            fd = null;
            this.writeStream = new BufferedWriter(new FileWriter(tempFile), 32768);
            String line2 = this.getFirstLine();
            while (line2 != null) {
                if (oldline.equals(line2)) {
                    this.writeStream.write(newline);
                    this.writeStream.newLine();
                } else {
                    this.writeStream.write(line2);
                    this.writeStream.newLine();
                }
                line2 = this.getNextLine();
            }
            this.writeStream.close();
            this.readStream.close();
            this.readStream = null;
            this.writeStream = null;
            this.replaceFile(this.fileToEdit, tempFile);
        }
        catch (IOException e) {
            throw new DirectoryTableAccessException("EXM_WRITEERROR", this.fileToEdit);
        }
        finally {
            this.unlockFile();
        }
    }

    void addLine(String line) throws DirectoryTableException {
        try {
            this.lockFile();
            this.writeStream = new BufferedWriter(new FileWriter(this.fileToEdit, true), 32768);
            this.writeStream.write(line);
            this.writeStream.newLine();
            this.writeStream.close();
            this.writeStream = null;
        }
        catch (IOException e) {
            throw new DirectoryTableAccessException("EXM_WRITEERROR", this.fileToEdit);
        }
        finally {
            this.unlockFile();
        }
    }

    void deleteLine(String line) throws DirectoryTableException {
        try {
            this.lockFile();
            String tempFile = this.makeTempName(this.fileToEdit);
            File fd = new File(tempFile);
            fd.delete();
            fd = null;
            this.writeStream = new BufferedWriter(new FileWriter(tempFile), 32768);
            String line2 = this.getFirstLine();
            while (line2 != null) {
                if (!line.equals(line2)) {
                    this.writeStream.write(line2);
                    this.writeStream.newLine();
                }
                line2 = this.getNextLine();
            }
            this.writeStream.close();
            this.readStream.close();
            this.readStream = null;
            this.writeStream = null;
            this.replaceFile(this.fileToEdit, tempFile);
        }
        catch (IOException e) {
            throw new DirectoryTableAccessException("EXM_WRITEERROR", this.fileToEdit);
        }
        finally {
            this.unlockFile();
        }
    }

    private String makeTempName(String filename) throws DirectoryTableException {
        int i;
        String tempName = null;
        File fd = null;
        for (i = 1; i < 256 && (fd = new File(tempName = filename + "." + i)).exists(); ++i) {
        }
        if (i < 256) {
            return tempName;
        }
        throw new DirectoryTableAccessException("EXM_NOTEMP", filename);
    }

    private void lockFile() throws DirectoryTableException {
        int retry;
        String lockPath = this.fileToEdit + ".as_lock_dir";
        File fd = new File(lockPath);
        for (retry = 0; retry < 100; ++retry) {
            if (fd.mkdir()) {
                this.locked = true;
                break;
            }
            if (!fd.isDirectory()) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (retry == 100) {
            if (fd.isDirectory()) {
                throw new DirectoryTableAccessException("EXM_LOCKED", lockPath);
            }
            throw new DirectoryTableAccessException("EXM_NOCREATELOCK", lockPath);
        }
    }

    private void unlockFile() throws DirectoryTableException {
        if (this.locked) {
            String lockPath = this.fileToEdit + ".as_lock_dir";
            File fd = new File(lockPath);
            fd.delete();
        }
    }

    private void replaceFile(String dest, String source) throws DirectoryTableException {
        File destFd = null;
        File canonDestFd = null;
        File sourceFd = null;
        try {
            destFd = new File(dest);
            String canonName = destFd.getCanonicalPath();
            destFd = null;
            DirectoryTableLibrary.fileCopyStat(canonName, source);
            canonDestFd = new File(canonName);
            canonDestFd.delete();
            sourceFd = new File(source);
            sourceFd.renameTo(canonDestFd);
            sourceFd = null;
            canonDestFd = null;
        }
        catch (IOException e) {
            throw new DirectoryTableAccessException("EXM_WRITEERROR", dest);
        }
    }

    private boolean isDbFileMultilineStart(String line) {
        int i = 0;
        int j = 0;
        i = line.indexOf("(");
        j = line.indexOf(")");
        if (i != -1) {
            return j == -1 || j <= i;
        }
        return false;
    }

    private boolean isDbFileMultilineEnd(String line) {
        int i = 0;
        i = line.indexOf(")");
        return i != -1;
    }
}

