/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.LdapTableDefinitions;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import com.sun.wbem.utility.directorytable.TableSetup;
import java.net.InetAddress;
import java.util.Vector;

public class LdapDirectoryTable
implements DirectoryTable,
TableSetup {
    TableDefinitions tableDefinitions;
    boolean needsFlush;
    String domainName;
    String serverName;
    String authName = "";
    String authPassword = "";
    int port;
    int sessionDescriptor = -1;
    DirectoryMask allSetMask;

    public int access(String tableName) throws DirectoryTableException {
        int access = 0;
        LdapTableDefinitions tableDefinitionsArg = new LdapTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        String checkTable = tableDefinitionsArg.getMappedTableName();
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 16, this.authName, this.authPassword, this.port) != 0) {
            return access;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 4, this.authName, this.authPassword, this.port) == 0) {
            access |= 1;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 8, this.authName, this.authPassword, this.port) == 0) {
            access |= 2;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 2, this.authName, this.authPassword, this.port) == 0) {
            access |= 8;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 1, this.authName, this.authPassword, this.port) == 0) {
            access |= 4;
        }
        return access;
    }

    public int access(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        int access = 0;
        String checkTable = tableDefinitionsArg.getMappedTableName();
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 16, this.authName, this.authPassword, this.port) != 0) {
            return access;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 4, this.authName, this.authPassword, this.port) == 0) {
            access |= 1;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 8, this.authName, this.authPassword, this.port) == 0) {
            access |= 2;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 2, this.authName, this.authPassword, this.port) == 0) {
            access |= 8;
        }
        if (DirectoryTableLibrary.ldapAccess(this.serverName, checkTable, 1, this.authName, this.authPassword, this.port) == 0) {
            access |= 4;
        }
        return access;
    }

    public void open(String tableName) throws DirectoryTableException {
        LdapTableDefinitions tableDefinitionsArg = new LdapTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        int n = tableDefinitionsArg.getNumberOfColumns();
        String[] colNames = new String[n];
        for (int i = 0; i < n; ++i) {
            colNames[i] = tableDefinitionsArg.getMappedColumnName(i + 1);
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapOpenTable(this.serverName, tableDefinitionsArg.getMappedTableName(), colNames, this.authName, this.authPassword, this.port);
        if (this.sessionDescriptor < 1) {
            int ldaperror = 0 - this.sessionDescriptor;
            if (ldaperror == 32) {
                throw new DirectoryTableDoesNotExistException(tableDefinitionsArg.getMappedTableName(), "DN", tableDefinitionsArg.getMappedTableName());
            }
            DirectoryTableLibrary.ldapErrorToException(ldaperror, tableDefinitionsArg);
        }
        this.tableDefinitions = tableDefinitionsArg;
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        int n = tableDefinitionsArg.getNumberOfColumns();
        String[] colNames = new String[n];
        for (int i = 0; i < n; ++i) {
            colNames[i] = tableDefinitionsArg.getMappedColumnName(i + 1);
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapOpenTable(this.serverName, tableDefinitionsArg.getMappedTableName(), colNames, this.authName, this.authPassword, this.port);
        if (this.sessionDescriptor < 1) {
            int ldaperror = 0 - this.sessionDescriptor;
            if (ldaperror == 32) {
                throw new DirectoryTableDoesNotExistException(tableDefinitionsArg.getMappedTableName(), "DN", tableDefinitionsArg.getMappedTableName());
            }
            DirectoryTableLibrary.ldapErrorToException(ldaperror, tableDefinitionsArg);
        }
        this.tableDefinitions = tableDefinitionsArg;
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        char columnSeparator = tableDefinitionsArg.getColumnSeparators().charAt(0);
        int rights = DirectoryTableLibrary.convertAccessToRights(tableDefinitionsArg.getAccess());
        int n = tableDefinitionsArg.getNumberOfColumns();
        String[] colNames = new String[n];
        for (int i = 0; i < n; ++i) {
            colNames[i] = tableDefinitionsArg.getMappedColumnName(i + 1);
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapAddTable(this.serverName, tableDefinitionsArg.getMappedTableName(), rights, colNames, this.authName, this.authPassword, this.port);
        if (this.sessionDescriptor < 1) {
            int ldaperror = 0 - this.sessionDescriptor;
            DirectoryTableLibrary.ldapErrorToException(ldaperror, tableDefinitionsArg);
        }
        this.tableDefinitions = tableDefinitionsArg;
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(String tableName) throws DirectoryTableException {
        LdapTableDefinitions tableDefinitionsArg = new LdapTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        char columnSeparator = tableDefinitionsArg.getColumnSeparators().charAt(0);
        int rights = DirectoryTableLibrary.convertAccessToRights(tableDefinitionsArg.getAccess());
        int n = tableDefinitionsArg.getNumberOfColumns();
        String[] colNames = new String[n];
        for (int i = 0; i < n; ++i) {
            colNames[i] = tableDefinitionsArg.getMappedColumnName(i + 1);
        }
        this.sessionDescriptor = DirectoryTableLibrary.ldapAddTable(this.serverName, tableDefinitionsArg.getMappedTableName(), rights, colNames, this.authName, this.authPassword, this.port);
        if (this.sessionDescriptor < 1) {
            int ldaperror = 0 - this.sessionDescriptor;
            DirectoryTableLibrary.ldapErrorToException(ldaperror, tableDefinitionsArg);
        }
        this.tableDefinitions = tableDefinitionsArg;
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void delete(TableDefinitions tableDefs) throws DirectoryTableException {
        int ret = 0;
        ret = DirectoryTableLibrary.ldapDeleteTable(this.serverName, tableDefs.getMappedTableName(), this.authName, this.authPassword, this.port);
        DirectoryTableLibrary.ldapErrorToException(ret, tableDefs);
    }

    public void delete(String tableName) throws DirectoryTableException {
        int ret = 0;
        LdapTableDefinitions tableDefinitionsArg = new LdapTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        ret = DirectoryTableLibrary.ldapDeleteTable(this.serverName, tableDefinitionsArg.getMappedTableName(), this.authName, this.authPassword, this.port);
        DirectoryTableLibrary.ldapErrorToException(ret, tableDefinitionsArg);
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException e) {
            this.needsFlush = false;
        }
        DirectoryTableLibrary.ldapCloseTable(this.sessionDescriptor);
        this.tableDefinitions = null;
        this.sessionDescriptor = -1;
        this.allSetMask = null;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            this.needsFlush = false;
        }
    }

    public void addRow(DirectoryRow row) throws DirectoryTableException {
        String dn = null;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        for (int i = 1; i <= row.getNumberOfRows(); ++i) {
            dn = this.rowToDN(row, i);
            if (dn == null) {
                throw new DirectoryTableAccessException("EXM_NOTUNIQUE");
            }
            int ret = DirectoryTableLibrary.ldapAddEntry(this.sessionDescriptor, dn, this.rowToArray(row, i));
            DirectoryTableLibrary.ldapErrorToException(ret, this.tableDefinitions);
        }
        this.needsFlush = true;
    }

    public void deleteRow(DirectoryRow row) throws DirectoryTableException {
        String dn = null;
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = row.getNumberOfColumns();
        int attrCount = 1;
        for (int k = 1; k <= n; ++k) {
            if ((this.tableDefinitions.getColumnAttributes(k) & 0x20) == 32) continue;
            ++attrCount;
        }
        String[] arr = new String[attrCount];
        arr[0] = this.tableDefinitions.getTableType();
        --attrCount;
        for (int j = 1; j <= n; ++j) {
            if ((this.tableDefinitions.getColumnAttributes(j) & 0x20) == 32) continue;
            arr[attrCount--] = this.tableDefinitions.getMappedColumnName(j);
        }
        for (int i = 1; i <= row.getNumberOfRows(); ++i) {
            dn = this.rowToDN(row, i);
            if (dn == null) {
                throw new DirectoryTableAccessException("EXM_NOTUNIQUE");
            }
            int ret = DirectoryTableLibrary.ldapDeleteEntry(this.sessionDescriptor, dn, arr);
            DirectoryTableLibrary.ldapErrorToException(ret, this.tableDefinitions);
        }
        this.needsFlush = true;
    }

    public void modifyRow(DirectoryRow searchRow, DirectoryRow replaceRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int ret = DirectoryTableLibrary.ldapModifyEntry(this.sessionDescriptor, this.rowToDN(searchRow, 1), this.rowToDN(replaceRow, 1), this.rowToArray(replaceRow, 1));
        DirectoryTableLibrary.ldapErrorToException(ret, this.tableDefinitions);
        this.needsFlush = true;
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow emptyRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(emptyRow);
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow emptyRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(emptyRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate template) throws DirectoryTableException {
        DirectoryRow searchRow = template.getTemplateAsRow(this.tableDefinitions);
        String searchStr = searchRow == null ? "" : this.rowToSearchName(searchRow, 1);
        String[] arr = DirectoryTableLibrary.ldapGetFirstEntry(this.sessionDescriptor, searchStr);
        if (arr == null) {
            return null;
        }
        DirectoryRow row = this.arrayToRow(arr);
        if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
            return row;
        }
        arr = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        while (arr != null) {
            row = this.arrayToRow(arr);
            if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
                return row;
            }
            arr = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getNextRow(SearchTemplate template) throws DirectoryTableException {
        String[] arr = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        while (arr != null) {
            DirectoryRow row = this.arrayToRow(arr);
            if (!row.isEmpty() && template.matchRow(row, 1, this.tableDefinitions)) {
                return row;
            }
            arr = DirectoryTableLibrary.ldapGetNextEntry(this.sessionDescriptor);
        }
        return null;
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        return this.getAll(this.allSetMask);
    }

    public DirectoryRow getAll(DirectoryMask mask) throws DirectoryTableException {
        String[] arr;
        DirectoryRow row = null;
        DirectoryRow searchRow = null;
        boolean currentRow = true;
        int nCol = 0;
        int nRow = 0;
        searchRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        String searchStr = this.rowToSearchName(searchRow, 1);
        if (searchStr.equals("(&(objectClass=SolarisProfAttr))")) {
            searchStr = "(!(objectClass=SolarisExecAttr))";
        }
        if ((arr = DirectoryTableLibrary.ldapGetAllEntries(this.sessionDescriptor, searchStr)) == null) {
            return row;
        }
        nCol = this.tableDefinitions.getNumberOfColumns();
        nRow = arr.length / nCol;
        row = new DirectoryRow(nCol, nRow);
        this.arrayIntoRow(arr, 0, row, 1, nRow, mask);
        return row;
    }

    public DirectoryRow getAll(SearchTemplate template) throws DirectoryTableException {
        return this.getAll(template, this.allSetMask);
    }

    public DirectoryRow getAll(SearchTemplate template, DirectoryMask mask) throws DirectoryTableException {
        DirectoryRow row = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        int currentRow = 1;
        int nCol = 0;
        int nRow = 0;
        DirectoryRow searchRow = template.getTemplateAsRow(this.tableDefinitions);
        String searchStr = searchRow == null ? this.rowToSearchName(new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1), 1) : this.rowToSearchName(searchRow, 1);
        String[] arr = DirectoryTableLibrary.ldapGetAllEntries(this.sessionDescriptor, searchStr);
        if (arr == null) {
            return null;
        }
        nCol = this.tableDefinitions.getNumberOfColumns();
        nRow = arr.length / nCol;
        for (int i = 0; i < nRow; ++i) {
            this.arrayIntoRow(arr, i * nCol, row, currentRow, 1, mask);
            if (row.isEmpty() || !template.matchRow(row, currentRow, this.tableDefinitions)) continue;
            row.addRows(1);
            ++currentRow;
        }
        row.deleteRow(currentRow);
        if (currentRow == 1) {
            return null;
        }
        return row;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int rows) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), rows);
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new LdapTableDefinitions(this.serverName, this.domainName);
    }

    public DirectoryMask getDirectoryMaskInstance() {
        return new DirectoryMask(this.tableDefinitions);
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    public void setContext(String context) throws DirectoryTableException {
        String portStr;
        try {
            portStr = DirectoryUtility.getDirectoryTableProperty("directorytable.ldap.port");
            if (portStr == null || portStr.equals("")) {
                portStr = "389";
            }
        }
        catch (UException a) {
            portStr = "389";
        }
        this.port = Integer.valueOf(portStr);
        this.serverName = DirectoryUtility.getContextProperty(context, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(context, "domainName");
        this.authName = DirectoryUtility.getContextProperty(context, "authName");
        this.authPassword = DirectoryUtility.getContextProperty(context, "authPassword");
        if (!DirectoryUtility.isLocalServer(this.serverName)) {
            throw new DirectoryTableOperationNotSupportedException("Remote LDAP");
        }
    }

    private String[] rowToArray(DirectoryRow row, int rowNum) throws DirectoryTableException {
        int n = row.getNumberOfColumns();
        String[] arr = new String[n + 1];
        arr[0] = this.tableDefinitions.getTableType();
        for (int i = 1; i < n + 1; ++i) {
            arr[i] = row.getColumn(i, rowNum);
        }
        if (n == 8 && arr[2].trim().length() == 0) {
            arr[2] = arr[1];
        }
        return arr;
    }

    private String rowToDN(DirectoryRow row, int rowNum) throws DirectoryTableException {
        String name = "";
        boolean first = true;
        int n = row.getNumberOfColumns();
        for (int i = 0; i < n; ++i) {
            if ((this.tableDefinitions.getColumnAttributes(i + 1) & 0x20) != 32) continue;
            if (!first) {
                name = name + "+";
            } else {
                first = false;
            }
            if (row.getColumn(i + 1, rowNum).equals("")) {
                String altCol = this.tableDefinitions.getAuxilliaryColumnData(i + 1);
                name = name + this.tableDefinitions.getMappedColumnName(i + 1) + "=" + row.getColumn(this.tableDefinitions.getColumnNumber(altCol), rowNum);
                continue;
            }
            name = name + this.tableDefinitions.getMappedColumnName(i + 1) + "=" + row.getColumn(i + 1, rowNum);
        }
        return name;
    }

    private DirectoryRow arrayToRow(String[] arr) throws DirectoryTableException {
        int n = this.tableDefinitions.getNumberOfColumns();
        DirectoryRow row = new DirectoryRow(n);
        for (int i = 0; i < n; ++i) {
            row.putColumn(i + 1, arr[i]);
        }
        return row;
    }

    private void arrayIntoRow(String[] arr, int arrIndex, DirectoryRow row, int rowIndex, int rowNum, DirectoryMask mask) throws DirectoryTableException {
        int n = this.tableDefinitions.getNumberOfColumns();
        if (rowNum == 0) {
            rowNum = (arr.length - arrIndex) / n;
        }
        for (int rNum = rowIndex; rNum < rowIndex + rowNum; ++rNum) {
            for (int i = 0; i < n; ++i) {
                if (!mask.getColumn(i + 1)) continue;
                row.putColumn(i + 1, rNum, arr[(rNum - rowIndex) * n + arrIndex + i]);
            }
        }
    }

    private String rowToSearchName(DirectoryRow row, int rowNum) throws DirectoryTableException {
        int n = row.getNumberOfColumns();
        boolean firstCol = true;
        String searchName = new String("");
        if (row.isEmpty()) {
            searchName = searchName + "(&(objectClass=" + this.tableDefinitions.getTableType() + "))";
            return searchName;
        }
        for (int i = 1; i <= n; ++i) {
            if ((this.tableDefinitions.getColumnAttributes(i) & 1) != 1) continue;
            if (firstCol) {
                searchName = searchName + "(&";
                firstCol = false;
            }
            if (row.getColumn(i, rowNum).equals("")) continue;
            searchName = searchName + "(" + this.tableDefinitions.getMappedColumnName(i) + "=" + row.getColumn(i, rowNum) + ")";
        }
        if (!firstCol) {
            searchName = searchName + "(objectClass=" + this.tableDefinitions.getTableType() + "))";
        }
        return searchName;
    }

    public Vector getScopes(int flags) {
        String portStr;
        String localServer;
        Vector<String> scopes = null;
        try {
            localServer = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return scopes;
        }
        try {
            portStr = DirectoryUtility.getDirectoryTableProperty("directorytable.ldap.port");
            if (portStr == null || portStr.equals("")) {
                portStr = "389";
            }
        }
        catch (UException a) {
            portStr = "389";
        }
        int sport = Integer.valueOf(portStr);
        String[] domains = null;
        domains = DirectoryTableLibrary.ldapGetAllDomains(localServer, sport);
        scopes = new Vector<String>();
        if (domains != null) {
            for (int i = 0; i < domains.length; ++i) {
                String[] colNames;
                LdapTableDefinitions tableDefinitionsArg = new LdapTableDefinitions(localServer, domains[i]);
                try {
                    tableDefinitionsArg.loadTableDefinitions("passwd");
                }
                catch (Exception e) {
                    return scopes;
                }
                String checkTable = tableDefinitionsArg.getMappedTableName();
                int n = tableDefinitionsArg.getNumberOfColumns();
                try {
                    colNames = new String[n];
                    for (int j = 0; j < n; ++j) {
                        colNames[j] = tableDefinitionsArg.getMappedColumnName(j + 1);
                    }
                }
                catch (Exception e) {
                    return scopes;
                }
                int session = DirectoryTableLibrary.ldapOpenTable(localServer, checkTable, colNames, this.authName, this.authPassword, sport);
                if (session < 0) continue;
                scopes.addElement("ldap:/" + localServer + "/" + domains[i]);
                DirectoryTableLibrary.ldapCloseTable(session);
            }
        }
        return scopes;
    }

    public void setup() {
    }

    public void refreshSetup() {
    }
}

