/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowSizeException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.FileDirectoryTable;
import com.sun.wbem.utility.directorytable.FileEditor;
import com.sun.wbem.utility.directorytable.NisTableDefinitions;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class NisDirectoryTable
extends FileDirectoryTable {
    private static final String ypwhichCmd = "/usr/bin/ypwhich";
    private static final String echoCmd = "/usr/bin/echo";
    private static final String makeCmd = "/usr/ccs/bin/make";
    private static final String grepCmd = "/bin/grep";
    private static final String sedCmd = "/bin/sed";
    private static final int MAX_BLOCK_LENGTH = 1024;
    private static final int HASH_LENGTH = 12;
    private String makeFile = null;
    private String makePath = null;
    private String updateSchedule = null;
    String domainName;
    String serverName;

    public NisDirectoryTable() {
        try {
            this.makePath = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.makepath");
            if (this.makePath == null || this.makePath.equals("")) {
                this.makePath = "/var/yp";
            }
        }
        catch (UException a) {
            this.makePath = "/var/yp";
        }
        try {
            this.makeFile = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.makefile");
            if (this.makeFile == null || this.makeFile.equals("")) {
                this.makeFile = "Makefile";
            }
        }
        catch (UException a) {
            this.makeFile = "Makefile";
        }
        try {
            this.updateSchedule = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.updateschedule");
            if (this.updateSchedule == null || this.updateSchedule.equals("")) {
                this.updateSchedule = "always";
            }
        }
        catch (UException a) {
            this.updateSchedule = "always";
        }
    }

    public int access(String tableName) throws DirectoryTableException {
        int access = 0;
        NisTableDefinitions tableDefinitionsArg = new NisTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        String checkFile = tableDefinitionsArg.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(checkFile, 0) != 0) {
            return access;
        }
        if (DirectoryTableLibrary.fileAccess(checkFile, 2) == 0) {
            access |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(checkFile, 4) == 0) {
            access |= 4;
        }
        return access;
    }

    public int access(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        int access = 0;
        String checkFile = tableDefinitionsArg.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(checkFile, 0) != 0) {
            return access;
        }
        if (DirectoryTableLibrary.fileAccess(checkFile, 2) == 0) {
            access |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(checkFile, 4) == 0) {
            access |= 4;
        }
        return access;
    }

    public void open(String tableName) throws DirectoryTableException {
        NisTableDefinitions tableDefinitionsArg = new NisTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        if (DirectoryTableLibrary.fileAccess(tableDefinitionsArg.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(tableName, "file", tableName);
        }
        if (!this.isMaster(tableDefinitionsArg, false)) {
            if (!this.isMaster("passwd.byname", false)) {
                throw new DirectoryTableAccessException("EXM_NOTMASTER", this.serverName);
            }
            throw new DirectoryTableDoesNotExistException(tableName, "file", tableName);
        }
        this.tableDefinitions = tableDefinitionsArg;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        if (DirectoryTableLibrary.fileAccess(tableDefinitionsArg.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(tableDefinitionsArg.getTableName(), "file", tableDefinitionsArg.getMappedTableName());
        }
        if (!this.isMaster(tableDefinitionsArg, false)) {
            if (!this.isMaster("passwd.byname", false)) {
                throw new DirectoryTableAccessException("EXM_NOTMASTER", this.serverName);
            }
            throw new DirectoryTableDoesNotExistException(tableDefinitionsArg.getTableName(), "file", tableDefinitionsArg.getMappedTableName());
        }
        this.tableDefinitions = tableDefinitionsArg;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitionsArg) throws DirectoryTableException {
        int mode = 0;
        int ret = 0;
        if (DirectoryTableLibrary.fileAccess(tableDefinitionsArg.getMappedTableName(), 0) != 0) {
            mode = DirectoryTableLibrary.convertAccessToMode(tableDefinitionsArg.getAccess());
            ret = DirectoryTableLibrary.fileCreate(tableDefinitionsArg.getMappedTableName(), tableDefinitionsArg.getUser(), tableDefinitionsArg.getGroup(), mode);
            DirectoryTableLibrary.errnoToException(ret, tableDefinitionsArg);
        }
        this.addMakefileEntry(tableDefinitionsArg);
        this.tableDefinitions = tableDefinitionsArg;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = true;
    }

    public void create(String tableName) throws DirectoryTableException {
        int mode = 0;
        int ret = 0;
        NisTableDefinitions tableDefinitionsArg = new NisTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        if (DirectoryTableLibrary.fileAccess(tableDefinitionsArg.getMappedTableName(), 0) != 0) {
            mode = DirectoryTableLibrary.convertAccessToMode(tableDefinitionsArg.getAccess());
            ret = DirectoryTableLibrary.fileCreate(tableDefinitionsArg.getMappedTableName(), tableDefinitionsArg.getUser(), tableDefinitionsArg.getGroup(), mode);
            DirectoryTableLibrary.errnoToException(ret, tableDefinitionsArg);
        }
        this.addMakefileEntry(tableDefinitionsArg);
        this.tableDefinitions = tableDefinitionsArg;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = true;
    }

    public void delete(TableDefinitions tableDefs) throws DirectoryTableException {
        int ret = 0;
        ret = DirectoryTableLibrary.fileDelete(tableDefs.getMappedTableName());
        DirectoryTableLibrary.errnoToException(ret, tableDefs);
    }

    public void delete(String tableName) throws DirectoryTableException {
        int ret = 0;
        NisTableDefinitions tableDefinitionsArg = new NisTableDefinitions(this.serverName, this.domainName);
        tableDefinitionsArg.loadTableDefinitions(tableName);
        ret = DirectoryTableLibrary.fileDelete(tableDefinitionsArg.getMappedTableName());
        DirectoryTableLibrary.errnoToException(ret, tableDefinitionsArg);
    }

    public void addRow(DirectoryRow row) throws DirectoryTableException {
        this.checkRowLength(row);
        super.addRow(row);
    }

    public void modifyRow(DirectoryRow searchRow, DirectoryRow replaceRow) throws DirectoryTableException {
        this.checkRowLength(replaceRow);
        super.modifyRow(searchRow, replaceRow);
    }

    public void flush() throws DirectoryTableException {
        String mapName = null;
        if (this.tableDefinitions == null) {
            return;
        }
        mapName = this.tableDefinitions.getTableType();
        String[] flushCmd = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + makeCmd + " -f " + this.makeFile + " " + mapName};
        if (this.needsFlush && this.updateSchedule.equals("always")) {
            String[] outputArr = CommonTools.CMN_exec(flushCmd);
            this.needsFlush = false;
        }
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new NisTableDefinitions(this.serverName, this.domainName);
    }

    public void setContext(String context) throws DirectoryTableException {
        this.serverName = DirectoryUtility.getContextProperty(context, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(context, "domainName");
        if (!DirectoryUtility.isLocalServer(this.serverName)) {
            throw new DirectoryTableOperationNotSupportedException("Remote NIS Master");
        }
    }

    private void addMakefileEntry(TableDefinitions tableDefs) throws DirectoryTableException {
        int i;
        if (this.checkForMakefileTarget(tableDefs.getTableType())) {
            return;
        }
        String rawName = tableDefs.getRawMappedTableName();
        rawName = this.convertMacrosToVariables(rawName);
        String line = rawName + ":";
        this.appendMakefileLine(line);
        line = tableDefs.getTableName() + ": " + tableDefs.getTableName() + ".time";
        this.appendMakefileLine(line);
        line = tableDefs.getTableName() + ".time: " + rawName;
        this.appendMakefileLine(line);
        for (i = 1; i <= tableDefs.getNumberOfColumns(); ++i) {
            if ((tableDefs.getColumnAttributes(i) & 1) != 1) continue;
            line = "    @(awk \\047BEGIN { FS = \"" + tableDefs.getColumnSeparators() + "\"; OFS = \"\\t\"; } /^[a-zA-Z0-9_]/ { print $$" + i + ", $$0 }\\047 " + rawName + " $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/" + tableDefs.getTableName() + ".by" + tableDefs.getColumnName(i) + "; ";
            this.appendMakefileLine(line);
        }
        line = "    @touch " + tableDefs.getTableName() + ".time; ";
        this.appendMakefileLine(line);
        line = "    @echo updated " + tableDefs.getTableName();
        this.appendMakefileLine(line);
        for (i = 1; i <= tableDefs.getNumberOfColumns(); ++i) {
            if ((tableDefs.getColumnAttributes(i) & 1) != 1) continue;
            line = "    @if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) " + tableDefs.getTableName() + ".by" + tableDefs.getColumnName(i) + "; fi";
            this.appendMakefileLine(line);
        }
    }

    private void appendMakefileLine(String line) throws DirectoryTableException {
        String[] appendLine = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + echoCmd + " '" + line + "' " + " >> " + this.makeFile};
        String[] outputArr = CommonTools.CMN_exec(appendLine);
    }

    private boolean checkForMakefileTarget(String target) {
        String[] getTargetCmd = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + grepCmd + " '^" + target + ":' " + this.makeFile};
        String[] outputArr = CommonTools.CMN_exec(getTargetCmd);
        return outputArr.length >= 1;
    }

    private String convertMacrosToVariables(String unexpanded) {
        String expanded = "";
        String tok = null;
        StringTokenizer unexpandedTokens = null;
        unexpandedTokens = new StringTokenizer(unexpanded, "%");
        while (unexpandedTokens.hasMoreTokens()) {
            tok = unexpandedTokens.nextToken();
            if (tok.compareTo("DIR") == 0) {
                expanded = expanded + "$(DIR)";
                continue;
            }
            if (tok.compareTo("PWDIR") == 0) {
                expanded = expanded + "$(PWDIR)";
                continue;
            }
            if (tok.compareTo("ALIASES") == 0) {
                expanded = expanded + "$(ALIASES)";
                continue;
            }
            expanded = expanded + tok;
        }
        return expanded;
    }

    private boolean isMaster(TableDefinitions tableDefs, boolean recheck) {
        String tableMap = null;
        if (tableDefs.getTableName().equals("shadow")) {
            return this.isMaster("passwd.byname", recheck);
        }
        if (tableDefs.getTableName().equals("networks")) {
            return this.isMaster("networks.byname", recheck);
        }
        if (tableDefs.getTableName().equals("aliases")) {
            return this.isMaster("mail.aliases", recheck);
        }
        if (tableDefs.getTableName().equals("auto_home")) {
            return this.isMaster("auto.home", recheck);
        }
        if (tableDefs.getTableName().equals("auto_master")) {
            return this.isMaster("auto.master", recheck);
        }
        if (tableDefs.getTableName().equals("protocols")) {
            return this.isMaster("protocols.byname", recheck);
        }
        if (tableDefs.getTableName().equals("services")) {
            return this.isMaster("services.byname", recheck);
        }
        if (tableDefs.getTableName().equals("rpc")) {
            return this.isMaster("rpc.bynumber", recheck);
        }
        if (tableDefs.getTableName().equals("user_attr")) {
            return this.isMaster("user_attr", recheck);
        }
        if (tableDefs.getTableName().equals("auth_attr")) {
            return this.isMaster("auth_attr", recheck);
        }
        if (tableDefs.getTableName().equals("prof_attr")) {
            return this.isMaster("prof_attr", recheck);
        }
        if (tableDefs.getTableName().equals("exec_attr")) {
            return this.isMaster("exec_attr", recheck);
        }
        try {
            for (int i = 1; i <= tableDefs.getNumberOfColumns(); ++i) {
                if ((tableDefs.getColumnAttributes(i) & 1) != 1) continue;
                tableMap = tableDefs.getTableName() + ".by" + tableDefs.getColumnName(i);
                break;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (tableMap == null) {
            return false;
        }
        return this.isMaster(tableMap, recheck);
    }

    private boolean isMaster(String tableMap, boolean recheck) {
        String master;
        try {
            master = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.ismaster");
            if (master == null) {
                master = "check";
            }
        }
        catch (UException a) {
            master = "check";
        }
        if (recheck || master.equals("check")) {
            String masterServer = DirectoryTableLibrary.nisGetMaster(this.domainName, tableMap);
            return masterServer.equalsIgnoreCase(this.serverName);
        }
        return master.equals("yes");
    }

    private String getMakefileVariable(String var) {
        String[] getVarCmd = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + grepCmd + " '^" + var + "' " + this.makeFile + " | " + sedCmd + " 's/^" + var + "[ \t]*=[ \t]*//'"};
        String[] outputArr = CommonTools.CMN_exec(getVarCmd);
        if (outputArr.length < 1) {
            return null;
        }
        return outputArr[0].trim();
    }

    public Vector getScopes(int flags) {
        String localServer;
        Vector<String> scopes = null;
        try {
            localServer = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return scopes;
        }
        String domain = DirectoryTableLibrary.getDomain();
        if (domain.length() > 0 && domain.charAt(domain.length() - 1) == '.') {
            domain = domain.substring(0, domain.length() - 1);
        }
        if (domain.equals("")) {
            return scopes;
        }
        String masterServer = DirectoryTableLibrary.nisGetMaster(domain, "passwd.byname");
        if (masterServer.equalsIgnoreCase(localServer)) {
            scopes = new Vector<String>();
            scopes.addElement("nis:/" + localServer + "/" + domain);
            return scopes;
        }
        return scopes;
    }

    public void setup() {
        String localServer;
        boolean isMasterServer = false;
        try {
            localServer = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            localServer = "";
        }
        String domain = DirectoryTableLibrary.getDomain();
        if (domain.length() > 0 && domain.charAt(domain.length() - 1) == '.') {
            domain = domain.substring(0, domain.length() - 1);
        }
        if (domain.equals("")) {
            isMasterServer = false;
        } else {
            String masterServer = DirectoryTableLibrary.nisGetMaster(domain, "passwd.byname");
            if (masterServer.equalsIgnoreCase(localServer)) {
                isMasterServer = true;
            }
        }
        if (!isMasterServer) {
            try {
                DirectoryUtility.setDirectoryTableProperty("directorytable.nis.ismaster", "no");
            }
            catch (UException a) {}
        } else {
            try {
                DirectoryUtility.setDirectoryTableProperty("directorytable.nis.ismaster", "yes");
            }
            catch (UException a) {
                // empty catch block
            }
            String dirVariable = this.getMakefileVariable("DIR");
            String rbacdirVariable = this.getMakefileVariable("RBACDIR");
            String pwdirVariable = this.getMakefileVariable("PWDIR");
            String aliasesVariable = this.getMakefileVariable("ALIASES");
            if (dirVariable != null) {
                try {
                    DirectoryUtility.setDirectoryTableProperty("directorytable.nis.dir", dirVariable);
                }
                catch (UException a) {
                    // empty catch block
                }
            }
            if (rbacdirVariable != null) {
                try {
                    DirectoryUtility.setDirectoryTableProperty("directorytable.nis.rbacdir", rbacdirVariable);
                }
                catch (UException a) {
                    // empty catch block
                }
            }
            if (pwdirVariable != null) {
                try {
                    DirectoryUtility.setDirectoryTableProperty("directorytable.nis.pwdir", pwdirVariable);
                }
                catch (UException a) {
                    // empty catch block
                }
            }
            if (aliasesVariable != null) {
                try {
                    DirectoryUtility.setDirectoryTableProperty("directorytable.nis.aliases", aliasesVariable);
                }
                catch (UException a) {
                    // empty catch block
                }
            }
        }
    }

    public void refreshSetup() {
        this.setup();
    }

    private void checkRowLength(DirectoryRow row) throws DirectoryTableException {
        for (int j = 1; j <= row.getNumberOfRows(); ++j) {
            int totalLength = 0;
            int maxKey = 0;
            int lastCol = this.allowsInlineComment ? this.tableDefinitions.getNumberOfColumns() - 1 : this.tableDefinitions.getNumberOfColumns();
            for (int i = 1; i <= lastCol; ++i) {
                if (i != 1) {
                    ++totalLength;
                }
                if (row.getColumn(i, j).equals("")) continue;
                totalLength += row.getColumn(i, j).length();
                if ((this.tableDefinitions.getColumnAttributes(i) & 1) != 1 || maxKey >= row.getColumn(i, j).length()) continue;
                maxKey = row.getColumn(i, j).length();
            }
            totalLength += maxKey;
            if ((totalLength += 12) < 1024) continue;
            throw new DirectoryTableRowSizeException("EXM_ROWSIZE", "Nis", String.valueOf(1024), String.valueOf(totalLength));
        }
    }
}

