/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.audit;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.management.services.audit.ConsoleAuditException;
import com.sun.management.services.audit.ConsoleAuditSession;
import com.sun.management.services.audit.ConsoleAuditSessionListener;
import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.common.ConsoleException;
import com.sun.management.services.common.Debug;
import com.sun.management.services.logging.ConsoleLogService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleAuditService {
    private static final String AUDIT_DEFAULT_TYPE_PROP = "audit.default.type";
    private static final String AUDIT_CLASS_FAIL_PROP = "audit.class.fail";
    private static final String AUDIT_CLASS_NAME_PART1 = "audit.";
    private static final String AUDIT_CLASS_NAME_PART2 = ".class";
    private static final String AUDIT_FAIL_FAIL = "fail";
    private static final String AUDIT_TYPE_DFLT = "None";
    private static final String AUDIT_CLASS_DFLT = "com.sun.management.services.audit.LogAuditSession";
    private static final String AUDIT_FAIL_DFLT = "default";
    private static HashMap auditTable = new HashMap();
    private static String auditType = null;
    private static String auditFail = null;
    private static boolean auditDflt = false;
    private static String auditSessionClassName = null;
    private static Class auditSessionClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsoleAuditSession getAuditSession(SSOToken sSOToken) throws ConsoleAuditException {
        ConsoleAuditService.getAuditSessionType();
        ConsoleAuditService.getAuditSessionFail();
        Class clazz = ConsoleAuditService.getAuditSessionClass(auditType, auditFail);
        ConsoleAuditSession consoleAuditSession = null;
        SSOTokenID sSOTokenID = null;
        if (sSOToken != null) {
            try {
                sSOTokenID = sSOToken.getTokenID();
                if (sSOTokenID == null) {
                    throw new Exception("null token identifier");
                }
            }
            catch (Exception exception) {
                Debug.trace1("Audit: get session with bad SSO token" + exception.getMessage());
                ConsoleAuditException consoleAuditException = new ConsoleAuditException("audit_err_01");
                Logger logger = ConsoleLogService.getConsoleLogger();
                logger.log(Level.WARNING, consoleAuditException.getLocalizedMessage());
                throw consoleAuditException;
            }
        }
        HashMap hashMap = auditTable;
        synchronized (hashMap) {
            if (sSOTokenID != null && (consoleAuditSession = (ConsoleAuditSession)auditTable.get(sSOTokenID)) != null) {
                return consoleAuditSession;
            }
            consoleAuditSession = ConsoleAuditService.createAuditSession(auditType, clazz);
            if (sSOTokenID != null) {
                ConsoleAuditSessionListener consoleAuditSessionListener = new ConsoleAuditSessionListener();
                try {
                    sSOToken.addSSOTokenListener((SSOTokenListener)consoleAuditSessionListener);
                }
                catch (Exception exception) {
                    Debug.trace1("Audit: error adding listener to token: " + exception.getMessage());
                }
                auditTable.put(sSOTokenID, consoleAuditSession);
            }
        }
        return consoleAuditSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAuditSession(SSOToken sSOToken) {
        SSOTokenID sSOTokenID = null;
        if (sSOToken != null) {
            try {
                sSOTokenID = sSOToken.getTokenID();
            }
            catch (Exception exception) {
                Debug.trace1("Audit: error removing session from cache: " + exception.getMessage());
            }
        }
        HashMap hashMap = auditTable;
        synchronized (hashMap) {
            if (sSOTokenID != null) {
                auditTable.remove(sSOTokenID);
            }
        }
    }

    private static synchronized void getAuditSessionType() {
        if (auditType == null && (auditType = ConsoleConfiguration.getProperty((String)AUDIT_DEFAULT_TYPE_PROP)) == null) {
            auditType = AUDIT_TYPE_DFLT;
            auditDflt = true;
        }
    }

    private static synchronized void getAuditSessionFail() {
        if (auditFail == null && (auditFail = ConsoleConfiguration.getProperty((String)AUDIT_CLASS_FAIL_PROP)) == null) {
            auditFail = AUDIT_FAIL_DFLT;
        }
    }

    private static ConsoleAuditSession createAuditSession(String string, Class clazz) throws ConsoleAuditException {
        ConsoleAuditSession consoleAuditSession = null;
        try {
            Class[] classArray = new Class[]{String.class};
            Object[] objectArray = new Object[]{string};
            Constructor constructor = clazz.getConstructor(classArray);
            consoleAuditSession = (ConsoleAuditSession)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            Debug.trace1("Audit: session constructor error: " + throwable.getMessage());
            ConsoleAuditException consoleAuditException = new ConsoleAuditException("audit_err_02", throwable.getLocalizedMessage());
            Logger logger = ConsoleLogService.getConsoleLogger();
            logger.log(Level.WARNING, consoleAuditException.getLocalizedMessage());
            throw consoleAuditException;
        }
        catch (Exception exception) {
            Debug.trace1("Audit: error creating session: " + exception.getMessage());
            ConsoleAuditException consoleAuditException = new ConsoleAuditException("audit_err_02", exception.getLocalizedMessage());
            Logger logger = ConsoleLogService.getConsoleLogger();
            logger.log(Level.WARNING, consoleAuditException.getLocalizedMessage());
            throw consoleAuditException;
        }
        return consoleAuditSession;
    }

    private static synchronized Class getAuditSessionClass(String string, String string2) throws ConsoleAuditException {
        Object object;
        Object object2;
        if (auditSessionClass != null) {
            return auditSessionClass;
        }
        if (!auditDflt && (auditSessionClassName = ConsoleConfiguration.getProperty((String)(object2 = AUDIT_CLASS_NAME_PART1 + string + AUDIT_CLASS_NAME_PART2))) == null) {
            Debug.trace1("Audit: error reading " + string + " audit session class name");
            object = new ConsoleAuditException("audit_err_03", string);
            Logger logger = ConsoleLogService.getConsoleLogger();
            logger.log(Level.WARNING, ((ConsoleException)object).getLocalizedMessage());
            if (string2 != null && string2.equals(AUDIT_FAIL_FAIL)) {
                throw object;
            }
        }
        if (auditSessionClassName == null) {
            auditDflt = true;
            auditType = AUDIT_TYPE_DFLT;
            auditSessionClassName = AUDIT_CLASS_DFLT;
        }
        if (ConsoleAuditService.loadAuditSessionClass(auditSessionClassName, string2)) {
            return auditSessionClass;
        }
        if (!auditDflt) {
            auditDflt = true;
            auditType = AUDIT_TYPE_DFLT;
            auditSessionClassName = AUDIT_CLASS_DFLT;
            if (ConsoleAuditService.loadAuditSessionClass(auditSessionClassName, AUDIT_FAIL_FAIL)) {
                return auditSessionClass;
            }
        }
        Debug.trace1("Audit: error loading any audit session class");
        object2 = new ConsoleAuditException("audit_err_04");
        object = ConsoleLogService.getConsoleLogger();
        ((Logger)object).log(Level.WARNING, ((ConsoleException)object2).getLocalizedMessage());
        throw object2;
    }

    private static boolean loadAuditSessionClass(String string, String string2) throws ConsoleAuditException {
        boolean bl;
        block2: {
            bl = false;
            try {
                auditSessionClass = Class.forName(string);
                bl = true;
            }
            catch (Exception exception) {
                Debug.trace1("Audit: audit session class " + string + " not found");
                ConsoleAuditException consoleAuditException = new ConsoleAuditException("audit_err_05", string);
                Logger logger = ConsoleLogService.getConsoleLogger();
                logger.log(Level.WARNING, consoleAuditException.getLocalizedMessage());
                if (string2 == null || !string2.equals(AUDIT_FAIL_FAIL)) break block2;
                throw consoleAuditException;
            }
        }
        return bl;
    }
}

