/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.logging;

import com.iplanet.sso.SSOToken;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.common.Debug;
import java.security.Principal;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.security.auth.Subject;

public class ConsoleLogRecord
extends LogRecord {
    private static final String LOG_SERVICE_BUNDLE = "com.sun.management.services.logging.resources.Resource";
    private String bundle_name = null;
    private String user_name = null;

    public ConsoleLogRecord(Level level, String string) {
        super(level, string);
    }

    public ConsoleLogRecord(Level level, String string, Object[] objectArray) {
        super(level, string);
        super.setParameters(objectArray);
    }

    public ConsoleLogRecord(Level level, String string, SSOToken sSOToken) {
        super(level, string);
        this.user_name = this.getUserFromToken(sSOToken);
    }

    public ConsoleLogRecord(Level level, String string, Object[] objectArray, SSOToken sSOToken) {
        super(level, string);
        super.setParameters(objectArray);
        this.user_name = this.getUserFromToken(sSOToken);
    }

    public void setResourceBundleName(String string) {
        super.setResourceBundleName(string);
        this.bundle_name = string;
    }

    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = null;
        if (this.bundle_name != null) {
            try {
                resourceBundle = ResourceBundle.getBundle(this.bundle_name, Locale.getDefault(), this.getClass().getClassLoader());
            }
            catch (Exception exception) {
                Debug.trace1("ConLogRecd: missing resource bundle: " + this.bundle_name);
            }
        }
        return resourceBundle;
    }

    public String getUserName() {
        return this.user_name;
    }

    public void setUserName(String string) {
        this.user_name = string;
    }

    public void setUserName(SSOToken sSOToken) {
        this.user_name = this.getUserFromToken(sSOToken);
    }

    private String getUserFromToken(SSOToken sSOToken) {
        Subject subject;
        String string = null;
        String string2 = null;
        Principal principal = null;
        if (sSOToken != null) {
            try {
                subject = sSOToken.getSubject();
                principal = AuthorizationServiceFactory.getPrincipal(subject, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (principal != null) {
            string = principal.getName();
            if (principal instanceof UserRolePrincipal) {
                subject = (UserRolePrincipal)principal;
                string = subject.getUserName();
                string2 = subject.getRoleName();
            }
        }
        if (string != null && string2 != null) {
            string = string2 + "(" + string + ")";
        }
        return string;
    }
}

