/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.console.admin;

import com.sun.management.services.common.CCServiceLibrary;
import com.sun.web.console.admin.WebAdminException;
import com.sun.web.console.admin.WebAdminUtil;
import com.sun.web.console.config.ConsoleConfigFactory;
import com.sun.web.console.config.ConsoleConfigLog;
import com.sun.web.console.config.ConsoleConfigPasswordManager;
import com.sun.web.console.config.ConsoleConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class WebAdminPassword {
    public static final String ADMIN_USERNAME = "username";
    public static final String ADMIN_PASSWORD = "password";
    private static final String FS = File.separator;
    private Properties env = null;
    private WebAdminUtil util = null;
    private String path = null;

    public WebAdminPassword(Properties properties, WebAdminUtil webAdminUtil) throws WebAdminException {
        this.env = properties;
        this.util = webAdminUtil;
        this.path = this.getPasswordStorePath();
    }

    public synchronized void updateAdminPassword(String string, String string2, boolean bl) throws WebAdminException {
        String string3 = null;
        ConsoleConfigPasswordManager consoleConfigPasswordManager = new ConsoleConfigPasswordManager(this.path);
        ConsoleConfigService consoleConfigService = this.getService(bl);
        String string4 = null;
        String string5 = null;
        String string6 = new WebAdminException("pass_prompt_01").getMessage();
        try {
            string3 = "pass_err_07";
            consoleConfigPasswordManager.load();
            string3 = "pass_err_03";
            string5 = consoleConfigPasswordManager.getValue("admin_pswd");
            string4 = consoleConfigPasswordManager.getValue("admin_name");
            if (string4 == null) {
                string4 = "admin";
            }
            if (string != null) {
                consoleConfigPasswordManager.setValue("admin_name", string);
            } else {
                string = string4;
            }
            consoleConfigPasswordManager.setValue("admin_pswd", string2);
            string3 = "pass_err_13";
            consoleConfigPasswordManager.save(false);
            if (!bl && consoleConfigService != null) {
                string3 = "pass_err_08";
                consoleConfigService.resetAdminPassword(string, string5, string2);
            }
            string3 = "pass_err_14";
            consoleConfigPasswordManager.commit();
            CCServiceLibrary.makeFilePrivate((String)this.path, (String)"root", (boolean)true);
            ConsoleConfigLog.log((int)3, (String)"log_adm_14", (String)string6);
        }
        catch (Exception exception) {
            throw new WebAdminException(string3, exception.getLocalizedMessage(), string6);
        }
    }

    public synchronized void updateKeystorePassword(String string, boolean bl) throws WebAdminException {
        String string2 = null;
        ConsoleConfigPasswordManager consoleConfigPasswordManager = new ConsoleConfigPasswordManager(this.path);
        ConsoleConfigService consoleConfigService = this.getService(bl);
        String string3 = null;
        String string4 = new WebAdminException("pass_prompt_02").getMessage();
        try {
            string2 = "pass_err_07";
            consoleConfigPasswordManager.load();
            string2 = "pass_err_03";
            string3 = consoleConfigPasswordManager.getValue("keystore_pswd");
            consoleConfigPasswordManager.setValue("keystore_pswd", string);
            string2 = "pass_err_13";
            consoleConfigPasswordManager.save(false);
            if (!bl && consoleConfigService != null) {
                string2 = "pass_err_08";
                consoleConfigService.resetKeystorePassword(string3, string);
            }
            string2 = "pass_err_14";
            consoleConfigPasswordManager.commit();
            CCServiceLibrary.makeFilePrivate((String)this.path, (String)"root", (boolean)true);
            ConsoleConfigLog.log((int)3, (String)"log_adm_14", (String)string4);
        }
        catch (Exception exception) {
            throw new WebAdminException(string2, exception.getLocalizedMessage(), string4);
        }
    }

    public synchronized void updateTruststorePassword(String string, boolean bl) throws WebAdminException {
        String string2 = null;
        ConsoleConfigPasswordManager consoleConfigPasswordManager = new ConsoleConfigPasswordManager(this.path);
        ConsoleConfigService consoleConfigService = this.getService(bl);
        String string3 = null;
        String string4 = new WebAdminException("pass_prompt_03").getMessage();
        try {
            string2 = "pass_err_07";
            consoleConfigPasswordManager.load();
            string2 = "pass_err_03";
            string3 = consoleConfigPasswordManager.getValue("truststore_pswd");
            consoleConfigPasswordManager.setValue("truststore_pswd", string);
            string2 = "pass_err_13";
            consoleConfigPasswordManager.save(false);
            if (!bl && consoleConfigService != null) {
                string2 = "pass_err_08";
                consoleConfigService.resetTruststorePassword(string3, string);
            }
            string2 = "pass_err_14";
            consoleConfigPasswordManager.commit();
            CCServiceLibrary.makeFilePrivate((String)this.path, (String)"root", (boolean)true);
            ConsoleConfigLog.log((int)3, (String)"log_adm_14", (String)string4);
        }
        catch (Exception exception) {
            throw new WebAdminException(string2, exception.getLocalizedMessage(), string4);
        }
    }

    public void verifyAdminPassword(String string) throws WebAdminException {
        String string2 = new WebAdminException("pass_prompt_01").getLocalizedMessage();
        String string3 = new WebAdminException("pass_prompt_04", string2).getLocalizedMessage();
        System.out.println(string3);
        String string4 = CCServiceLibrary.getPassword();
        this.verifyNameAndPassword(string, string4);
    }

    public void verifyAdminPasswordFile(String string) throws WebAdminException {
        String string2 = null;
        String string3 = null;
        Properties properties = null;
        FileInputStream fileInputStream = null;
        WebAdminException webAdminException = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            string2 = properties.getProperty(ADMIN_USERNAME);
            string3 = properties.getProperty(ADMIN_PASSWORD);
        }
        catch (Exception exception) {
            webAdminException = new WebAdminException("pass_err_12", string, exception.getLocalizedMessage());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (webAdminException != null) {
            throw webAdminException;
        }
        this.verifyNameAndPassword(string2, string3);
    }

    private ConsoleConfigService getService(boolean bl) throws WebAdminException {
        ConsoleConfigService consoleConfigService = null;
        if (!bl && this.util.isInstanceConfigured(this.env)) {
            try {
                String string = this.env.getProperty("console_instance");
                ConsoleConfigFactory consoleConfigFactory = new ConsoleConfigFactory();
                consoleConfigService = consoleConfigFactory.createConsoleConfigService(this.env, string);
                consoleConfigService.initialize();
            }
            catch (Exception exception) {
                throw new WebAdminException("comm_err_02", exception.getLocalizedMessage());
            }
        }
        return consoleConfigService;
    }

    private void verifyNameAndPassword(String string, String string2) throws WebAdminException {
        if (string == null || string2 == null) {
            throw new WebAdminException("pass_err_11");
        }
        ConsoleConfigPasswordManager consoleConfigPasswordManager = null;
        try {
            consoleConfigPasswordManager = new ConsoleConfigPasswordManager(this.path);
            consoleConfigPasswordManager.load();
        }
        catch (Exception exception) {
            throw new WebAdminException("pass_err_07", exception.getLocalizedMessage());
        }
        String string3 = "";
        String string4 = "";
        try {
            string3 = consoleConfigPasswordManager.getValue("admin_name");
            string4 = consoleConfigPasswordManager.getValue("admin_pswd");
        }
        catch (Exception exception) {
            throw new WebAdminException("pass_err_09", exception.getLocalizedMessage());
        }
        if (string3 == null || string4 == null) {
            throw new WebAdminException("pass_err_10");
        }
        if (!string.equals(string3) || !string2.equals(string4)) {
            throw new WebAdminException("pass_err_11");
        }
    }

    private String getPassword(String string) throws WebAdminException {
        String string2 = new WebAdminException("pass_prompt_04", string).getLocalizedMessage();
        String string3 = new WebAdminException("pass_prompt_05").getLocalizedMessage();
        String string4 = new WebAdminException("pass_prompt_06").getLocalizedMessage();
        String string5 = new WebAdminException("pass_prompt_07").getLocalizedMessage();
        String string6 = null;
        for (int i = 0; i < 3; ++i) {
            System.out.println(string2);
            string6 = CCServiceLibrary.getPassword();
            if (string6 == null) {
                System.out.println(string5);
                continue;
            }
            if ((string6 = string6.trim()).length() < 6 || string6.length() > 32) {
                System.out.println(string5);
                continue;
            }
            System.out.println(string3);
            String string7 = CCServiceLibrary.getPassword();
            if (string7 == null || string7.trim().length() == 0) {
                System.out.println(string5);
                continue;
            }
            if (string6.equals(string7 = string7.trim())) break;
            System.out.println(string4);
            string6 = null;
        }
        if (string6 == null) {
            throw new WebAdminException("pass_err_04");
        }
        return string6;
    }

    private String getPasswordStorePath() {
        String string = this.env.getProperty("console_conf");
        String string2 = this.env.getProperty("console_instance");
        String string3 = string + FS + string2 + FS + ".pswd";
        return string3;
    }
}

