/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sunvts.ui;

import com.sun.sunvts.bean.LogBean;
import com.sun.sunvts.ui.SunvtsGUIApp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;

public class TestLogPanel
extends JPanel {
    private String logName = null;
    LogBean logbean = LogBean.getLogBean();
    private static Hashtable<String, TestLogPanel> logHash = new Hashtable();
    private JScrollPane LogScrollPane;
    private JButton btnDelete;
    private JButton btnView;
    private JScrollPane jScrollPane1;
    private JLabel lblLogName;
    private JLabel lblMaxLines;
    private JLabel lblShowLast;
    private JTextArea taLog;
    private JTextArea taLogView;
    private JTextField txtLogLines;

    private TestLogPanel() {
        this.initComponents();
    }

    private TestLogPanel(String name) {
        this();
        this.setLogName(name);
        this.lblLogName.setText(this.getLogName());
    }

    public static TestLogPanel getTestLogPanel(String s) {
        TestLogPanel testlogpanel = logHash.get(s);
        if (testlogpanel == null) {
            testlogpanel = new TestLogPanel(s);
            logHash.put(s, testlogpanel);
        }
        return testlogpanel;
    }

    private void initComponents() {
        this.lblLogName = new JLabel();
        this.LogScrollPane = new JScrollPane();
        this.taLog = new JTextArea();
        this.lblShowLast = new JLabel();
        this.txtLogLines = new JTextField();
        this.lblMaxLines = new JLabel();
        this.btnView = new JButton();
        this.btnDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.taLogView = new JTextArea();
        ResourceMap resourceMap = ((SunvtsGUIApp)Application.getInstance(SunvtsGUIApp.class)).getContext().getResourceMap(TestLogPanel.class);
        this.setBackground(resourceMap.getColor("Form.background"));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setAutoscrolls(true);
        this.setName("Form");
        this.lblLogName.setText(resourceMap.getString("lblLogName.text", new Object[0]));
        this.lblLogName.setName("lblLogName");
        this.LogScrollPane.setBorder(null);
        this.LogScrollPane.setName("LogScrollPane");
        this.taLog.setBackground(resourceMap.getColor("taLog.background"));
        this.taLog.setColumns(20);
        this.taLog.setEditable(false);
        this.taLog.setLineWrap(true);
        this.taLog.setRows(5);
        this.taLog.setText(resourceMap.getString("taLog.text", new Object[0]));
        this.taLog.setWrapStyleWord(true);
        this.taLog.setName("taLog");
        this.LogScrollPane.setViewportView(this.taLog);
        this.lblShowLast.setText(resourceMap.getString("lblShowLast.text", new Object[0]));
        this.lblShowLast.setName("lblShowLast");
        this.txtLogLines.setText(resourceMap.getString("txtLogLines.text", new Object[0]));
        this.txtLogLines.setName("txtLogLines");
        this.lblMaxLines.setText(resourceMap.getString("lblMaxLines.text", new Object[0]));
        this.lblMaxLines.setName("lblMaxLines");
        this.btnView.setText(resourceMap.getString("btnView.text", new Object[0]));
        this.btnView.setName("btnView");
        this.btnView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestLogPanel.this.btnViewActionPerformed(evt);
            }
        });
        this.btnDelete.setText(resourceMap.getString("btnDelete.text", new Object[0]));
        this.btnDelete.setName("btnDelete");
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestLogPanel.this.btnDeleteActionPerformed(evt);
            }
        });
        this.jScrollPane1.setName("jScrollPane1");
        this.taLogView.setBackground(resourceMap.getColor("taLogView.background"));
        this.taLogView.setColumns(20);
        this.taLogView.setEditable(false);
        this.taLogView.setLineWrap(true);
        this.taLogView.setRows(5);
        this.taLogView.setMaximumSize(new Dimension(200, 100));
        this.taLogView.setName("taLogView");
        this.jScrollPane1.setViewportView(this.taLogView);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jScrollPane1, -1, 459, Short.MAX_VALUE).add(1, this.LogScrollPane, -1, 459, Short.MAX_VALUE).add(1, this.lblLogName).add(1, layout.createSequentialGroup().add(this.lblShowLast).add(18, 18, 18).add(this.txtLogLines, -2, 94, -2).addPreferredGap(0).add(this.lblMaxLines).addPreferredGap(1).add(this.btnView).addPreferredGap(1).add(this.btnDelete))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.lblLogName).addPreferredGap(1).add(this.LogScrollPane, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.txtLogLines, -2, -1, -2).add(this.lblMaxLines).add(this.btnView, -2, 18, -2).add(this.lblShowLast).add(this.btnDelete, -2, 18, -2)).add(46, 46, 46).add(this.jScrollPane1, -2, 309, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnViewActionPerformed(ActionEvent evt) {
        this.viewLogs();
    }

    private void viewLogs() {
        int logLines = 30;
        try {
            logLines = Integer.parseInt(this.txtLogLines.getText());
            this.logbean.viewLog(this.logName, logLines);
            this.taLogView.setText(this.logbean.getLogs());
        }
        catch (NumberFormatException numex) {
            JOptionPane.showMessageDialog(this, "Please type in number of lines (1 - 1,000,000) to view the logs \n", "Viewing Logs", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Viewing Logs", 0);
        }
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        try {
            this.logbean.deleteLog(this.logName);
            JOptionPane.showMessageDialog(this, this.logName + "logs have been deleted", "Deleting Logs", 1);
        }
        catch (FileNotFoundException file_ex) {
            JOptionPane.showMessageDialog(this, file_ex.getMessage(), "Delete Logs-File Not Found ", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Deleting Logs", 0);
        }
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }
}

