/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.upgrade;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cimom.ReadersWriter;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.PSRlogImpl;
import com.sun.wbem.upgrade.DagTraversor;
import com.sun.wbem.util.I18N;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ComSunUpgrader {
    private CIMOMHandle cimClient;
    private String repositoryDir;
    private DataOutputStream succStream;
    private DataOutputStream dupStream;
    private DataOutputStream errorStream;
    private DataOutputStream cycleStream;

    private void processClasses(Enumeration e, PSRlogImpl ps, CIMOMHandle cimClient, CIMObjectPath op, ReadersWriter rw) throws Exception {
        String ns = op.getNameSpace();
        HashMap<String, CIMClass> cMap = new HashMap<String, CIMClass>();
        ArrayList<String> list = new ArrayList<String>();
        String[] listArray = null;
        while (e.hasMoreElements()) {
            CIMClass cc = (CIMClass)e.nextElement();
            String name = cc.getName().toLowerCase();
            cMap.put(name, cc);
            list.add(0, name);
            listArray = new String[list.size()];
            list.toArray(listArray);
        }
        DagCB dcb = new DagCB(cMap, cimClient, op, rw);
        DagTraversor dag = new DagTraversor(listArray, new String[]{"s", "a"}, dcb);
        dag.start();
        for (String className : dcb.addedClassList) {
            System.out.println(I18N.loadStringFormat("ADDING_INSTANCE", className));
            Enumeration ei = ps.enumerateInstances(ns, className, false, false).elements();
            while (ei.hasMoreElements()) {
                boolean success = true;
                CIMInstance ci = (CIMInstance)ei.nextElement();
                try {
                    cimClient.createInstance(op, ci);
                }
                catch (CIMException ex) {
                    success = false;
                    System.out.println((Object)ex);
                    if (ex.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                        this.dupStream.writeBytes(ns + "\n");
                        this.dupStream.writeBytes(ci + "\n");
                    } else {
                        this.errorStream.writeBytes(ns + "\n");
                        this.errorStream.writeBytes(ci + "\n");
                        this.errorStream.writeBytes((Object)((Object)ex) + "\n");
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex);
                    success = false;
                    this.errorStream.writeBytes(ns + "\n");
                    this.errorStream.writeBytes(ci + "\n");
                    this.errorStream.writeBytes(ex + "\n");
                }
                if (!success) continue;
                this.succStream.writeBytes(ns + "\n");
                this.succStream.writeBytes(ci + "\n");
            }
        }
    }

    private DataOutputStream getStream(String filepath) throws Exception {
        File f = new File(filepath);
        f.createNewFile();
        DataOutputStream fStream = new DataOutputStream(new FileOutputStream(filepath));
        return fStream;
    }

    public ComSunUpgrader(CIMOMHandle cimClient, String repositoryDir) throws Exception {
        this.cimClient = cimClient;
        this.repositoryDir = repositoryDir;
        this.succStream = this.getStream(repositoryDir + File.separator + "succ");
        this.dupStream = this.getStream(repositoryDir + File.separator + "dup");
        this.errorStream = this.getStream(repositoryDir + File.separator + "err");
        this.cycleStream = this.getStream(repositoryDir + File.separator + "cycle");
    }

    public void run() throws Exception {
        ReadersWriter rw = new ReadersWriter();
        PSRlogImpl ps = new PSRlogImpl("localhost", rw, this.repositoryDir);
        Vector v = ps.enumerateNameSpace("", true);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String ns = (String)e.nextElement();
            System.out.println(I18N.loadStringFormat("ADDING_NS", ns));
            CIMObjectPath nsop = new CIMObjectPath();
            nsop.setNameSpace(ns);
            ns = nsop.getNameSpace();
            boolean success = true;
            try {
                this.cimClient.createNameSpace(new CIMNameSpace("", ns));
            }
            catch (CIMException ex) {
                success = false;
                if (ex.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                    this.dupStream.writeBytes(ns + "\n");
                } else {
                    this.errorStream.writeBytes(ns + "\n");
                    this.errorStream.writeBytes((Object)((Object)ex) + "\n");
                }
            }
            catch (Exception ex) {
                success = false;
                this.errorStream.writeBytes(ns + "\n");
                this.errorStream.writeBytes(ex + "\n");
            }
            if (success) {
                this.succStream.writeBytes(ns + "\n");
            }
            Enumeration eq = ps.enumerateQualifierTypes(nsop).elements();
            while (eq.hasMoreElements()) {
                CIMObjectPath qop = (CIMObjectPath)eq.nextElement();
                CIMQualifierType cqt = ps.getQualifierType(qop);
                success = true;
                try {
                    this.cimClient.createQualifierType(nsop, cqt);
                }
                catch (CIMException ex) {
                    success = false;
                    if (ex.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                        this.dupStream.writeBytes(qop + "\n");
                    } else {
                        this.errorStream.writeBytes(qop + "\n");
                        this.errorStream.writeBytes((Object)((Object)ex) + "\n");
                    }
                }
                catch (Exception ex) {
                    success = false;
                    this.errorStream.writeBytes(qop + "\n");
                    this.errorStream.writeBytes(ex + "\n");
                }
                if (!success) continue;
                this.succStream.writeBytes(qop + "\n");
            }
            eq = ps.enumerateClasses(nsop, true, true).elements();
            this.processClasses(eq, ps, this.cimClient, nsop, rw);
        }
    }

    private static String getInput(String prompt) throws IOException {
        System.out.print(prompt);
        byte[] a = new byte[20];
        System.in.read(a, 0, 20);
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != 10) continue;
            a[i] = 0;
            break;
        }
        return new String(a);
    }

    public static void main(String[] args) throws Exception {
        I18N.setResourceName("com.sun.wbem.cimom.CIMOM");
        String password = ComSunUpgrader.getInput(I18N.loadString("PASSWORD"));
        CIMClient cimClient = null;
        Exception e1 = null;
        int i = 0;
        while (i < 10) {
            try {
                cimClient = new CIMClient(new CIMNameSpace("", ""), args[0], password);
                break;
            }
            catch (Exception e) {
                e1 = e;
            }
        }
        if (i == 10) {
            throw e1;
        }
        ComSunUpgrader ru = new ComSunUpgrader((CIMOMHandle)cimClient, args[1]);
        ru.run();
    }

    private class DagCB
    implements DagTraversor.Callback {
        HashMap cMap = null;
        CIMObjectPath op;
        String ns;
        CIMOMHandle cimClient;
        List addedClassList;
        ReadersWriter rw;

        public void noCycles(String nodeName) {
            System.out.println(I18N.loadStringFormat("ADDING_CLASS", nodeName));
            CIMClass cc = (CIMClass)this.cMap.get(nodeName);
            boolean success = true;
            try {
                this.cimClient.createClass(this.op, cc);
                this.addedClassList.add(0, nodeName);
            }
            catch (CIMException ex) {
                System.out.println((Object)ex);
                success = false;
                if (ex.getID().equals("CIM_ERR_ALREADY_EXISTS")) {
                    this.addedClassList.add(0, nodeName);
                    try {
                        ComSunUpgrader.this.dupStream.writeBytes(this.ns + "\n");
                        ComSunUpgrader.this.dupStream.writeBytes(cc + "\n");
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                    }
                } else {
                    try {
                        ComSunUpgrader.this.errorStream.writeBytes(this.ns + "\n");
                        ComSunUpgrader.this.errorStream.writeBytes(cc + "\n");
                        ComSunUpgrader.this.errorStream.writeBytes((Object)((Object)ex) + "\n");
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                success = false;
                try {
                    ComSunUpgrader.this.errorStream.writeBytes(this.ns + "\n");
                    ComSunUpgrader.this.errorStream.writeBytes(cc + "\n");
                    ComSunUpgrader.this.errorStream.writeBytes(ex + "\n");
                }
                catch (Exception e1) {
                    System.out.println(e1);
                }
            }
            if (success) {
                try {
                    ComSunUpgrader.this.succStream.writeBytes(this.ns + "\n");
                    ComSunUpgrader.this.succStream.writeBytes(cc + "\n");
                }
                catch (Exception e1) {
                    System.out.println(e1);
                }
            }
        }

        public String[] dependNodes(String nodeName, String dependency) {
            CIMClass cc = (CIMClass)this.cMap.get(nodeName);
            if (dependency.equals("s")) {
                String sc = cc.getSuperClass();
                if (sc == null || sc.length() == 0) {
                    return null;
                }
                String[] sArray = new String[]{sc.toLowerCase()};
                return sArray;
            }
            if (!cc.isAssociation()) {
                return null;
            }
            ArrayList<String> assocList = new ArrayList<String>();
            Enumeration ep = cc.getProperties().elements();
            while (ep.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)ep.nextElement();
                if (!cp.isReference()) continue;
                String refClassName = cp.getType().getRefClassName().toLowerCase();
                assocList.add(refClassName);
            }
            int size = assocList.size();
            if (size == 0) {
                return null;
            }
            String[] assocArray = new String[size];
            assocList.toArray(assocArray);
            return assocArray;
        }

        public void cycleDetected(String[] cycleInfo) {
            try {
                ComSunUpgrader.this.cycleStream.writeBytes(this.ns + "\n");
                for (int i = 0; i < cycleInfo.length; ++i) {
                    ComSunUpgrader.this.cycleStream.writeBytes(cycleInfo[i] + " ");
                }
                ComSunUpgrader.this.cycleStream.writeBytes("\n");
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }

        DagCB(HashMap cMap, CIMOMHandle cimClient, CIMObjectPath op, ReadersWriter rw) {
            this.cMap = cMap;
            this.cimClient = cimClient;
            this.op = op;
            this.ns = op.getNameSpace();
            this.addedClassList = new ArrayList();
            this.rw = rw;
        }
    }
}

