/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.security.CertificateStore;
import com.sun.management.viperimpl.util.security.SMCSSLConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public final class RootCACertificateStore
implements CertificateStore {
    private static String _filename = null;
    private static char[] _storepass = null;
    private KeyStore _cacerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            if (this._cacerts == null) {
                this._cacerts = KeyStore.getInstance("JKS");
                this._cacerts.load(null, null);
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File rootCAFile = new File(_filename);
                    if (!rootCAFile.exists()) {
                        throw new KeyStoreException("Root Certificates not loaded!");
                    }
                    FileInputStream fis = new FileInputStream(rootCAFile);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    RootCACertificateStore.this._cacerts.load(bis, _storepass);
                    bis.close();
                    fis.close();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            ex.printStackTrace();
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    FileOutputStream fos = new FileOutputStream(new File(_filename));
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    RootCACertificateStore.this._cacerts.store(bos, _storepass);
                    bos.close();
                    fos.close();
                    return null;
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            ex.printStackTrace();
        }
    }

    public void replaceSMC(String alias, Certificate cert) throws KeyStoreException {
        this._cacerts.setCertificateEntry(alias, cert);
    }

    public void add(Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Cannot add root CA certificate");
    }

    public void remove(Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Cannot remove root CA certificate");
    }

    public boolean contains(Certificate cert) throws KeyStoreException {
        return this._cacerts.getCertificateAlias(cert) != null;
    }

    public boolean verify(Certificate cert) throws KeyStoreException {
        StringBuffer sb = new StringBuffer();
        Enumeration<String> enumr = this._cacerts.aliases();
        while (enumr.hasMoreElements()) {
            String alias = enumr.nextElement();
            Certificate rootCert = this._cacerts.getCertificate(alias);
            try {
                cert.verify(rootCert.getPublicKey());
                return true;
            }
            catch (GeneralSecurityException e) {
            }
        }
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        HashSet<Certificate> certCollection = new HashSet<Certificate>();
        Enumeration<String> enumr = this._cacerts.aliases();
        while (enumr.hasMoreElements()) {
            String alias = enumr.nextElement();
            Certificate cert = this._cacerts.getCertificate(alias);
            certCollection.add(cert);
        }
        return certCollection.iterator();
    }

    public KeyStore getKeyStore() {
        return this._cacerts;
    }

    static {
        _filename = SMCSSLConfig.getRootCertificateFile();
        _storepass = SMCSSLConfig.getKeyStorePasswd();
    }
}

