/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.adapter.rmi;

import com.sun.wbem.client.adapter.rmi.CIMOM_1;
import com.sun.wbem.client.adapter.rmi.CheckSumGen;
import com.sun.wbem.client.adapter.rmi.RemoteCIMListener;
import com.sun.wbem.client.adapter.rmi.RemoteListenerImpl;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOperation;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SunDigestClientSecurity;

public class RMIJavaxClient
implements CIMClientAPI {
    private static final String protocol_name = "cim-rmi";
    private static final String HANDLERCLASS = "solaris_javaxrmidelivery";
    private CIMOM_1 comp;
    private CIMNameSpace nameSpace;
    private SunDigestClientSecurity cs;
    private CIMListener clientListener;
    private RemoteCIMListener remoteListener;
    private int debug;
    public static final String RMIPORT = "5987";
    private final String RMIPORTPROP = "javax.wbem.rmiport";
    private final String RMIPROTVERSION = "1";
    private CheckSumGen csg = new CheckSumGen();
    private boolean latestVersion = false;
    private Object heartBeatObj = null;

    public RMIJavaxClient(String version, CIMNameSpace name, CIMListener clientListener, Integer dbg, CIMOM_1 comp) throws CIMException {
        this.clientListener = clientListener;
        this.nameSpace = name;
        this.debug = dbg;
        this.cs = null;
        this.comp = comp;
    }

    public String getProtocol() {
        return protocol_name;
    }

    public synchronized void initSecurityContext(String version, ClientSecurityContext csc) throws CIMException {
        try {
            this.cs = (SunDigestClientSecurity)csc;
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_FAILED", "Invalid security context");
        }
        SecurityMessage cm = this.cs.generateHello();
        Locale l = Locale.getDefault();
        SecurityMessage sm = this.hello(version, cm, l.getCountry(), l.getLanguage(), l.getVariant(), null);
        cm = this.cs.generateResponse(sm);
        sm = this.credentials(version, cm);
        this.cs.checkResult(sm);
        String roleName = this.cs.getRoleName();
        if (roleName != null && roleName.trim().length() > 0) {
            String rolePswd = this.cs.getRolePassword();
            String encrPswd = this.cs.trans51Format(rolePswd);
            this.assumeRole(version, roleName, encrPswd);
        }
        this.latestVersion = this.checkVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkVersion(String version) throws CIMException {
        String[] oarray = new String[]{version, "getVersion"};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            try {
                Vector outp = this.comp.getVersion(version, st);
            }
            catch (CIMException e) {
                return false;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "getVersion", e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createNameSpace(String version, CIMNameSpace currNs, CIMNameSpace newNs) throws CIMException {
        String[] oarray = new String[]{version, "createNameSpace", this.csg.toString(currNs), this.csg.toString(newNs)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.createNameSpace(version, currNs, newNs, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "createNameSpace", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(String version) throws CIMException {
        String[] oarray = new String[]{version, "close"};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                try {
                    UnicastRemoteObject.unexportObject(this.remoteListener, false);
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
                this.comp.close(version, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "close", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteNameSpace(String version, CIMNameSpace currNs, CIMNameSpace delNs) throws CIMException {
        String[] oarray = new String[]{version, "deleteNameSpace", this.csg.toString(currNs), this.csg.toString(delNs)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.deleteNameSpace(version, currNs, delNs, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "deleteNameSpace", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteClass(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        String[] oarray = new String[]{version, "deleteClass", this.csg.toString(currNs), this.csg.toString(path)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.deleteClass(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "deleteClass", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteInstance(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        String[] oarray = new String[]{version, "deleteInstance", this.csg.toString(currNs), this.csg.toString(path)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.deleteInstance(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "deleteInstance", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteQualifierType(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        String[] oarray = new String[]{version, "deleteQualifierType", this.csg.toString(currNs), this.csg.toString(path)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.deleteQualifierType(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "deleteQualifierType", e);
            }
        }
    }

    public synchronized Vector enumerateClasses(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        Boolean bln = deep ? Boolean.TRUE : Boolean.FALSE;
        String[] oarray = new String[]{version, "enumerateClasses", this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumerateClasses(version, currNs, path, deep, localOnly, includeQualifiers, includeClassOrigin, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumerateClasses", e);
            }
        }
    }

    public synchronized Vector enumerateClassNames(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        Boolean bln = deep ? Boolean.TRUE : Boolean.FALSE;
        String[] oarray = new String[]{version, "enumerateClassNames", this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumerateClassNames(version, currNs, path, deep, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumClass", e);
            }
        }
    }

    public synchronized Vector enumNameSpace(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        Boolean bln = deep ? Boolean.TRUE : Boolean.FALSE;
        String[] oarray = new String[]{version, "enumNameSpace", this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumNameSpace(version, currNs, path, deep, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumNameSpace", e);
            }
        }
    }

    public Vector enumerateInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String fName = "enumerateInstances";
        Boolean bln = deep ? Boolean.TRUE : Boolean.FALSE;
        String[] oarray = new String[]{version, fName, this.csg.toString(currNs), this.csg.toString(path), bln.toString()};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumerateInstances(version, currNs, path, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", fName, e);
            }
        }
    }

    public Vector enumerateInstanceNames(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        if (!this.latestVersion) {
            throw new CIMException("VER_ERROR", version);
        }
        String[] oarray = new String[]{version, "enumerateInstanceNames", this.csg.toString(currNs), this.csg.toString(path)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumerateInstanceNames(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumerateInstanceNames", e);
            }
        }
    }

    public synchronized Vector enumQualifierTypes(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        String[] oarray = new String[]{version, "enumQualifierTypes", this.csg.toString(currNs), this.csg.toString(path)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.enumQualifierTypes(version, currNs, path, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "enumQualifierTypes", e);
            }
        }
    }

    public CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath path, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String fName = "getClass";
        Boolean blo = localOnly ? Boolean.TRUE : Boolean.FALSE;
        String[] oarray = new String[]{version, fName, this.csg.toString(currNs), this.csg.toString(path), blo.toString()};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.getClass(version, currNs, path, localOnly, includeQualifiers, includeClassOrigin, propertyList, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", fName, e);
            }
        }
    }

    public CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath path, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String fName = "getInstance";
        Boolean blo = localOnly ? Boolean.TRUE : Boolean.FALSE;
        String[] oarray = new String[]{version, fName, this.csg.toString(currNs), this.csg.toString(path), blo.toString()};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.getInstance(version, currNs, path, localOnly, includeQualifiers, includeClassOrigin, propertyList, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", fName, e);
            }
        }
    }

    public synchronized CIMValue invokeMethod(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, Vector inParams, Vector outParams) throws CIMException {
        String[] oarray = new String[]{version, "invokeMethod", this.csg.toString(currNs), this.csg.toString(name), methodName, this.csg.toString(inParams)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                Vector v = this.comp.invokeMethod(version, currNs, name, methodName, inParams, st);
                for (int i = 1; i < v.size(); ++i) {
                    outParams.addElement(v.elementAt(i));
                }
                return (CIMValue)v.elementAt(0);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "invokeMethod", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CIMValue invokeMethod(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        String[] oarray = new String[]{version, "invokeMethod", this.csg.toString(currNs), this.csg.toString(name), methodName};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            Vector v;
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                v = this.comp.invokeMethod(version, currNs, name, methodName, inArgs, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "invokeMethod", e);
            }
            for (int i = 1; i < v.size(); ++i) {
                outArgs[i - 1] = (CIMArgument)v.elementAt(i);
            }
            return (CIMValue)v.elementAt(0);
        }
    }

    public synchronized CIMQualifierType getQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        String[] oarray = new String[]{version, "getQualifierType", this.csg.toString(currNs), this.csg.toString(name)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.getQualifierType(version, currNs, name, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "getQualifierType", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        String[] oarray = new String[]{version, "createQualifierType", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(qt)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.createQualifierType(version, currNs, name, qt, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "createQualifierType", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        String[] oarray = new String[]{version, "createClass", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(cc)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.createClass(version, currNs, name, cc, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "createClass", e);
            }
        }
    }

    public synchronized CIMObjectPath createInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        String[] oarray = new String[]{version, "createInstance", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(ci)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.createInstance(version, currNs, name, ci, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "createInstance", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        String[] oarray = new String[]{version, "setQualifierType", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(qt)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.setQualifierType(version, currNs, name, qt, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "setQualifierType", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        String[] oarray = new String[]{version, "setClass", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(cc)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.setClass(version, currNs, name, cc, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "setClass", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
        String[] oarray = new String[]{version, "setInstance", this.csg.toString(currNs), this.csg.toString(name), this.csg.toString(ci)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.setInstance(version, currNs, name, ci, includeQualifier, propertyList, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "setInstance", e);
            }
        }
    }

    public synchronized CIMValue getProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName) throws CIMException {
        String[] oarray = new String[]{version, "getProperty", this.csg.toString(currNs), this.csg.toString(name), propertyName};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.getProperty(version, currNs, name, propertyName, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "getProperty", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName, CIMValue cv) throws CIMException {
        String[] oarray = new String[]{version, "setProperty", this.csg.toString(currNs), this.csg.toString(name), propertyName, this.csg.toString(cv)};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.setProperty(version, currNs, name, propertyName, cv, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "setProperty", e);
            }
        }
    }

    public synchronized Vector execQuery(String version, CIMNameSpace currNs, CIMObjectPath relNS, String query, String ql) throws CIMException {
        String[] oarray = new String[]{version, "execQuery", this.csg.toString(currNs), this.csg.toString(relNS), query, ql + ""};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.execQuery(version, currNs, relNS, query, ql, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "execQuery", e);
            }
        }
    }

    public Vector associators(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String fName = "associators";
        String[] oarray = new String[]{version, fName, this.csg.toString(currNs), this.csg.toString(objectName), assocClass, resultClass, role, resultRole};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.associators(version, currNs, objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", fName, e);
            }
        }
    }

    public Vector associatorNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        String[] oarray = new String[]{version, "associatorNames", this.csg.toString(currNs), this.csg.toString(objectName), assocClass, resultClass, role, resultRole};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.associatorNames(version, currNs, objectName, assocClass, resultClass, role, resultRole, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "associatorNames", e);
            }
        }
    }

    public Vector references(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        String[] oarray = new String[]{version, "references", this.csg.toString(currNs), this.csg.toString(objectName), resultClass, role};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.references(version, currNs, objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "references", e);
            }
        }
    }

    public Vector referenceNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        String[] oarray = new String[]{version, "referenceNames", this.csg.toString(currNs), this.csg.toString(objectName), resultClass, role};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.referenceNames(version, currNs, objectName, resultClass, role, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "referenceNames", e);
            }
        }
    }

    public Vector performOperations(String version, CIMOperation[] batchedOperations) throws CIMException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < batchedOperations.length; ++i) {
            buff.append(batchedOperations[i].getClass().getName());
        }
        String[] oarray = new String[]{version, buff.toString()};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                return this.comp.performOperations(version, batchedOperations, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "performOperations", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assumeRole(String version, String roleName, String encrPswd) throws CIMException {
        String[] oarray = new String[]{version, "assumeRole", roleName, encrPswd};
        SunDigestClientSecurity sunDigestClientSecurity = this.cs;
        synchronized (sunDigestClientSecurity) {
            SecurityToken st = this.cs.getSecurityToken(oarray);
            this.cs.incSessionKey();
            try {
                this.comp.assumeRole(version, roleName, encrPswd, st);
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("RMIERROR", "assumeRole", e);
            }
        }
    }

    private SecurityMessage hello(String version, SecurityMessage cm, String country, String language, String variant, String[] otherInfo) throws CIMException {
        try {
            return this.comp.hello(version, cm, country, language, variant, otherInfo);
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("RMIERROR", "hello", e);
        }
    }

    private SecurityMessage credentials(String version, SecurityMessage cm) throws CIMException {
        try {
            Object[] returnVals = this.comp.credentials(version, cm);
            this.heartBeatObj = returnVals[1];
            return (SecurityMessage)returnVals[0];
        }
        catch (CIMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CIMException("RMIERROR", "credentials", e);
        }
    }

    public void setListener(String version) throws CIMException {
        String[] oarray = new String[]{version, "setListener"};
        SecurityToken st = this.cs.getSecurityToken(oarray);
        try {
            this.remoteListener = new RemoteListenerImpl(this.clientListener);
            this.comp.setListener(version, this.remoteListener, st);
        }
        catch (CIMException e) {
            try {
                UnicastRemoteObject.unexportObject(this.remoteListener, false);
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (!e.getID().equals("CIM_ERR_NOT_SUPPORTED")) {
                throw e;
            }
        }
        catch (Exception e) {
            try {
                UnicastRemoteObject.unexportObject(this.remoteListener, false);
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (e instanceof ServerException) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            throw new CIMException("RMIERROR", "setListener", e);
        }
    }

    public CIMInstance getIndicationHandler(CIMListener cl) throws CIMException {
        if (cl != null) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        CIMInstance ci = new CIMInstance();
        ci.setClassName(HANDLERCLASS);
        return ci;
    }
}

