/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.MOFFormatter;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;

public class CIMDataType
implements Serializable {
    static final long serialVersionUID = 200L;
    private int type;
    private String refClassName;
    private int size;
    public static final int SIZE_SINGLE = -1;
    public static final int SIZE_UNLIMITED = -2;
    public static final int INVALID = -1;
    public static final int UINT8 = 0;
    public static final int SINT8 = 1;
    public static final int UINT16 = 2;
    public static final int SINT16 = 3;
    public static final int UINT32 = 4;
    public static final int SINT32 = 5;
    public static final int UINT64 = 6;
    public static final int SINT64 = 7;
    public static final int STRING = 8;
    public static final int BOOLEAN = 9;
    public static final int REAL32 = 10;
    public static final int REAL64 = 11;
    public static final int DATETIME = 12;
    public static final int CHAR16 = 13;
    public static final int UINT8_ARRAY = 14;
    public static final int SINT8_ARRAY = 15;
    public static final int UINT16_ARRAY = 16;
    public static final int SINT16_ARRAY = 17;
    public static final int UINT32_ARRAY = 18;
    public static final int SINT32_ARRAY = 19;
    public static final int UINT64_ARRAY = 20;
    public static final int SINT64_ARRAY = 21;
    public static final int STRING_ARRAY = 22;
    public static final int BOOLEAN_ARRAY = 23;
    public static final int REAL32_ARRAY = 24;
    public static final int REAL64_ARRAY = 25;
    public static final int DATETIME_ARRAY = 26;
    public static final int CHAR16_ARRAY = 27;
    public static final int REFERENCE = 28;
    public static final int OBJECT = 29;
    public static final int NULL = 30;
    public static final int CLASS = 31;
    protected static CIMDataType[] predefined = new CIMDataType[30];

    public static final int findType(Object o) {
        if (o == null) {
            return 30;
        }
        if (o instanceof Vector) {
            return CIMDataType.findType((Vector)o);
        }
        if (o instanceof UnsignedInt8) {
            return 0;
        }
        if (o instanceof Byte) {
            return 1;
        }
        if (o instanceof UnsignedInt16) {
            return 2;
        }
        if (o instanceof Short) {
            return 3;
        }
        if (o instanceof UnsignedInt32) {
            return 4;
        }
        if (o instanceof Integer) {
            return 5;
        }
        if (o instanceof UnsignedInt64) {
            return 6;
        }
        if (o instanceof Long) {
            return 7;
        }
        if (o instanceof String) {
            return 8;
        }
        if (o instanceof Boolean) {
            return 9;
        }
        if (o instanceof Float) {
            return 10;
        }
        if (o instanceof Double) {
            return 11;
        }
        if (o instanceof Character) {
            return 13;
        }
        if (o instanceof CIMDateTime) {
            return 12;
        }
        if (o instanceof CIMObjectPath) {
            return 28;
        }
        if (o instanceof CIMInstance) {
            return 29;
        }
        if (o instanceof CIMClass) {
            return 31;
        }
        return -1;
    }

    public static CIMDataType getDataType(String type) throws CIMException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.equals("boolean")) {
            return new CIMDataType(9);
        }
        if (type.equals("char16")) {
            return new CIMDataType(13);
        }
        if (type.equals("datetime")) {
            return new CIMDataType(12);
        }
        if (type.equals("real32")) {
            return new CIMDataType(10);
        }
        if (type.equals("real64")) {
            return new CIMDataType(11);
        }
        if (type.equals("sint16")) {
            return new CIMDataType(3);
        }
        if (type.equals("sint32")) {
            return new CIMDataType(5);
        }
        if (type.equals("sint64")) {
            return new CIMDataType(7);
        }
        if (type.equals("sint8")) {
            return new CIMDataType(1);
        }
        if (type.equals("string")) {
            return new CIMDataType(8);
        }
        if (type.equals("uint16")) {
            return new CIMDataType(2);
        }
        if (type.equals("uint32")) {
            return new CIMDataType(4);
        }
        if (type.equals("uint64")) {
            return new CIMDataType(6);
        }
        if (type.equals("uint8")) {
            return new CIMDataType(0);
        }
        return new CIMDataType(8);
    }

    public static CIMDataType getDataType(String type, boolean isArray) throws CIMException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (isArray) {
            if (type.equals("boolean")) {
                return new CIMDataType(23);
            }
            if (type.equals("char16")) {
                return new CIMDataType(27);
            }
            if (type.equals("datetime")) {
                return new CIMDataType(26);
            }
            if (type.equals("real32")) {
                return new CIMDataType(24);
            }
            if (type.equals("real64")) {
                return new CIMDataType(25);
            }
            if (type.equals("sint16")) {
                return new CIMDataType(17);
            }
            if (type.equals("sint32")) {
                return new CIMDataType(19);
            }
            if (type.equals("sint64")) {
                return new CIMDataType(21);
            }
            if (type.equals("sint8")) {
                return new CIMDataType(15);
            }
            if (type.equals("string")) {
                return new CIMDataType(22);
            }
            if (type.equals("uint16")) {
                return new CIMDataType(16);
            }
            if (type.equals("uint32")) {
                return new CIMDataType(18);
            }
            if (type.equals("uint64")) {
                return new CIMDataType(20);
            }
            if (type.equals("uint8")) {
                return new CIMDataType(14);
            }
            return new CIMDataType(22);
        }
        return CIMDataType.getDataType(type);
    }

    public static final int findType(Vector v) {
        if (v == null) {
            return 30;
        }
        Object o = null;
        int k = v.size();
        for (int i = 0; i < k && (o = v.elementAt(i)) == null; ++i) {
        }
        if (o == null) {
            return 30;
        }
        int type = CIMDataType.findType(o);
        return CIMDataType.findArrayType(type);
    }

    public static final int findArrayType(int simpleType) {
        if (simpleType < 0 || simpleType > 13) {
            return -1;
        }
        return simpleType + 14;
    }

    public static final int findSimpleType(int arrayType) {
        if (arrayType < 14 || arrayType > 27) {
            return -1;
        }
        return arrayType - 14;
    }

    public CIMDataType(int type) {
        if ((type < 0 || type > 27) && type != 29 && type != 31) {
            throw new IllegalArgumentException();
        }
        this.size = type > 13 && type < 28 ? -2 : -1;
        this.type = type;
        this.refClassName = null;
    }

    public CIMDataType(int type, int size) {
        if (type < 14 || type > 27) {
            throw new IllegalArgumentException(type + "");
        }
        if (size != -2 && size <= 0) {
            throw new IllegalArgumentException(size + "");
        }
        this.type = type;
        this.size = size;
        this.refClassName = null;
    }

    public static CIMDataType getPredefinedType(int type) {
        if ((type < 0 || type > 27) && type != 29 && type != 31) {
            throw new IllegalArgumentException();
        }
        if (predefined[type] == null) {
            CIMDataType.predefined[type] = new CIMDataType(type);
        }
        return predefined[type];
    }

    public CIMDataType(String refClassName) {
        if (refClassName == null) {
            throw new NullPointerException();
        }
        this.type = 28;
        this.refClassName = refClassName;
        this.size = -1;
    }

    public boolean isArrayType() {
        return this.type >= 14 && this.type <= 27;
    }

    public boolean isReferenceType() {
        return this.type == 28;
    }

    public int getType() {
        return this.type;
    }

    int getType(String cimtype) {
        Field[] fields = this.getClass().getFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                if (!cimtype.equalsIgnoreCase(fields[i].getName())) continue;
                return fields[i].getInt(fields[i]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public int getSize() {
        return this.size;
    }

    public String getRefClassName() {
        return this.refClassName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CIMDataType)) {
            return false;
        }
        CIMDataType ct = (CIMDataType)obj;
        if (this.refClassName == null && ct.refClassName != null) {
            return false;
        }
        if (this.refClassName != null && !this.refClassName.equals(ct.refClassName)) {
            return false;
        }
        return this.type == ct.type && this.size == ct.size;
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }
}

