/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.MOFFormatter;

public class CIMParameter
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private CIMDataType type;
    private int size = 0;
    private Vector qualifiers = new Vector();

    public void setQualifiers(Vector qTable) {
        this.qualifiers = qTable;
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public void setType(CIMDataType type) {
        this.type = type;
    }

    public CIMDataType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int aSize) {
        this.size = aSize;
    }

    public CIMParameter() {
        this("");
    }

    public CIMParameter(String name) {
        super(name);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public synchronized Object clone() {
        return this.clone(true);
    }

    synchronized Object clone(boolean includeQualifier) {
        CIMParameter pe = new CIMParameter();
        pe.name = this.name;
        pe.identifier = this.identifier;
        pe.type = this.type;
        pe.size = this.size;
        if (this.qualifiers == null || !includeQualifier) {
            pe.qualifiers = new Vector();
        } else {
            Vector<Object> ov = new Vector<Object>();
            Enumeration e = this.qualifiers.elements();
            while (e.hasMoreElements()) {
                CIMQualifier qe = (CIMQualifier)e.nextElement();
                ov.addElement(qe.clone());
            }
            pe.qualifiers = ov;
        }
        return pe;
    }

    public CIMQualifier getQualifier(String name) {
        if (name == null) {
            return null;
        }
        int tempIndex = this.qualifiers.indexOf(new CIMQualifier(name));
        CIMQualifier qe = tempIndex >= 0 ? (CIMQualifier)this.qualifiers.elementAt(tempIndex) : null;
        return qe;
    }
}

