/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.CIMVersion;
import javax.wbem.client.BatchCIMClient;
import javax.wbem.client.BatchHandle;
import javax.wbem.client.BatchResult;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMClientFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.ClientSecurityFactory;
import javax.wbem.security.SunDigestClientSecurity;

public class CIMClient
implements CIMOMHandle {
    private String noAbsNameSpace = null;
    private String version;
    private CIMClientAPI api;
    private CIMNameSpace nameSpace;
    private CIMNameSpace rootNameSpace;
    private CIMNameSpace hostNameSpace;
    protected Hashtable subIdListenerMap;
    private InetAddress host;
    private ClientSecurityContext csc = null;
    private static String protocol;
    private ThreadLocal tl = new ThreadLocal();
    private static final int DEBUG_OFF = 0;
    private boolean listenerset = false;
    public static final String WQL = "WQL";
    public static final String CIM_XML = "cim-xml";
    public static final String CIM_RMI = "cim-rmi";
    private boolean AUTHENTICATE = true;
    private ClientListener clientListener = new ClientListener();

    private CIMObjectPath combineObjectPath(CIMNameSpace ns, CIMObjectPath op) {
        String nsNs;
        if (op == null) {
            op = new CIMObjectPath();
        }
        if ((nsNs = ns.getNameSpace()) == null || nsNs.length() == 0) {
            return op;
        }
        String opNs = op.getNameSpace();
        if (opNs == null) {
            return op;
        }
        if (opNs.charAt(0) == '\\') {
            return op;
        }
        CIMObjectPath tempOp = new CIMObjectPath();
        tempOp.setNameSpace(nsNs + "\\" + op.getNameSpace());
        tempOp.setObjectName(op.getObjectName());
        tempOp.setKeys(op.getKeys());
        return tempOp;
    }

    public CIMClient(CIMNameSpace name, Principal principal, Object credential) throws CIMException {
        this(name, principal, credential, null, 0);
    }

    public CIMClient(CIMNameSpace name, Principal principal, Object credential, String protocol) throws CIMException {
        this(name, principal, credential, protocol, 0);
    }

    CIMClient(CIMNameSpace name, Principal principal, Object credential, String protocol, int debug) throws CIMException {
        this.initTrace();
        this.setProtocol(protocol);
        this.version = CIMVersion.major + "";
        if (name == null) {
            name = new CIMNameSpace();
        }
        if (principal == null) {
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL");
        }
        String str = principal.getName();
        if (str == null || str.trim().length() == 0) {
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL");
        }
        if (credential == null) {
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        name.setNameSpace("\\" + name.getNameSpace());
        this.nameSpace = name;
        this.rootNameSpace = new CIMNameSpace("", "");
        this.noAbsNameSpace = System.getProperty("wbem.noAbsNameSpace");
        if (this.nameSpace.getHostURL() != null) {
            this.hostNameSpace = new CIMNameSpace(this.nameSpace.getHostURL().toString());
            this.hostNameSpace.setNameSpace("\\");
        } else {
            this.hostNameSpace = new CIMNameSpace(this.nameSpace.getHost());
            this.hostNameSpace.setNameSpace("\\");
        }
        this.api = CIMClientFactory.getClientAPI(this.version, this.nameSpace, this.getProtocol(), debug, this.clientListener);
        this.setProtocol(this.api.getProtocol());
        this.csc = ClientSecurityFactory.createClientSecurity(this.nameSpace, principal, credential, null, this.getProtocol());
        this.api.initSecurityContext(this.version, this.csc);
    }

    public synchronized void createNameSpace(CIMNameSpace ns) throws CIMException {
        this.api.createNameSpace(this.version, this.checkNameSpace(ns), ns);
    }

    public synchronized void close() throws CIMException {
        String[] oarray = new String[]{this.version, "close"};
        this.api.close(this.version);
    }

    public synchronized void deleteNameSpace(CIMNameSpace ns) throws CIMException {
        this.api.deleteNameSpace(this.version, this.checkNameSpace(ns), ns);
    }

    public synchronized void deleteClass(CIMObjectPath path) throws CIMException {
        this.api.deleteClass(this.version, this.checkNameSpace(path), path);
    }

    public synchronized void deleteInstance(CIMObjectPath path) throws CIMException {
        this.api.deleteInstance(this.version, this.checkNameSpace(path), path);
    }

    public synchronized void deleteQualifierType(CIMObjectPath path) throws CIMException {
        this.api.deleteQualifierType(this.version, this.checkNameSpace(path), path);
    }

    public synchronized Enumeration enumNameSpace(CIMObjectPath path, boolean deep) throws CIMException {
        Vector v = this.api.enumNameSpace(this.version, this.checkNameSpace(path), path, deep);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public Enumeration enumerateClasses(CIMObjectPath path) throws CIMException {
        return this.enumerateClasses(path, false, true, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep) throws CIMException {
        return this.enumerateClasses(path, deep, true, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        return this.enumerateClasses(path, deep, localOnly, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.enumerateClasses(path, deep, localOnly, includeQualifiers, false);
    }

    public synchronized Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        Vector v = this.api.enumerateClasses(this.version, this.checkNameSpace(path), path, deep, localOnly, includeQualifiers, includeClassOrigin);
        return v.elements();
    }

    public Enumeration enumerateClassNames(CIMObjectPath path) throws CIMException {
        return this.enumerateClassNames(path, false);
    }

    public synchronized Enumeration enumerateClassNames(CIMObjectPath path, boolean deep) throws CIMException {
        Vector v = this.api.enumerateClassNames(this.version, this.checkNameSpace(path), path, deep);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public synchronized Enumeration enumerateInstanceNames(CIMObjectPath path) throws CIMException {
        Vector v = this.api.enumerateInstanceNames(this.version, this.checkNameSpace(path), path);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public Enumeration enumerateInstances(CIMObjectPath path) throws CIMException {
        return this.enumerateInstances(path, true, true, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep) throws CIMException {
        return this.enumerateInstances(path, deep, true, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly) throws CIMException {
        return this.enumerateInstances(path, deep, localOnly, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.enumerateInstances(path, deep, localOnly, includeQualifiers, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.enumerateInstances(path, deep, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.enumerateInstances(this.version, this.checkNameSpace(path), path, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public synchronized Enumeration enumQualifierTypes(CIMObjectPath path) throws CIMException {
        Vector v = this.api.enumQualifierTypes(this.version, this.checkNameSpace(path), path);
        return v.elements();
    }

    public CIMClass getClass(CIMObjectPath name) throws CIMException {
        return this.getClass(name, true, true, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly) throws CIMException {
        return this.getClass(name, localOnly, true, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.getClass(name, localOnly, includeQualifiers, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.getClass(name, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized CIMClass getClass(CIMObjectPath path, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.api.getClass(this.version, this.checkNameSpace(path), path, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstance getInstance(CIMObjectPath name) throws CIMException {
        return this.getInstance(name, true, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly) throws CIMException {
        return this.getInstance(name, localOnly, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly, boolean includeQualifiers) throws CIMException {
        return this.getInstance(name, localOnly, includeQualifiers, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.getInstance(name, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized CIMInstance getInstance(CIMObjectPath path, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.api.getInstance(this.version, this.checkNameSpace(path), path, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath path, String methodName, Vector inParams, Vector outParams) throws CIMException {
        return this.api.invokeMethod(this.version, this.checkNameSpace(path), path, methodName, inParams, outParams);
    }

    public CIMValue invokeMethod(CIMObjectPath path, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        return this.api.invokeMethod(this.version, this.checkNameSpace(path), path, methodName, inArgs, outArgs);
    }

    public synchronized CIMQualifierType getQualifierType(CIMObjectPath path) throws CIMException {
        return this.api.getQualifierType(this.version, this.checkNameSpace(path), path);
    }

    public synchronized void createQualifierType(CIMObjectPath path, CIMQualifierType qt) throws CIMException {
        this.api.createQualifierType(this.version, this.checkNameSpace(path), path, qt);
    }

    public synchronized void setQualifierType(CIMObjectPath path, CIMQualifierType qt) throws CIMException {
        this.api.setQualifierType(this.version, this.checkNameSpace(path), path, qt);
    }

    public synchronized void createClass(CIMObjectPath path, CIMClass cc) throws CIMException {
        this.api.createClass(this.version, this.checkNameSpace(path), path, cc);
    }

    public synchronized void setClass(CIMObjectPath path, CIMClass cc) throws CIMException {
        this.api.setClass(this.version, this.checkNameSpace(path), path, cc);
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath path, CIMInstance ci) throws CIMException {
        CIMNameSpace tmpNameSpace = this.checkNameSpace(path);
        CIMObjectPath cop = this.api.createInstance(this.version, this.checkNameSpace(path), path, ci);
        if (cop == null) {
            return null;
        }
        String relNS = CIMClient.stripNS(cop.getNameSpace(), this.nameSpace.getNameSpace());
        cop.setNameSpace(relNS);
        return cop;
    }

    public synchronized void setInstance(CIMObjectPath path, CIMInstance ci) throws CIMException {
        this.api.setInstance(this.version, this.checkNameSpace(path), path, ci, true, null);
    }

    public void setInstance(CIMObjectPath path, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        this.api.setInstance(this.version, this.checkNameSpace(path), path, ci, includeQualifiers, propertyList);
    }

    public synchronized CIMValue getProperty(CIMObjectPath path, String propertyName) throws CIMException {
        return this.api.getProperty(this.version, this.checkNameSpace(path), path, propertyName);
    }

    public synchronized void setProperty(CIMObjectPath path, String propertyName, CIMValue newValue) throws CIMException {
        this.api.setProperty(this.version, this.checkNameSpace(path), path, propertyName, newValue);
    }

    public synchronized void setProperty(CIMObjectPath name, String propertyName) throws CIMException {
        this.setProperty(name, propertyName, null);
    }

    public String encryptData(String clearData) throws CIMException {
        if (clearData == null) {
            return null;
        }
        SunDigestClientSecurity sdcs = null;
        try {
            sdcs = (SunDigestClientSecurity)this.csc;
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        String sval = sdcs.trans51Format(clearData);
        return "<" + sval + ">";
    }

    public synchronized Enumeration execQuery(CIMObjectPath path, String query, String ql) throws CIMException {
        if (ql == null || ql.length() == 0) {
            ql = WQL;
        }
        Vector v = this.api.execQuery(this.version, this.checkNameSpace(path), path, query, ql);
        return v.elements();
    }

    public Enumeration associators(CIMObjectPath objectName) throws CIMException {
        return this.associators(objectName, null, null, null, null, true, true, null);
    }

    public Enumeration associators(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.associators(this.version, this.checkNameSpace(objectName), objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public Enumeration associatorNames(CIMObjectPath objectName) throws CIMException {
        return this.associatorNames(objectName, null, null, null, null);
    }

    public Enumeration associatorNames(CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        Vector v = this.api.associatorNames(this.version, this.checkNameSpace(objectName), objectName, assocClass, resultClass, role, resultRole);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public Enumeration references(CIMObjectPath path, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        Vector v = this.api.references(this.version, this.checkNameSpace(path), path, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
        return v.elements();
    }

    public Enumeration references(CIMObjectPath objectName) throws CIMException {
        return this.references(objectName, null, null, true, true, null);
    }

    public Enumeration referenceNames(CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        Vector v = this.api.referenceNames(this.version, this.checkNameSpace(objectName), objectName, resultClass, role);
        Vector<CIMObjectPath> v2 = new Vector<CIMObjectPath>();
        for (int i = 0; i < v.size(); ++i) {
            CIMObjectPath op = (CIMObjectPath)v.elementAt(i);
            String relNS = CIMClient.stripNS(op.getNameSpace(), this.nameSpace.getNameSpace());
            op.setNameSpace(relNS);
            v2.addElement(op);
        }
        return v2.elements();
    }

    public Enumeration referenceNames(CIMObjectPath objectName) throws CIMException {
        return this.referenceNames(objectName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCIMListener(CIMListener l) throws CIMException {
        if (protocol != null && !this.listenerset) {
            CIMClient cIMClient = this;
            synchronized (cIMClient) {
                if (!this.listenerset) {
                    this.api.setListener(this.version);
                    this.listenerset = true;
                }
            }
        }
        this.clientListener.addCIMListener(l);
    }

    public void removeCIMListener(CIMListener l) throws CIMException {
        this.clientListener.removeCIMListener(l);
    }

    public CIMInstance getIndicationHandler(CIMListener cl) throws CIMException {
        return this.api.getIndicationHandler(cl);
    }

    protected void finalize() {
    }

    private void initTrace() {
        String level = System.getProperty("wbem.debug.level");
        String device = System.getProperty("wbem.debug.device");
        if (device != null && device.equalsIgnoreCase("file")) {
            device = "wbem_client";
        }
        Debug.traceOpen(level, device);
        Debug.trace1("Starting CIMClient version 2.5.0 03/02/11:16:44");
    }

    private String getProtocol() {
        return protocol;
    }

    private void setProtocol(String protocol) {
        CIMClient.protocol = protocol;
    }

    static String stripNS(String ns1, String ns2) {
        if ((ns1 = ns1.toLowerCase()).startsWith(ns2 = ns2.toLowerCase())) {
            String relNS = ns1.substring(ns2.length());
            if (relNS.startsWith("\\")) {
                return relNS.substring(1);
            }
            return relNS;
        }
        return ns1;
    }

    public BatchResult performBatchOperations(BatchHandle bc) throws CIMException {
        CIMOperation[] oplist = null;
        try {
            oplist = ((BatchCIMClient)bc).getOperationList();
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)ex);
        }
        if (oplist != null && oplist.length > 0) {
            for (int i = 0; i < oplist.length; ++i) {
                oplist[i].setNameSpace(this.checkNameSpace(oplist[i].getTargetNS()));
            }
            Vector v = this.api.performOperations(this.version, oplist);
            if (v == null || oplist.length != v.size()) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            Object[] arr = new Object[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                oplist[i].setResult(v.elementAt(i));
                arr[i] = oplist[i].getResult();
            }
            BatchResult br = new BatchResult(arr);
            return br;
        }
        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
    }

    protected CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    private CIMNameSpace checkNameSpace(CIMObjectPath path) {
        if (this.noAbsNameSpace == null && path != null && path.getNameSpace() != null && path.getNameSpace().startsWith("\\")) {
            return this.rootNameSpace;
        }
        return this.nameSpace;
    }

    private CIMNameSpace checkNameSpace(CIMNameSpace inNs) {
        if (this.noAbsNameSpace == null && inNs != null && inNs.getNameSpace() != null && inNs.getNameSpace().startsWith("\\")) {
            return this.rootNameSpace;
        }
        return this.nameSpace;
    }

    private class ClientListener
    implements CIMListener {
        private List listenerList = new ArrayList();

        private ClientListener() {
        }

        public void addCIMListener(CIMListener l) {
            if (l == null) {
                return;
            }
            if (!this.listenerList.contains(l)) {
                this.listenerList.add(l);
            }
        }

        public void removeCIMListener(CIMListener l) {
            this.listenerList.remove(l);
        }

        public void indicationOccured(CIMEvent e) {
            new IndicationDeliverer(e).start();
        }

        private class IndicationDeliverer
        extends Thread {
            CIMEvent e;

            IndicationDeliverer(CIMEvent e) {
                this.e = e;
            }

            public void run() {
                ArrayList l = new ArrayList(ClientListener.this.listenerList);
                for (CIMListener listener : l) {
                    listener.indicationOccured(this.e);
                }
            }
        }
    }
}

