/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.wbem.client.adapter.http.transport.Header;
import javax.wbem.client.adapter.http.transport.HttpClientManager;
import javax.wbem.client.adapter.http.transport.HttpClientSocketFactory;
import javax.wbem.client.adapter.http.transport.HttpParseException;
import javax.wbem.client.adapter.http.transport.MessageReader;
import javax.wbem.client.adapter.http.transport.MessageWriter;
import javax.wbem.client.adapter.http.transport.OutboundRequest;
import javax.wbem.client.adapter.http.transport.Request;
import javax.wbem.client.adapter.http.transport.ServerInfo;
import javax.wbem.client.adapter.http.transport.StartLine;
import javax.wbem.client.adapter.http.transport.TimedConnection;

public class HttpClientConnection
implements TimedConnection {
    private static final int HTTP_MAJOR = 1;
    private static final int HTTP_MINOR = 1;
    private static final String clientString = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return "Java/" + System.getProperty("java.version", "???") + " " + HttpClientConnection.class.getName();
        }
    });
    private static final int DIRECT = 0;
    private static final int PROXIED = 1;
    private static final int TUNNELED = 2;
    private static final int IDLE = 0;
    private static final int BUSY = 1;
    private static final int CLOSED = 2;
    private int mode;
    private int state = 0;
    private Object stateLock = new Object();
    private ServerInfo targetInfo;
    private ServerInfo proxyInfo;
    private HttpClientManager manager;
    private Socket sock;
    private OutputStream out;
    private InputStream in;
    private boolean useMPost = false;
    private boolean chunkingDisabled = false;

    public HttpClientConnection(String host, int port, HttpClientSocketFactory factory, boolean useMPost) throws IOException {
        this.useMPost = useMPost;
        this.manager = new HttpClientManager();
        this.mode = 0;
        this.targetInfo = this.manager.getServerInfo(host, port);
        this.setupConnection(factory);
    }

    public HttpClientConnection(String host, int port, HttpClientSocketFactory factory, boolean useMPost, boolean useChunking) throws IOException {
        this.useMPost = useMPost;
        this.chunkingDisabled = !useChunking;
        this.manager = new HttpClientManager();
        this.mode = 0;
        this.targetInfo = this.manager.getServerInfo(host, port);
        this.setupConnection(factory);
    }

    public HttpClientConnection(String targetHost, int targetPort, String proxyHost, int proxyPort, boolean tunnel, HttpClientSocketFactory factory, HttpClientManager manager) throws IOException {
        this.manager = manager;
        this.mode = tunnel ? 2 : 1;
        this.targetInfo = manager.getServerInfo(targetHost, targetPort);
        this.proxyInfo = manager.getServerInfo(proxyHost, proxyPort);
        this.setupConnection(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() throws IOException {
        this.markBusy();
        this.fetchServerInfo();
        try {
            boolean bl = this.ping(false);
            return bl;
        }
        finally {
            this.markIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundRequest newRequest(String URLPath) throws IOException {
        OutboundRequestImpl req = null;
        this.markBusy();
        this.fetchServerInfo();
        try {
            OutboundRequestImpl outboundRequestImpl = req = new OutboundRequestImpl(URLPath);
            return outboundRequestImpl;
        }
        finally {
            if (req == null) {
                this.markIdle();
            }
        }
    }

    protected void idle() {
    }

    public Socket getSocket() {
        return this.sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean force) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return true;
            }
            if (!force && this.state == 1) {
                return false;
            }
            this.state = 2;
        }
        this.disconnect();
        return true;
    }

    private void fetchServerInfo() {
        ServerInfo sinfo = this.manager.getServerInfo(this.targetInfo.host, this.targetInfo.port);
        if (sinfo.timestamp > this.targetInfo.timestamp) {
            this.targetInfo = sinfo;
        }
        if (this.mode != 0) {
            sinfo = this.manager.getServerInfo(this.proxyInfo.host, this.proxyInfo.port);
            if (sinfo.timestamp > this.proxyInfo.timestamp) {
                this.proxyInfo = sinfo;
            }
        }
    }

    private void flushServerInfo() {
        this.manager.cacheServerInfo(this.targetInfo);
        if (this.mode != 0) {
            this.manager.cacheServerInfo(this.proxyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBusy() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                throw new IOException("connection closed");
            }
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markIdle() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            this.state = 0;
        }
        this.idle();
    }

    private void setupConnection(HttpClientSocketFactory factory) throws IOException {
        try {
            for (int i = 0; i < 4; ++i) {
                if (this.sock == null) {
                    this.connect(factory);
                }
                if (this.mode == 1 && this.proxyInfo.timestamp == -1L) {
                    this.requestProxyOptions();
                    continue;
                }
                if (this.targetInfo.timestamp == -1L) {
                    this.ping(true);
                    continue;
                }
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.disconnect();
        throw new ConnectException("failed to establish HTTP connection");
    }

    private void connect(HttpClientSocketFactory factory) throws IOException {
        this.disconnect();
        for (int i = 0; i < 2; ++i) {
            if (this.sock == null) {
                ServerInfo sinfo = this.mode == 0 ? this.targetInfo : this.proxyInfo;
                this.sock = factory.createSocket(sinfo.host, sinfo.port);
                this.out = new BufferedOutputStream(this.sock.getOutputStream());
                this.in = new BufferedInputStream(this.sock.getInputStream());
            }
            if (this.mode != 2) {
                return;
            }
            if (!this.requestProxyConnect()) continue;
            this.sock = factory.createTunnelSocket(this.sock);
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.in = new BufferedInputStream(this.sock.getInputStream());
            return;
        }
    }

    private void disconnect() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sock = null;
            this.out = null;
            this.in = null;
        }
    }

    private boolean ping(boolean setup) throws IOException {
        StartLine outLine = this.createPostLine(null);
        Header outHeader = this.createPostHeader(outLine);
        MessageWriter writer = new MessageWriter(this.out, false);
        writer.writeStartLine(outLine);
        writer.writeHeader(outHeader);
        writer.flush();
        String msgBody = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<CIM DTDVERSION=\"2.0\" CIMVERSION=\"2.0\">\n</CIM\n>";
        writer.writeContent(msgBody.getBytes(), 0, msgBody.length());
        writer.writeTrailer(null);
        MessageReader reader = new MessageReader(this.in, false);
        StartLine inLine = reader.readStartLine();
        Header inHeader = reader.readHeader();
        inHeader.merge(reader.readTrailer());
        this.analyzePostResponse(inLine, inHeader);
        if (!HttpClientConnection.supportsPersist(inLine, inHeader)) {
            if (setup) {
                this.disconnect();
            } else {
                this.shutdown(true);
            }
        }
        return inLine.status / 100 == 2;
    }

    private boolean requestProxyOptions() throws IOException {
        MessageWriter writer = new MessageWriter(this.out, false);
        writer.writeStartLine(new StartLine(1, 1, "OPTIONS", "*"));
        writer.writeHeader(this.createProxyHeader());
        writer.writeTrailer(null);
        MessageReader reader = new MessageReader(this.in, false);
        StartLine inLine = reader.readStartLine();
        Header inHeader = reader.readHeader();
        inHeader.merge(reader.readTrailer());
        this.analyzeProxyResponse(inLine, inHeader);
        if (!HttpClientConnection.supportsPersist(inLine, inHeader)) {
            this.disconnect();
        }
        return inLine.status / 100 == 2;
    }

    private boolean requestProxyConnect() throws IOException {
        StartLine outLine = new StartLine(1, 1, "CONNECT", this.targetInfo.host + ":" + this.targetInfo.port);
        Header outHeader = this.createProxyHeader();
        String auth = this.proxyInfo.getAuthString("http", outLine.method, outLine.uri);
        if (auth != null) {
            outHeader.setField("Proxy-Authorization", auth);
        }
        MessageWriter writer = new MessageWriter(this.out, false);
        writer.writeStartLine(outLine);
        writer.writeHeader(outHeader);
        writer.writeTrailer(null);
        MessageReader reader = new MessageReader(this.in, true);
        StartLine inLine = reader.readStartLine();
        Header inHeader = reader.readHeader();
        inHeader.merge(reader.readTrailer());
        this.analyzeProxyResponse(inLine, inHeader);
        if (inLine.status / 100 == 2) {
            return true;
        }
        if (!HttpClientConnection.supportsPersist(inLine, inHeader)) {
            this.disconnect();
        }
        return false;
    }

    private StartLine createPostLine(String URLPath) {
        String methodName = this.useMPost ? "M-POST" : "POST";
        String path = URLPath;
        if (path == null || path.length() == 0) {
            path = "/";
        }
        String uri = this.mode == 1 ? "http://" + this.targetInfo.host + ":" + this.targetInfo.port + path : path;
        return new StartLine(1, 1, methodName, uri);
    }

    private Header createBaseHeader() {
        Header header = new Header();
        long now = System.currentTimeMillis();
        header.setField("Date", Header.getDateString(now));
        header.setField("User-Agent", clientString);
        return header;
    }

    private Header createProxyHeader() {
        Header header = this.createBaseHeader();
        header.setField("Host", this.proxyInfo.host + ":" + this.proxyInfo.port);
        return header;
    }

    private Header createPostHeader(StartLine sline) {
        Header header = this.createBaseHeader();
        header.setField("Host", this.targetInfo.host + ":" + this.targetInfo.port);
        header.setField("Connection", "Keep-Alive");
        String auth = this.targetInfo.getAuthString("http", sline.method, sline.uri);
        if (auth != null) {
            header.setField("Authorization", auth);
        }
        if (this.mode == 1 && (auth = this.proxyInfo.getAuthString("http", sline.method, sline.uri)) != null) {
            header.setField("Proxy-Authorization", auth);
        }
        return header;
    }

    private void analyzePostResponse(StartLine inLine, Header inHeader) {
        long now = System.currentTimeMillis();
        String str = inHeader.getField("WWW-Authenticate");
        if (str != null) {
            try {
                this.targetInfo.setAuthInfo(str);
            }
            catch (HttpParseException ex) {
                // empty catch block
            }
            this.targetInfo.timestamp = now;
        } else {
            str = inHeader.getField("Authentication-Info");
            if (str != null) {
                try {
                    this.targetInfo.updateAuthInfo(str);
                }
                catch (HttpParseException ex) {
                    // empty catch block
                }
                this.targetInfo.timestamp = now;
            }
        }
        if (this.mode != 0) {
            str = inHeader.getField("Proxy-Authenticate");
            if (str != null) {
                try {
                    this.proxyInfo.setAuthInfo(str);
                }
                catch (HttpParseException ex) {
                    // empty catch block
                }
                this.proxyInfo.timestamp = now;
            } else {
                str = inHeader.getField("Proxy-Authentication-Info");
                if (str != null) {
                    try {
                        this.proxyInfo.updateAuthInfo(str);
                    }
                    catch (HttpParseException ex) {
                        // empty catch block
                    }
                    this.proxyInfo.timestamp = now;
                }
            }
        }
        if (this.mode != 1) {
            this.targetInfo.major = inLine.major;
            this.targetInfo.minor = inLine.minor;
            this.targetInfo.timestamp = now;
        } else {
            if (inLine.status == 407) {
                this.proxyInfo.major = inLine.major;
                this.proxyInfo.minor = inLine.minor;
            }
            this.proxyInfo.timestamp = now;
        }
        if (inLine.status / 100 == 2) {
            this.targetInfo.timestamp = now;
        }
        this.flushServerInfo();
    }

    private void analyzeProxyResponse(StartLine inLine, Header inHeader) {
        this.proxyInfo.major = inLine.major;
        this.proxyInfo.minor = inLine.minor;
        this.proxyInfo.timestamp = System.currentTimeMillis();
        String str = inHeader.getField("Proxy-Authenticate");
        if (str != null) {
            try {
                this.proxyInfo.setAuthInfo(str);
            }
            catch (HttpParseException ex) {}
        } else {
            str = inHeader.getField("Proxy-Authentication-Info");
            if (str != null) {
                try {
                    this.proxyInfo.updateAuthInfo(str);
                }
                catch (HttpParseException ex) {
                    // empty catch block
                }
            }
        }
        this.flushServerInfo();
    }

    public boolean supportsChunking() {
        if (this.chunkingDisabled) {
            return false;
        }
        ServerInfo si = this.mode == 1 ? this.proxyInfo : this.targetInfo;
        return StartLine.compareVersions(si.major, si.minor, 1, 1) >= 0;
    }

    private static boolean supportsPersist(StartLine sline, Header header) {
        if (header.containsValue("Connection", "close", true)) {
            return false;
        }
        if (header.containsValue("Connection", "Keep-Alive", true)) {
            return true;
        }
        int c = StartLine.compareVersions(sline.major, sline.minor, 1, 1);
        return c >= 0;
    }

    private final class OutboundRequestImpl
    extends Request
    implements OutboundRequest {
        private MessageWriter writer;
        private MessageReader reader;
        private StartLine inLine;
        private Header inHeader;
        private boolean persist = false;
        private Header outHeader;
        private StartLine outLine;

        OutboundRequestImpl(String URLPath) throws IOException {
            this.writer = new MessageWriter(HttpClientConnection.this.out, HttpClientConnection.this.supportsChunking());
            this.reader = new MessageReader(HttpClientConnection.this.in, false);
            this.outLine = HttpClientConnection.this.createPostLine(URLPath);
            this.outHeader = HttpClientConnection.this.createPostHeader(this.outLine);
            this.outHeader.setField("Content-Type", "text/xml;charset=UTF-8");
            this.outHeader.setField("Accept", "text/xml, application/xml");
        }

        public int getResponseCode() {
            return this.inLine.status;
        }

        public void addHeaderField(String name, String value) {
            this.outHeader.setField(name, value);
        }

        public void endWriteHeader() throws IOException {
            this.writer.writeStartLine(this.outLine);
            this.writer.writeHeader(this.outHeader);
        }

        public OutputStream getRequestOutputStream() {
            return this.getOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.getInputStream();
        }

        public void dumpOutHeader() throws IOException {
            this.outLine.write(System.out);
            this.outHeader.write(System.out);
        }

        public void dumpInHeader() throws IOException {
            this.inLine.write(System.out);
            this.inHeader.write(System.out);
        }

        void startOutput() throws IOException {
        }

        void write(byte[] b, int off, int len) throws IOException {
            this.writer.writeContent(b, off, len);
        }

        void endOutput() throws IOException {
            this.writer.writeTrailer(null);
        }

        boolean startInput() throws IOException {
            this.inLine = this.reader.readStartLine();
            this.inHeader = this.reader.readHeader();
            return this.inLine.status / 100 == 2;
        }

        int read(byte[] b, int off, int len) throws IOException {
            return this.reader.readContent(b, off, len);
        }

        int available() throws IOException {
            return this.reader.availableContent();
        }

        void endInput() throws IOException {
            this.inHeader.merge(this.reader.readTrailer());
            HttpClientConnection.this.analyzePostResponse(this.inLine, this.inHeader);
            this.persist = HttpClientConnection.supportsPersist(this.inLine, this.inHeader);
        }

        void done(boolean corrupt) {
            if (corrupt || !this.persist) {
                HttpClientConnection.this.shutdown(true);
            } else {
                HttpClientConnection.this.markIdle();
            }
        }
    }
}

