/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.ClientSecurityContext;

public class ClientSecurityFactory {
    private static final String PROP_DEFAULT_FILE = "javax.wbem.client.WbemDefaults";
    private static final String PROP_EXTEND_FILE = "WbemClient";
    private static final String PROP_SECURITY = "security";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_MECHANISM = "mechanism";
    private static final String PROP_NAME = "name";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_CLASS = "client.class";
    private static final String DFLT_XML_SECURITY = "basic";
    private static final String DFLT_RMI_SECURITY = "sundigest";
    private static final String DFLT_BASIC_CLASS = "javax.wbem.security.BasicClientSecurity";
    private static final String DFLT_SUNDIGEST_CLASS = "javax.wbem.security.SunDigestClientSecurity";
    private static Properties props = null;

    public static ClientSecurityContext createClientSecurity(CIMNameSpace ns, Principal principal, Object credential, String mechanism, String protocol) throws CIMException {
        String name = null;
        String mech = null;
        String proto = protocol;
        if ((protocol == null || protocol.trim().length() == 0) && (proto = ClientSecurityFactory.getProperty(name = "transport.protocol.default")) == null) {
            proto = "cim-rmi";
        }
        proto = proto.toLowerCase();
        if ((mech == null || mech.trim().length() == 0) && (mech = ClientSecurityFactory.getProperty(name = "transport." + proto + "." + PROP_SECURITY + "." + PROP_DEFAULT)) == null) {
            if (proto.equals("cim-xml")) {
                mech = DFLT_XML_SECURITY;
            } else if (proto.equals("cim-rmi")) {
                mech = DFLT_RMI_SECURITY;
            } else {
                Debug.trace1("Security mechanism not valid");
                throw new CIMSecurityException("CIM_ERR_NOT_FOUND", PROP_DEFAULT);
            }
        }
        mech = mech.toLowerCase();
        name = "security.mechanism.name." + mech;
        String temp = ClientSecurityFactory.getProperty(name);
        if (temp == null || !mech.equalsIgnoreCase(temp)) {
            Debug.trace1("Security mechanism not in configuration properties");
            throw new CIMException("CIM_ERR_NOT_FOUND", "mechanism-0");
        }
        Debug.trace1("Security mechanism name is " + mech);
        name = "security." + mech + "." + PROP_TRANSPORT;
        String list = ClientSecurityFactory.getProperty(name);
        if (list == null) {
            if (mech.equals(DFLT_XML_SECURITY)) {
                list = "cim-xml";
            } else if (mech.equals(DFLT_RMI_SECURITY)) {
                list = "cim-rmi";
            }
        }
        if (list == null) {
            Debug.trace1("Security mechanism not supported on protocol");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-1");
        }
        List al = ClientSecurityFactory.parseList(list);
        if (!al.contains(proto)) {
            Debug.trace1("Security mechanism not supported on protocol");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-2");
        }
        name = "security." + mech + "." + PROP_CLASS;
        String classname = ClientSecurityFactory.getProperty(name);
        if (classname == null) {
            if (mech.equals(DFLT_XML_SECURITY)) {
                classname = DFLT_BASIC_CLASS;
            } else if (mech.equals(DFLT_RMI_SECURITY)) {
                classname = DFLT_SUNDIGEST_CLASS;
            }
        }
        if (classname == null) {
            Debug.trace1("No security module class for mechanism");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-3");
        }
        if (!ClientSecurityFactory.checkSecurityClass(classname)) {
            Debug.trace1("Security module class not allowed");
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-4");
        }
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            Debug.trace1("Mechanism " + mech + ": class not found: " + classname, ex);
            throw new CIMSecurityException("CIM_ERR_NOT_FOUND", "mechanism-5");
        }
        ClientSecurityContext cs = null;
        try {
            Class[] paramTypes = new Class[]{CIMNameSpace.class, Principal.class, Object.class};
            Object[] paramList = new Object[]{ns, principal, credential};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            cs = (ClientSecurityContext)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            Throwable ax = ex.getTargetException();
            Debug.trace1("Error in security module class constructor", ax);
            if (ax instanceof CIMException) {
                CIMException cex = (CIMException)ax;
                throw cex;
            }
            throw new CIMSecurityException("CIM_ERR_FAILED", (Object)ax);
        }
        catch (Exception ex) {
            Debug.trace1("Error creating security module instance", ex);
            throw new CIMSecurityException("CIM_ERR_FAILED", (Object)ex);
        }
        return cs;
    }

    public static String[] getSecurityMechanisms() throws CIMException {
        String[] astr = null;
        String name = "security.mechanism";
        List list = ClientSecurityFactory.getPropertyList(name);
        if (list != null && list.size() > 0) {
            astr = new String[list.size()];
            list.toArray(astr);
        }
        return astr;
    }

    static String getProperty(String name) throws CIMException {
        if (props == null) {
            ClientSecurityFactory.initProperties();
        }
        return props.getProperty(name);
    }

    static List getPropertyList(String name) throws CIMException {
        ArrayList<String> list = new ArrayList<String>();
        if (props == null) {
            ClientSecurityFactory.initProperties();
        }
        boolean i = false;
        boolean sw = true;
        String prefix = name.concat(".");
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String val;
            String key = (String)en.nextElement();
            if (!key.startsWith(prefix) || (val = props.getProperty(key)) == null) continue;
            list.add(val);
        }
        return list;
    }

    private static boolean checkSecurityClass(String classname) {
        return classname.equals(DFLT_BASIC_CLASS) || classname.equals(DFLT_SUNDIGEST_CLASS) || classname.equals("com.sun.wbem.client.SolarisDigestClientSecurity");
    }

    private static List parseList(String list) {
        ArrayList<String> al = new ArrayList<String>(10);
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreElements()) {
            String elem = (String)st.nextElement();
            al.add(elem);
        }
        return al;
    }

    private static void initProperties() throws CIMException {
        if (props == null) {
            props = new Properties();
            try {
                ClientSecurityFactory.loadProperties(PROP_DEFAULT_FILE);
            }
            catch (Exception ex) {
                Debug.trace1("Error loading WbemDefaults properties");
                throw new CIMException("CIM_ERR_FAILED", PROP_DEFAULT_FILE);
            }
            try {
                ClientSecurityFactory.loadProperties(PROP_EXTEND_FILE);
            }
            catch (MissingResourceException ex) {
                Debug.trace1("Error loading properties: WbemClient");
            }
        }
    }

    private static void loadProperties(String bundle) throws CIMException {
        PropertyResourceBundle prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, new Locale("", ""));
        if (prb != null) {
            String val = null;
            Enumeration<String> en = prb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                try {
                    val = prb.getString(key);
                }
                catch (Exception ex) {
                    key = null;
                }
                if (key == null) continue;
                props.setProperty(key, val);
            }
        }
    }
}

