/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.management.services.registration.AppDescriptorParser;
import com.sun.management.services.registration.ManagementApp;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.registration.WebXmlParser;
import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xml.sax.InputSource;

public class AppXmlChecker {
    private static final String CATEGORY_PROP = "category.name";
    private String[] categories = null;
    private String conpath = null;
    private WebUtilLogger logger = null;

    public AppXmlChecker(String string, WebUtilLogger webUtilLogger) throws WebUtilException {
        this.conpath = string;
        this.logger = webUtilLogger;
        this.categories = this.getCategoryList(string);
        if (this.categories == null || this.categories.length == 0) {
            throw new WebUtilException("check_err_100");
        }
    }

    public RegistrationInfo parse(boolean bl, String string) throws WebUtilException {
        FileInputStream fileInputStream;
        RegistrationInfo registrationInfo = null;
        if (string == null || string.trim().length() == 0) {
            throw new WebUtilException("check_err_03");
        }
        if (bl && !this.canParserValidate(string)) {
            this.printError("check_err_28");
            bl = false;
        }
        String string2 = "file:" + this.conpath + "/private/system/";
        InputSource inputSource = null;
        try {
            fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            inputSource = new InputSource(bufferedReader);
            inputSource.setSystemId(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WebUtilException("check_err_04", string);
        }
        catch (Exception exception) {
            throw new WebUtilException("check_err_12", exception.getLocalizedMessage());
        }
        fileInputStream = new AppDescriptorParser(bl);
        try {
            registrationInfo = fileInputStream.parse(inputSource);
        }
        catch (Exception exception) {
            throw new WebUtilException("check_err_09", exception.getLocalizedMessage());
        }
        return registrationInfo;
    }

    public int check(RegistrationInfo registrationInfo) {
        String string;
        String string2;
        int n = 0;
        ManagementApp managementApp = registrationInfo.getManagementApp();
        String string3 = managementApp.getCategory();
        if (string3 == null || string3.trim().length() == 0) {
            string3 = "(empty)";
        }
        boolean bl = false;
        for (int i = 0; i < this.categories.length; ++i) {
            if (!string3.equalsIgnoreCase(this.categories[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.printError("check_err_101", string3);
            n = 1;
        }
        if (AppXmlChecker.getVersionNumber(string2 = registrationInfo.getVersion()) >= 202 && ((string = managementApp.getPrimaryProductName()) == null || string.trim().length() == 0)) {
            this.printError("check_err_102");
            n = 2;
        }
        return n;
    }

    private boolean canParserValidate(String string) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            String string2 = WebXmlParser.trimWebXml((InputStream)fileInputStream);
            if (string2 != null) {
                bl = string2.indexOf("<!DOCTYPE") >= 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private String[] getCategoryList(String string) {
        String[] stringArray = null;
        Properties properties = new Properties();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string + WebUtilConstants.SYSTEM_SUBDIR + File.separator + "default.properties";
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = 1;
        boolean bl = true;
        while (bl) {
            String string3 = "category.name." + n;
            try {
                String string4 = properties.getProperty(string3);
                if (string4 == null) {
                    bl = false;
                } else {
                    arrayList.add(string4);
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            ++n;
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static int getVersionNumber(String string) {
        int n = 0;
        try {
            String[] stringArray = string.trim().split("[^0123456789.]");
            string = "0" + stringArray[0];
        }
        catch (Exception exception) {
            return n;
        }
        int n2 = 0;
        int n3 = 0;
        try {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n4 = stringTokenizer.countTokens();
            if (n4 > 0) {
                string2 = stringTokenizer.nextToken();
                n2 = new Integer(string2);
            }
            if (n4 > 1) {
                string2 = stringTokenizer.nextToken();
                n3 = new Integer(string2);
            }
            n = n2 * 100 + n3;
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    private void printError(String string) {
        this.printError(string, null, null, null);
    }

    private void printError(String string, String string2) {
        this.printError(string, string2, null, null);
    }

    private void printError(String string, String string2, String string3) {
        this.printError(string, string2, string3, null);
    }

    private void printError(String string, String string2, String string3, String string4) {
        WebUtilException webUtilException = new WebUtilException(string, string2 == null ? "(null)" : string2, string3 == null ? "(null)" : string3, string4 == null ? "(null)" : string4);
        String string5 = webUtilException.getLocalizedMessage();
        if (this.logger != null) {
            this.logger.log(string5, 1);
        } else {
            System.out.println(string5);
        }
    }
}

