/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.CliSubcommand;
import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import com.sun.web.util.WebappImport;
import java.io.File;

public class CliImport
implements CliSubcommand {
    private static final String HELP_PREFIX = "import_help_";
    private static final String JATO_LIST = WebUtilConstants.SYSTEM_SUBDIR + File.separator + "jato.imports";
    private static final String FACES_LIST = WebUtilConstants.SYSTEM_SUBDIR + File.separator + "faces.imports";
    private String consoledir;
    private WebUtilLogger logger = null;

    public CliImport(String string) {
        this.consoledir = string;
        this.logger = new WebUtilLogger("import");
    }

    public int execute(String[] stringArray) throws WebUtilException {
        String string = null;
        Object var3_3 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        if (stringArray.length != 2) {
            this.printError("cli_err_02", null);
            return 2;
        }
        String[] stringArray2 = stringArray[1].split("_WxS_");
        boolean bl3 = true;
        String string3 = null;
        boolean bl4 = false;
        int n = 0;
        while (n < stringArray2.length) {
            string2 = this.stripQuotes(stringArray2[n]);
            if (bl3) {
                if (string2.equals("-h") || string2.equals("--help") || string2.equals("-?")) {
                    this.showHelp();
                    return 0;
                }
                if (string2.equals("-j") || string2.equals("--jato")) {
                    bl = true;
                    ++n;
                    continue;
                }
                if (string2.equals("-f") || string2.equals("--faces")) {
                    bl2 = true;
                    ++n;
                    continue;
                }
            }
            if (string2.startsWith("-")) {
                string3 = "cli_err_02";
                break;
            }
            bl3 = false;
            if (string != null) {
                string3 = "cli_err_08";
                break;
            }
            string = string2;
            ++n;
        }
        if (string3 != null) {
            this.printError(string3, string2);
            return 2;
        }
        if (string == null || string.length() == 0) {
            this.printError("import_err_01", null);
            return 2;
        }
        String string4 = this.consoledir + WebUtilConstants.IMPORT_SUBDIR;
        String string5 = this.consoledir + JATO_LIST;
        String string6 = this.consoledir + FACES_LIST;
        File file = new File(string5);
        File file2 = new File(string6);
        if (!file.exists() || !file2.exists()) {
            this.printError("import_err_02", null);
            return 2;
        }
        int n2 = 0;
        try {
            WebappImport webappImport = new WebappImport(this.consoledir, this.logger);
            if (bl) {
                webappImport.copyResources(string4, string, string5);
            }
            if (bl2) {
                webappImport.copyResources(string4, string, string6);
            }
        }
        catch (WebUtilException webUtilException) {
            this.printMessage(0, webUtilException);
            n2 = 2;
        }
        catch (Exception exception) {
            this.printError("import_err_03", exception.getLocalizedMessage());
            n2 = 2;
        }
        return n2;
    }

    public String getDescription() {
        WebUtilException webUtilException = new WebUtilException("usage_102");
        return webUtilException.getLocalizedMessage();
    }

    private String stripQuotes(String string) {
        if (string.startsWith("\"") && (string = string.substring(1)).endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void showHelp() {
        boolean bl = true;
        int n = 0;
        System.out.println("");
        while (bl) {
            String string = HELP_PREFIX + ++n;
            String string2 = new WebUtilException(string).getLocalizedMessage();
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.equals("EOM") || string2.equals(string)) break;
            System.out.println(string2);
        }
        System.out.println("");
    }

    private String getOptionValue(int n, String[] stringArray, String string, String string2) throws WebUtilException {
        if (n >= stringArray.length) {
            throw new WebUtilException("cli_err_09", string.substring(2));
        }
        if (stringArray[n].startsWith("-")) {
            throw new WebUtilException("cli_err_09", string.substring(2));
        }
        if (string2 != null) {
            throw new WebUtilException("cli_err_10", string.substring(2));
        }
        return stringArray[n];
    }

    private void printInfo(String string, String string2) {
        this.printMessage(2, string, string2, null, null);
    }

    private void printWarning(String string, String string2) {
        this.printMessage(1, string, string2, null, null);
    }

    private void printError(String string, String string2) {
        this.printMessage(0, string, string2, null, null);
    }

    private void printMessage(int n, String string, String string2, String string3, String string4) {
        WebUtilException webUtilException = new WebUtilException(string, string2 == null ? "(null)" : string2, string3 == null ? "(null)" : string3, string4 == null ? "(null)" : string4);
        this.printMessage(n, webUtilException);
    }

    private void printMessage(int n, WebUtilException webUtilException) {
        String string = webUtilException.getLocalizedMessage();
        if (this.logger != null) {
            this.logger.log(string, n);
        } else if (n == 0) {
            System.err.println(string);
        } else {
            System.out.println(string);
        }
    }
}

