/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.CliSubcommand;
import com.sun.web.util.ProductImageUtility;
import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import com.sun.web.util.WebUtilLogger;
import java.io.File;

public class CliProductImage
implements CliSubcommand {
    private static final String TYPE_OPT_SHORT = "-t";
    private static final String TYPE_OPT_LONG = "--type";
    private static final String NAME_OPT_SHORT = "-n";
    private static final String NAME_OPT_LONG = "--name";
    private static final String DIR_OPT_SHORT = "-d";
    private static final String DIR_OPT_LONG = "--directory";
    private static final String XML_OPT_SHORT = "-a";
    private static final String XML_OPT_LONG = "--appxml";
    private static final String RES_OPT_SHORT = "-r";
    private static final String RES_OPT_LONG = "--resource";
    private static final String HELP_PREFIX = "image_help_";
    private static final String WEB_INF_SUBDIR = "WEB-INF";
    private String console_home;
    private WebUtilLogger logger = null;

    public CliProductImage(String string) {
        this.console_home = string;
        this.logger = new WebUtilLogger("prodname");
    }

    public int execute(String[] stringArray) throws WebUtilException {
        File file;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        String string6 = null;
        if (stringArray.length != 2) {
            this.printError("cli_err_02", null);
            return 2;
        }
        String[] stringArray2 = stringArray[1].split("_WxS_");
        boolean bl2 = true;
        Object var11_11 = null;
        boolean bl3 = false;
        int n = 0;
        while (n < stringArray2.length) {
            string6 = this.stripQuotes(stringArray2[n]);
            if (bl2) {
                if (string6.equals("-h") || string6.equals("--help") || string6.equals("-?")) {
                    this.showHelp();
                    return 0;
                }
                if (string6.equals(TYPE_OPT_SHORT) || string6.equals(TYPE_OPT_LONG)) {
                    string = this.getOptionValue(++n, stringArray2, TYPE_OPT_LONG, string);
                    ++n;
                    continue;
                }
                if (string6.equals(DIR_OPT_SHORT) || string6.equals(DIR_OPT_LONG)) {
                    string3 = this.getOptionValue(++n, stringArray2, DIR_OPT_LONG, string3);
                    ++n;
                    continue;
                }
                if (string6.equals(NAME_OPT_SHORT) || string6.equals(NAME_OPT_LONG)) {
                    string2 = this.getOptionValue(++n, stringArray2, NAME_OPT_LONG, string2);
                    ++n;
                    continue;
                }
                if (string6.equals(XML_OPT_SHORT) || string6.equals(XML_OPT_LONG)) {
                    string4 = this.getOptionValue(++n, stringArray2, XML_OPT_LONG, string4);
                    ++n;
                    continue;
                }
                if (string6.equals(RES_OPT_SHORT) || string6.equals(RES_OPT_LONG)) {
                    string5 = this.getOptionValue(++n, stringArray2, RES_OPT_LONG, string5);
                    ++n;
                    continue;
                }
            }
            this.printError("cli_err_08", string6);
            return 2;
        }
        if (string == null) {
            this.printError("image_err_01", TYPE_OPT_LONG);
            return 2;
        }
        if (string3 == null) {
            this.printError("image_err_04", DIR_OPT_LONG);
            return 2;
        }
        if (string4 != null && string2 != null) {
            this.printError("image_err_19", null);
            return 2;
        }
        if (string2 == null && string4 == null) {
            string4 = string3;
        }
        if (string4 != null && !string4.endsWith(File.separator + "app.xml")) {
            string4 = string4 + File.separator + WEB_INF_SUBDIR + File.separator + "app.xml";
        }
        if ((file = new File(string3 + File.separator + WEB_INF_SUBDIR)).exists() && file.isDirectory()) {
            string3 = string3 + File.separator + WebUtilConstants.IMAGE_SUBDIR;
        }
        int n2 = 0;
        try {
            ProductImageUtility productImageUtility = new ProductImageUtility(this.console_home, string5);
            if (string4 != null) {
                productImageUtility.createImagesFromAppxml(string, string4, string3);
            } else if (string2 != null) {
                productImageUtility.createImagesFromNames(string, string2, string3);
            }
        }
        catch (WebUtilException webUtilException) {
            this.printMessage(0, webUtilException);
            n2 = 2;
        }
        catch (Exception exception) {
            this.printError("image_err_20", exception.getLocalizedMessage());
            n2 = 2;
        }
        return n2;
    }

    public String getDescription() {
        WebUtilException webUtilException = new WebUtilException("usage_101");
        return webUtilException.getLocalizedMessage();
    }

    private String stripQuotes(String string) {
        if (string.startsWith("\"") && (string = string.substring(1)).endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void showHelp() {
        boolean bl = true;
        int n = 0;
        System.out.println("");
        while (bl) {
            String string = HELP_PREFIX + ++n;
            String string2 = new WebUtilException(string).getLocalizedMessage();
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2.equals("EOM") || string2.equals(string)) break;
            System.out.println(string2);
        }
        System.out.println("");
    }

    private String getOptionValue(int n, String[] stringArray, String string, String string2) throws WebUtilException {
        if (n >= stringArray.length) {
            throw new WebUtilException("cli_err_09", string.substring(2));
        }
        if (stringArray[n].startsWith("-")) {
            throw new WebUtilException("cli_err_09", string.substring(2));
        }
        if (string2 != null) {
            throw new WebUtilException("cli_err_10", string.substring(2));
        }
        return stringArray[n];
    }

    private void printInfo(String string, String string2) {
        this.printMessage(2, string, string2, null, null);
    }

    private void printWarning(String string, String string2) {
        this.printMessage(1, string, string2, null, null);
    }

    private void printError(String string, String string2) {
        this.printMessage(0, string, string2, null, null);
    }

    private void printMessage(int n, String string, String string2, String string3, String string4) {
        WebUtilException webUtilException = new WebUtilException(string, string2 == null ? "(null)" : string2, string3 == null ? "(null)" : string3, string4 == null ? "(null)" : string4);
        this.printMessage(n, webUtilException);
    }

    private void printMessage(int n, WebUtilException webUtilException) {
        String string = webUtilException.getLocalizedMessage();
        if (this.logger != null) {
            this.logger.log(string, n);
        } else if (n == 0) {
            System.err.println(string);
        } else {
            System.out.println(string);
        }
    }
}

