/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.management.services.registration.AppDescriptorParser;
import com.sun.management.services.registration.ManagementApp;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.web.util.GenerateProductImage;
import com.sun.web.util.WebUtilConstants;
import com.sun.web.util.WebUtilException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.xml.sax.InputSource;

public class ProductImageUtility {
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";
    public static final String VERSION = "version";
    public static final String ALL = "all";
    private static final String FS = File.separator;
    private static final int ERR_SUCCESS = 0;
    private static final int ERR_FAILURE = 1;
    private static final String LEGACY_PRODUCTNAME_FILE = "ProductNames";
    private static final String PRIMARY_FILENAME = "PrimaryProductName.png";
    private static final String SECONDARY_FILENAME = "SecondaryProductName.png";
    private static final String VERSION_FILENAME = "VersionProductName.png";
    private static final String PROPERTY_FILENAME = "ProductName.properties";
    private static final String PROP_HEADER = "Product name image properties";
    private static final String PROP_PRIMARY = "primary.";
    private static final String PROP_SECONDARY = "secondary.";
    private static final String PROP_VERSION = "version.";
    private static final String PROP_URI = "uri";
    private static final String PROP_HEIGHT = "height";
    private static final String PROP_WIDTH = "width";
    private static final String KEY_PROPERTY_FILENAME = "propertyFile";
    private static final String KEY_FONT_PATH = "fontLocation";
    private static final String KEY_PRIMARY_FILENAME = "primaryFilename";
    private static final String KEY_PRIMARY_FONTSIZE = "primaryFontSize";
    private static final String KEY_PRIMARY_HEIGHT = "primaryHeight";
    private static final String KEY_PRIMARY_FORECOLOR = "primaryForeColor";
    private static final String KEY_PRIMARY_BACKCOLOR = "primaryBackColor";
    private static final String KEY_PRIMARY_SECOND_FONTSIZE = "primarySecondFontSize";
    private static final String KEY_SECONDARY_FILENAME = "secondaryFilename";
    private static final String KEY_SECONDARY_FONTSIZE = "secondaryFontSize";
    private static final String KEY_SECONDARY_HEIGHT = "secondaryHeight";
    private static final String KEY_SECONDARY_FORECOLOR = "secondaryForeColor";
    private static final String KEY_SECONDARY_BACKCOLOR = "secondaryBackColor";
    private static final String KEY_SECONDARY_SECOND_FONTSIZE = "secondarySecondFontSize";
    private static final String KEY_VERSION_FILENAME = "versionFilename";
    private static final String KEY_VERSION_FONTSIZE = "versionFontSize";
    private static final String KEY_VERSION_HEIGHT = "versionHeight";
    private static final String KEY_VERSION_FORECOLOR = "versionForeColor";
    private static final String KEY_VERSION_BACKCOLOR = "versionBackColor";
    private static final String KEY_VERSION_SECOND_FONTSIZE = "versionSecondFontSize";
    private String consoledir = null;
    private HashMap legacy_map = null;
    private String resfile = null;
    private String prifile = "PrimaryProductName.png";
    private String secfile = "SecondaryProductName.png";
    private String verfile = "VersionProductName.png";
    private String propfile = "ProductName.properties";

    public ProductImageUtility(String string, String string2) throws WebUtilException {
        this.consoledir = string;
        if (string2 != null && string2.trim().length() > 0) {
            this.resfile = string2;
            File file = null;
            file = new File(this.resfile);
            if (!file.exists()) {
                throw new WebUtilException("image_err_12", this.resfile);
            }
        }
    }

    public void createImagesFromAppxml(String string, String string2, String string3) throws Exception {
        if (string2 == null) {
            throw new WebUtilException("image_err_16", "(null)");
        }
        File file = new File(string2);
        if (!file.exists()) {
            throw new WebUtilException("image_err_16", string2);
        }
        RegistrationInfo registrationInfo = this.parseXmlFile(string2);
        String[] stringArray = this.getNamesFromXmlFile(registrationInfo);
        if (stringArray[0] == null || stringArray[0].trim().length() == 0) {
            stringArray = this.getNamesFromLegacyFile(registrationInfo);
        }
        this.generateImages(string, stringArray, string3);
    }

    public void createImagesFromNames(String string, String string2, String string3) throws Exception {
        String[] stringArray = this.splitName(string2);
        this.generateImages(string, stringArray, string3);
    }

    public void generateImages(String string, String[] stringArray, String string2) throws Exception {
        Serializable serializable;
        String string3 = string.toLowerCase();
        if (PRIMARY.startsWith(string3)) {
            string = PRIMARY;
        } else if (SECONDARY.startsWith(string3)) {
            string = SECONDARY;
        } else if (VERSION.startsWith(string3)) {
            string = VERSION;
        } else if (ALL.startsWith(string3)) {
            string = ALL;
        }
        if (string == null) {
            throw new WebUtilException("image_err_02", string);
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new WebUtilException("image_err_04");
        }
        File file = new File(string2);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new WebUtilException("image_err_06", string2);
            }
        } else {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                throw new WebUtilException("image_err_05", string2, exception.getLocalizedMessage());
            }
        }
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (stringArray[0] == null || stringArray[0].trim().length() == 0) {
            throw new WebUtilException("image_err_03");
        }
        string4 = stringArray[0].trim();
        string5 = stringArray[1] != null && stringArray[1].trim().length() > 0 ? stringArray[1].trim() : string4;
        string6 = stringArray[2] != null && stringArray[2].trim().length() > 0 ? stringArray[2].trim() : string4;
        GenerateProductImage generateProductImage = null;
        try {
            generateProductImage = new GenerateProductImage();
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_13", exception.getLocalizedMessage());
        }
        Properties properties = null;
        if (this.resfile != null && ((File)(serializable = new File(this.resfile))).exists()) {
            properties = this.getResourceProperties(this.resfile);
            this.setResourceProperties(generateProductImage, properties);
        }
        generateProductImage.initialize();
        serializable = new Properties();
        String string7 = string2 + FS + this.propfile;
        File file2 = new File(string7);
        if (file2.exists()) {
            serializable = this.getResourceProperties(string7);
        }
        BufferedImage bufferedImage = null;
        String string8 = null;
        if (string.equals(PRIMARY) || string.equals(ALL)) {
            try {
                string8 = string2 + FS + this.prifile;
                bufferedImage = generateProductImage.GeneratePrimaryImage(string4);
                this.writeImage(bufferedImage, string8);
                ((Properties)serializable).setProperty("primary.uri", "/com_sun_web_ui/images/" + this.prifile);
                ((Properties)serializable).setProperty("primary.height", String.valueOf(bufferedImage.getHeight()));
                ((Properties)serializable).setProperty("primary.width", String.valueOf(bufferedImage.getWidth()));
                bufferedImage.flush();
            }
            catch (Exception exception) {
                throw new WebUtilException("image_err_08", PRIMARY, exception.getLocalizedMessage());
            }
        }
        if (string.equals(SECONDARY) || string.equals(ALL)) {
            try {
                string8 = string2 + FS + this.secfile;
                bufferedImage = generateProductImage.GenerateSecondaryImage(string5);
                this.writeImage(bufferedImage, string8);
                ((Properties)serializable).setProperty("secondary.uri", "/com_sun_web_ui/images/" + this.secfile);
                ((Properties)serializable).setProperty("secondary.height", String.valueOf(bufferedImage.getHeight()));
                ((Properties)serializable).setProperty("secondary.width", String.valueOf(bufferedImage.getWidth()));
                bufferedImage.flush();
            }
            catch (Exception exception) {
                throw new WebUtilException("image_err_08", SECONDARY, exception.getLocalizedMessage());
            }
        }
        if (string.equals(VERSION) || string.equals(ALL)) {
            try {
                string8 = string2 + FS + this.verfile;
                bufferedImage = generateProductImage.GenerateVersionImage(string6);
                this.writeImage(bufferedImage, string8);
                ((Properties)serializable).setProperty("version.uri", "/com_sun_web_ui/images/" + this.verfile);
                ((Properties)serializable).setProperty("version.height", String.valueOf(bufferedImage.getHeight()));
                ((Properties)serializable).setProperty("version.width", String.valueOf(bufferedImage.getWidth()));
                bufferedImage.flush();
            }
            catch (Exception exception) {
                throw new WebUtilException("image_err_08", VERSION, exception.getLocalizedMessage());
            }
        }
        File file3 = new File(string7);
        try {
            if (file3.exists()) {
                file3.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string7);
            ((Properties)serializable).store(fileOutputStream, PROP_HEADER);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_9", string7, exception.getLocalizedMessage());
        }
    }

    public void writeImage(BufferedImage bufferedImage, String string) throws Exception {
        String string2 = string;
        if (!string2.endsWith(".png")) {
            string2 = string2 + ".png";
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_10", string2, exception.getLocalizedMessage());
        }
    }

    private Properties getResourceProperties(String string) throws Exception {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_11", string, exception.getLocalizedMessage());
        }
        return properties;
    }

    private void setResourceProperties(GenerateProductImage generateProductImage, Properties properties) throws Exception {
        String string = null;
        String string2 = null;
        try {
            string = KEY_PRIMARY_FILENAME;
            string2 = properties.getProperty(string);
            if (string2 != null && string2.length() > 0) {
                this.prifile = string2;
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_FILENAME)) != null && string2.length() > 0) {
                this.secfile = string2;
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_FILENAME)) != null && string2.length() > 0) {
                this.verfile = string2;
            }
            if ((string2 = properties.getProperty(string = KEY_PROPERTY_FILENAME)) != null && string2.length() > 0) {
                this.propfile = string2;
            }
            if ((string2 = properties.getProperty(KEY_FONT_PATH)) != null && string2.length() > 0) {
                generateProductImage.setFontLocation(string2);
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_FONTSIZE)) != null) {
                generateProductImage.setPrimaryFontSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_HEIGHT)) != null) {
                generateProductImage.setPrimaryHeight(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_FORECOLOR)) != null) {
                generateProductImage.setPrimaryForegroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_BACKCOLOR)) != null) {
                generateProductImage.setPrimaryBackgroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_PRIMARY_SECOND_FONTSIZE)) != null) {
                generateProductImage.setPrimarySecondLineSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_FONTSIZE)) != null) {
                generateProductImage.setSecondaryFontSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_HEIGHT)) != null) {
                generateProductImage.setSecondaryHeight(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_FORECOLOR)) != null) {
                generateProductImage.setSecondaryForegroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_SECONDARY_BACKCOLOR)) != null) {
                generateProductImage.setSecondaryBackgroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_FONTSIZE)) != null) {
                generateProductImage.setVersionFontSize(Float.parseFloat(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_HEIGHT)) != null) {
                generateProductImage.setVersionHeight(Integer.parseInt(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_FORECOLOR)) != null) {
                generateProductImage.setVersionForegroundColor(Color.decode(string2));
            }
            if ((string2 = properties.getProperty(string = KEY_VERSION_BACKCOLOR)) != null) {
                generateProductImage.setVersionBackgroundColor(Color.decode(string2));
            }
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_14", string, string2);
        }
    }

    private RegistrationInfo parseXmlFile(String string) throws Exception {
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        String string2 = "file://" + this.consoledir.replace('\\', '/') + "/private/system/";
        InputSource inputSource = null;
        try {
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            inputSource = new InputSource(bufferedReader);
            inputSource.setSystemId(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WebUtilException("image_err_16", string);
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_17", string, exception.getLocalizedMessage());
        }
        fileInputStream = new AppDescriptorParser(false);
        inputStreamReader = null;
        try {
            inputStreamReader = fileInputStream.parse(inputSource);
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_17", string, exception.getLocalizedMessage());
        }
        return inputStreamReader;
    }

    private String[] getNamesFromXmlFile(RegistrationInfo registrationInfo) {
        ManagementApp managementApp = registrationInfo.getManagementApp();
        String string = managementApp.getPrimaryProductName();
        String string2 = managementApp.getSecondaryProductName();
        String string3 = managementApp.getVersionProductName();
        String[] stringArray = new String[]{string, string2, string3};
        return stringArray;
    }

    private String[] getNamesFromLegacyFile(RegistrationInfo registrationInfo) throws WebUtilException {
        String string;
        String[] stringArray = new String[]{null, null, null};
        ManagementApp managementApp = registrationInfo.getManagementApp();
        String string2 = managementApp.getPluginName();
        if (this.legacy_map == null) {
            this.legacy_map = this.readLegacyFile();
        }
        if ((string = (String)this.legacy_map.get(string2)) != null) {
            stringArray = this.splitName(string);
        }
        return stringArray;
    }

    private HashMap readLegacyFile() throws WebUtilException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.consoledir + WebUtilConstants.SYSTEM_SUBDIR + FS + LEGACY_PRODUCTNAME_FILE;
        File file = new File(string);
        if (!file.exists()) {
            return hashMap;
        }
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        Object var7_7 = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "ISO-8859-1");
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_22", exception.getLocalizedMessage());
        }
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#") || (n = string2.indexOf("|")) <= 0) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                hashMap.put(string3, string4);
            }
        }
        catch (Exception exception) {
            throw new WebUtilException("image_err_22", exception.getLocalizedMessage());
        }
        return hashMap;
    }

    private String[] splitName(String string) {
        String[] stringArray = new String[]{null, null, null};
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            stringArray[0] = stringTokenizer.nextToken();
        }
        if (n > 1) {
            stringArray[1] = stringTokenizer.nextToken();
        }
        if (n > 2) {
            stringArray[2] = stringTokenizer.nextToken();
        }
        return stringArray;
    }
}

