/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.management.services.common.ConsoleInfo;
import com.sun.web.util.CliSubcommand;
import com.sun.web.util.WebUtilException;
import java.lang.reflect.Constructor;

public class WebappCliDriver {
    private static final String OPT_VERS_SHORT = "-V";
    private static final String OPT_VERS_LONG = "--version";
    private static String[][] subcommands = new String[][]{{"create", "com.sun.web.util.CliCreate"}, {"import", "com.sun.web.util.CliImport"}, {"prodname", "com.sun.web.util.CliProductImage"}, {"validate", "com.sun.web.util.CliXmlChecker"}};

    public static void main(String[] stringArray) {
        WebUtilException webUtilException;
        String string = null;
        int n = 0;
        String string2 = System.getProperty("com.sun.web.console.home");
        if (string2 == null) {
            webUtilException = new WebUtilException("cli_err_01");
            System.err.println(webUtilException.getLocalizedMessage());
            System.exit(2);
        }
        if (stringArray.length < 1) {
            webUtilException = new WebUtilException("cli_err_02");
            System.err.println(webUtilException.getLocalizedMessage());
            System.exit(2);
        }
        if ((string = stringArray[0]).equals("-h") || string.equals("--help") || string.equals("-?")) {
            WebappCliDriver.showHelp(string2);
        } else if (string.equals(OPT_VERS_SHORT) || string.equals(OPT_VERS_LONG)) {
            WebappCliDriver.showVersion(string2);
        } else {
            boolean bl = false;
            for (int i = 0; i < subcommands.length; ++i) {
                String string3 = subcommands[i][0];
                if (!string.equals(string3)) continue;
                String string4 = subcommands[i][1];
                n = WebappCliDriver.executeSubcommand(string2, string3, string4, stringArray);
                bl = true;
                break;
            }
            if (!bl) {
                WebUtilException webUtilException2 = new WebUtilException("cli_err_03", string);
                System.err.println(webUtilException2.getLocalizedMessage());
                n = 2;
            }
        }
        System.exit(n);
    }

    protected WebappCliDriver() {
    }

    private static int executeSubcommand(String string, String string2, String string3, String[] stringArray) {
        WebUtilException webUtilException = null;
        int n = 0;
        try {
            CliSubcommand cliSubcommand = WebappCliDriver.getSubcommandInstance(string, string2, string3);
            n = cliSubcommand.execute(stringArray);
        }
        catch (WebUtilException webUtilException2) {
            webUtilException = webUtilException2;
            n = 2;
        }
        catch (Exception exception) {
            webUtilException = new WebUtilException("cli_err_04", string2, exception.getLocalizedMessage());
            n = 2;
        }
        if (webUtilException != null) {
            System.err.println(webUtilException.getLocalizedMessage());
        }
        return n;
    }

    private static void showUsage(String string) {
        WebappCliDriver.printMessage(new WebUtilException("usage_01"));
        WebappCliDriver.printMessage(new WebUtilException("usage_02"));
        WebappCliDriver.printMessage(new WebUtilException("usage_03"));
    }

    private static void showHelp(String string) {
        WebappCliDriver.printMessage(" ");
        WebappCliDriver.showUsage(string);
        WebappCliDriver.printMessage(" ");
        WebappCliDriver.printMessage(new WebUtilException("usage_04"));
        WebappCliDriver.printMessage(new WebUtilException("usage_05"));
        WebappCliDriver.printMessage(" ");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < subcommands.length; ++i) {
            Object object;
            string2 = subcommands[i][0];
            string3 = subcommands[i][1];
            try {
                object = WebappCliDriver.getSubcommandInstance(string, string2, string3);
                string4 = object.getDescription();
            }
            catch (Exception exception) {
                WebUtilException webUtilException = new WebUtilException("cli_err_05", exception.getLocalizedMessage());
                string4 = webUtilException.getLocalizedMessage();
            }
            object = string2 + "       ";
            object = ((String)object).substring(0, 8);
            WebappCliDriver.printMessage("    " + (String)object + "  " + string4);
            WebappCliDriver.printMessage(" ");
        }
        WebappCliDriver.printMessage(new WebUtilException("usage_06"));
        WebappCliDriver.printMessage(new WebUtilException("usage_07"));
        WebappCliDriver.printMessage(" ");
        WebappCliDriver.printMessage(new WebUtilException("usage_08"));
        WebappCliDriver.printMessage(new WebUtilException("usage_09"));
        WebappCliDriver.printMessage(" ");
        WebappCliDriver.printMessage(new WebUtilException("usage_10"));
        WebappCliDriver.printMessage(" ");
    }

    private static void showVersion(String string) {
        String string2 = ConsoleInfo.getProductName() + " " + ConsoleInfo.getDisplayVersion();
        System.out.println(string2);
    }

    private static CliSubcommand getSubcommandInstance(String string, String string2, String string3) throws WebUtilException {
        CliSubcommand cliSubcommand = null;
        try {
            Class<?> clazz = Class.forName(string3);
            Class[] classArray = new Class[]{String.class};
            Object[] objectArray = new Object[]{string};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            cliSubcommand = (CliSubcommand)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebUtilException("cli_err_06", string2, string3);
        }
        catch (Exception exception) {
            throw new WebUtilException("cli_err_07", string2, exception.getLocalizedMessage());
        }
        return cliSubcommand;
    }

    private static void printMessage(WebUtilException webUtilException) {
        WebappCliDriver.printMessage(webUtilException.getLocalizedMessage());
    }

    private static void printMessage(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(2, string.length() - 1);
        }
        System.out.println(string);
    }
}

