/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.fsmgr.fstype;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.fsmgr.common.FsMgrException;
import com.sun.wbem.solarisprovider.fsmgr.common.Solaris_FileSystem_Native;
import com.sun.wbem.utility.common.CommonTools;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;

public class Solaris_Directory
implements InstanceProvider,
MethodProvider,
Authorizable {
    private static final String FSMGR_READ_RIGHT = "solaris.admin.fsmgr.read";
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil;
    private static final String SOLARIS_DIR = "Solaris_Directory";
    private static final String NFS = "nfs";
    private static final String UFS = "ufs";
    private static final String HSFS = "hsfs";
    private static final String SOLARIS_NFS = "Solaris_NFS";
    private static final String SOLARIS_UFS = "Solaris_UFS";
    private static final String SOLARIS_HSFS = "Solaris_HSFS";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String CIM_FS = "CIM_FileSystem";
    private static final String CS_NAME = "CSName";
    private static final String CS_CREAT_CLASS = "CSCreationClassName";
    private static final String FS_CREAT_CLASS = "FSCreationClassName";
    private static final String FS_NAME = "FSName";
    private static final String CREAT_CLASS = "CreationClassName";
    private static final String NAME = "Name";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, SOLARIS_DIR);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        return null;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        Object object;
        String string = null;
        CIMInstance cIMInstance = cIMClass.newInstance();
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (!object.getName().equalsIgnoreCase(NAME)) continue;
            string = (String)object.getValue().getValue();
        }
        if (string == null) {
            throw new CIMProviderException("CIM_ERR_INVALID_PARAMETER");
        }
        object = new File(string);
        if (!((File)object).exists()) {
            throw new CIMProviderException("CIM_ERR_INVALID_PARAMETER");
        }
        cIMInstance.setProperty(NAME, new CIMValue((Object)string));
        String string2 = Solaris_FileSystem_Native.GetFSType(string);
        if (string2 == null) {
            throw new CIMProviderException("CIM_ERR_FAILED");
        }
        cIMInstance.setProperty(FS_NAME, new CIMValue((Object)string2));
        if (string2.equalsIgnoreCase(NFS)) {
            cIMInstance.setProperty(FS_CREAT_CLASS, new CIMValue((Object)SOLARIS_NFS));
        } else if (string2.equalsIgnoreCase(UFS)) {
            cIMInstance.setProperty(FS_CREAT_CLASS, new CIMValue((Object)SOLARIS_UFS));
        } else if (string2.equalsIgnoreCase(HSFS)) {
            cIMInstance.setProperty(FS_CREAT_CLASS, new CIMValue((Object)SOLARIS_HSFS));
        } else {
            cIMInstance.setProperty(FS_CREAT_CLASS, new CIMValue((Object)CIM_FS));
        }
        cIMInstance.setProperty(CREAT_CLASS, new CIMValue((Object)SOLARIS_DIR));
        cIMInstance.setProperty(CS_CREAT_CLASS, new CIMValue((Object)SOLARIS_CS));
        try {
            cIMInstance.setProperty(CS_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception exception) {
            String string3 = this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)string3);
        }
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        this.provUtil.checkRights(FSMGR_READ_RIGHT, cIMObjectPath);
        try {
            if (string.equalsIgnoreCase("getFile")) {
                String string2 = (String)((CIMValue)vector.elementAt(0)).getValue();
                return new CIMValue((Object)this.getFile(string2, vector2));
            }
            if (string.equalsIgnoreCase("getDirectoryList")) {
                String string3 = (String)((CIMValue)vector.elementAt(0)).getValue();
                return new CIMValue((Object)this.getDirectoryList(string3, vector2));
            }
            if (string.equalsIgnoreCase("makeDirectory")) {
                String string4 = (String)((CIMValue)vector.elementAt(0)).getValue();
                return new CIMValue((Object)this.makeDirectory(string4, vector2));
            }
            if (string.equalsIgnoreCase("getFilesystemType")) {
                String string5 = (String)((CIMValue)vector.elementAt(0)).getValue();
                return new CIMValue((Object)this.getFSType(string5, vector2));
            }
        }
        catch (FsMgrException fsMgrException) {
            String string6 = this.provUtil.writeLog(2, (Exception)((Object)fsMgrException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string6);
        }
        return null;
    }

    public Integer getFSType(String string, Vector vector) {
        if (string == null) {
            return new Integer(-1);
        }
        String string2 = Solaris_FileSystem_Native.GetFSType(string);
        CIMValue cIMValue = new CIMValue((Object)string2);
        vector.addElement(cIMValue);
        return new Integer(0);
    }

    public Integer getFile(String string, Vector vector) throws FsMgrException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new FsMgrException("EXM_FSS_GETFILE_ERROR", string);
            }
            CIMValue cIMValue = new CIMValue((Object)file.getParent());
            vector.addElement(cIMValue);
            cIMValue = new CIMValue((Object)file.getName());
            vector.addElement(cIMValue);
            cIMValue = new CIMValue((Object)new Boolean(file.isDirectory()));
            vector.addElement(cIMValue);
        }
        catch (Exception exception) {
            throw new FsMgrException("EXM_FSS_GETFILE_ERROR", string);
        }
        return new Integer(0);
    }

    public Integer getDirectoryList(String string, Vector vector) throws FsMgrException {
        try {
            Vector<Boolean> vector2;
            Vector<String> vector3;
            Serializable serializable;
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                int n;
                String[] stringArray = file.list();
                String[] stringArray2 = new String[stringArray.length];
                String[] stringArray3 = new String[stringArray.length];
                Boolean[] booleanArray = new Boolean[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    serializable = new File(file, stringArray[i]);
                    stringArray2[i] = ((File)serializable).getParent();
                    stringArray3[i] = ((File)serializable).getName();
                    booleanArray[i] = new Boolean(((File)serializable).isDirectory());
                }
                vector3 = new Vector<String>(stringArray2.length);
                serializable = new Vector(stringArray3.length);
                vector2 = new Vector<Boolean>(booleanArray.length);
                for (n = 0; n < stringArray2.length; ++n) {
                    vector3.addElement(stringArray2[n]);
                }
                for (n = 0; n < stringArray3.length; ++n) {
                    ((Vector)serializable).addElement(stringArray3[n]);
                }
                for (n = 0; n < booleanArray.length; ++n) {
                    vector2.addElement(booleanArray[n]);
                }
            } else {
                throw new FsMgrException("EXM_FSS_GETLIST_ERROR", string);
            }
            CIMValue cIMValue = new CIMValue(vector3);
            vector.addElement(cIMValue);
            cIMValue = new CIMValue((Object)serializable);
            vector.addElement(cIMValue);
            cIMValue = new CIMValue(vector2);
            vector.addElement(cIMValue);
        }
        catch (Exception exception) {
            throw new FsMgrException("EXM_FSS_GETLIST_ERROR", string);
        }
        return new Integer(0);
    }

    public Integer makeDirectory(String string, Vector vector) throws FsMgrException {
        try {
            if (!this.mkdir(string)) {
                throw new FsMgrException("EXM_FSS_MAKEDIR_ERROR", string);
            }
            File file = new File(string);
            CIMValue cIMValue = new CIMValue((Object)file.getParent());
            vector.addElement(cIMValue);
            cIMValue = new CIMValue((Object)file.getName());
            vector.addElement(cIMValue);
            cIMValue = new CIMValue((Object)new Boolean(file.isDirectory()));
            vector.addElement(cIMValue);
        }
        catch (Exception exception) {
            throw new FsMgrException("EXM_FSS_MAKEDIR_ERROR", string);
        }
        return new Integer(0);
    }

    private boolean mkdir(String string) {
        boolean bl = false;
        File file = new File(string);
        if (!file.exists()) {
            bl = file.mkdirs();
            String string2 = "/usr/bin/chmod -f 777 ";
            string2 = string2.concat(file.getAbsolutePath());
            CommonTools.CMN_exec((String)string2);
        } else {
            bl = true;
        }
        return bl;
    }
}

