/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.Parse;
import com.sun.wbem.repository.PSRlogImpl;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMMethodException;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMPropertyException;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMQualifierTypeException;
import javax.wbem.cim.CIMScope;
import javax.wbem.cim.CIMSemanticException;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;

public class CIMOMUtils {
    private static int uniqueInt = 0;
    PSRlogImpl ps;

    CIMOMUtils(PSRlogImpl ps) {
        this.ps = ps;
    }

    PSRlogImpl getPS() {
        return this.ps;
    }

    private Object intTypeConvert(int type, Object value) {
        if (value == null) {
            return null;
        }
        Number number = null;
        if (value instanceof String) {
            String svalue = (String)value;
            switch (type) {
                case 13: {
                    throw new IllegalArgumentException();
                }
                case 12: {
                    return new CIMDateTime(svalue);
                }
                case 9: {
                    throw new IllegalArgumentException();
                }
                case 28: {
                    Parse p = new Parse();
                    return p.parseOp(svalue);
                }
            }
            number = new BigDecimal(svalue);
        }
        if (type == 12 || type == 9) {
            throw new IllegalArgumentException();
        }
        if (number == null) {
            number = (Number)value;
        }
        switch (type) {
            case 0: {
                return new UnsignedInt8(number.shortValue());
            }
            case 1: {
                return new Byte(number.byteValue());
            }
            case 2: {
                return new UnsignedInt16(number.intValue());
            }
            case 3: {
                return new Short(number.shortValue());
            }
            case 4: {
                return new UnsignedInt32(number.longValue());
            }
            case 5: {
                return new Integer(number.intValue());
            }
            case 6: {
                String s = number.toString();
                int dotIndex = s.indexOf(".");
                if (dotIndex == 0) {
                    s = "0";
                }
                if (dotIndex > 0) {
                    s = s.substring(0, dotIndex);
                }
                if (s.charAt(0) == '-') {
                    s = s.substring(1);
                }
                return new UnsignedInt64(s);
            }
            case 7: {
                return new Long(number.longValue());
            }
            case 10: {
                return new Float(number.floatValue());
            }
            case 11: {
                return new Double(number.doubleValue());
            }
            case 13: {
                return new Character((char)number.intValue());
            }
        }
        throw new IllegalArgumentException();
    }

    CIMValue typeConvert(CIMDataType dt, CIMValue cv) {
        if (cv == null || dt == null) {
            return cv;
        }
        Object value = cv.getValue();
        int cvt = CIMDataType.findType((Object)value);
        if (cvt == 30) {
            if (value instanceof Vector && !dt.isArrayType()) {
                throw new IllegalArgumentException(cv.toString());
            }
            return cv;
        }
        int cdt = dt.getType();
        if (cvt == cdt) {
            return cv;
        }
        if (dt.isArrayType() != cv.getType().isArrayType()) {
            throw new IllegalArgumentException(cv.toString());
        }
        if (dt.getType() == cv.getType().getType()) {
            return cv;
        }
        if (value instanceof Vector) {
            cdt = CIMDataType.findSimpleType((int)cdt);
            Vector<Object> nv = new Vector<Object>();
            Enumeration e = ((Vector)value).elements();
            while (e.hasMoreElements()) {
                nv.addElement(this.intTypeConvert(cdt, e.nextElement()));
            }
            return new CIMValue(nv, dt);
        }
        return new CIMValue(this.intTypeConvert(cdt, value));
    }

    void checkQualifier(String namespace, CIMQualifier cq) throws CIMException {
        CIMQualifierType cqt = this.ps.getQualifierType(namespace.toLowerCase(), cq.getName().toLowerCase());
        if (cqt == null) {
            throw new CIMSemanticException("NO_SUCH_QUALIFIER1", (Object)cq.getName());
        }
        CIMDataType dt = cqt.getType();
        if (!cq.hasValue() && dt.equals((Object)CIMDataType.getPredefinedType((int)9))) {
            cq.setValue(CIMValue.TRUE);
            cq.setDefaults(cqt);
        } else {
            cq.setDefaults(cqt);
        }
    }

    CIMQualifier createDefaultQualifier(String namespace, String qName) throws CIMException {
        CIMQualifierType cqt = this.ps.getQualifierType(namespace.toLowerCase(), qName.toLowerCase());
        if (cqt == null) {
            throw new CIMSemanticException("NO_SUCH_QUALIFIER1", (Object)qName);
        }
        return new CIMQualifier(qName, cqt);
    }

    public static synchronized String getUniqueString() {
        Calendar c = Calendar.getInstance();
        return new String(c.get(1) + ":" + c.get(2) + ":" + c.get(5) + ":" + c.get(10) + ":" + c.get(9) + ":" + c.get(12) + ":" + c.get(13) + ":" + ++uniqueInt);
    }

    void doCommonQualifierChecks(String namespace, String elementName, Vector qualifiers, CIMScope scope) throws CIMException {
        if (qualifiers == null) {
            return;
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String lcns = namespace.toLowerCase();
        Enumeration qe = qualifiers.elements();
        while (qe.hasMoreElements()) {
            CIMQualifier cq = (CIMQualifier)qe.nextElement();
            String tlc = cq.getName().toLowerCase();
            if (ht.get(tlc) != null) {
                throw new CIMSemanticException("CIM_ERR_INVALID_PARAMETER", (Object)cq);
            }
            ht.put(tlc, tlc);
            CIMQualifierType cqt = this.ps.getQualifierType(lcns, tlc);
            if (cqt == null) {
                throw new CIMSemanticException("NO_SUCH_QUALIFIER2", (Object)elementName, (Object)cq.getName());
            }
            CIMDataType dt = cqt.getType();
            if (!cq.hasValue() && dt.equals((Object)CIMDataType.getPredefinedType((int)9))) {
                cq.setValue(CIMValue.TRUE);
                cq.setDefaults(cqt);
            } else {
                try {
                    cq.setValue(this.typeConvert(cqt.getType(), cq.getValue()));
                }
                catch (Exception e) {
                    throw new CIMQualifierTypeException("TYPE_ERROR", new Object[]{cqt.getName(), "", cqt.getType(), cq.getValue().getType(), cq.getValue()});
                }
                cq.setDefaults(cqt);
            }
            this.assignQualifierDefaultFlavor(cq);
            if (cqt.hasScope(scope)) continue;
            if (scope.equals((Object)CIMScope.getScope((int)1)) || scope.equals((Object)CIMScope.getScope((int)2))) {
                throw new CIMClassException("SCOPE_ERROR", (Object)elementName, (Object)cq.getName(), (Object)scope);
            }
            if (scope.equals((Object)CIMScope.getScope((int)4)) || scope.equals((Object)CIMScope.getScope((int)5))) {
                throw new CIMPropertyException("SCOPE_ERROR", (Object)elementName, (Object)cq.getName(), (Object)scope);
            }
            if (scope.equals((Object)CIMScope.getScope((int)6)) || scope.equals((Object)CIMScope.getScope((int)7))) {
                throw new CIMMethodException("SCOPE_ERROR", (Object)elementName, (Object)cq.getName(), (Object)scope);
            }
            throw new CIMSemanticException("SCOPE_ERROR", (Object)elementName, (Object)cq.getName(), (Object)scope);
        }
    }

    void assignInheritedQualifiers(Vector qualifiers, Vector inheritedQualifiers) {
        if (inheritedQualifiers != null) {
            if (qualifiers == null) {
                qualifiers = new Vector<Object>();
            }
            Enumeration iterator = inheritedQualifiers.elements();
            while (iterator.hasMoreElements()) {
                CIMQualifier pos = (CIMQualifier)iterator.nextElement();
                if (!pos.hasFlavor(CIMFlavor.getFlavor((int)3))) continue;
                if (qualifiers.contains(new CIMQualifier(pos.getName()))) {
                    if (pos.hasFlavor(CIMFlavor.getFlavor((int)0))) continue;
                    qualifiers.removeElement(new CIMQualifier(pos.getName()));
                    qualifiers.addElement(pos.clone());
                    continue;
                }
                qualifiers.addElement(pos.clone());
            }
        }
    }

    private void assignQualifierDefaultFlavor(CIMQualifier qt) {
        if (qt == null) {
            return;
        }
        if (!(qt.hasFlavor(new CIMFlavor(0)) || qt.hasFlavor(new CIMFlavor(1)) || qt.hasFlavor(new CIMFlavor(2)))) {
            qt.addFlavor(new CIMFlavor(0));
        }
        if (!qt.hasFlavor(new CIMFlavor(3)) && !qt.hasFlavor(new CIMFlavor(2))) {
            qt.addFlavor(new CIMFlavor(3));
        }
    }

    private Vector getLocalProps(Vector props, String className) {
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        Enumeration e = props.elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getOriginClass().equalsIgnoreCase(className)) continue;
            v.addElement(cp);
        }
        return v;
    }

    private Vector getLocalMethods(Vector methods, String className) {
        Vector<CIMMethod> v = new Vector<CIMMethod>();
        Enumeration e = methods.elements();
        while (e.hasMoreElements()) {
            CIMMethod cm = (CIMMethod)e.nextElement();
            if (!cm.getOriginClass().equalsIgnoreCase(className)) continue;
            v.addElement(cm);
        }
        return v;
    }

    CIMInstance getLocal(CIMInstance ci) {
        if (ci == null) {
            return null;
        }
        ci.setProperties(this.getLocalProps(ci.getProperties(), ci.getClassName()));
        return ci;
    }

    CIMClass getLocal(CIMClass cc) {
        if (cc == null) {
            return null;
        }
        cc.setProperties(this.getLocalProps(cc.getProperties(), cc.getName()));
        cc.setMethods(this.getLocalMethods(cc.getMethods(), cc.getName()));
        return cc;
    }
}

