/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMImpl;
import com.sun.wbem.cimom.CIMOMUtils;
import com.sun.wbem.cimom.CommonServerSecurityContext;
import com.sun.wbem.cimom.DeliveryHandler;
import com.sun.wbem.cimom.FilterActivation;
import com.sun.wbem.cimom.IndicationPoller;
import com.sun.wbem.cimom.InternalProviderAdapter;
import com.sun.wbem.cimom.LogFile;
import com.sun.wbem.cimom.ReadersWriter;
import com.sun.wbem.cimom.ServerSecurity;
import com.sun.wbem.cimom.TaskManager;
import com.sun.wbem.repository.PSRlogImpl;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.query.AttributeExp;
import javax.wbem.query.SelectList;

public class EventService
implements InternalProviderAdapter.InternalServiceProvider {
    PSRlogImpl ps = null;
    CIMOMUtils cu = null;
    CIMOMImpl cimom = null;
    private IndicationPoller indicationPoller = null;
    ProviderCIMOMHandle pch = null;
    Map filterActivations = new TreeMap();
    private static int pingTime = 600000;
    static int pollInterval = 3000;
    static final String FILTERDELIVERYASSOC = "cim_indicationsubscription";
    static final String DELIVERYCLASS = "cim_indicationhandler";
    public static final String RMIDELIVERYCLASS = "solaris_rmidelivery";
    public static final String JRMIDELIVERYCLASS = "solaris_javaxrmidelivery";
    static final String CIMFILTERCLASS = "cim_indicationfilter";
    static final String FILTERPROPERTY = "filter";
    static final String DELIVERYPROPERTY = "handler";
    static final String OWNERPROP = "owner";
    public static final String HANDLERNAMEPROP = "name";
    static final String FILTERNAMEPROP = "name";
    static final String CCNPROP = "creationclassname";
    static final String QUERYPROP = "query";
    static final String QUERYLANGPROP = "querylanguage";
    static final String TARGETNSPROP = "sourceNameSpace";
    static final String SYSTEMCCNPROP = "systemcreationclassname";
    static final String SYSTEMNAMEPROP = "systemname";
    static final String SUBSCRIPTIONALIASPROP = "subscriptionalias";
    static final String CSNAME = "solaris_computersystem";
    public static EventService eventService = null;
    CIMInstanceProvider cim_filterdelivery = new CIM_FilterDelivery();
    CIMProvider cim_filter = new CIM_Filter();
    CIMInstanceProvider solaris_rmidelivery = new Solaris_RMIDelivery();
    String hostName;
    TaskManager tm = null;
    TaskManager.Task task;
    private ReadersWriter cfl = new ReadersWriter();
    private Map classFilterMap = new HashMap();
    private static final int LCLISTSIZE = 8;

    private void removeDelivery(CIMObjectPath delivery, CIMObjectPath assocOp) {
        Vector tv = null;
        try {
            LogFile.add(1, "REMOVING_HANDLER", delivery.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            tv = this.ps.referenceNames(assocOp, delivery, "");
        }
        catch (Exception e) {
            Debug.trace2((String)"Remove delivery failed", (Throwable)e);
            return;
        }
        Enumeration enum1 = tv.elements();
        while (enum1.hasMoreElements()) {
            CIMObjectPath assoc = (CIMObjectPath)enum1.nextElement();
            try {
                this.pch.deleteInstance(assoc);
            }
            catch (Exception e) {}
        }
        try {
            this.pch.deleteInstance(delivery);
        }
        catch (CIMException e) {
            // empty catch block
        }
    }

    public String[] getProviderNames() {
        return new String[]{FILTERDELIVERYASSOC, RMIDELIVERYCLASS, JRMIDELIVERYCLASS, CIMFILTERCLASS};
    }

    public CIMProvider getProvider(String className) throws CIMException {
        if (className.equals(FILTERDELIVERYASSOC)) {
            return this.cim_filterdelivery;
        }
        if (className.equals(RMIDELIVERYCLASS)) {
            return this.solaris_rmidelivery;
        }
        if (className.equals(JRMIDELIVERYCLASS)) {
            return this.solaris_rmidelivery;
        }
        if (className.equals(CIMFILTERCLASS)) {
            return this.cim_filter;
        }
        throw new CIMProviderException("NO_INSTANCE_PROVIDER", (Object)className);
    }

    IndicationPoller getIndicationPoller() {
        return this.indicationPoller;
    }

    private int getOffset(int eventType, boolean polled) {
        if (eventType < 0) {
            return 0;
        }
        if (eventType < 3) {
            if (polled) {
                return eventType * 2;
            }
            return eventType * 2 + 1;
        }
        return eventType + 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addClassFilter(String className, FilterActivation.SubActivation sa, boolean polled) {
        boolean returnFlag = false;
        this.cfl.writeLock();
        try {
            ArrayList filterList = (ArrayList)this.classFilterMap.get(className);
            int offset = this.getOffset(sa.getEventType(), polled);
            if (filterList == null) {
                filterList = new ArrayList();
                for (int i = 0; i < 8; ++i) {
                    filterList.add(new ArrayList());
                }
                List filterSubList = (List)filterList.get(offset);
                filterSubList.add(sa);
                this.classFilterMap.put(className, filterList);
                returnFlag = true;
            } else {
                List filterSubList = (List)filterList.get(offset);
                if (filterSubList.size() == 0) {
                    returnFlag = true;
                }
                filterSubList.add(sa);
            }
        }
        finally {
            this.cfl.writeUnlock();
        }
        return returnFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeClassFilter(String className, FilterActivation.SubActivation sa, boolean polled) {
        boolean returnFlag = false;
        this.cfl.writeLock();
        try {
            int i;
            int offset = this.getOffset(sa.getEventType(), polled);
            List filterList = (List)this.classFilterMap.get(className);
            if (filterList == null) {
                boolean bl = false;
                return bl;
            }
            List filterSubList = (List)filterList.get(offset);
            filterSubList.remove(sa);
            if (filterSubList.size() == 0) {
                returnFlag = true;
            }
            for (i = 0; i < 8 && ((List)filterList.get(i)).size() == 0; ++i) {
            }
            if (i == 8) {
                this.classFilterMap.remove(className);
            }
        }
        finally {
            this.cfl.writeUnlock();
        }
        return returnFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getClassFilters(String className, String eventTypeString, boolean polled) {
        this.cfl.readLock();
        className = className.toLowerCase();
        int eventType = FilterActivation.determineEventType(eventTypeString);
        try {
            List filterList = (List)this.classFilterMap.get(className);
            if (filterList == null) {
                List list = null;
                return list;
            }
            Object filterSubList1 = null;
            Object filterSubList2 = null;
            int offset = this.getOffset(eventType, polled);
            List list = (List)filterList.get(offset);
            return list;
        }
        finally {
            this.cfl.readUnlock();
        }
    }

    private void activateFilters() throws CIMException {
        Enumeration enum1 = this.ps.enumerateNameSpace("", true).elements();
        CIMObjectPath assocOp = new CIMObjectPath(FILTERDELIVERYASSOC);
        while (enum1.hasMoreElements()) {
            CIMObjectPath op = new CIMObjectPath("", (String)enum1.nextElement());
            op.setObjectName(CIMFILTERCLASS);
            assocOp.setNameSpace(op.getNameSpace());
            Enumeration instenum = null;
            try {
                instenum = this.ps.enumerateInstances(op, false, false).elements();
            }
            catch (CIMException e) {
                continue;
            }
            while (instenum.hasMoreElements()) {
                CIMInstance filterInstance = (CIMInstance)instenum.nextElement();
                CIMObjectPath filterOp = new CIMObjectPath(filterInstance.getClassName().toLowerCase());
                filterOp.setKeys(filterInstance.getKeyValuePairs());
                filterOp.setNameSpace(op.getNameSpace().toLowerCase());
                Vector tv = null;
                try {
                    tv = this.ps.referenceNames(assocOp, filterOp, "");
                }
                catch (CIMException e) {
                    continue;
                }
                ArrayList<CIMInstance> handlerSubscriptionList = new ArrayList<CIMInstance>();
                if (tv.size() == 0) continue;
                boolean mustActivate = false;
                Enumeration deliveryEnum = tv.elements();
                while (deliveryEnum.hasMoreElements()) {
                    CIMObjectPath filterDeliveryOp = (CIMObjectPath)deliveryEnum.nextElement();
                    CIMObjectPath deliveryOp = null;
                    Enumeration keyEnum = filterDeliveryOp.getKeys().elements();
                    while (keyEnum.hasMoreElements()) {
                        CIMProperty cp = (CIMProperty)keyEnum.nextElement();
                        if (!cp.getName().equalsIgnoreCase(DELIVERYPROPERTY)) continue;
                        try {
                            deliveryOp = (CIMObjectPath)cp.getValue().getValue();
                        }
                        catch (NullPointerException e) {}
                    }
                    if (DeliveryHandler.isTransient(deliveryOp)) {
                        this.ps.deleteInstance(filterDeliveryOp);
                        try {
                            this.ps.deleteInstance(deliveryOp);
                        }
                        catch (CIMException oe) {}
                        continue;
                    }
                    handlerSubscriptionList.add(this.ps.getInstance(deliveryOp));
                    handlerSubscriptionList.add(this.ps.getInstance(filterDeliveryOp));
                    mustActivate = true;
                }
                if (!mustActivate) continue;
                Iterator i = handlerSubscriptionList.iterator();
                CIMInstance handlerInstance = (CIMInstance)i.next();
                CIMInstance subscriptionInstance = (CIMInstance)i.next();
                FilterActivation fa = new FilterActivation(filterOp, filterInstance, this);
                fa.run();
                fa.getPollInfo(handlerInstance, subscriptionInstance);
                fa.activate(handlerInstance, subscriptionInstance);
                this.filterActivations.put(filterOp.toString(), fa);
                while (i.hasNext()) {
                    handlerInstance = (CIMInstance)i.next();
                    subscriptionInstance = (CIMInstance)i.next();
                    fa.activateSubscription(handlerInstance, subscriptionInstance);
                }
            }
        }
    }

    public EventService(PSRlogImpl ps, CIMOMUtils cu, CIMOMImpl cimom, ProviderCIMOMHandle pch, Properties props) throws Exception {
        this.ps = ps;
        this.cu = cu;
        this.cimom = cimom;
        this.pch = pch;
        this.indicationPoller = new IndicationPoller(pch);
        String pollIntervalString = props.getProperty("com.sun.wbem.cimom.pollInterval");
        if (pollIntervalString != null) {
            pollInterval = Integer.parseInt(pollIntervalString) * 1000;
        }
        try {
            this.activateFilters();
        }
        catch (Exception e) {
            try {
                LogFile.add(0, "INDICATION_HANDLER_ERROR", e.toString());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.hostName = "";
        }
        try {
            this.tm = new TaskManager();
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
        eventService = this;
        new HandlerChecker().start();
    }

    public void deliverEvent(String namespace, CIMInstance ci) {
        this.task = new IndicationDeliverer(namespace, ci);
        this.tm.add(this.task);
    }

    public void deliverEvent(String namespace, CIMInstance ci, boolean polled) {
        this.task = new IndicationDeliverer(namespace, ci, polled);
        this.tm.add(this.task);
    }

    public void deliverEvent(CIMInstance ci, CIMObjectPath[] matchedFilterOps) {
        this.task = new IndicationDeliverer(ci, matchedFilterOps);
        this.tm.add(this.task);
    }

    private class IndicationDeliverer
    implements TaskManager.Task {
        CIMInstance ci;
        String namespace;
        boolean polled = false;
        CIMObjectPath[] matchedFilterOps = null;

        IndicationDeliverer(String namespace, CIMInstance ci) {
            this.ci = ci;
            CIMObjectPath tOp = new CIMObjectPath();
            tOp.setNameSpace(namespace);
            this.namespace = tOp.getNameSpace();
        }

        IndicationDeliverer(String namespace, CIMInstance ci, boolean polled) {
            this.ci = ci;
            CIMObjectPath tOp = new CIMObjectPath();
            tOp.setNameSpace(namespace);
            this.namespace = tOp.getNameSpace();
            this.polled = polled;
        }

        IndicationDeliverer(CIMInstance ci, CIMObjectPath[] matchedFilterOps) {
            this.ci = ci;
            this.matchedFilterOps = matchedFilterOps;
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }

        private void getProperty(CIMInstance inci, CIMInstance outci, String attrName) {
            Vector propVec = outci.getProperties();
            outci.setClassName(inci.getClassName());
            StringTokenizer st = null;
            try {
                st = new StringTokenizer(attrName, ".");
            }
            catch (Exception e) {
                return;
            }
            String token1 = (String)st.nextElement();
            String token2 = null;
            try {
                token2 = (String)st.nextElement();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (token2 == null) {
                CIMProperty cp = inci.getProperty(token1);
                boolean isInstance = false;
                try {
                    Object o = cp.getValue().getValue();
                    if (o instanceof CIMInstance) {
                        isInstance = true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int rindex = propVec.indexOf(cp);
                if (rindex == -1) {
                    propVec.add(cp);
                } else if (isInstance) {
                    propVec.remove(rindex);
                    propVec.insertElementAt(cp, rindex);
                }
            } else {
                CIMInstance tci;
                int index = propVec.indexOf(new CIMProperty(token1));
                if (index == -1) {
                    tci = new CIMInstance();
                    tci.setProperties(new Vector());
                    CIMProperty tcp = new CIMProperty(token1);
                    tcp.setValue(new CIMValue((Object)tci));
                    propVec.add(tcp);
                } else {
                    try {
                        tci = (CIMInstance)((CIMProperty)propVec.get(index)).getValue().getValue();
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                try {
                    CIMInstance tinci = (CIMInstance)inci.getProperty(token1).getValue().getValue();
                    this.getProperty(tinci, tci, attrName.substring(attrName.indexOf(".") + 1));
                }
                catch (Exception e) {
                    return;
                }
            }
        }

        private CIMInstance selectListIterator(SelectList sl, CIMInstance inci) throws CIMException {
            Enumeration e = sl.elements();
            CIMInstance ci = new CIMInstance();
            ci.setProperties(new Vector());
            while (e.hasMoreElements()) {
                String attr = ((AttributeExp)e.nextElement()).getAttributeName();
                if (attr.equals("*")) {
                    return inci;
                }
                this.getProperty(inci, ci, attr);
            }
            return ci;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deliverEvent(CIMInstance indication, List faList) throws Exception {
            for (FilterActivation fa : faList) {
                SelectList sl = fa.getParsedExp().getSelectList();
                CIMInstance selectedIndication = sl == null ? new CIMInstance() : (CIMInstance)sl.apply((CIMElement)indication);
                selectedIndication.setClassName(indication.getClassName());
                CIMObjectPath filterOp = fa.getFilterOp();
                CIMObjectPath assocOp = new CIMObjectPath();
                assocOp.setObjectName(EventService.FILTERDELIVERYASSOC);
                assocOp.setNameSpace(filterOp.getNameSpace());
                Vector tv = EventService.this.ps.associatorNames(assocOp, filterOp, EventService.DELIVERYCLASS, "", "");
                Enumeration e = tv.elements();
                while (e.hasMoreElements()) {
                    CIMObjectPath op = (CIMObjectPath)e.nextElement();
                    CIMInstance ci = EventService.this.ps.getInstance(op);
                    IndicationHandler ih = DeliveryHandler.getIndicationHandler(op.getObjectName());
                    if (ih != null) {
                        try {
                            ih.deliverEvent(new CIMEvent(selectedIndication), ci);
                            continue;
                        }
                        catch (Exception ex) {
                            Debug.trace2((String)"Delivery failed", (Throwable)ex);
                            CIMInstanceProvider cIMInstanceProvider = EventService.this.cim_filterdelivery;
                            synchronized (cIMInstanceProvider) {
                                EventService.this.removeDelivery(op, assocOp);
                                continue;
                            }
                        }
                    }
                    try {
                        LogFile.add(1, "NO_HANDLER", op.getObjectName());
                    }
                    catch (Exception ex) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.matchedFilterOps != null) {
                ArrayList<FilterActivation> matchedFilters = new ArrayList<FilterActivation>();
                for (int i = 0; i < this.matchedFilterOps.length; ++i) {
                    CIMObjectPath filterOp = this.matchedFilterOps[i];
                    if (filterOp == null) {
                        Debug.trace2((String)"Received a null filter op, ignoring it");
                        continue;
                    }
                    CIMInstance ci = null;
                    try {
                        ci = EventService.this.ps.getInstance(filterOp);
                    }
                    catch (CIMException ce) {
                        Debug.trace2((String)"Exception retrieving filter", (Throwable)ce);
                    }
                    if (ci == null) {
                        Debug.trace2((String)"Corresponding filter not found for op");
                        Debug.trace2((String)"Not delivering events");
                        return;
                    }
                    CIMObjectPath tempOp = new CIMObjectPath(filterOp.getObjectName().toLowerCase());
                    tempOp.setNameSpace(filterOp.getNameSpace().toLowerCase());
                    tempOp.setKeys(ci.getKeyValuePairs());
                    FilterActivation fa = (FilterActivation)EventService.this.filterActivations.get(tempOp.toString());
                    if (fa == null) {
                        Debug.trace2((String)("Cannot find activation for " + tempOp));
                        return;
                    }
                    matchedFilters.add(fa);
                }
                try {
                    this.deliverEvent(this.ci, matchedFilters);
                }
                catch (Exception e) {
                    Debug.trace2((String)"Deliver event failed", (Throwable)e);
                }
            } else {
                List l;
                String className = this.ci.getClassName().toLowerCase();
                int eventType = FilterActivation.determineEventType(className);
                if (eventType != -1) {
                    CIMInstance sourceInstance = (CIMInstance)this.ci.getProperty("SourceInstance").getValue().getValue();
                    className = sourceInstance.getClassName().toLowerCase();
                }
                if ((l = EventService.this.getClassFilters(this.namespace + ":" + className, this.ci.getClassName(), this.polled)) == null) {
                    try {
                        try {
                            LogFile.add(1, "INVALID_INDICATION", this.namespace, className, this.ci.toString());
                            return;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                }
                Iterator i = l.iterator();
                ArrayList<FilterActivation> matchedFilters = new ArrayList<FilterActivation>();
                while (i.hasNext()) {
                    FilterActivation.SubActivation sa = (FilterActivation.SubActivation)i.next();
                    FilterActivation fa = sa.getParentActivation();
                    if (matchedFilters.contains(fa)) continue;
                    try {
                        if (sa.getExpression() != null && !sa.getExpression().apply((CIMElement)this.ci)) continue;
                        matchedFilters.add(fa);
                    }
                    catch (CIMException e) {
                        Debug.trace2((String)"Expression instance mismatch, check filter", (Throwable)e);
                    }
                }
                try {
                    this.deliverEvent(this.ci, matchedFilters);
                }
                catch (Exception e) {
                    Debug.trace2((String)"Deliver event failed", (Throwable)e);
                }
            }
        }
    }

    private class Solaris_RMIDelivery
    implements CIMInstanceProvider,
    Authorizable {
        public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.enumerateInstances(op, false);
            Object[] copArray = new CIMObjectPath[v.size()];
            v.copyInto(copArray);
            return copArray;
        }

        public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.enumerateInstances(op, false, localOnly);
            Object[] ciArray = new CIMInstance[v.size()];
            v.copyInto(ciArray);
            return ciArray;
        }

        public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            CIMInstance ci = EventService.this.ps.getInstance(op);
            if (localOnly) {
                ci = EventService.this.cu.getLocal(ci);
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }

        public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
            String sessionID = null;
            try {
                sessionID = (String)ci.getProperty("name").getValue().getValue();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            ServerSecurity ss = null;
            try {
                ss = (ServerSecurity)ServerSecurity.getRequestSession();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (sessionID != null) {
                ss = (ServerSecurity)DeliveryHandler.getIndicationHandler(ci.getClassName()).getSecurityContext(ci);
            }
            if (ss == null) {
                throw new CIMSecurityException("NO_SUCH_SESSION", (Object)sessionID);
            }
            if (ss.getListener() == null) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            ci.setProperty("name", new CIMValue((Object)new String(ss.getSessionId()), CIMDataType.getPredefinedType((int)8)));
            ci.setProperty(EventService.CCNPROP, new CIMValue((Object)ci.getClassName().toLowerCase()));
            ci.setProperty(EventService.SYSTEMCCNPROP, new CIMValue((Object)EventService.CSNAME));
            ci.setProperty(EventService.SYSTEMNAMEPROP, new CIMValue((Object)EventService.this.hostName));
            ci.setProperty(EventService.OWNERPROP, new CIMValue((Object)new String(ss.getUserName()), CIMDataType.getPredefinedType((int)8)));
            EventService.this.ps.addCIMElement(op.getNameSpace(), ci);
            CIMObjectPath rcop = new CIMObjectPath(ci.getClassName(), ci.getKeyValuePairs());
            rcop.setNameSpace(op.getNameSpace());
            return rcop;
        }

        public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }

        public void deleteInstance(CIMObjectPath op) throws CIMException {
            EventService.this.ps.deleteInstance(op);
        }

        public void initialize(CIMOMHandle ch) {
        }

        public void cleanup() {
        }

        public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.execQuery(op, query, ql, cc);
            Object[] ciArray = new CIMInstance[v.size()];
            v.copyInto(ciArray);
            return ciArray;
        }
    }

    private class CIM_Filter
    implements CIMInstanceProvider,
    Authorizable {
        public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.enumerateInstances(op, false);
            Object[] copArray = new CIMObjectPath[v.size()];
            v.copyInto(copArray);
            return copArray;
        }

        public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.enumerateInstances(op, false, localOnly);
            Object[] ciArray = new CIMInstance[v.size()];
            v.copyInto(ciArray);
            return ciArray;
        }

        public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            CIMInstance ci = EventService.this.ps.getInstance(op);
            if (localOnly) {
                ci = EventService.this.cu.getLocal(ci);
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }

        public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
            String value = null;
            String targetNS = null;
            try {
                value = (String)ci.getProperty("name").getValue().getValue();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            try {
                targetNS = (String)ci.getProperty(EventService.TARGETNSPROP).getValue().getValue();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            CIMObjectPath rcop = null;
            if (value == null) {
                EventService eventService = EventService.this;
                ci.setProperty("name", new CIMValue((Object)eventService.cu.getUniqueString()));
            }
            ci.setProperty(EventService.CCNPROP, new CIMValue((Object)EventService.CIMFILTERCLASS));
            ci.setProperty(EventService.SYSTEMCCNPROP, new CIMValue((Object)EventService.CSNAME));
            ci.setProperty(EventService.SYSTEMNAMEPROP, new CIMValue((Object)EventService.this.hostName));
            rcop = new CIMObjectPath(ci.getClassName(), ci.getKeyValuePairs());
            rcop.setNameSpace(op.getNameSpace());
            if (targetNS != null) {
                targetNS = new CIMNameSpace(".", "/" + targetNS).getNameSpace();
                ci.setProperty(EventService.TARGETNSPROP, new CIMValue((Object)targetNS.toLowerCase()));
            }
            EventService.this.ps.addCIMElement(op.getNameSpace(), ci);
            return rcop;
        }

        public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }

        public void deleteInstance(CIMObjectPath op) throws CIMException {
            EventService.this.ps.deleteInstance(op);
        }

        public void initialize(CIMOMHandle ch) {
        }

        public void cleanup() {
        }

        public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.execQuery(op, query, ql, cc);
            Object[] ciArray = new CIMInstance[v.size()];
            v.copyInto(ciArray);
            return ciArray;
        }
    }

    private class CIM_FilterDelivery
    implements CIMInstanceProvider,
    Authorizable {
        public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.enumerateInstances(op, false);
            Object[] copArray = new CIMObjectPath[v.size()];
            v.copyInto(copArray);
            return copArray;
        }

        public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.enumerateInstances(op, false, localOnly);
            Object[] ciArray = new CIMInstance[v.size()];
            v.copyInto(ciArray);
            return ciArray;
        }

        public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
            CIMInstance ci = EventService.this.ps.getInstance(op);
            if (localOnly) {
                ci = EventService.this.cu.getLocal(ci);
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }

        private boolean fillNameSpace(CIMObjectPath currentns, CIMObjectPath op) {
            if (op.getNameSpace() == null || op.getNameSpace().length() == 0) {
                op.setNameSpace(currentns.getNameSpace());
                return true;
            }
            if (!op.getNameSpace().startsWith("\\")) {
                op.setNameSpace(currentns.getNameSpace() + "\\" + op.getNameSpace());
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
            String owner;
            CIMObjectPath filterOp = null;
            CIMObjectPath deliveryOp = null;
            try {
                filterOp = (CIMObjectPath)ci.getProperty(EventService.FILTERPROPERTY).getValue().getValue();
                deliveryOp = (CIMObjectPath)ci.getProperty(EventService.DELIVERYPROPERTY).getValue().getValue();
            }
            catch (Exception e) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                ci.setProperty(EventService.SUBSCRIPTIONALIASPROP, new CIMValue((Object)""));
            }
            catch (Exception tex) {
                // empty catch block
            }
            boolean keychanged = false;
            boolean b1 = this.fillNameSpace(op, filterOp);
            boolean b2 = this.fillNameSpace(op, deliveryOp);
            keychanged = b1 | b2;
            CIMInstance filterInstance = EventService.this.ps.getInstance(filterOp);
            CIMInstance deliveryInstance = EventService.this.ps.getInstance(deliveryOp);
            if (filterInstance == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)filterOp.toString());
            }
            if (deliveryInstance == null) {
                throw new CIMException("CIM_ERR_NOT_FOUND", (Object)deliveryOp.toString());
            }
            CIMObjectPath returnOp = new CIMObjectPath();
            returnOp.setObjectName(ci.getClassName());
            returnOp.setNameSpace(op.getNameSpace());
            Vector tv = EventService.this.ps.associatorNames(returnOp, filterOp, EventService.DELIVERYCLASS, "", "");
            FilterActivation fa = null;
            try {
                owner = (String)deliveryInstance.getProperty(EventService.OWNERPROP).getValue().getValue();
            }
            catch (NullPointerException ne) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)EventService.OWNERPROP);
            }
            if (tv.size() == 0) {
                fa = new FilterActivation(filterOp, filterInstance, EventService.this);
                fa.run();
                fa.getPollInfo(deliveryInstance, ci);
                fa.authorize(owner, deliveryInstance, ci);
                fa.activate(deliveryInstance, ci);
            }
            CIMObjectPath tempOp = new CIMObjectPath(filterOp.getObjectName().toLowerCase());
            tempOp.setNameSpace(filterOp.getNameSpace().toLowerCase());
            tempOp.setKeys(filterInstance.getKeyValuePairs());
            if (fa != null) {
                Map map = EventService.this.filterActivations;
                synchronized (map) {
                    EventService.this.filterActivations.put(tempOp.toString(), fa);
                }
            }
            Map map = EventService.this.filterActivations;
            synchronized (map) {
                fa = (FilterActivation)EventService.this.filterActivations.get(tempOp.toString());
            }
            fa.authorize(owner, deliveryInstance, ci);
            fa.activateSubscription(deliveryInstance, ci);
            EventService.this.ps.addCIMElement(op.getNameSpace(), ci);
            if (keychanged) {
                returnOp.setKeys(ci.getKeyValuePairs());
                return returnOp;
            }
            return null;
        }

        public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void deleteInstance(CIMObjectPath op) throws CIMException {
            Enumeration e = op.getKeys().elements();
            CIMObjectPath filterOp = null;
            CIMObjectPath handlerOp = null;
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp.getName().equalsIgnoreCase(EventService.FILTERPROPERTY)) {
                    try {
                        filterOp = (CIMObjectPath)cp.getValue().getValue();
                    }
                    catch (NullPointerException ex) {
                        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                    }
                }
                if (!cp.getName().equalsIgnoreCase(EventService.DELIVERYPROPERTY)) continue;
                try {
                    handlerOp = (CIMObjectPath)cp.getValue().getValue();
                }
                catch (NullPointerException ex) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            }
            Vector tv = EventService.this.ps.associatorNames(op, filterOp, EventService.DELIVERYCLASS, "", "");
            CIMInstance filterInstance = EventService.this.ps.getInstance(filterOp);
            CIMInstance handlerInstance = EventService.this.ps.getInstance(handlerOp);
            CIMInstance subscriptionInstance = EventService.this.ps.getInstance(op);
            EventService.this.ps.deleteInstance(op);
            CIMObjectPath tempOp = new CIMObjectPath(filterOp.getObjectName().toLowerCase());
            tempOp.setNameSpace(filterOp.getNameSpace().toLowerCase());
            tempOp.setKeys(filterInstance.getKeyValuePairs());
            FilterActivation fa = null;
            if (tv.size() != 1) {
                Map map = EventService.this.filterActivations;
                synchronized (map) {
                    fa = (FilterActivation)EventService.this.filterActivations.get(tempOp.toString());
                }
                fa.deactivateSubscription(handlerInstance, subscriptionInstance);
                return;
            }
            Map map = EventService.this.filterActivations;
            synchronized (map) {
                fa = (FilterActivation)EventService.this.filterActivations.remove(tempOp.toString());
            }
            fa.deactivate(handlerInstance, subscriptionInstance);
            Debug.trace3((String)("Deactivation complete fasize " + EventService.this.filterActivations.size() + " cfmap size " + EventService.this.classFilterMap.size()));
        }

        public void initialize(CIMOMHandle ch) {
        }

        public void cleanup() {
        }

        public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
            Vector v = EventService.this.ps.execQuery(op, query, ql, cc);
            Object[] ciArray = new CIMInstance[v.size()];
            v.copyInto(ciArray);
            return ciArray;
        }
    }

    private class HandlerChecker
    extends Thread {
        private HandlerChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loop() {
            ArrayList activeFilters = new ArrayList();
            Map map = EventService.this.filterActivations;
            synchronized (map) {
                Set s = EventService.this.filterActivations.entrySet();
                for (Map.Entry e : s) {
                    activeFilters.add(e.getValue());
                }
            }
            Iterator i = activeFilters.iterator();
            TreeMap<String, String> handlerMap = new TreeMap<String, String>();
            CIMObjectPath assocOp = new CIMObjectPath(EventService.FILTERDELIVERYASSOC);
            while (i.hasNext()) {
                FilterActivation fa = (FilterActivation)i.next();
                CIMObjectPath filterOp = fa.getFilterOp();
                assocOp.setNameSpace(filterOp.getNameSpace());
                Vector tv = null;
                try {
                    tv = EventService.this.ps.referenceNames(assocOp, filterOp, "");
                }
                catch (CIMException e) {
                    continue;
                }
                if (tv.size() == 0) continue;
                Enumeration deliveryEnum = tv.elements();
                while (deliveryEnum.hasMoreElements()) {
                    CIMObjectPath filterDeliveryOp = (CIMObjectPath)deliveryEnum.nextElement();
                    CIMObjectPath deliveryOp = null;
                    Enumeration keyEnum = filterDeliveryOp.getKeys().elements();
                    while (keyEnum.hasMoreElements()) {
                        CIMProperty cp = (CIMProperty)keyEnum.nextElement();
                        if (!cp.getName().equalsIgnoreCase(EventService.DELIVERYPROPERTY)) continue;
                        try {
                            deliveryOp = (CIMObjectPath)cp.getValue().getValue();
                        }
                        catch (NullPointerException e) {}
                    }
                    String key = deliveryOp.toString();
                    if (handlerMap.get(key) != null) continue;
                    handlerMap.put(key, "");
                    CIMInstance ci = null;
                    try {
                        ci = EventService.this.ps.getInstance(deliveryOp);
                    }
                    catch (CIMException e) {
                        continue;
                    }
                    IndicationHandler ih = DeliveryHandler.getIndicationHandler(ci.getClassName());
                    try {
                        ih.ping(ci);
                    }
                    catch (CIMException e) {
                        CIMInstanceProvider cIMInstanceProvider = EventService.this.cim_filterdelivery;
                        synchronized (cIMInstanceProvider) {
                            EventService.this.removeDelivery(deliveryOp, assocOp);
                        }
                    }
                }
            }
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(pingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.loop();
            }
        }
    }

    public static interface IndicationHandler {
        public void deliverEvent(CIMEvent var1, CIMInstance var2) throws CIMException;

        public void ping(CIMInstance var1) throws CIMException;

        public CommonServerSecurityContext getSecurityContext(CIMInstance var1);
    }
}

