<?xml version="1.0" encoding="UTF-8"?>

<!-- =================================================================

     Console web application web.xml template file for Woodstock
     components.

     Copy this template to your web application WEB-INF subdirectory
     as "web.xml".

     Remove this comment from the resulting web.xml file.
     ================================================================= -->

<!-- Sun Java Web Console 3.1 Web Application Deployment Descriptor -->
<!-- For web applications using the Woodstock JSF based components -->

<web-app version="2.5">
    xmlns="http://java.sun.com/xml/ns/javaee"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://java.sun.com/xml/ns/javaee
    http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd">

  <!-- Context parameters for JSF based components -->
  <context-param>
    <param-name>javax.faces.STATE_SAVING_METHOD</param-name>
    <param-value>server</param-value>
  </context-param>
  <context-param>
    <param-name>javax.faces.CONFIG_FILES</param-name>
    <param-value>/WEB-INF/faces-config.xml,/WEB-INF/console-webui-config.xml</param-value>
  </context-param>
  <context-param>
    <param-name>com.sun.webui.jsf.DEFAULT_THEME</param-name>
    <param-value>suntheme</param-value>
  </context-param>

  <!-- CONSOLE FILTER CONFIGURATION -->
  <!-- All management web applications must define this filter. -->
  <!-- Add ignore path parameter values for URI's for which the -->
  <!-- filter should pass through without making security checks. -->
  <!-- Paths can end with the "*" wildcard indicator. -->
  <filter>
    <filter-name>AppSessionManagerFilter</filter-name>
    <filter-class>
      com.sun.management.services.session.AppSessionManagerFilter
    </filter-class>

    <!-- ADD URI PATHS TO IGNORE WHEN USING THE SECURE PORT -->
    <init-param>
      <param-name>ignore-paths-https</param-name>
      <param-value>
        /images/*
        /html/*
        /faces/com_sun_webui_jsf/*
        /com_sun_webui_jsf/*
      </param-value>
    </init-param>

    <!-- ADD URI PATHS TO IGNORE WHEN USING THE NON-SECURE PORT -->
    <init-param>
      <param-name>ignore-paths-http</param-name>
      <param-value>
        /html/*
        /images/*
        /faces/com_sun_webui_jsf/*
        /com_sun_webui_jsf/*
      </param-value>
    </init-param>
  </filter>
  <filter-mapping>
    <filter-name>AppSessionManagerFilter</filter-name>
    <url-pattern>/*</url-pattern>
  </filter-mapping>
  
  <!-- Upload Filter and mapping -->
  <!-- Remove this comment when upload component is used:
  <filter>
    <filter-name>UploadFilter</filter-name>
    <filter-class>com.sun.webui.jsf.util.UploadFilter</filter-class>
    <init-param>
      <param-name>maxSize</param-name>
      <param-value>1000000</param-value>
    </init-param>
    <init-param>
      <param-name>sizeThreshold</param-name>
      <param-value>4096</param-value>
    </init-param>
  </filter>
  <filter-mapping>
    <filter-name>UploadFilter</filter-name>
    <servlet-name>FacesServlet</servlet-name>
  </filter-mapping>

  End of commented out section -->


  <!-- CONSOLE COMMON COMPONENT SERVLET CONFIGURATION DEFINITIONS -->

  <!-- Internal servlet required for console registration -->
  <servlet>
    <servlet-name>Registrar</servlet-name>
    <servlet-class>
      com.sun.management.services.registration.servlet.WebConsoleRegistrarServlet
    </servlet-class>
    <load-on-startup>3</load-on-startup>
  </servlet>

  <!-- Internal common component servlets required for JSF components -->
  <servlet>
     <servlet-name>FacesServlet</servlet-name>
     <servlet-class>javax.faces.webapp.FacesServlet</servlet-class>
     <init-param>
        <param-name>javax.faces.LIFECYCLE_ID</param-name>
        <param-value>com.sun.faces.lifecycle.PARTIAL</param-value>
     </init-param>
     <load-on-startup>1</load-on-startup>
  </servlet>
  <servlet>
     <servlet-name>ThemeServlet</servlet-name>
     <servlet-class>com.sun.webui.theme.ThemeServlet</servlet-class>
  </servlet>


  <!-- ADD APPLICATION SERVLET CONFIGURATION DEFINITIONS HERE -->


  <!-- CONSOLE COMMON COMPONENT SERVLET MAPPINGS -->

  <!-- Internal servlet required for console registration -->
  <servlet-mapping>
    <servlet-name>Registrar</servlet-name>
    <url-pattern>/Registrar</url-pattern>
  </servlet-mapping>

  <!-- Internal common component servlet mappings for JSF components -->
  <servlet-mapping>
     <servlet-name>FacesServlet</servlet-name>
     <url-pattern>/faces/*</url-pattern>
  </servlet-mapping>
  <servlet-mapping>
     <servlet-name>ThemeServlet</servlet-name>
     <url-pattern>/theme/*</url-pattern>
  </servlet-mapping>


  <!-- ADD APPLICATION SERVLET MAPPINGS HERE -->


</web-app>
