<?xml version='1.0' encoding='ISO-8859-1' ?>

<project name="%%REPLACE_NAME%%" default="all" basedir=".">

<!-- build file for the %%REPLACE_NAME%% web application -->

<!-- ======= Initialize build properties section ======= -->

    <!-- load properties to use for the build -->
    <!-- Must include at least the following: -->
    <!--    console.conf - path to console configuration directory -->
    <!--    jato.flag    - "true" if using any Jato components -->
    <!--    faces.flag   - "true" if using any JSF components -->
    <property file="build.properties"/>
    <fail unless="console.conf"
	message="Must set path to console configuration directory"/>
    <property file="${console.conf}/config.properties"/>
    <fail unless="console_home"
	message="Console configuration properties not found"/>

<!-- ===== Determine the operating system environment ===== -->

    <condition property="os_name" value="solaris">
        <contains substring="sunos" string="${os.name}" casesensitive="false"/>
    </condition>

    <condition property="os_name" value="linux">
        <contains substring="linux" string="${os.name}" casesensitive="false"/>
    </condition>

    <condition property="os_name" value="windows">
        <contains substring="windows" string="${os.name}" casesensitive="false"/>
    </condition>

<!-- ===== Initialize paths for classpath handling ===== -->

    <!-- Path for shared jars (from the container) -->
    <path id="shared.classpath">
        <fileset dir="${container_shared_lib}">
            <include name="jsf-api.jar"/>
	    <include name="*jstl.jar"/>
            <include name="commons-*.jar"/>
        </fileset>
    </path>

    <!-- Path for common jars (from the container) -->
    <path id="common.classpath">
        <fileset dir="${container_common_lib}">
            <include name="j2ee*.jar"/>
            <include name="servlet*.jar"/>
            <include name="jsp*.jar"/>
        </fileset>
    </path>

    <!-- Path for Jato-based components jars -->
    <path id="jato.classpath">
        <fileset dir="${jato_home}">
            <include name="jato.jar"/>
        </fileset>
        <fileset dir="${console_home}/lib">
            <include name="cc.jar"/>
        </fileset>
    </path>

    <!-- Path for JSF-based components jars -->
    <path id="webui.classpath">
        <fileset dir="${console_home}/lib">
            <include name="webui.jar"/>
            <include name="suntheme.jar"/>
            <include name="dataprovider.jar"/>
        </fileset>
    </path>

    <!-- Path for console framework jars -->
    <path id="console.classpath">
        <fileset dir="${console_home}/lib">
            <include name="serviceapi.jar"/>
            <include name="serviceimpl.jar"/>
            <include name="SMIWebCommon.jar"/>
            <include name="consoleutil.jar"/>
	    <include name="${os_name}_impl.jar"/>
	    <include name="${os_name}_implx.jar"/>
        </fileset>
    </path>

<!-- ========= Target to clean the build tree  ========= -->

    <target name="clean" description="Remove all the build generated files">
        <echo message="Cleaning the build directory structure"/>
        <delete>
           <fileset dir="WEB-INF/classes">
               <include name="**/*.class"/>
           </fileset>
        </delete>
        <delete>
           <fileset dir="WEB-INF/lib">
               <include name="*.jar"/>
           </fileset>
        </delete>
    </target>

<!-- ======== Target to compile the Java classes ======= -->

    <target name="compile" description="Compile all the Java source files">
	<echo message="Compiling the Java source files"/>
        <javac
	    deprecation="true"
            nowarn="true"
            srcdir="WEB-INF/classes"
            bootclasspath="${java_home}/lib/rt.jar"
            includes="**/*.java">
            <classpath>
                <path refid="shared.classpath"/>
                <path refid="common.classpath"/>
                <path refid="jato.classpath"/>
                <path refid="webui.classpath"/>
                <path refid="console.classpath"/>
            </classpath>
        </javac>
    </target>

<!-- ======= Target to process console resources ======= -->

    <target name="import" description="Import and validate console resources">
        <echo message="Processing console resources"/>
        <taskdef name="jwc_import"
             classname="com.sun.web.util.AntImport">
             <classpath>
                <path refid="console.classpath"/>
             </classpath>
        </taskdef>
        <taskdef name="jwc_validate"
             classname="com.sun.web.util.AntXmlChecker">
             <classpath>
                <path refid="console.classpath"/>
             </classpath>
        </taskdef>
        <taskdef name="jwc_prodname"
             classname="com.sun.web.util.AntProductImage">
             <classpath>
                <path refid="console.classpath"/>
             </classpath>
        </taskdef>
        <jwc_validate type="all"
		jato="${jato.flag}"
		faces="${faces.flag}"
		consoledir="${console_home}"/>
        <jwc_prodname type="all"
		consoledir="${console_home}"/>
        <jwc_import jato="${jato.flag}"
		faces="${faces.flag}"
		consoledir="${console_home}"/>
    </target>

<!-- ========= Build web application jar files ========= -->

    <target name="jars" description="Build web application jar files">
        <echo message="Building web application jar files"/>
        <jar destfile="WEB-INF/lib/%%REPLACE_CONTEXT%%.jar">
             <fileset dir="WEB-INF/classes"
                includes="**/*.class"/>
             <fileset dir="WEB-INF/classes"
                includes="**/*.properties"/>
        </jar>
    </target>

<!-- ========= Build web application war file  ========= -->

    <!-- The console will deploy a directory structure, -->
    <!-- so this step is not necessary.  Included for   -->
    <!-- completeness.                                  -->
    <target name="war" description="Build web application war file">
        <echo message="Building web application war file"/>
	<war destfile="%%REPLACE_CONTEXT%%.war"
	    webxml="WEB-INF/web.xml"
	    excludes="build.xml build.properties">
		<fileset dir="com_sun_web_ui"/>
		<fileset dir="html"/>
		<fileset dir="jsp"/>
		<fileset dir="js"/>
		<fileset dir="WEB-INF"/>
	</war>
    </target>


<!-- ========= Execute all the build steps ========= -->

    <target name="all" description="Build the full application"
	depends="clean,compile,import,jars">
        <echo message="Building full web application"/>
	
    </target>

</project>
