<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE web-app PUBLIC
  "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN"
  "http://java.sun.com/dtd/web-app_2_3.dtd">

<web-app>

<!-- Sun Java Web Console 3.0 Web Application Deployment Descriptor -->
<!-- For web applications using the console JATO based components -->

  <!-- ADD APPLICATION JATO MODULE CONTEXT PARAMETERS HERE -->
  <!-- Replace myapp and myservlet with your application name and -->
  <!-- servlet name.  Add a context parameter for each JATO module. -->
  <!-- For example:
  <context-param>
    <param-name>jato:com.sun.myapp.myservlet.*:moduleURL</param-name>
    <param-value>../myservlet</param-value>
  </context-param>
  -->


  <!-- CONSOLE FILTER CONFIGURATION -->
  <!-- All management web applications must define this filter. -->
  <!-- Add ignore path parameter values for URI's for which the -->
  <!-- filter should pass through without making security checks. -->
  <!-- Paths can end with the "*" wildcard indicator. -->
  <filter>
    <filter-name>AppSessionManagerFilter</filter-name>
    <filter-class>
      com.sun.management.services.session.AppSessionManagerFilter
    </filter-class>

    <!-- ADD URI PATHS TO IGNORE WHEN USING THE SECURE PORT -->
    <init-param>
      <param-name>ignore-paths-https</param-name>
      <param-value>
        /images/*
        /help/*
        /html/*
        /version/*
      </param-value>
    </init-param>

    <!-- ADD URI PATHS TO IGNORE WHEN USING THE NON-SECURE PORT -->
    <init-param>
      <param-name>ignore-paths-http</param-name>
      <param-value>
        /html/*
        /help/*
        /help2/*
        /images/*
      </param-value>
    </init-param>
  </filter>
  <filter-mapping>
    <filter-name>AppSessionManagerFilter</filter-name>
    <url-pattern>/*</url-pattern>
  </filter-mapping>
  
  <!-- ADD OPTIONAL APPLICATION FILTER DEFINITIONS HERE -->


  <!-- CONSOLE WEB APPLICATION DEFAULT LISTENER -->
  <listener>
    <listener-class>com.sun.web.common.ConsoleServletBase</listener-class>
  </listener>


  <!-- CONSOLE COMMON COMPONENT SERVLET CONFIGURATION DEFINITIONS -->

  <!-- Internal servlet required for console registration -->
  <servlet>
    <servlet-name>Registrar</servlet-name>
    <servlet-class>
      com.sun.management.services.registration.servlet.WebConsoleRegistrarServlet
    </servlet-class>
    <load-on-startup>3</load-on-startup>
  </servlet>

  <!-- Internal common component servlets required for some complex tags -->
  <servlet>
    <servlet-name>ccTopologyServlet</servlet-name>
    <servlet-class>
      com.sun.web.ui.servlet.topology.CCTopologyServlet
    </servlet-class>
  </servlet>
  <servlet>
    <servlet-name>tableServlet</servlet-name>
    <servlet-class>
      com.sun.web.ui.servlet.table.TableServlet
    </servlet-class>
  </servlet>
  <servlet>
    <servlet-name>badgingServlet</servlet-name>
    <servlet-class>
      com.sun.web.ui.servlet.badging.BadgingServlet
    </servlet-class>
  </servlet>
  <servlet>
    <servlet-name>HelpServlet</servlet-name>
    <servlet-class>
      com.sun.web.ui.servlet.help.HelpServlet
    </servlet-class>
  </servlet>
  <servlet>
    <servlet-name>VersionServlet</servlet-name>
    <servlet-class>
      com.sun.web.ui.servlet.version.VersionServlet
    </servlet-class>
  </servlet>
  <servlet>
    <servlet-name>dateTimeServlet</servlet-name>
    <servlet-class>com.sun.web.ui.servlet.datetime.DateTimeServlet</servlet-class>
  </servlet>
  <servlet>
    <servlet-name>help2Servlet</servlet-name>
    <servlet-class>com.sun.web.ui.servlet.help2.Help2Servlet</servlet-class>
  </servlet>

  <!-- ADD APPLICATION SERVLET CONFIGURATION DEFINITIONS HERE -->


  <!-- CONSOLE COMMON COMPONENT SERVLET MAPPINGS -->

  <!-- Internal servlet required for console registration -->
  <servlet-mapping>
    <servlet-name>Registrar</servlet-name>
    <url-pattern>/Registrar</url-pattern>
  </servlet-mapping>

  <!-- Internal common component servlet mappings for some complex tags -->
  <servlet-mapping>
    <servlet-name>ccTopologyServlet</servlet-name>
    <url-pattern>/ccTopologyImage</url-pattern>
  </servlet-mapping>
  <servlet-mapping>
    <servlet-name>tableServlet</servlet-name>
    <url-pattern>/table/*</url-pattern>
  </servlet-mapping>
  <servlet-mapping>
    <servlet-name>badgingServlet</servlet-name>
    <url-pattern>/badging/*</url-pattern>
  </servlet-mapping>
  <servlet-mapping>
    <servlet-name>HelpServlet</servlet-name>
    <url-pattern>/cchelp/*</url-pattern>
  </servlet-mapping>
  <servlet-mapping>
    <servlet-name>VersionServlet</servlet-name>
    <url-pattern>/ccversion/*</url-pattern>
  </servlet-mapping>
  <servlet-mapping>
    <servlet-name>dateTimeServlet</servlet-name>
    <url-pattern>/datetime/*</url-pattern>
  </servlet-mapping>
  <servlet-mapping>
    <servlet-name>help2Servlet</servlet-name>
    <url-pattern>/cchelp2/*</url-pattern>
  </servlet-mapping>


  <!-- ADD APPLICATION SERVLET MAPPINGS HERE -->


  <!-- CONSOLE COMMON COMPONENT TAGLIB DEFINITIONS -->
  <!-- Taglib tld files should be installed in the specified directory. -->
  <taglib>
    <taglib-uri>/cc.tld</taglib-uri>
    <taglib-location>/WEB-INF/tld/com_sun_web_ui/cc.tld</taglib-location>
  </taglib>
  <taglib>
    <taglib-uri>/jato.tld</taglib-uri>
    <taglib-location>/WEB-INF/tld/com_iplanet_jato/jato.tld</taglib-location>
  </taglib>

  <!-- ADD APPLICATION TAGLIB DEFINITIONS HERE -->


</web-app>
