/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.MutableShortcutsModel;
import org.openide.util.NbBundle;
import org.openide.util.Task;

class KeymapViewModel
extends DefaultTableModel
implements Runnable {
    private KeymapModel model = new KeymapModel();
    private MutableShortcutsModel mutableModel = new MutableShortcutsModel(this.model, null);
    private String currentProfile;
    static final ActionsComparator actionsComparator = new ActionsComparator();
    private String searchText = "";
    private volatile Task initTask;
    private Map<String, List<String>> categories;
    private boolean supressDataEvents;

    public KeymapViewModel() {
        super(new String[]{NbBundle.getMessage(KeymapViewModel.class, (String)"ActionsColumnName"), NbBundle.getMessage(KeymapViewModel.class, (String)"ShortcutColumnName"), NbBundle.getMessage(KeymapViewModel.class, (String)"CategoryColumnName")}, 0);
    }

    MutableShortcutsModel getMutableModel() {
        return this.mutableModel;
    }

    void update() {
        this.postUpdate();
    }

    @Override
    public void run() {
        this.update0();
    }

    private void scheduleUpdate() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public Task postUpdate() {
        Task task = this.initTask;
        if (task != null && task.isFinished()) {
            this.scheduleUpdate();
            return task;
        }
        if (task == null) {
            this.initTask = KeymapModel.RP.post(new Runnable(){

                @Override
                public void run() {
                    KeymapViewModel.this.mutableModel.getCategories();
                    KeymapViewModel.this.mutableModel.getItems("");
                    KeymapViewModel.this.scheduleUpdate();
                }
            });
            return this.initTask;
        }
        if (task.isFinished()) {
            this.scheduleUpdate();
        }
        return task;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return ActionHolder.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    void setSearchText(String string) {
        this.searchText = string;
    }

    public Map<String, List<String>> getCategories() {
        if (this.categories == null) {
            this.categories = new TreeMap<String, List<String>>();
            ArrayList<String> arrayList = new ArrayList<String>(this.model.getActionCategories());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    List<String> list = this.categories.get(string2);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.categories.put(string2, list);
                    }
                    String string4 = string2 = string2.length() == 0 ? string3 : string2 + '/' + string3;
                    if (!list.isEmpty() && list.get(list.size() - 1).equals(string2)) continue;
                    list.add(string2);
                }
            }
        }
        return this.categories;
    }

    @Override
    public void fireTableDataChanged() {
        if (!this.supressDataEvents) {
            super.fireTableDataChanged();
        }
    }

    @Override
    public void fireTableRowsInserted(int n, int n2) {
        if (!this.supressDataEvents) {
            super.fireTableRowsInserted(n, n2);
        }
    }

    @Override
    public void fireTableRowsDeleted(int n, int n2) {
        if (!this.supressDataEvents) {
            super.fireTableRowsDeleted(n, n2);
        }
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (!this.supressDataEvents) {
            super.fireTableChanged(tableModelEvent);
        }
    }

    private void update0() {
        String string;
        boolean bl = false;
        if (this.searchText.matches(".*[A-Z].*")) {
            bl = true;
            string = this.searchText;
        } else {
            string = this.searchText.toLowerCase();
        }
        this.supressDataEvents = true;
        this.getDataVector().removeAllElements();
        for (String string2 : this.getCategories().keySet()) {
            for (String string3 : this.getCategories().get(string2)) {
                for (Object object : this.mutableModel.getItems(string3, false)) {
                    ShortcutAction shortcutAction = (ShortcutAction)object;
                    String[] stringArray = this.mutableModel.getShortcuts(shortcutAction);
                    String string4 = shortcutAction.getDisplayName();
                    if (string4.isEmpty() || !this.searched(bl ? string4 : string4.toLowerCase(), string)) continue;
                    if (stringArray.length == 0) {
                        this.addRow(new Object[]{new ActionHolder(shortcutAction, false), "", string3});
                        continue;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string5 = stringArray[i];
                        this.addRow(new Object[]{i == 0 ? new ActionHolder(shortcutAction, false) : new ActionHolder(shortcutAction, true), string5, string3});
                    }
                }
            }
        }
        this.supressDataEvents = false;
        this.fireTableDataChanged();
    }

    private boolean searched(String string, String string2) {
        return string.length() == 0 || string.startsWith(string2) || string.contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runWithoutEvents(Runnable runnable) {
        try {
            this.supressDataEvents = true;
            runnable.run();
        }
        finally {
            this.supressDataEvents = false;
        }
    }

    static class ActionsComparator
    implements Comparator {
        ActionsComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                return 1;
            }
            if (object2 instanceof String) {
                return -1;
            }
            return ((ShortcutAction)object).getDisplayName().compareTo(((ShortcutAction)object2).getDisplayName());
        }
    }
}

