/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray.internal.impl;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jdesktop.jdic.tray.internal.TrayIconService;
import org.jdesktop.jdic.tray.internal.impl.GnomeSystemTrayService;
import org.jdesktop.jdic.tray.internal.impl.GnomeTrayAppletService;
import sun.awt.EmbeddedFrame;

public class GnomeTrayIconService
extends GnomeTrayAppletService
implements TrayIconService {
    private JPopupMenu menu;
    private IconPanel iconPanel;
    private Icon icon;
    private HWToolTip tooltip;
    private boolean autoSize;
    private LinkedList actionList = new LinkedList();

    public GnomeTrayIconService() {
        this.iconPanel = new IconPanel();
        this.frame.add(this.iconPanel);
        this.frame.setFocusable(true);
        this.frame.requestFocus();
        this.initListeners();
        this.frame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowDeactivated(WindowEvent windowEvent) {
                EmbeddedFrame embeddedFrame = GnomeTrayIconService.this.frame;
                synchronized (embeddedFrame) {
                    GnomeTrayIconService.this.frame.notify();
                }
            }
        });
    }

    void mousePressed(final MouseEvent mouseEvent) {
        if (this.menu != null) {
            if (mouseEvent.isPopupTrigger()) {
                if (this.tooltip != null) {
                    this.tooltip.setVisible(false);
                }
                Dimension dimension = this.menu.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                final Point point = mouseEvent.getPoint();
                final Frame frame = (Frame)mouseEvent.getSource();
                SwingUtilities.convertPointToScreen(point, frame);
                point.x = point.x + dimension.width > dimension2.width ? point.x - dimension.width : point.x;
                point.y = point.y + dimension.height > dimension2.height ? point.y - dimension.height : point.y;
                SwingUtilities.convertPointFromScreen(point, frame);
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Frame frame2 = frame;
                        synchronized (frame2) {
                            try {
                                if (frame.isActive()) {
                                    frame.wait();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                GnomeTrayIconService.access$300(2.access$200(this.this$1)).show(2.access$000(this.this$1), 2.access$100(this.this$1).x, 2.access$100(this.this$1).y);
                            }
                        });
                    }

                    static /* synthetic */ Frame access$000(2 var0) {
                        return var0.frame;
                    }

                    static /* synthetic */ Point access$100(2 var0) {
                        return var0.point;
                    }

                    static /* synthetic */ GnomeTrayIconService access$200(2 var0) {
                        return var0.GnomeTrayIconService.this;
                    }
                });
                thread.start();
            } else {
                if (this.tooltip != null) {
                    this.tooltip.setVisible(false);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Thread thread = new Thread(new Runnable(this){
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                ListIterator<E> listIterator = GnomeTrayIconService.access$500(4.access$400(this.this$1)).listIterator(0);
                                while (listIterator.hasNext()) {
                                    ActionListener actionListener = (ActionListener)listIterator.next();
                                    actionListener.actionPerformed(new ActionEvent(4.access$400(this.this$1), 1001, "PressAction", 4.access$600(this.this$1).getWhen(), 0));
                                }
                            }
                        });
                        thread.start();
                    }

                    static /* synthetic */ GnomeTrayIconService access$400(4 var0) {
                        return var0.GnomeTrayIconService.this;
                    }

                    static /* synthetic */ MouseEvent access$600(4 var0) {
                        return var0.mouseEvent;
                    }
                });
            }
        }
    }

    void mouseEntered(MouseEvent mouseEvent) {
        if (this.tooltip != null && (this.menu == null || this.menu != null && !this.menu.isShowing())) {
            Dimension dimension = this.tooltip.getSize();
            Point point = this.frame.getLocationOnScreen();
            Dimension dimension2 = this.tooltip.getPreferredSize();
            this.tooltip.show(point.x, point.y - dimension2.height - 5);
        }
    }

    void mouseExited(MouseEvent mouseEvent) {
        if (this.tooltip != null) {
            this.tooltip.setVisible(false);
        }
    }

    void initListeners() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GnomeTrayIconService.this.mousePressed(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                GnomeTrayIconService.this.mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                GnomeTrayIconService.this.mouseExited(mouseEvent);
            }
        };
        this.iconPanel.addMouseListener(mouseAdapter);
        this.frame.addMouseListener(mouseAdapter);
    }

    public void addNotify() {
        if (GnomeTrayAppletService.winMap.get(new Long(this.getWindow())) == null) {
            this.init();
            if (this.icon != null) {
                this.setIcon(this.icon);
            }
            if (this.menu != null) {
                this.setPopupMenu(this.menu);
            }
            if (this.tooltip != null) {
                this.tooltip = new HWToolTip(this.tooltip.label.getTipText(), this.frame);
            }
            this.initListeners();
        }
        GnomeSystemTrayService.dockWindow(this.getWindow());
        this.frame.setVisible(true);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        if (jPopupMenu != null) {
            jPopupMenu.setLightWeightPopupEnabled(false);
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.icon != null) {
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            this.reshape(0, 0, n, n2);
            this.frame.setVisible(false);
            this.frame.remove(this.iconPanel);
            this.iconPanel = new IconPanel();
            this.frame.add(this.iconPanel);
            this.frame.setVisible(true);
        }
        this.iconPanel.repaint();
    }

    public void setCaption(String string) {
        if (this.tooltip == null) {
            this.tooltip = new HWToolTip(string, this.frame);
        } else {
            this.tooltip.setCaption(string);
        }
    }

    public void setIconAutoSize(boolean bl) {
        this.autoSize = bl;
        if (this.autoSize && this.icon != null) {
            int n = this.icon.getIconWidth();
            int n2 = this.icon.getIconHeight();
            this.reshape(0, 0, n, n2);
            this.frame.setVisible(false);
            this.frame.remove(this.iconPanel);
            this.iconPanel = new IconPanel();
            this.frame.add(this.iconPanel);
            this.frame.setVisible(true);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionList.remove(actionListener);
    }

    public Point getLocationOnScreen() {
        Point point = null;
        if (this.iconPanel != null) {
            point = this.iconPanel.getLocationOnScreen();
        }
        return point;
    }

    static /* synthetic */ JPopupMenu access$300(GnomeTrayIconService gnomeTrayIconService) {
        return gnomeTrayIconService.menu;
    }

    static /* synthetic */ LinkedList access$500(GnomeTrayIconService gnomeTrayIconService) {
        return gnomeTrayIconService.actionList;
    }

    class HWToolTip
    extends JWindow {
        Font font;
        JToolTip label;

        public HWToolTip(String string, Window window) {
            super(window);
            this.font = new Font("Serif", 10, 0);
            this.setFocusableWindowState(false);
            this.setName("###overrideRedirect###");
            this.label = new JToolTip();
            this.label.setTipText(string);
            this.getContentPane().add(this.label);
        }

        public void setCaption(String string) {
            this.label.setTipText(string);
        }

        public void show(int n, int n2) {
            this.setLocation(n, n2);
            Dimension dimension = this.label.getPreferredSize();
            this.setSize(dimension.width, dimension.height);
            this.setVisible(true);
        }
    }

    class IconPanel
    extends JComponent {
        Image img;

        IconPanel() {
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = GnomeTrayIconService.this.getAppletSize();
            graphics.clearRect(0, 0, dimension.width, dimension.height);
            if (GnomeTrayIconService.this.icon != null) {
                int n = GnomeTrayIconService.this.icon.getIconWidth();
                int n2 = GnomeTrayIconService.this.icon.getIconHeight();
                if (!GnomeTrayIconService.this.autoSize) {
                    GnomeTrayIconService.this.icon.paintIcon(this, graphics, 0, 0);
                } else {
                    if (this.img == null) {
                        this.img = this.createImage(n, n2);
                    }
                    GnomeTrayIconService.this.icon.paintIcon(this, this.img.getGraphics(), 0, 0);
                    graphics.drawImage(this.img, 0, 0, dimension.width, dimension.height, 0, 0, n, n2, this);
                }
            }
            super.paintComponent(graphics);
        }

        boolean doesIconReferenceImage(Icon icon, Image image) {
            Image image2 = icon != null && icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
            return image2 == image;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (!this.isShowing() || !this.doesIconReferenceImage(GnomeTrayIconService.this.icon, image)) {
                return false;
            }
            return super.imageUpdate(image, n, n2, n3, n4, n5);
        }
    }
}

