/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.swing.ProfilerColumnModel;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

public class ProfilerTableContainer
extends JPanel {
    private static final String PROP_COLUMN = "column";
    private ProfilerTable table;
    private JScrollPane tableScroll;
    private JPanel scrollersPanel;

    public ProfilerTableContainer(final ProfilerTable profilerTable, boolean bl, ColumnChangeAdapter columnChangeAdapter) {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(new HTMLTextArea().getBackground());
        this.table = profilerTable;
        this.tableScroll = new JScrollPane(profilerTable){

            @Override
            protected JViewport createViewport() {
                if (this.getViewport() == null) {
                    return ProfilerTableContainer.this.customViewport(profilerTable);
                }
                return super.createViewport();
            }
        };
        this.tableScroll.setVerticalScrollBarPolicy(22);
        this.tableScroll.setHorizontalScrollBarPolicy(31);
        this.configureVerticalScrollBar(this.tableScroll.getVerticalScrollBar());
        if (!bl) {
            this.tableScroll.setBorder(BorderFactory.createEmptyBorder());
            this.tableScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        }
        this.add((Component)this.tableScroll, "Center");
        final ProfilerColumnModel profilerColumnModel = profilerTable._getColumnModel();
        final Set<Integer> set = profilerTable.getScrollableColumns();
        if (set != null && !set.isEmpty()) {
            this.scrollersPanel = new JPanel(null){

                @Override
                public void doLayout() {
                    int n = this.getHeight();
                    if (n > 0) {
                        for (Component component : this.getComponents()) {
                            JScrollBar jScrollBar = (JScrollBar)component;
                            int n2 = profilerTable.convertColumnIndexToView(ProfilerTableContainer.this.getColumn(jScrollBar));
                            Rectangle rectangle = profilerTable.getTableHeader().getHeaderRect(n2);
                            jScrollBar.setBounds(rectangle.x, 0, rectangle.width, n);
                            jScrollBar.doLayout();
                        }
                    }
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.height = 0;
                    for (Component component : this.getComponents()) {
                        JScrollBar jScrollBar = (JScrollBar)component;
                        if (!profilerColumnModel.isColumnVisible(ProfilerTableContainer.this.getColumn(jScrollBar))) continue;
                        dimension.height = Math.max(dimension.height, jScrollBar.getPreferredSize().height);
                    }
                    return dimension;
                }
            };
            this.scrollersPanel.setOpaque(true);
            this.scrollersPanel.setBackground(this.getBackground());
            for (final Integer object : set) {
                final JScrollBar jScrollBar = new JScrollBar(0){
                    private boolean adjusting;
                    {
                        super(n);
                        this.adjusting = false;
                        this.putClientProperty(ProfilerTableContainer.PROP_COLUMN, object);
                    }

                    @Override
                    public void setValue(int n) {
                        n = this.checkedValue(n);
                        super.setValue(n);
                        this.updateColumnOffset(n);
                    }

                    @Override
                    public void setValues(int n, int n2, int n3, int n4) {
                        if (this.adjusting) {
                            return;
                        }
                        n = this.checkedValue(n);
                        this.setEnabled(n2 < n4);
                        if (this.trackEnd()) {
                            n = n4 - n2;
                        }
                        super.setValues(n, n2, n3, n4);
                        this.updateColumnOffset(n);
                    }

                    @Override
                    public void setValueIsAdjusting(boolean bl) {
                        this.adjusting = bl;
                        super.setValueIsAdjusting(bl);
                        if (!this.adjusting) {
                            ProfilerTableContainer.this.updateHorizontalScrollBars(profilerTable, object, false);
                        }
                    }

                    @Override
                    public int getUnitIncrement() {
                        return 20;
                    }

                    @Override
                    public int getUnitIncrement(int n) {
                        return this.getUnitIncrement();
                    }

                    @Override
                    public int getBlockIncrement() {
                        return (int)((float)this.getVisibleAmount() * 0.9f);
                    }

                    @Override
                    public int getBlockIncrement(int n) {
                        return this.getBlockIncrement();
                    }

                    private void updateColumnOffset(int n) {
                        profilerTable.setColumnOffset(object, n);
                    }

                    private boolean trackEnd() {
                        if (!this.isEnabled()) {
                            return false;
                        }
                        int n = this.getVisibleAmount();
                        if (n > 0) {
                            return this.getValue() + n >= this.getMaximum();
                        }
                        return !profilerTable.isLeadingAlign(object);
                    }

                    private int checkedValue(int n) {
                        n = Math.max(0, n);
                        n = Math.min(this.getMaximum() - this.getVisibleAmount(), n);
                        return n;
                    }
                };
                jScrollBar.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                        ProfilerTableContainer.scroll(jScrollBar, mouseWheelEvent);
                    }
                });
                this.scrollersPanel.add(jScrollBar);
            }
            MouseWheelListener[] mouseWheelListenerArray = this.tableScroll.getMouseWheelListeners();
            if (mouseWheelListenerArray != null && mouseWheelListenerArray.length == 1) {
                final MouseWheelListener mouseWheelListener = mouseWheelListenerArray[0];
                this.tableScroll.removeMouseWheelListener(mouseWheelListener);
                this.tableScroll.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                        if (ProfilerTableContainer.onlyShift(mouseWheelEvent)) {
                            int n;
                            int n2 = profilerTable.columnAtPoint(mouseWheelEvent.getPoint());
                            int n3 = n = n2 == -1 ? -1 : profilerTable.convertColumnIndexToModel(n2);
                            if (n != -1 && profilerTable.isScrollableColumn(n)) {
                                JScrollBar jScrollBar = ProfilerTableContainer.this.getScroller(n);
                                if (jScrollBar != null) {
                                    ProfilerTableContainer.scroll(jScrollBar, mouseWheelEvent);
                                }
                                return;
                            }
                        }
                        mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                    }
                });
            }
            profilerColumnModel.addColumnChangeListener(new ColumnChangeAdapter(){

                @Override
                public void columnWidthChanged(int n, int n2, int n3) {
                    if (profilerTable.isScrollableColumn(n)) {
                        ProfilerTableContainer.this.updateHorizontalScrollBars(profilerTable, n, true);
                    }
                }

                @Override
                public void columnPreferredWidthChanged(int n, int n2, int n3) {
                    if (profilerTable.isScrollableColumn(n)) {
                        ProfilerTableContainer.this.updateHorizontalScrollBars(profilerTable, n, false);
                    }
                }
            });
            profilerColumnModel.addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                }

                @Override
                public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                    this.moved(tableColumnModelEvent);
                }

                @Override
                public void columnMarginChanged(ChangeEvent changeEvent) {
                    this.margin(changeEvent);
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                }

                private void moved(TableColumnModelEvent tableColumnModelEvent) {
                    if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                        ProfilerTableContainer.this.updateHorizontalScrollBars(profilerTable, -1, true);
                    }
                }

                private void margin(ChangeEvent changeEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (Integer n : set) {
                                int n2 = profilerTable.convertColumnIndexToView(n);
                                Rectangle rectangle = profilerTable.getTableHeader().getHeaderRect(n2);
                                Rectangle rectangle2 = ProfilerTableContainer.this.getScroller(n).getBounds();
                                if (rectangle.x == rectangle2.x && rectangle.width == rectangle2.width) continue;
                                ProfilerTableContainer.this.updateHorizontalScrollBars(profilerTable, -1, true);
                                break;
                            }
                        }
                    });
                }
            });
            this.add((Component)this.scrollersPanel, "South");
        }
        if (columnChangeAdapter != null) {
            profilerColumnModel.addColumnChangeListener(columnChangeAdapter);
        }
    }

    private static void scroll(JScrollBar jScrollBar, MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            int n;
            int n2 = mouseWheelEvent.getUnitsToScroll() < 0 ? -1 : 1;
            int n3 = jScrollBar.getUnitIncrement(n2);
            int n4 = jScrollBar.getValue();
            if (n4 != (n = n4 + n3 * n2)) {
                jScrollBar.setValue(n);
            }
            mouseWheelEvent.consume();
        }
    }

    private static boolean onlyShift(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown() && !mouseEvent.isAltDown() && !mouseEvent.isAltGraphDown() && !mouseEvent.isControlDown() && !mouseEvent.isMetaDown();
    }

    public boolean tableNeedsScrolling() {
        return this.tableScroll.getVerticalScrollBar().isEnabled();
    }

    public BufferedImage createTableScreenshot(boolean bl) {
        return bl ? UIUtils.createScreenshot(this.tableScroll) : UIUtils.createScreenshot(this.table);
    }

    private int getColumn(JScrollBar jScrollBar) {
        return (Integer)jScrollBar.getClientProperty(PROP_COLUMN);
    }

    private JScrollBar getScroller(int n) {
        for (Component component : this.scrollersPanel.getComponents()) {
            JScrollBar jScrollBar = (JScrollBar)component;
            if (this.getColumn(jScrollBar) != n) continue;
            return jScrollBar;
        }
        return null;
    }

    private JViewport customViewport(final JTable jTable) {
        return new JViewport(){
            private boolean listening;
            {
                this.setBackground(jTable.getBackground());
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                Component component = this.getView();
                if (component == jTable) {
                    int n;
                    int n2;
                    if (!this.listening) {
                        this.hookColumns();
                    }
                    if ((n2 = this.getHeight()) > (n = component.getHeight())) {
                        graphics.setColor(jTable.getGridColor());
                        JTableHeader jTableHeader = jTable.getTableHeader();
                        for (int i = 0; i < jTable.getColumnCount(); ++i) {
                            Rectangle rectangle = jTableHeader.getHeaderRect(i);
                            if (rectangle.width <= 0) continue;
                            graphics.drawLine(rectangle.x + rectangle.width - 1, n, rectangle.x + rectangle.width - 1, n2 - 1);
                        }
                    }
                }
            }

            private void hookColumns() {
                jTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                    @Override
                    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                        this.repaint();
                    }

                    @Override
                    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                        this.repaint();
                    }

                    @Override
                    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                        this.repaint();
                    }

                    @Override
                    public void columnMarginChanged(ChangeEvent changeEvent) {
                        this.repaint();
                    }

                    @Override
                    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                        this.repaint();
                    }
                });
                this.listening = true;
            }
        };
    }

    private void configureVerticalScrollBar(final JScrollBar jScrollBar) {
        jScrollBar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                jScrollBar.setEnabled(ProfilerTableContainer.this.isEnabled() && jScrollBar.getVisibleAmount() < jScrollBar.getMaximum());
            }
        });
    }

    private void updateHorizontalScrollBars(ProfilerTable profilerTable, int n, boolean bl) {
        if (n != -1) {
            JScrollBar jScrollBar = this.getScroller(n);
            int n2 = profilerTable.getColumnOffset(n);
            int n3 = profilerTable.getColumnPreferredWidth(n);
            int n4 = profilerTable.convertColumnIndexToView(n);
            int n5 = profilerTable.getTableHeader().getHeaderRect((int)n4).width;
            if (n3 > n5) {
                int n6 = Math.min(n2, n3 - n5);
                jScrollBar.setValues(n6, n5, 0, n3);
            } else {
                jScrollBar.setValues(0, 0, 0, 0);
            }
        }
        if (bl) {
            this.doLayout();
            this.scrollersPanel.doLayout();
            this.repaint();
        }
    }

    public static class ColumnChangeAdapter
    implements ProfilerColumnModel.Listener {
        @Override
        public void columnOffsetChanged(int n, int n2, int n3) {
        }

        @Override
        public void columnWidthChanged(int n, int n2, int n3) {
        }

        @Override
        public void columnPreferredWidthChanged(int n, int n2, int n3) {
        }
    }
}

