/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.swing.CustomField;
import com.sun.cns.basicreg.wizard.swing.Field;
import com.sun.cns.basicreg.wizard.swing.FieldPanel;
import com.sun.cns.basicreg.wizard.swing.RadioBoxPanel;
import com.sun.cns.basicreg.wizard.swing.WizardPanel;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class FormPanel
extends JPanel {
    public static final String TRUE_STR = "true";
    public static final String FALSE_STR = "false";
    protected WizardPanel parentWizardPanel;
    protected Field[] fields;
    protected FieldPanel[] fieldPanels;
    protected JLabel[] m_labels;
    protected JComponent[] m_components;
    protected boolean[] hasErrorSupport;
    protected double maximumLabelWidth;
    protected Map buttonGroupsMap;
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$wizard$swing$FormPanel == null ? (class$com$sun$cns$basicreg$wizard$swing$FormPanel = FormPanel.class$("com.sun.cns.basicreg.wizard.swing.FormPanel")) : class$com$sun$cns$basicreg$wizard$swing$FormPanel).getName());
    static /* synthetic */ Class class$com$sun$cns$basicreg$wizard$swing$FormPanel;

    public FormPanel(WizardPanel parentWizardPanel, Field[] fields) {
        this(parentWizardPanel, fields, null);
    }

    public FormPanel(WizardPanel parentWizardPanel, Field[] fields, JComponent[] customFormFields) {
        this(parentWizardPanel, fields, customFormFields, null);
    }

    public FormPanel(WizardPanel parentWizardPanel, Field[] fields, JComponent[] customFormFields, ActionListener returnActionListener) {
        this.parentWizardPanel = parentWizardPanel;
        this.fields = fields;
        this.buildLabelsAndComponents(customFormFields, returnActionListener);
        this.setAnyInitialValues();
        this.setLayout(new BoxLayout(this, 1));
        this.layoutLabelsAndComponents();
    }

    private void buildLabelsAndComponents(JComponent[] customFormFields, ActionListener returnActionListener) {
        this.m_labels = new JLabel[this.fields.length];
        this.m_components = new JComponent[this.fields.length];
        this.hasErrorSupport = new boolean[this.fields.length];
        HashMap<String, ButtonGroup> buttonGroupsMap = new HashMap<String, ButtonGroup>();
        for (int i = 0; i < this.fields.length; ++i) {
            switch (this.fields[i].getType()) {
                case 0: {
                    if (customFormFields != null && customFormFields[i] != null) {
                        this.m_components[i] = customFormFields[i];
                        this.hasErrorSupport[i] = ((CustomField)((Object)customFormFields[i])).hasErrorSupport();
                        break;
                    }
                    LOG.severe("ERROR - FormPanel() missing custom form field");
                    this.m_components[i] = new JLabel("missing custom field");
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 1: {
                    this.m_components[i] = new JTextField(this.fields[i].getLength());
                    ((JTextField)this.m_components[i]).setEditable(this.fields[i].getIsEditable());
                    this.m_components[i].setFocusable(this.fields[i].getIsEditable());
                    this.hasErrorSupport[i] = true;
                    break;
                }
                case 7: {
                    String labelIconFilename = this.fields[i].getLabelIconFilename();
                    String labelIconDescription = this.fields[i].getLabelIconDescription();
                    if (labelIconFilename != null) {
                        Icon labelIcon = I18N.getIcon(labelIconFilename, labelIconDescription);
                        this.m_components[i] = new JLabel(labelIcon, 0);
                    } else {
                        this.m_components[i] = new JLabel();
                    }
                    this.setComponentFont(this.m_components[i], this.fields[i].getFontFamily(), this.fields[i].getFontStyle(), this.fields[i].getFontSize());
                    ((JLabel)this.m_components[i]).setVerticalTextPosition(1);
                    ((JLabel)this.m_components[i]).setEnabled(this.fields[i].getIsEditable());
                    this.m_components[i].setFocusable(false);
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 2: {
                    this.m_components[i] = this.fields[i].getPopulation() != null ? new JComboBox<Object>(this.fields[i].getPopulation()) : new JComboBox();
                    ((JComboBox)this.m_components[i]).setEnabled(this.fields[i].getIsEditable());
                    this.m_components[i].setFocusable(this.fields[i].getIsEditable());
                    this.hasErrorSupport[i] = true;
                    break;
                }
                case 3: {
                    if (this.fields[i].getIsSelectRadio()) {
                        this.m_components[i] = new JRadioButton(this.fields[i].getLabel());
                        if (this.fields[i].getMnemonic() != null) {
                            ((JRadioButton)this.m_components[i]).setMnemonic(Integer.parseInt(this.fields[i].getMnemonic()));
                        }
                        this.hasErrorSupport[i] = false;
                        String radioGroupId = this.fields[i].getButtonGroupId();
                        if (radioGroupId != null) {
                            ButtonGroup buttonGroup = (ButtonGroup)buttonGroupsMap.get(radioGroupId);
                            if (buttonGroup == null) {
                                buttonGroup = new ButtonGroup();
                                buttonGroupsMap.put(radioGroupId, buttonGroup);
                            }
                            buttonGroup.add((JRadioButton)this.m_components[i]);
                        }
                    } else {
                        this.m_components[i] = new JCheckBox(this.fields[i].getLabel());
                        this.hasErrorSupport[i] = true;
                        if (this.fields[i].getMnemonic() != null) {
                            ((JCheckBox)this.m_components[i]).setMnemonic(Integer.parseInt(this.fields[i].getMnemonic()));
                        }
                    }
                    ((JToggleButton)this.m_components[i]).setVerticalTextPosition(1);
                    this.fields[i].setLabel(null);
                    ((JToggleButton)this.m_components[i]).setEnabled(this.fields[i].getIsEditable());
                    this.m_components[i].setFocusable(this.fields[i].getIsEditable());
                    String slaveId = this.fields[i].getSlaveId();
                    String[] slaveIds = Util.getCommaSeparatedValues(slaveId);
                    if (slaveIds != null) {
                        for (int index = 0; index < slaveIds.length; ++index) {
                            String slaveWidgetId = slaveIds[index];
                            LOG.finest("  SSSS  SLAVE WID: " + slaveWidgetId);
                            final int slaveIndex = this.getFieldIndex(slaveWidgetId);
                            final int myIndex = i;
                            if (slaveWidgetId == null || slaveIndex == -1) continue;
                            ((JToggleButton)this.m_components[i]).addItemListener(new ItemListener(){

                                public void itemStateChanged(ItemEvent itemEvent) {
                                    LOG.finest("SLAVE LISTENER CALLED");
                                    String widgetId = FormPanel.this.fields[myIndex].getId();
                                    LOG.finest("MASTER WID: " + widgetId);
                                    String slaveValue = FormPanel.this.parentWizardPanel.getWidgetSlaveValue(widgetId);
                                    LOG.finest("SLAVE INDEX: " + slaveIndex);
                                    LOG.finest("SLAVE VALUE: " + slaveValue);
                                    if (((JToggleButton)FormPanel.this.m_components[myIndex]).isSelected()) {
                                        FormPanel.this.setFieldEditable(slaveIndex, true);
                                        FormPanel.this.setFieldValue(slaveIndex, slaveValue);
                                    } else {
                                        FormPanel.this.setFieldEditable(slaveIndex, false);
                                        FormPanel.this.setFieldValue(slaveIndex, null);
                                    }
                                    FormPanel.this.fields[slaveIndex].setError(null);
                                    if (FormPanel.this.fieldPanels != null && FormPanel.this.fieldPanels[slaveIndex] != null) {
                                        FormPanel.this.fieldPanels[slaveIndex].setErrorText(null);
                                    }
                                }
                            });
                        }
                    }
                    final String nextFormId = this.fields[i].getNextFormIdIfSelected();
                    final String radioGroupId = this.fields[i].getButtonGroupId();
                    if (nextFormId == null) break;
                    final int myIndex = i;
                    ((JToggleButton)this.m_components[i]).addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent itemEvent) {
                            LOG.finest("NEXT FORM ID LISTENER CALLED");
                            Form myForm = FormPanel.this.parentWizardPanel.getForm();
                            if (((JToggleButton)FormPanel.this.m_components[myIndex]).isSelected()) {
                                myForm.setNextIdentifier(nextFormId);
                            } else if (radioGroupId == null) {
                                myForm.setNextIdentifier(null);
                            }
                        }
                    });
                    break;
                }
                case 4: {
                    this.m_components[i] = new JPasswordField(this.fields[i].getLength());
                    ((JPasswordField)this.m_components[i]).setEditable(this.fields[i].getIsEditable());
                    this.m_components[i].setFocusable(this.fields[i].getIsEditable());
                    this.hasErrorSupport[i] = true;
                    break;
                }
                case 5: {
                    this.m_components[i] = new RadioBoxPanel(this.fields[i].getIsVertical());
                    if (this.fields[i].getPopulation() != null) {
                        ((RadioBoxPanel)this.m_components[i]).addButtons((String[])this.fields[i].getPopulation());
                    }
                    ((RadioBoxPanel)this.m_components[i]).setEnabled(this.fields[i].getIsEditable());
                    this.m_components[i].setFocusable(this.fields[i].getIsEditable());
                    this.hasErrorSupport[i] = true;
                    break;
                }
                case 6: {
                    this.m_components[i] = new JTextArea(this.fields[i].getNumberRows(), this.fields[i].getNumberColumns());
                    ((JTextArea)this.m_components[i]).setOpaque(this.fields[i].getIsScrollable());
                    this.setComponentFont(this.m_components[i], this.fields[i].getFontFamily(), this.fields[i].getFontStyle(), this.fields[i].getFontSize());
                    ((JTextArea)this.m_components[i]).setLineWrap(true);
                    ((JTextArea)this.m_components[i]).setWrapStyleWord(true);
                    ((JTextArea)this.m_components[i]).setEditable(this.fields[i].getIsEditable());
                    this.m_components[i].setFocusable(this.fields[i].getIsEditable());
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 8: {
                    this.m_components[i] = new JEditorPane();
                    ((JEditorPane)this.m_components[i]).setMargin(new Insets(10, 10, 15, 15));
                    ((JEditorPane)this.m_components[i]).setContentType("text/html");
                    this.setComponentFont(this.m_components[i], this.fields[i].getFontFamily(), this.fields[i].getFontStyle(), this.fields[i].getFontSize());
                    ((JEditorPane)this.m_components[i]).setEditable(this.fields[i].getIsEditable());
                    this.m_components[i].setFocusable(this.fields[i].getIsEditable());
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 9: {
                    this.m_components[i] = null;
                    this.hasErrorSupport[i] = false;
                    break;
                }
                case 10: {
                    this.m_components[i] = null;
                    this.hasErrorSupport[i] = false;
                    break;
                }
                default: {
                    LOG.severe("ERROR - FormPanel FormPanel() unknown field type");
                }
            }
            if (this.m_components[i] != null) {
                if (this.fields[i].getLabel() != null && this.fields[i].getIsRequired()) {
                    StringBuffer labelSB = new StringBuffer("<html><font color='red'>");
                    labelSB.append(I18N.getString("is.required.txt"));
                    labelSB.append("</font>");
                    labelSB.append(this.fields[i].getLabel()).append("</html>");
                    this.m_labels[i] = new JLabel(labelSB.toString(), 2);
                    this.m_labels[i].getAccessibleContext().setAccessibleName(this.fields[i].getLabel());
                    this.m_labels[i].getAccessibleContext().setAccessibleDescription(this.fields[i].getLabel());
                } else if (this.fields[i].getLabel() != null) {
                    this.m_labels[i] = new JLabel(this.fields[i].getLabel(), 2);
                    this.m_labels[i].getAccessibleContext().setAccessibleName(this.fields[i].getLabel());
                    this.m_labels[i].getAccessibleContext().setAccessibleDescription(this.fields[i].getLabel());
                } else {
                    this.m_labels[i] = null;
                }
                if (this.fields[i].gets508Name() != null) {
                    this.m_components[i].getAccessibleContext().setAccessibleName(this.fields[i].gets508Name());
                }
                if (this.fields[i].gets508Desc() != null) {
                    this.m_components[i].getAccessibleContext().setAccessibleDescription(this.fields[i].gets508Desc());
                }
            }
            this.maximumLabelWidth = FieldPanel.getMaximumWidth(this.m_labels, this.m_components);
            if (returnActionListener == null) continue;
            this.registerKeyboardAction(returnActionListener, KeyStroke.getKeyStroke(10, 0, true), 1);
        }
    }

    private void setAnyInitialValues() {
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getInitialValue() == null) continue;
            this.setFieldValue(i, (String)this.fields[i].getInitialValue());
        }
    }

    public void layoutLabelsAndComponents() {
        this.removeAll();
        this.add(Box.createVerticalGlue());
        this.fieldPanels = new FieldPanel[this.fields.length];
        Container rowFieldsPanel = null;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.m_components[i] == null) continue;
            this.fieldPanels[i] = new FieldPanel(this, this.m_components[i], this.m_labels[i], this.fields[i], this.hasErrorSupport[i], this.maximumLabelWidth);
            if (this.fields[i].getIsNewRow()) {
                if (rowFieldsPanel != null) {
                    this.addComponentToVerticalBoxContainer((JComponent)rowFieldsPanel, this, 0.0f);
                }
                if (this.isNextFieldInNewRow(i)) {
                    rowFieldsPanel = null;
                    this.addComponentToVerticalBoxContainer(this.fieldPanels[i], this, 0.0f);
                    continue;
                }
                rowFieldsPanel = new JPanel();
                rowFieldsPanel.setLayout(new BoxLayout(rowFieldsPanel, 0));
                this.addComponentToHorizontalBoxContainer(this.fieldPanels[i], rowFieldsPanel, 0.0f);
                continue;
            }
            if (rowFieldsPanel == null) {
                LOG.severe("ERROR - expected row panel is null");
                continue;
            }
            rowFieldsPanel.add(Box.createHorizontalStrut(20));
            this.addComponentToHorizontalBoxContainer(this.fieldPanels[i], rowFieldsPanel, 0.0f);
        }
        if (rowFieldsPanel != null) {
            this.addComponentToVerticalBoxContainer((JComponent)rowFieldsPanel, this, 0.0f);
        }
        this.add(Box.createVerticalGlue());
    }

    private boolean isNextFieldInNewRow(int currentIndex) {
        int index;
        for (index = currentIndex + 1; index < this.fields.length && this.m_components[index] == null; ++index) {
        }
        if (index >= this.fields.length) {
            return true;
        }
        return this.fields[index].getIsNewRow();
    }

    private void addComponentToVerticalBoxContainer(JComponent component, Container container, float xAlignment) {
        component.setMaximumSize(component.getPreferredSize());
        component.setAlignmentX(xAlignment);
        container.add(component);
        container.add(new Box.Filler(new Dimension(0, 5), new Dimension(0, 10), new Dimension(0, 20)));
    }

    private void addComponentToHorizontalBoxContainer(JComponent component, Container container, float yAlignment) {
        component.setAlignmentY(yAlignment);
        container.add(component);
    }

    private void setComponentFont(Component component, String fontFamily, String fontStyle, int fontSize) {
        LOG.finest("MAKE FONT: " + fontStyle + ", " + fontSize + ", " + fontFamily);
        HashMap<TextAttribute, Object> fontMap = new HashMap<TextAttribute, Object>();
        if (fontFamily != null) {
            fontMap.put(TextAttribute.FAMILY, fontFamily);
        }
        if (fontStyle != null) {
            if (fontStyle.equalsIgnoreCase("italic")) {
                fontMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            } else if (fontStyle.equalsIgnoreCase("bold")) {
                fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            } else if (fontStyle.equalsIgnoreCase("light")) {
                fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            } else if (fontStyle.equalsIgnoreCase("heavy")) {
                fontMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_HEAVY);
            }
        }
        if (fontSize != 0) {
            fontMap.put(TextAttribute.SIZE, new Float(fontSize));
        }
        component.setFont(new Font(fontMap));
    }

    private int getFieldIndex(String fieldId) {
        if (fieldId == null) {
            return -1;
        }
        for (int index = 0; index < this.fields.length; ++index) {
            String anId = this.fields[index].getId();
            if (anId == null || !anId.equals(fieldId)) continue;
            return index;
        }
        return -1;
    }

    public WizardPanel getParentWizardPanel() {
        return this.parentWizardPanel;
    }

    public Component getField(int fieldIndex) {
        return this.m_components[fieldIndex];
    }

    public void setFieldVisible(int fieldIndex, boolean visible) {
        this.m_labels[fieldIndex].setVisible(visible);
        this.m_components[fieldIndex].setVisible(visible);
        this.revalidate();
    }

    public boolean isFieldVisible(int fieldIndex) {
        return this.m_components[fieldIndex].isVisible();
    }

    public JComponent getFirstFocusableField() {
        if (this.m_components == null) {
            return null;
        }
        for (int i = 0; i < this.m_components.length; ++i) {
            if (this.m_components[i] == null || !this.m_components[i].isFocusable()) continue;
            return this.m_components[i];
        }
        return null;
    }

    public String getFieldValue(String fieldId) {
        int index = this.getFieldIndex(fieldId);
        if (index == -1) {
            LOG.severe("ERROR - no field found with id: " + fieldId);
            return null;
        }
        return this.getFieldValue(index);
    }

    public void setFieldValue(String fieldId, String valueStr) {
        int index = this.getFieldIndex(fieldId);
        if (index == -1) {
            LOG.severe("ERROR - no field found with id: " + fieldId);
            return;
        }
        this.setFieldValue(index, valueStr);
    }

    public boolean isFieldEditable(int fieldIndex) {
        boolean result = false;
        switch (this.fields[fieldIndex].getType()) {
            case 0: {
                result = ((CustomField)((Object)this.m_components[fieldIndex])).isFieldEditable();
                break;
            }
            case 1: {
                result = ((JTextField)this.m_components[fieldIndex]).isEditable();
                break;
            }
            case 7: {
                result = ((JLabel)this.m_components[fieldIndex]).isEnabled();
                break;
            }
            case 2: {
                result = ((JComboBox)this.m_components[fieldIndex]).isEnabled();
                break;
            }
            case 3: {
                result = ((JToggleButton)this.m_components[fieldIndex]).isEnabled();
                break;
            }
            case 4: {
                result = ((JPasswordField)this.m_components[fieldIndex]).isEditable();
                break;
            }
            case 5: {
                result = ((RadioBoxPanel)this.m_components[fieldIndex]).isEnabled();
                break;
            }
            case 6: {
                result = ((JTextArea)this.m_components[fieldIndex]).isEditable();
                break;
            }
            case 8: {
                result = ((JEditorPane)this.m_components[fieldIndex]).isEditable();
                break;
            }
            case 9: {
                LOG.severe("ERROR - isFieldEditable() called for field type hidden");
                break;
            }
            case 10: {
                LOG.severe("ERROR - isFieldEditable() called for field type ignored");
                break;
            }
            default: {
                LOG.severe("ERROR - isFieldEditable() unknown field type");
            }
        }
        return result;
    }

    public void setFieldEditable(int fieldIndex, boolean editable) {
        switch (this.fields[fieldIndex].getType()) {
            case 0: {
                ((CustomField)((Object)this.m_components[fieldIndex])).setFieldEditable(editable);
                break;
            }
            case 1: {
                ((JTextField)this.m_components[fieldIndex]).setEditable(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 7: {
                ((JLabel)this.m_components[fieldIndex]).setEnabled(editable);
                this.m_components[fieldIndex].setFocusable(false);
                break;
            }
            case 2: {
                ((JComboBox)this.m_components[fieldIndex]).setEnabled(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 3: {
                ((JToggleButton)this.m_components[fieldIndex]).setEnabled(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 4: {
                ((JPasswordField)this.m_components[fieldIndex]).setEditable(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 5: {
                ((RadioBoxPanel)this.m_components[fieldIndex]).setEnabled(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 6: {
                ((JTextArea)this.m_components[fieldIndex]).setEditable(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 8: {
                ((JEditorPane)this.m_components[fieldIndex]).setEditable(editable);
                this.m_components[fieldIndex].setFocusable(editable);
                break;
            }
            case 9: {
                LOG.severe("ERROR - setFieldEditable() called for field type hidden");
                break;
            }
            case 10: {
                LOG.severe("ERROR - setFieldEditable() called for field type ignored");
                break;
            }
            default: {
                LOG.severe("ERROR - setFieldEditable() unknown field type");
            }
        }
    }

    public String getFieldValue(int fieldIndex) {
        String returnStr;
        switch (this.fields[fieldIndex].getType()) {
            case 0: {
                returnStr = ((CustomField)((Object)this.m_components[fieldIndex])).getValue();
                break;
            }
            case 1: {
                returnStr = ((JTextField)this.m_components[fieldIndex]).getText();
                break;
            }
            case 7: {
                returnStr = ((JLabel)this.m_components[fieldIndex]).getText();
                break;
            }
            case 2: {
                returnStr = (String)((JComboBox)this.m_components[fieldIndex]).getSelectedItem();
                break;
            }
            case 3: {
                if (((JToggleButton)this.m_components[fieldIndex]).isSelected()) {
                    returnStr = TRUE_STR;
                    break;
                }
                returnStr = FALSE_STR;
                break;
            }
            case 4: {
                returnStr = new String(((JPasswordField)this.m_components[fieldIndex]).getPassword());
                break;
            }
            case 5: {
                returnStr = ((RadioBoxPanel)this.m_components[fieldIndex]).getSelectedItem();
                break;
            }
            case 6: {
                returnStr = ((JTextArea)this.m_components[fieldIndex]).getText();
                break;
            }
            case 8: {
                returnStr = ((JEditorPane)this.m_components[fieldIndex]).getText();
                break;
            }
            case 9: {
                LOG.severe("ERROR - getFieldValue() called for field type hidden");
                returnStr = null;
                break;
            }
            case 10: {
                LOG.severe("ERROR - getFieldValue() called for field type ignored");
                returnStr = null;
                break;
            }
            default: {
                LOG.severe("ERROR - getFieldValue() unknown field type");
                returnStr = null;
            }
        }
        return returnStr;
    }

    public void setFieldValue(int fieldIndex, String valueStr) {
        switch (this.fields[fieldIndex].getType()) {
            case 0: {
                ((CustomField)((Object)this.m_components[fieldIndex])).setValue(valueStr);
                break;
            }
            case 1: {
                ((JTextField)this.m_components[fieldIndex]).setText(valueStr);
                break;
            }
            case 7: {
                ((JLabel)this.m_components[fieldIndex]).setText(valueStr);
                break;
            }
            case 2: {
                ((JComboBox)this.m_components[fieldIndex]).setSelectedItem(valueStr);
                break;
            }
            case 3: {
                ((JToggleButton)this.m_components[fieldIndex]).setSelected(valueStr != null && valueStr.equals(TRUE_STR));
                break;
            }
            case 4: {
                ((JPasswordField)this.m_components[fieldIndex]).setText(valueStr);
                break;
            }
            case 5: {
                ((RadioBoxPanel)this.m_components[fieldIndex]).setSelectedItem(valueStr);
                break;
            }
            case 6: {
                ((JTextArea)this.m_components[fieldIndex]).setText(valueStr);
                break;
            }
            case 8: {
                ((JEditorPane)this.m_components[fieldIndex]).setText(valueStr);
                break;
            }
            case 9: {
                LOG.severe("ERROR - setFieldValue() called for field type hidden");
                break;
            }
            case 10: {
                LOG.severe("ERROR - setFieldValue() called for field type ignored");
                break;
            }
            default: {
                LOG.severe("ERROR - setFieldValue() unknown field type");
            }
        }
    }

    public int getContinueCheckIndex() {
        for (int index = 0; index < this.fields.length; ++index) {
            if (!this.fields[index].getIsContinueCheck()) continue;
            return index;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

